/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.templates;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.ui.displays.components.slider.Ordinal;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.displays.DisplayHelper;
import io.intino.sumus.box.ui.displays.templates.AbstractDashboardTemplate;
import io.intino.sumus.box.util.Formatters;
import io.intino.sumus.reporting.model.DashboardDefinition;
import io.intino.sumus.reporting.model.Period;
import java.io.File;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DashboardTemplate
extends AbstractDashboardTemplate<SumusBox> {
    private String title;
    private String dashboard;
    private String report;
    private Timetag period;
    private io.intino.sumus.reporting.model.Scale scale;
    private String window;
    private String rootNode;
    private String node;
    private boolean admin;
    private static final Integer SearchPeriodLimit = 60;

    public DashboardTemplate(SumusBox box) {
        super(box);
    }

    public void title(String title) {
        this.title = title;
    }

    public void dashboard(String dashboard) {
        this.dashboard = dashboard;
        this.report = this.firstReport();
        this.period = this.defaultPeriod();
    }

    public void rootNode(String node) {
        this.rootNode = node;
        this.node = node;
    }

    public void admin(String value) {
        this.admin = Boolean.parseBoolean(value);
    }

    public void open(String dashboard, String report, Timetag period, String node) {
        this.dashboard = dashboard;
        this.report = report;
        this.period = period != null ? period : this.defaultPeriod();
        this.scale = period != null ? DisplayHelper.scaleOf(period) : this.defaultScale();
        this.window = null;
        this.rootNode = node != null ? node : this.defaultNode();
        this.node = node != null ? node : this.defaultNode();
        this.reportSelector.select(new String[]{((SumusBox)this.box()).dashboardTranslations(dashboard, this.language()).getOrDefault(report, report)});
    }

    public void didMount() {
        super.didMount();
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.initReportSelector();
        this.initPeriodSlider();
        this.initReportStamp();
        this.scaleSelector.onSelect(e -> this.updateScale(e.selection().size() > 0 ? (String)e.selection().get(0) : null));
        this.windowSelector.onSelect(e -> this.updateWindow(e.selection().size() > 0 ? (String)e.selection().get(0) : null));
    }

    public void refresh() {
        super.refresh();
        this.refreshReportSelector();
        this.refreshPeriod(this.selectedPeriod());
        this.refreshPeriodSlider();
        this.refreshPeriodScale();
        this.refreshPeriodWindow();
        this.refreshReportStamp();
    }

    private void initReportSelector() {
        this.reportSelector.onSelect(e1 -> {
            List selection = e1.selection();
            if (selection.size() <= 0) {
                return;
            }
            this.openReport(this.selectedReport());
        });
    }

    private void openReport(String selectedReport) {
        if (selectedReport == null) {
            return;
        }
        this.report = selectedReport;
        if (this.windows().size() <= 0) {
            this.window = null;
        }
        this.refreshPeriodSlider();
        this.refreshPeriodScale();
        this.refreshPeriodWindow();
        this.refreshReportStamp();
    }

    private void initPeriodSlider() {
        this.previousPeriod.onExecute(e -> this.previousPeriod());
        this.nextPeriod.onExecute(e -> this.nextPeriod());
        this.periodSelector.onChange(e -> this.updatePeriod((Instant)e.value()));
    }

    private void initReportStamp() {
        this.reportStamp.onSelectNode(node -> {
            this.node = node;
        });
        this.reportStamp.onSelectScale(scale -> {
            this.updateScale(scale.name());
            this.scaleSelector.selection(new String[]{this.translate(scale.name())});
        });
        this.reportStamp.onSelectWindow(window -> {
            this.updateWindow((String)window);
            this.windowSelector.selection(new String[]{this.translate((String)window)});
        });
        this.reportStamp.onSelectPeriod(p -> {
            Timetag period = this.limitPeriod((Timetag)p);
            this.updatePeriod(period);
            this.periodSelector.value(Formatters.instantOf(period));
        });
    }

    private void refreshReportSelector() {
        this.reportSelector.clear();
        Map<String, String> translations = ((SumusBox)this.box()).dashboardTranslations(this.dashboard, this.language());
        DashboardDefinition definition = ((SumusBox)this.box()).dashboardDefinition(this.dashboard);
        Map<Optional<String>, List<String>> groups = this.groupedReports();
        groups.entrySet().forEach(g -> this.addReportGroup((Map.Entry<Optional<String>, List<String>>)g, translations));
        this.noReportsMessage.visible(definition.reportDefinitions().size() <= 0);
        this.periodBlock.visible(definition.reportDefinitions().size() > 0);
        if (this.report != null) {
            this.reportSelector.selection(new String[]{translations.getOrDefault(this.report, this.report)});
        } else if (groups.size() > 0) {
            String report = this.firstReport();
            translations.getOrDefault(report, report);
        }
    }

    private void addReportGroup(Map.Entry<Optional<String>, List<String>> group, Map<String, String> translations) {
        List<String> reports = group.getValue();
        if (group.getKey().isPresent()) {
            this.reportSelector.addSubHeader(group.getKey().get());
        }
        reports.forEach(r -> this.reportSelector.add((String)r));
    }

    private void refreshPeriodSlider() {
        this.periodSelector.views(Collections.singletonList(DisplayHelper.viewOf(this.selectedScale())));
        this.periodSelector.pattern(this.translate(DisplayHelper.pattern(this.selectedScale())));
        this.periodSelector.max(Instant.now().plus(1L, ChronoUnit.DAYS));
    }

    private void refreshPeriodScale() {
        this.scaleSelector.clear();
        List<String> options = this.scales();
        this.scaleSelector.addAll(options);
        this.scaleSelectorBlock.visible(options.size() > 1);
        if (options.size() <= 0) {
            return;
        }
        io.intino.sumus.reporting.model.Scale scale = this.selectedScale();
        this.scaleSelector.select(new String[]{scale != null ? this.translate(scale.name()) : options.get(0)});
    }

    private void refreshPeriodWindow() {
        this.windowSelector.clear();
        List<String> options = this.windows();
        this.windowSelector.addAll(options);
        this.windowSelectorBlock.visible(options.size() > 1);
        if (options.size() <= 0) {
            return;
        }
        String window = this.selectedWindow();
        this.windowSelector.select(new String[]{window != null ? this.translate(window) : options.get(0)});
    }

    private void refreshReportStamp() {
        this.reportStamp.dashboard(this.dashboard);
        this.reportStamp.report(this.report);
        this.reportStamp.period(this.period);
        this.reportStamp.scale(this.scale);
        this.reportStamp.window(this.window);
        this.reportStamp.rootNode(this.rootNode);
        this.reportStamp.node(this.node);
        this.reportStamp.admin(this.admin);
        this.reportStamp.refresh();
    }

    private String selectedReport() {
        String selected = this.reportSelector.selection().size() > 0 ? (String)this.reportSelector.selection().get(0) : null;
        Map<String, String> translations = ((SumusBox)this.box()).dashboardTranslations(this.dashboard, this.language());
        return ((SumusBox)this.box()).reports(this.dashboard).stream().filter(r -> translations.getOrDefault(r, (String)r).equals(selected)).findFirst().orElse(null);
    }

    private void updatePeriod(Instant period) {
        if (this.period != null && this.period.equals((Object)new Timetag(period, this.scale()))) {
            return;
        }
        this.updatePeriod(new Timetag(period, this.scale()));
    }

    private void previousPeriod() {
        this.updatePeriod(this.period != null ? this.findPrevious(this.period) : this.firstPeriod());
        this.periodSelector.value(Formatters.instantOf(this.period));
    }

    private Timetag findPrevious(Timetag period) {
        int index;
        Timetag result = period.previous();
        List<Timetag> timetags = this.sliderTimetags();
        for (index = 0; index < SearchPeriodLimit && !timetags.contains(result); ++index) {
            result = result.previous();
        }
        return index == SearchPeriodLimit ? this.firstPeriod() : result;
    }

    private void nextPeriod() {
        this.updatePeriod(this.period != null ? this.findNext(this.period) : this.lastPeriod());
        this.periodSelector.value(Formatters.instantOf(this.period));
    }

    private Timetag findNext(Timetag period) {
        int index;
        Timetag result = period.next();
        List<Timetag> timetags = this.sliderTimetags();
        for (index = 0; index < SearchPeriodLimit && !timetags.contains(result); ++index) {
            result = result.next();
        }
        return index == SearchPeriodLimit ? this.lastPeriod() : result;
    }

    private Timetag firstPeriod() {
        List<Timetag> timetags = this.sliderTimetags();
        return timetags.size() > 0 ? timetags.get(0) : null;
    }

    private Timetag lastPeriod() {
        List<Timetag> timetags = this.sliderTimetags();
        return timetags.size() > 0 ? timetags.get(timetags.size() - 1) : null;
    }

    private Timetag limitPeriod(Timetag period) {
        Timetag defaultPeriod = this.defaultPeriod();
        return period.isAfter(defaultPeriod) ? defaultPeriod : period;
    }

    private void updatePeriod(long value) {
        List<Timetag> timetags = this.sliderTimetags();
        Timetag timetag = timetags.get((int)value);
        if (this.period != null && this.period.equals((Object)timetag)) {
            return;
        }
        this.updatePeriod(timetag);
        this.periodSelector.value(Formatters.instantOf(timetag));
    }

    private void updatePeriod(Timetag period) {
        this.period = period;
        this.refreshReportStamp();
        this.refreshPeriodToolbar();
    }

    private void refreshPeriodToolbar() {
        Timetag now = new Timetag(Instant.now(), this.scale());
        List<Timetag> timetags = this.sliderTimetags();
        Timetag beforeLimit = !timetags.isEmpty() ? timetags.get(0).next() : now.next();
        this.previousPeriod.readonly(this.period == null || this.period.isBefore(beforeLimit));
        Timetag afterLimit = !timetags.isEmpty() ? timetags.get(timetags.size() - 1).previous() : now.previous();
        this.nextPeriod.readonly(this.period == null || this.period.isAfter(afterLimit));
    }

    private void updateScale(String scale) {
        if (scale == null) {
            return;
        }
        if (this.scale != null && this.translate(this.scale.name()).equals(scale)) {
            return;
        }
        DashboardDefinition.ReportDefinition reportDefinition = this.reportDefinition();
        if (reportDefinition == null) {
            return;
        }
        this.scale = Arrays.stream(reportDefinition.scales()).filter(s -> this.translate(s.name()).equalsIgnoreCase(this.translate(scale))).findFirst().orElse(null);
        if (this.scale == null) {
            return;
        }
        this.period = new Timetag(this.period.datetime(), DisplayHelper.timetagScaleOf(this.scale));
        this.refreshPeriod(this.period);
        this.refreshPeriodSlider();
        this.refreshReportStamp();
    }

    private void updateWindow(String window) {
        if (window == null) {
            return;
        }
        if (this.window != null && this.window.equals(window)) {
            return;
        }
        this.window = this.windows().stream().filter(s -> this.translate((String)s).equalsIgnoreCase(window)).findFirst().orElse(null);
        if (this.window == null) {
            return;
        }
        this.refreshReportStamp();
    }

    private Timetag selectedPeriod() {
        return this.period != null ? this.period : (this.periodSelector != null ? this.periodValue(this.periodSelector.value()) : null);
    }

    private io.intino.sumus.reporting.model.Scale selectedScale() {
        if (this.scale == null || !this.scales().contains(this.translate(this.scale.name()))) {
            return this.scaleSelector != null && this.scaleSelector.selection().size() > 0 ? this.periodScale((String)this.scaleSelector.selection().get(0)) : io.intino.sumus.reporting.model.Scale.Day;
        }
        return this.scale;
    }

    private String selectedWindow() {
        if (this.window == null || !this.windows().contains(this.translate(this.window))) {
            return this.windowSelector.selection().size() > 0 ? (String)this.windowSelector.selection().get(0) : null;
        }
        return this.window;
    }

    private List<String> scales() {
        DashboardDefinition.ReportDefinition reportDefinition = this.reportDefinition();
        if (reportDefinition == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(reportDefinition.scales()).map(s -> this.translate(s.name())).collect(Collectors.toList());
    }

    private List<String> windows() {
        DashboardDefinition.ReportDefinition reportDefinition = this.reportDefinition();
        if (reportDefinition == null) {
            return Collections.emptyList();
        }
        List periods = Arrays.stream(reportDefinition.periods()).filter(p -> p.scale() == this.selectedScale()).collect(Collectors.toList());
        if (periods.size() == 1 && ((Period)periods.get(0)).isSingle()) {
            return Collections.emptyList();
        }
        return periods.stream().map(p -> String.valueOf(p.window())).collect(Collectors.toList());
    }

    private Timetag periodValue(Instant value) {
        return new Timetag(value != null ? value : Instant.now(), this.scale());
    }

    private io.intino.sumus.reporting.model.Scale periodScale(String scale) {
        DashboardDefinition.ReportDefinition reportDefinition = this.reportDefinition();
        if (reportDefinition == null) {
            return io.intino.sumus.reporting.model.Scale.Day;
        }
        return Arrays.stream(this.reportDefinition().scales()).filter(s -> this.translate(s.name()).equals(scale)).findFirst().orElse(null);
    }

    private Scale scale() {
        List<Timetag> timetags = this.timetags(this.selectedScale());
        return timetags.size() > 0 ? timetags.get(0).scale() : Scale.Day;
    }

    private long posOf(Timetag selectedPeriod) {
        List<Timetag> timetags = this.sliderTimetags();
        for (int i = 0; i < timetags.size(); ++i) {
            if (!timetags.get(i).equals((Object)selectedPeriod)) continue;
            return i;
        }
        return -1L;
    }

    private Ordinal ordinal() {
        return new Ordinal(){

            public String name() {
                return "period";
            }

            public String label() {
                return DashboardTemplate.this.translate("Period");
            }

            public int step() {
                return 1;
            }

            public Ordinal.Formatter formatter(String language) {
                return value -> {
                    String type = DashboardTemplate.this.selectedReport();
                    if (type == null) {
                        return "";
                    }
                    List<Timetag> timetags = DashboardTemplate.this.sliderTimetags();
                    return value < (long)timetags.size() ? Formatters.date(timetags.get((int)value), DashboardTemplate.this.language(), this.translator()) : "";
                };
            }

            private Function<String, String> translator() {
                return arg_0 -> ((DashboardTemplate)DashboardTemplate.this).translate(arg_0);
            }
        };
    }

    private List<Timetag> sliderTimetags() {
        List<Timetag> timetags = this.timetags(this.selectedScale());
        Collections.reverse(timetags);
        return timetags;
    }

    private List<Timetag> timetags(io.intino.sumus.reporting.model.Scale scale) {
        if (this.report == null) {
            return Collections.emptyList();
        }
        List<File> periodList = ((SumusBox)this.box()).archetype().datamarts().dashboards().getDashboardPeriods(this.dashboard, this.report);
        return periodList.stream().filter(f -> f.getName().endsWith(".zip")).map(f -> this.timetagFrom(this.timetagOf((File)f), scale)).filter(Objects::nonNull).distinct().sorted((o1, o2) -> o2.compare(o1)).collect(Collectors.toList());
    }

    private String timetagOf(File file) {
        String name = file.getName();
        if (name.contains("-")) {
            return name.split("-")[0];
        }
        return name.substring(0, name.indexOf("."));
    }

    private Timetag timetagFrom(String value, io.intino.sumus.reporting.model.Scale scale) {
        try {
            if (value.contains("W")) {
                return scale == io.intino.sumus.reporting.model.Scale.Week ? DashboardTemplate.weekTimetagFrom(value) : null;
            }
            if (scale == io.intino.sumus.reporting.model.Scale.Week) {
                return null;
            }
            Timetag timetag = new Timetag(value);
            return timetag.scale() == DisplayHelper.timetagScaleOf(scale) ? timetag : null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static Timetag weekTimetagFrom(String timetag) {
        int year = Integer.parseInt(timetag.split("W")[0]);
        int week = Integer.parseInt(timetag.split("W")[1]);
        LocalDate desiredDate = LocalDate.now().withYear(year).with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, week).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        return new Timetag(desiredDate, Scale.Day);
    }

    public static void main(String[] args) {
        System.out.println(DashboardTemplate.weekTimetagFrom("2022W13"));
    }

    private DashboardDefinition.ReportDefinition reportDefinition() {
        return ((SumusBox)this.box()).dashboardDefinition(this.dashboard).reportDefinitions().stream().filter(r -> r.name().equals(this.report)).findFirst().orElse(null);
    }

    private Timetag defaultPeriod() {
        return new Timetag(Instant.now(), Scale.Day);
    }

    private io.intino.sumus.reporting.model.Scale defaultScale() {
        return DisplayHelper.scaleOf(this.defaultPeriod());
    }

    private String defaultNode() {
        return ((SumusBox)this.box()).defaultReportNodeName(this.dashboard, this.report, this.period, this.scale, this.window);
    }

    private void refreshPeriod(Timetag period) {
        if (period == null) {
            return;
        }
        this.periodSelector.value(Formatters.instantOf(period));
        this.refreshPeriodToolbar();
    }

    private String firstReport() {
        List<String> reports = ((SumusBox)this.box()).reports(this.dashboard);
        if (reports.size() <= 0) {
            return null;
        }
        Map<Optional<String>, List<String>> reportMap = this.groupedReports();
        return reportMap.values().iterator().next().get(0);
    }

    private Map<Optional<String>, List<String>> groupedReports() {
        DashboardDefinition definition = ((SumusBox)this.box()).dashboardDefinition(this.dashboard);
        LinkedHashMap<Optional<String>, List<DashboardDefinition.ReportDefinition>> map = new LinkedHashMap<Optional<String>, List<DashboardDefinition.ReportDefinition>>();
        for (DashboardDefinition.ReportDefinition reportDefinition : definition.reportDefinitions()) {
            Optional<String> group = Optional.ofNullable(reportDefinition.group());
            map.putIfAbsent(group, new ArrayList());
            ((List)map.get(group)).add(reportDefinition);
        }
        return this.translate(map);
    }

    private Map<Optional<String>, List<String>> translate(Map<Optional<String>, List<DashboardDefinition.ReportDefinition>> reports) {
        Map<String, String> translations = ((SumusBox)this.box()).dashboardTranslations(this.dashboard, this.language());
        return reports.entrySet().stream().collect(Collectors.toMap(e -> ((Optional)e.getKey()).isPresent() ? Optional.ofNullable(translations.getOrDefault(((Optional)e.getKey()).get(), (String)((Optional)e.getKey()).get())) : (Optional<String>)e.getKey(), e -> ((List)e.getValue()).stream().map(c -> translations.getOrDefault(c.name(), c.name())).collect(Collectors.toList()), (a, b) -> a, LinkedHashMap::new));
    }
}

