/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.util;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Locale;
import java.util.function.Function;

public class Formatters {
    private static final String ExcelDateFormat = "dd-MMMM-yyyy";
    private static final String DownloadDateFormat = "dd_MM_YYYY_HH_mm_ss";

    public static String logo(String content) {
        return Formatters.logo("", content);
    }

    public static String logo(String prefix, String content) {
        return prefix + content;
    }

    public static Instant instantOf(Timetag timetag) {
        if (timetag == null) {
            return null;
        }
        return Instant.ofEpochSecond(LocalDateTime.of(timetag.year(), timetag.month(), timetag.day(), 12, 1).toEpochSecond(ZoneOffset.UTC));
    }

    public static String date(Instant date, String pattern, String language) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, new Locale(language, language.toUpperCase()));
        return formatter.format(new Date(date.toEpochMilli()));
    }

    public static String downloadDate(Instant date, String language, String extension) {
        SimpleDateFormat formatter = new SimpleDateFormat(DownloadDateFormat, new Locale(language, language.toUpperCase()));
        return formatter.format(new Date(date.toEpochMilli())) + "." + extension;
    }

    public static String excelDate(Timetag timetag, String language) {
        SimpleDateFormat formatter = new SimpleDateFormat(ExcelDateFormat, new Locale(language, language.toUpperCase()));
        return formatter.format(new Date(Formatters.instantOf(timetag).toEpochMilli()));
    }

    public static String normalizeSitePage(String page) {
        String result = page == null || page.equals("index.html") ? "0" : page.replace(".html", "");
        try {
            Integer.parseInt(result);
            return result;
        }
        catch (NumberFormatException ex) {
            return "-1";
        }
    }

    public static String firstUpperCase(String content) {
        return content.substring(0, 1).toUpperCase() + content.substring(1);
    }

    public static String date(Timetag timetag, String language, Function<String, String> translator) {
        Scale scale = timetag.scale();
        String month = Formatters.padded(timetag.month(), 2);
        String day = Formatters.padded(timetag.day(), 2);
        String hour = Formatters.padded(timetag.hour(), 2);
        String minute = Formatters.padded(timetag.minute(), 2);
        if (scale == Scale.Year) {
            return String.valueOf(timetag.year());
        }
        if (scale == Scale.Month) {
            return timetag.year() + "/" + month;
        }
        if (scale == Scale.Day) {
            return timetag.year() + "/" + month + "/" + day;
        }
        if (scale == Scale.Hour) {
            return timetag.year() + "/" + month + "/" + day + " " + hour;
        }
        return timetag.year() + "/" + month + "/" + day + " " + hour + ":" + minute;
    }

    public static String padded(int value, int pad) {
        return String.format("%0" + pad + "d", value);
    }
}

