/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.templates;

import io.intino.alexandria.Json;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.core.Box;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.schemas.MicrositeFilter;
import io.intino.sumus.box.schemas.MicrositeParams;
import io.intino.sumus.box.ui.displays.templates.AbstractCubeAnalyzeTemplate;
import io.intino.sumus.box.util.StringHelper;
import io.intino.sumus.reporting.model.DashboardDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class CubeAnalyzeTemplate
extends AbstractCubeAnalyzeTemplate<SumusBox> {
    private String dashboard;
    private String cube;
    private Timetag period;
    private String node;
    private Consumer<MicrositeParams> openMicrositeListener;

    public CubeAnalyzeTemplate(Box box) {
        super((SumusBox)box);
    }

    public CubeAnalyzeTemplate dashboard(String dashboard) {
        this.dashboard = dashboard;
        return this;
    }

    public CubeAnalyzeTemplate cube(String cube) {
        this.cube = cube;
        return this;
    }

    public CubeAnalyzeTemplate period(Timetag period) {
        this.period = period;
        return this;
    }

    public CubeAnalyzeTemplate node(String node) {
        this.node = node;
        return this;
    }

    public CubeAnalyzeTemplate onOpenMicrosite(Consumer<MicrositeParams> listener) {
        this.openMicrositeListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.view.onExecute(e -> this.openMicrosite());
        this.analyze.onOpen(e -> this.refreshCubeDialog());
    }

    public void refresh() {
        super.refresh();
        this.cubeTitle.value(this.translate(this.cube));
    }

    private void openMicrosite() {
        DashboardDefinition dashboardDefinition = ((SumusBox)this.box()).dashboardDefinition(this.dashboard);
        MicrositeParams params = new MicrositeParams();
        params.cube(this.cube);
        params.from(this.period.value());
        params.to(this.period.value());
        params.filters(Collections.singletonList(new MicrositeFilter().dimension(dashboardDefinition.navigation()).values(Collections.singletonList(this.node))));
        this.openMicrositeListener.accept(params);
    }

    private void refreshCubeDialog() {
        DashboardDefinition dashboardDefinition = ((SumusBox)this.box()).dashboardDefinition(this.dashboard);
        Map<String, List<String>> filters = Collections.singletonMap(dashboardDefinition.navigation(), Collections.singletonList(this.node));
        this.cubeDialog.title(this.title());
        this.cubeStamp.open(this.cube, this.period.value(), dashboardDefinition.navigation(), StringHelper.encode(Json.toString(filters)), true);
        this.cubeStamp.refresh();
    }

    private String title() {
        Map<String, String> translations = ((SumusBox)this.box()).dashboardTranslations(this.dashboard, this.language());
        return this.translate("Analyze by") + " " + translations.getOrDefault(this.cube, this.cube);
    }
}

