/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.templates;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.office.ExcelReportBuilder;
import io.intino.alexandria.ui.displays.components.MicroSite;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.displays.templates.AbstractSiteTemplate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import org.apache.commons.io.FileUtils;

public class SiteTemplate
extends AbstractSiteTemplate<SumusBox> {
    private Timetag timetag;
    private String siteName;
    private int page = 0;

    public SiteTemplate(SumusBox box) {
        super(box);
    }

    public void open(String timetag, String site, String page) {
        this.timetag = new Timetag(timetag);
        this.siteName = site;
        this.page = Integer.parseInt(page);
    }

    public void refresh() {
        super.refresh();
        this.site.site(this.load(this.timetag, this.siteName));
        this.site.page(this.page);
        this.site.contentAdapter(new MicroSite.ContentAdapter(){

            public String filename(String filename) {
                return filename.replace(".tsv", ".xlsx");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public InputStream adapt(InputStream stream) {
                File tempFile = null;
                try {
                    tempFile = new File(((SumusBox)SiteTemplate.this.box()).archetype().tmp().root(), Instant.now().toString().replace(":", "") + ".tsv");
                    FileUtils.copyInputStreamToFile((InputStream)stream, (File)tempFile);
                    File template = ((SumusBox)SiteTemplate.this.box()).archetype().configuration().getTemplate("microsite.xlsx");
                    InputStream inputStream = ExcelReportBuilder.create().template(template).build(tempFile);
                    return inputStream;
                }
                catch (IOException ignored) {
                    InputStream inputStream = stream;
                    return inputStream;
                }
                finally {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                }
            }
        });
        this.site.refresh();
    }

    private File load(Timetag timetag, String web) {
        return ((SumusBox)this.box()).archetype().microsites().getSite(web);
    }
}

