/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.filters.GroupFilter;
import io.intino.alexandria.ui.model.dynamictable.Section;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.schemas.MicrositeFilter;
import io.intino.sumus.box.schemas.MicrositeParams;
import io.intino.sumus.box.schemas.ViewContent;
import io.intino.sumus.box.schemas.ViewFilterContent;
import io.intino.sumus.box.schemas.ViewFilterParams;
import io.intino.sumus.box.schemas.ViewNodeContent;
import io.intino.sumus.box.schemas.ViewNodeParams;
import io.intino.sumus.box.schemas.ViewParams;
import io.intino.sumus.box.ui.datasources.CubeDatasource;
import io.intino.sumus.box.ui.datasources.MicroSiteBuilderOfCube;
import io.intino.sumus.box.ui.displays.AbstractReportRenderer;
import io.intino.sumus.box.ui.displays.DisplayHelper;
import io.intino.sumus.box.ui.displays.notifiers.ReportRendererNotifier;
import io.intino.sumus.box.util.TimetagHelper;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.reporting.model.Scale;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ReportRenderer
extends AbstractReportRenderer<SumusBox> {
    private String dashboard;
    private String content;
    private Consumer<String> openNodeListener;
    private Function<ViewParams, String> openViewListener;
    private Function<ViewNodeParams, String> openViewNodeListener;
    private Function<ViewFilterParams, String> openViewFilterListener;
    private Function<String, String> openReportListener;
    private Consumer<Scale> selectScaleListener;
    private Consumer<String> selectWindowListener;

    public ReportRenderer(SumusBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        ((ReportRendererNotifier)this.notifier).refreshBaseUrl(((SumusBox)this.box()).configuration().url());
    }

    public ReportRenderer dashboard(String dashboard) {
        this.dashboard = dashboard;
        return this;
    }

    public ReportRenderer content(String content) {
        this.content = content;
        return this;
    }

    public ReportRenderer onOpenNode(Consumer<String> listener) {
        this.openNodeListener = listener;
        return this;
    }

    public ReportRenderer onOpenView(Function<ViewParams, String> listener) {
        this.openViewListener = listener;
        return this;
    }

    public ReportRenderer onOpenViewNode(Function<ViewNodeParams, String> listener) {
        this.openViewNodeListener = listener;
        return this;
    }

    public ReportRenderer onOpenViewFilter(Function<ViewFilterParams, String> listener) {
        this.openViewFilterListener = listener;
        return this;
    }

    public ReportRenderer onOpenReport(Function<String, String> listener) {
        this.openReportListener = listener;
        return this;
    }

    public ReportRenderer onSelectScale(Consumer<Scale> listener) {
        this.selectScaleListener = listener;
        return this;
    }

    public ReportRenderer onSelectWindow(Consumer<String> listener) {
        this.selectWindowListener = listener;
        return this;
    }

    public void printPage() {
        ((ReportRendererNotifier)this.notifier).printPage();
    }

    public void refresh() {
        super.refresh();
        ((ReportRendererNotifier)this.notifier).refresh(this.content);
    }

    public void refreshEvents() {
        ((ReportRendererNotifier)this.notifier).refreshEvents();
    }

    public void openNode(String area) {
        this.openNodeListener.accept(area);
    }

    public void openView(ViewParams params) {
        ((ReportRendererNotifier)this.notifier).gotoView(this.contentOf(this.openViewListener.apply(params), params));
    }

    public void openViewNode(ViewNodeParams params) {
        ((ReportRendererNotifier)this.notifier).gotoViewNode(this.contentOf(this.openViewNodeListener.apply(params), params));
    }

    @Deprecated
    public void openViewFilter(ViewFilterParams params) {
        ((ReportRendererNotifier)this.notifier).gotoViewFilter(this.contentOf(this.openViewFilterListener.apply(params), params));
    }

    public void openReport(String report) {
        ((ReportRendererNotifier)this.notifier).gotoReport(this.openReportListener.apply(report));
    }

    private ViewContent contentOf(String content, ViewParams params) {
        return new ViewContent().content(content).view(params.view()).period(params.period());
    }

    private ViewNodeContent contentOf(String content, ViewNodeParams params) {
        return new ViewNodeContent().content(content).view(params.view()).period(params.period()).node(params.node()).filters(params.filters());
    }

    private ViewFilterContent contentOf(String content, ViewFilterParams params) {
        return new ViewFilterContent().content(content).view(params.view()).period(params.period()).filters(params.filters());
    }

    public void selectScale(String scale) {
        this.selectScaleListener.accept(Scale.valueOf((String)scale));
    }

    public void selectWindow(String window) {
        this.selectWindowListener.accept(window);
    }

    public void openMicrosite(MicrositeParams params) {
        ((ReportRendererNotifier)this.notifier).generatingMicrosite();
        Timetag timetag = new Timetag(params.from());
        CubeDatasource source = new CubeDatasource((SumusBox)this.box(), this.session(), params.cube(), TimetagHelper.scaleFrom(timetag), timetag);
        source.timetag(timetag);
        source.toTimetag(new Timetag(params.to()));
        Dimension dimension = this.dimensionFrom(source, params);
        List<Filter> filters = this.filtersOf(params.filters());
        Section section = new Section(source.translate(dimension.name()));
        source.drill(source.translate(dimension.name()));
        source.filters(filters);
        String label = params.label() != null && !params.label().isEmpty() ? params.label() : source.title();
        String description = params.description() != null && !params.description().isEmpty() ? params.description() : source.description(null, null);
        MicroSiteBuilderOfCube builder = new MicroSiteBuilderOfCube((SumusBox)this.box(), DisplayHelper.cellProvider((SumusBox)this.box(), source), this.language());
        Iterator<Fact> details = source.details(source.timetag(), section, null, filters);
        String result = builder.build(timetag, label, description, source.itemColumns(), details);
        String url = ((SumusBox)this.box()).configuration().url();
        ((ReportRendererNotifier)this.notifier).gotoMicrosite(url + (url.endsWith("/") ? "" : "/") + "drills/" + timetag + "/" + result + "/");
    }

    private Dimension dimensionFrom(CubeDatasource source, MicrositeParams params) {
        return params.filters().size() > 0 ? source.findDimension(params.filters().get(0).dimension()) : source.findDimension(((SumusBox)this.box()).dashboardDefinition(this.dashboard).navigation());
    }

    private List<String> dimensionValuesFrom(MicrositeParams params) {
        MicrositeFilter filter;
        MicrositeFilter micrositeFilter = filter = params.filters().size() > 0 ? params.filters().get(0) : null;
        if (filter == null || filter.values().size() <= 0) {
            return List.of(this.session().preference("territory"));
        }
        return filter.values();
    }

    private List<Filter> filtersOf(List<MicrositeFilter> filters) {
        return filters.stream().map(this::filterOf).collect(Collectors.toList());
    }

    private Filter filterOf(MicrositeFilter filter) {
        return new GroupFilter(filter.dimension(), filter.values());
    }

    private String language() {
        return this.session() != null ? this.session().discoverLanguage() : "en";
    }
}

