/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus;

import io.intino.alexandria.Timetag;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Archetype {
    private final File root;

    public Archetype(File root) {
        this.root = root;
        root.mkdirs();
    }

    public File root() {
        return this.root;
    }

    public Relative relative() {
        return new Relative(this.root);
    }

    private static File createParent(File file) {
        file.getParentFile().mkdirs();
        return file;
    }

    public Configuration configuration() {
        return new Configuration(this.root);
    }

    public Tmp tmp() {
        return new Tmp(this.root);
    }

    public Datamarts datamarts() {
        return new Datamarts(this.root);
    }

    public Microsites microsites() {
        return new Microsites(this.root);
    }

    public static class Relative {
        private final String name;
        private final File root;

        public Relative(File root) {
            this.name = "";
            this.root = root;
            root.mkdirs();
        }

        public String root() {
            return this.name;
        }

        public Configuration configuration() {
            return new Configuration(this.root, this.name);
        }

        public Tmp tmp() {
            return new Tmp(this.root, this.name);
        }

        public Datamarts datamarts() {
            return new Datamarts(this.root, this.name);
        }

        public Microsites microsites() {
            return new Microsites(this.root, this.name);
        }

        public static class Microsites {
            private final File root;
            private final String name;

            public Microsites(File parentRoot, String parent) {
                this.root = new File(parent, "microsites");
                this.root.mkdirs();
                this.name = parent + (!parent.isEmpty() ? "/" : "") + "microsites";
            }

            public String root() {
                return this.name;
            }

            public String getSite(String id) {
                return "{id}.zip".replace("{id}", id);
            }
        }

        public static class Datamarts {
            private final File root;
            private final String name;

            public Datamarts(File parentRoot, String parent) {
                this.root = new File(parent, "datamarts");
                this.root.mkdirs();
                this.name = parent + (!parent.isEmpty() ? "/" : "") + "datamarts";
            }

            public String root() {
                return this.name;
            }

            public Dashboards dashboards() {
                return new Dashboards(this.root, this.name);
            }

            public Ledgers ledgers() {
                return new Ledgers(this.root, this.name);
            }

            public static class Ledgers {
                private final File root;
                private final String name;

                public Ledgers(File parentRoot, String parent) {
                    this.root = new File(parent, "ledgers");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "ledgers";
                }

                public String root() {
                    return this.name;
                }

                public String getLedger(String name, Timetag period) {
                    return "{name}/{period}.tsv".replace("{name}", name).replace("{period}", period.toString());
                }

                public String getLedgerTranslations(String name, String language) {
                    return "{name}.{language}.json".replace("{name}", name).replace("{language}", language);
                }

                public String getLedgerDefinition(String name) {
                    return "{name}.ledger".replace("{name}", name);
                }

                public List<String> getLedgerRange(String name) {
                    if (!new File(this.root, "{name}").exists()) {
                        return Collections.emptyList();
                    }
                    return Arrays.stream(new File(this.root, "{name}").listFiles()).filter(f -> f.getName().contains(".tsv".replace("{name}", name))).map(f -> f.getName()).collect(Collectors.toList());
                }
            }

            public static class Dashboards {
                private final File root;
                private final String name;

                public Dashboards(File parentRoot, String parent) {
                    this.root = new File(parent, "dashboards");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "dashboards";
                }

                public String root() {
                    return this.name;
                }

                public String getDashboardDefinition(String name) {
                    return "{name}.dashboard".replace("{name}", name);
                }

                public String getDashboardTranslations(String name, String language) {
                    return "{name}.{language}.json".replace("{name}", name).replace("{language}", language);
                }

                public String getDashboardReports(String dashboard) {
                    return "{dashboard}/reports".replace("{dashboard}", dashboard);
                }

                public List<String> getDashboardPeriods(String dashboard, String name) {
                    if (!new File(this.root, "{dashboard}/reports/{name}").exists()) {
                        return Collections.emptyList();
                    }
                    return Arrays.stream(new File(this.root, "{dashboard}/reports/{name}").listFiles()).filter(f -> f.getName().contains(".zip".replace("{dashboard}", dashboard).replace("{name}", name))).map(f -> f.getName()).collect(Collectors.toList());
                }

                public String getDashboardReport(String dashboard, String name, String period) {
                    return "{dashboard}/reports/{name}/{period}.zip".replace("{dashboard}", dashboard).replace("{name}", name).replace("{period}", period);
                }

                public String getDashboardReport(String dashboard, String name, String period, String window) {
                    return "{dashboard}/reports/{name}/{period}#{window}.zip".replace("{dashboard}", dashboard).replace("{name}", name).replace("{period}", period).replace("{window}", window);
                }

                public String getDashboardView(String dashboard, String name, String period) {
                    return "{dashboard}/views/{name}/{period}.zip".replace("{dashboard}", dashboard).replace("{name}", name).replace("{period}", period);
                }
            }
        }

        public static class Tmp {
            private final File root;
            private final String name;

            public Tmp(File parentRoot, String parent) {
                this.root = new File(parent, "tmp");
                this.root.mkdirs();
                this.name = parent + (!parent.isEmpty() ? "/" : "") + "tmp";
            }

            public String root() {
                return this.name;
            }
        }

        public static class Configuration {
            private final File root;
            private final String name;

            public Configuration(File parentRoot, String parent) {
                this.root = new File(parent, "configuration");
                this.root.mkdirs();
                this.name = parent + (!parent.isEmpty() ? "/" : "") + "configuration";
            }

            public String root() {
                return this.name;
            }

            public String getTemplate(String name) {
                return "templates/{name}".replace("{name}", name);
            }

            public String getLogo() {
                return "logo.png";
            }

            public String getLogoBase64() {
                return "logo.base64.txt";
            }

            public String getTheme() {
                return "theme.json";
            }
        }
    }

    public static class Microsites {
        private final File root;

        public Microsites(File parent) {
            this.root = new File(parent, "microsites");
            this.root.mkdirs();
        }

        public File root() {
            return this.root;
        }

        public File getSite(String id) {
            return Archetype.createParent(new File(this.root, "{id}.zip".replace("{id}", id)));
        }
    }

    public static class Datamarts {
        private final File root;

        public Datamarts(File parent) {
            this.root = new File(parent, "datamarts");
            this.root.mkdirs();
        }

        public File root() {
            return this.root;
        }

        public Dashboards dashboards() {
            return new Dashboards(this.root);
        }

        public Ledgers ledgers() {
            return new Ledgers(this.root);
        }

        public static class Ledgers {
            private final File root;

            public Ledgers(File parent) {
                this.root = new File(parent, "ledgers");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File getLedger(String name, Timetag period) {
                return Archetype.createParent(new File(this.root, "{name}/{period}.tsv".replace("{name}", name).replace("{period}", period.toString())));
            }

            public File getLedgerTranslations(String name, String language) {
                return Archetype.createParent(new File(this.root, "{name}.{language}.json".replace("{name}", name).replace("{language}", language)));
            }

            public File getLedgerDefinition(String name) {
                return Archetype.createParent(new File(this.root, "{name}.ledger".replace("{name}", name)));
            }

            public List<File> getLedgerRange(String name) {
                new File(this.root, "{name}".replace("{name}", name)).mkdirs();
                return Arrays.stream(new File(this.root, "{name}".replace("{name}", name)).listFiles()).filter(f -> f.getName().contains(".tsv")).collect(Collectors.toList());
            }
        }

        public static class Dashboards {
            private final File root;

            public Dashboards(File parent) {
                this.root = new File(parent, "dashboards");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File getDashboardDefinition(String name) {
                return Archetype.createParent(new File(this.root, "{name}.dashboard".replace("{name}", name)));
            }

            public File getDashboardTranslations(String name, String language) {
                return Archetype.createParent(new File(this.root, "{name}.{language}.json".replace("{name}", name).replace("{language}", language)));
            }

            public File getDashboardReports(String dashboard) {
                return Archetype.createParent(new File(this.root, "{dashboard}/reports".replace("{dashboard}", dashboard)));
            }

            public List<File> getDashboardPeriods(String dashboard, String name) {
                new File(this.root, "{dashboard}/reports/{name}".replace("{dashboard}", dashboard).replace("{name}", name)).mkdirs();
                return Arrays.stream(new File(this.root, "{dashboard}/reports/{name}".replace("{dashboard}", dashboard).replace("{name}", name)).listFiles()).filter(f -> f.getName().contains(".zip")).collect(Collectors.toList());
            }

            public File getDashboardReport(String dashboard, String name, String period) {
                return Archetype.createParent(new File(this.root, "{dashboard}/reports/{name}/{period}.zip".replace("{dashboard}", dashboard).replace("{name}", name).replace("{period}", period)));
            }

            public File getDashboardReport(String dashboard, String name, String period, String window) {
                return Archetype.createParent(new File(this.root, "{dashboard}/reports/{name}/{period}#{window}.zip".replace("{dashboard}", dashboard).replace("{name}", name).replace("{period}", period).replace("{window}", window)));
            }

            public File getDashboardView(String dashboard, String name, String period) {
                return Archetype.createParent(new File(this.root, "{dashboard}/views/{name}/{period}.zip".replace("{dashboard}", dashboard).replace("{name}", name).replace("{period}", period)));
            }
        }
    }

    public static class Tmp {
        private final File root;

        public Tmp(File parent) {
            this.root = new File(parent, "tmp");
            this.root.mkdirs();
        }

        public File root() {
            return this.root;
        }
    }

    public static class Configuration {
        private final File root;

        public Configuration(File parent) {
            this.root = new File(parent, "configuration");
            this.root.mkdirs();
        }

        public File root() {
            return this.root;
        }

        public File getTemplate(String name) {
            return Archetype.createParent(new File(this.root, "templates/{name}".replace("{name}", name)));
        }

        public File getLogo() {
            return Archetype.createParent(new File(this.root, "logo.png"));
        }

        public File getLogoBase64() {
            return Archetype.createParent(new File(this.root, "logo.base64.txt"));
        }

        public File getTheme() {
            return Archetype.createParent(new File(this.root, "theme.json"));
        }
    }
}

