/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.datasources;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.ui.model.TimeRange;
import io.intino.alexandria.ui.model.TimeScale;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.filters.GroupFilter;
import io.intino.alexandria.ui.model.dynamictable.Column;
import io.intino.alexandria.ui.model.dynamictable.Section;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.datasources.BaseCubeDatasource;
import io.intino.sumus.box.ui.datasources.ItemColumn;
import io.intino.sumus.box.ui.datasources.Range;
import io.intino.sumus.box.util.EmptyLedger;
import io.intino.sumus.box.util.Formatters;
import io.intino.sumus.engine.Attribute;
import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Index;
import io.intino.sumus.engine.Ledger;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.ledgers.composite.CompositeLedger;
import io.intino.sumus.model.AttributeDefinition;
import io.intino.sumus.model.IndicatorDefinition;
import io.intino.sumus.model.LedgerDefinition;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CubeDatasource
extends BaseCubeDatasource {
    public static final String NoSelection = "Sin dividir";
    public static final Slice SliceAll = CubeDatasource.sliceAll();
    private Ledger ledger = null;
    private LedgerDefinition ledgerDefinition = null;
    private Timetag timetag;
    private Timetag toTimetag;
    private String dimension = "Sin dividir";
    private String drill = null;
    private String condition;
    private List<Filter> filters = new ArrayList<Filter>();
    private boolean sameQuery = false;
    private Cube lastCube;
    private boolean transpose = false;
    private int zoomLevel = 1;

    public CubeDatasource(SumusBox box, UISession session, String name, TimeScale scale) {
        super(box, session, name, scale);
    }

    public CubeDatasource(SumusBox box, UISession session, String name, TimeScale scale, Timetag timetag) {
        super(box, session, name, scale);
        this.timetag = timetag;
    }

    private Ledger ledger() {
        if (this.ledger == null) {
            this.ledger = this.toTimetag != null && !this.timetag.equals((Object)this.toTimetag) ? this.compositeLedger() : this.box().ledger(this.name(), this.timetag);
        }
        return this.ledger;
    }

    private LedgerDefinition ledgerDefinition() {
        if (this.ledgerDefinition == null) {
            this.ledgerDefinition = this.box().ledgerDefinition(this.name());
        }
        return this.ledgerDefinition;
    }

    public List<Dimension> dimensions() {
        return this.ledger().dimensions().stream().sorted(Comparator.comparing(o -> this.translate(o.name()))).collect(Collectors.toList());
    }

    public Dimension findDimension(String key) {
        return this.ledger().dimensions().stream().filter(d -> d.name().equals(key) || this.translate(d.name()).equals(key)).findFirst().orElse(null);
    }

    public List<Slice> slices(Dimension dimension) {
        return dimension.slices();
    }

    public List<Slice> slices(Dimension dimension, Predicate<Slice> predicate) {
        if (dimension == null) {
            return Collections.emptyList();
        }
        List slices = dimension.levels() > 1 ? dimension.slices(this.zoomLevel) : dimension.slices();
        return slices.stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Slice> slices(String dimension) {
        return this.slices(this.findDimension(dimension));
    }

    public List<Column> columns() {
        List indicatorList = this.ledgerDefinition().indicators;
        return indicatorList.stream().map(this::columnOf).collect(Collectors.toList());
    }

    public String columnName(String label) {
        List indicatorList = this.ledgerDefinition().indicators;
        return indicatorList.stream().filter(e -> e.name().equals(label) || this.translate(e.name()).equals(label)).map(e -> e.name()).findFirst().orElse(null);
    }

    public List<ItemColumn> itemColumns() {
        return this.ledger().attributes().stream().map(this::itemColumnOf).collect(Collectors.toList());
    }

    public String title() {
        Object result = this.translate(Formatters.firstUpperCase(this.name()));
        result = (String)result + " [" + this.timetag.label() + (String)(this.toTimetag != null && !this.toTimetag.equals((Object)this.timetag) ? " - " + this.toTimetag.label() : "") + "]";
        return result;
    }

    public String description(String dimensionSlice, String drillSlice) {
        Object result = this.attachedValues().entrySet().stream().map(e -> this.serialize(((Dimension)e.getKey()).name(), ((Slice)e.getValue()).name())).collect(Collectors.joining("; "));
        result = (String)result + (String)(this.drill != null && drillSlice != null && !drillSlice.isEmpty() ? (((String)result).isEmpty() ? "" : "; ") + this.serialize(this.translate(this.drill), drillSlice) : "");
        result = (String)result + (String)(this.dimension != null && dimensionSlice != null && !dimensionSlice.isEmpty() ? (((String)result).isEmpty() ? "" : "; ") + this.serialize(this.translate(this.dimension), dimensionSlice) : "");
        if (this.condition != null && !this.condition.isEmpty()) {
            result = (String)result + (((String)result).isEmpty() ? "" : "; ") + this.serialize(this.translate("Condition"), this.condition);
        }
        if (this.filters != null && this.filters.size() > 0) {
            result = (String)result + (((String)result).isEmpty() ? "" : "; ") + this.filters.stream().map(f -> this.serialize(f.grouping(), this.serialize((Filter)f))).collect(Collectors.joining("; "));
        }
        return !((String)result).isEmpty() ? result : null;
    }

    public Timetag timetag() {
        return this.timetag;
    }

    public void timetag(Timetag timetag) {
        this.sameQuery = false;
        this.timetag = timetag;
        this.ledger = null;
        this.ledgerDefinition = null;
    }

    public Timetag toTimetag() {
        return this.toTimetag;
    }

    public CubeDatasource toTimetag(Timetag to) {
        this.sameQuery = false;
        this.toTimetag = to;
        this.ledger = null;
        this.ledgerDefinition = null;
        return this;
    }

    public String dimension() {
        return this.dimension;
    }

    public CubeDatasource dimension(String dimension) {
        this.sameQuery = false;
        this.dimension = dimension;
        return this;
    }

    public String drill() {
        return this.drill != null ? this.drill : this.defaultDrill();
    }

    public CubeDatasource drill(String drill) {
        this.sameQuery = false;
        this.drill = drill;
        this.zoomLevel = 1;
        return this;
    }

    public String condition() {
        return this.condition;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public CubeDatasource filters(List<Filter> filters) {
        this.sameQuery = false;
        this.filters = filters;
        return this;
    }

    public boolean transpose() {
        return this.transpose;
    }

    public CubeDatasource transpose(boolean value) {
        this.transpose = value;
        return this;
    }

    public int zoomLevel() {
        return this.zoomLevel;
    }

    public CubeDatasource zoomLevel(int level) {
        this.sameQuery = false;
        this.zoomLevel = level;
        return this;
    }

    public boolean contains(Dimension dimension) {
        return this.dimensions().stream().anyMatch(d -> d == dimension);
    }

    public boolean containsFilter(Dimension dimension) {
        return this.filters != null && this.filters.stream().anyMatch(f -> f.grouping().equalsIgnoreCase(dimension.name()));
    }

    public List<Section> sections(Ledger ledger, Cube cube, Timetag timetag) {
        Dimension dimensionObject = this.dimensionAfterTransposeFrom(cube);
        List<Slice> divideBySlices = this.dimensionAfterTranspose().equals(NoSelection) ? Collections.singletonList(SliceAll) : this.slices(dimensionObject, this.sliceFilter(this.dimensionAfterTranspose()));
        return divideBySlices.stream().filter(c -> this.canRenderSection(ledger, cube, this.dimensionAfterTranspose(), (Slice)c)).map(s -> this.sectionOf(cube, (Slice)s, this.drillAfterTranspose(), timetag)).filter(s -> s.rows().size() > 0).collect(Collectors.toList());
    }

    public List<Section> sections(Timetag timetag, String dimensionKey, String drillKey, String condition, List<Filter> filters) {
        Cube cube;
        String dimension = this.dimensionAfterTranspose(dimensionKey, drillKey);
        String drill = this.drillAfterTranspose(dimensionKey, drillKey);
        boolean sameQuery = this.sameQuery(timetag, dimensionKey, drillKey, condition, filters);
        this.saveParameters(timetag, dimensionKey, drillKey, condition, filters);
        if (this.timetag != timetag) {
            this.ledger = this.box().ledger(this.name(), timetag);
        }
        if (dimension == null || drill == null) {
            return Collections.emptyList();
        }
        Dimension drillObject = this.findDimension(drill);
        if (drillObject == null) {
            return Collections.emptyList();
        }
        this.lastCube = cube = sameQuery ? this.lastCube : this.executeQuery(this.findDimension(dimension), this.findDimension(drill), filters);
        return this.sections(this.ledger, cube, timetag);
    }

    public List<Fact> items(Timetag timetag, int start, int count, Section section, String row, String condition, List<Filter> filters, List<String> sortings) {
        return this.load(this.executeDetail(this.findDimension(this.dimensionAfterTranspose()), section, this.findDimension(this.drillAfterTranspose()), row, filters), start, count);
    }

    public long itemCount(Timetag timetag, Section section, String row, String condition, List<Filter> filters) {
        return this.loadCount(this.executeDetail(this.findDimension(this.dimensionAfterTranspose()), section, this.findDimension(this.drillAfterTranspose()), row, filters));
    }

    public Iterator<Fact> details(Timetag timetag, Section section, String row, List<Filter> filters) {
        return this.executeDetail(this.findDimension(this.dimensionAfterTranspose()), section, this.findDimension(this.drillAfterTranspose()), row, filters).iterator();
    }

    public TimeRange range() {
        Range range = this.box().ledgerRange(this.name());
        return this.rangeOf(Formatters.instantOf(range.min), Formatters.instantOf(range.max), this.timeScale());
    }

    public List<Group> groups(String key) {
        Dimension dimension = this.findDimension(key);
        return this.filter(dimension, this.slices(dimension, this.sliceFilter(key))).stream().map(this::groupOf).collect(Collectors.toList());
    }

    private Cube executeQuery(Dimension dimension, final Dimension drill, List<Filter> filters) {
        Ledger ledger = this.ledger();
        Ledger.Query query = ledger.cube();
        List<Slice> slices = this.slicesOf(ledger, query, filters);
        ArrayList<Dimension> drills = new ArrayList<Dimension>(){
            {
                this.add(drill);
            }
        };
        if (dimension != null && !dimension.name().equals(NoSelection)) {
            drills.add(dimension);
        }
        query.filter(slices.toArray(new Slice[0]));
        query.dimensions((List)drills);
        return query.build();
    }

    private Iterable<Fact> executeDetail(Dimension dimension, Section section, Dimension drillDimension, String drillValue, List<Filter> filters) {
        String drillCategory = drillValue != null ? this.slice(drillDimension, drillValue).name() : null;
        Ledger ledger = this.ledger();
        Ledger.Query query = ledger.cube();
        List<Slice> slices = this.slicesOf(ledger, query, filters);
        if (dimension != null && section != null) {
            slices.addAll(this.slicesOf(ledger, query, dimension, this.slice(dimension, section.label()).name()));
        }
        if (drillDimension != null && drillCategory != null) {
            slices.addAll(this.slicesOf(ledger, query, drillDimension, drillCategory));
        }
        query.filter(slices.toArray(new Slice[0]));
        return query.build().facts();
    }

    private Dimension dimensionAfterTransposeFrom(Cube cube) {
        return this.dimensionFrom(cube, this.dimensionAfterTranspose());
    }

    public List<Section> sections() {
        return this.sections(this.timetag(), this.dimension(), this.drill(), this.condition(), this.filters());
    }

    private List<Slice> filter(Dimension dimension, List<Slice> slices) {
        Filter filter = this.filters.stream().filter(f -> f.grouping().equalsIgnoreCase(dimension.name())).findFirst().orElse(null);
        if (filter == null) {
            return slices;
        }
        Set groups = ((GroupFilter)filter).groups();
        return slices.stream().filter(s -> groups.stream().anyMatch(g -> s.name().startsWith((String)g) || this.translate(s.name()).startsWith((String)g))).collect(Collectors.toList());
    }

    public String dimensionAfterTranspose() {
        return this.dimensionAfterTranspose(this.dimension, this.drill);
    }

    public String drillAfterTranspose() {
        return this.drillAfterTranspose(this.dimension, this.drill);
    }

    protected Timetag toTimetagOrDefault(Timetag from) {
        return this.toTimetag() != null ? this.toTimetag() : from;
    }

    private Section sectionOf(Cube cube, Slice dimensionSlice, String drill, Timetag timetag) {
        Section result = new Section(dimensionSlice.name().equals(NoSelection) || dimensionSlice.name().equals(SliceAll.name()) ? "" : this.translate(dimensionSlice.name()), "white", "#002069", 12);
        Dimension drillDimension = this.dimensionFrom(cube, drill);
        result.columns(this.columns());
        result.fontSize(9);
        result.color(this.box().theme().getOrDefault("section.color", "black"));
        result.backgroundColor(this.box().theme().getOrDefault("section.backgroundColor", "#DDDDDD"));
        result.isOrdinal(drillDimension.isOrdinal());
        List<Slice> drillBySlices = this.slices(drillDimension, this.sliceFilter(drill));
        Map<List, Cube.Cell> cellMap = cube.cells().stream().collect(Collectors.toMap(Cube.Cell::slices, c -> c));
        drillBySlices.stream().filter(s -> this.canRenderSection(this.ledger, cube, drill, (Slice)s)).forEach(s -> {
            Cube.Cell cell = this.cellOf((Map<List<Slice>, Cube.Cell>)cellMap, dimensionSlice, (Slice)s);
            if (cell == null) {
                return;
            }
            List<Double> values = this.valuesOf(cell, timetag);
            result.add(this.translate(s.name()), "", values);
        });
        return result;
    }

    private Cube.Cell cellOf(Map<List<Slice>, Cube.Cell> cellMap, Slice dimension, Slice drill) {
        ArrayList<Slice> slices = new ArrayList<Slice>();
        if (dimension != null && dimension != SliceAll) {
            slices.add(dimension);
        }
        if (drill != null) {
            slices.add(drill);
        }
        return this.cellOf(cellMap, slices);
    }

    private Cube.Cell cellOf(Map<List<Slice>, Cube.Cell> cellMap, List<Slice> slices) {
        if (cellMap.containsKey(slices)) {
            return cellMap.get(slices);
        }
        Collections.reverse(slices);
        return cellMap.getOrDefault(slices, null);
    }

    private Predicate<Slice> sliceFilter(String drill) {
        return value -> true;
    }

    private List<Double> valuesOf(Cube.Cell cell, Timetag timetag) {
        if (cell == null) {
            return this.columns().stream().map(c -> 0.0).collect(Collectors.toList());
        }
        Map<String, Object> values = cell.indicators().stream().collect(Collectors.toMap(Cube.Indicator::name, Cube.Indicator::value));
        return this.columns().stream().map(c -> {
            String columnName = this.columnName(c.label());
            Double value = this.doubleValueOf(values.getOrDefault(columnName, null));
            return value != null ? value / Math.pow(10.0, c.countDecimals()) : 0.0;
        }).collect(Collectors.toList());
    }

    private Double doubleValueOf(Object value) {
        if (value instanceof Integer) {
            return (double)((Integer)value);
        }
        if (value instanceof Long) {
            return (double)((Long)value);
        }
        return (Double)value;
    }

    private Group groupOf(Slice slice) {
        return new Group().name(slice.name()).label(this.translate(slice.name()));
    }

    private boolean sameQuery(Timetag timetag, String dimension, String drill, String condition, List<Filter> filters) {
        if (!this.sameQuery) {
            return false;
        }
        if (this.timetag == null || !this.timetag.equals((Object)timetag)) {
            return false;
        }
        if (this.condition != null && !this.condition.equals(condition)) {
            return false;
        }
        if (this.filters.size() != filters.size() || !this.serialize(this.filters).equals(this.serialize(filters))) {
            return false;
        }
        if (this.dimension == null || this.drill == null) {
            return false;
        }
        return this.drill.equals(drill) && this.dimension.equals(dimension);
    }

    private String serialize(List<Filter> filters) {
        return filters.stream().map(f -> f.grouping() + String.join((CharSequence)"", ((GroupFilter)f).groups())).collect(Collectors.joining(""));
    }

    private void saveParameters(Timetag timetag, String dimension, String drill, String condition, List<Filter> filters) {
        this.timetag = timetag;
        this.dimension = dimension;
        this.drill = drill;
        this.condition = condition;
        this.filters = filters.stream().map(f -> new GroupFilter(f.grouping(), new ArrayList(((GroupFilter)f).groups()))).collect(Collectors.toList());
        this.sameQuery = true;
    }

    private String serialize(String key, String value) {
        return this.translate(key) + ": " + value;
    }

    private String serialize(Filter filter) {
        if (!(filter instanceof GroupFilter)) {
            return "";
        }
        Set groups = ((GroupFilter)filter).groups();
        return groups.stream().collect(Collectors.joining(", "));
    }

    public List<Fact> load(Iterable<Fact> iterable, int start, int count) {
        Iterator<Fact> iterator = iterable.iterator();
        ArrayList<Fact> result = new ArrayList<Fact>();
        int current = 0;
        while (iterator.hasNext()) {
            Fact next = iterator.next();
            if (current >= start && current < start + count) {
                result.add(next);
            }
            if (current >= start + count) break;
            ++current;
        }
        return result;
    }

    private static ItemColumn textColumn(String label) {
        return new ItemColumn(label, ItemColumn.Type.Text);
    }

    private static ItemColumn linkColumn(String label, AttributeDefinition definition) {
        return new ItemColumn(label, ItemColumn.Type.Link, CubeDatasource.urlBasePath(definition));
    }

    private static String urlBasePath(AttributeDefinition definition) {
        return definition instanceof AttributeDefinition.Url ? ((AttributeDefinition.Url)definition).path() : null;
    }

    private static ItemColumn numberColumn(String label) {
        return new ItemColumn(label, ItemColumn.Type.Number);
    }

    private TimeRange rangeOf(Instant from, Instant to, TimeScale timeScale) {
        return new TimeRange(from != null ? from : Instant.now(), to != null ? to : Instant.now(), timeScale);
    }

    private long loadCount(Iterable<Fact> iterable) {
        Iterator<Fact> iterator = iterable.iterator();
        long count = 0L;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    private boolean canRenderSection(Ledger ledger, Cube cube, String dimensionKey, Slice slice) {
        Dimension dimension = this.dimensionFrom(cube, dimensionKey);
        return dimensionKey.equals(NoSelection) || dimension != null && dimension.slices().stream().anyMatch(s -> s == slice);
    }

    private Dimension dimensionFrom(Cube cube, String dimensionKey) {
        return cube.dimensions().stream().filter(d -> d.name().equals(dimensionKey) || this.translate(d.name()).equals(dimensionKey)).findFirst().orElse(null);
    }

    private String dimensionAfterTranspose(String dimension, String drill) {
        return this.transpose ? drill : dimension;
    }

    private String drillAfterTranspose(String dimension, String drill) {
        return this.transpose ? dimension : drill;
    }

    private Column columnOf(IndicatorDefinition indicator) {
        return new Column(this.translate(indicator.name()), this.operatorOf(indicator.formula())).metric(indicator.unit());
    }

    private Column.Operator operatorOf(IndicatorDefinition.Formula formula) {
        if (formula.function == IndicatorDefinition.Function.Avg) {
            return Column.Operator.Average;
        }
        return Column.Operator.Sum;
    }

    private List<Slice> slicesOf(Ledger ledger, Ledger.Query query, List<Filter> filters) {
        List<Slice> result = this.slicesOf(ledger, filters);
        this.attachedValues().forEach((key, value) -> result.addAll(new ArrayList<Slice>(this.slicesOf(ledger, key.name(), new HashSet<String>(Collections.singleton(value.name()))))));
        return result;
    }

    private List<Slice> slicesOf(Ledger ledger, String grouping, Set<String> groups) {
        Dimension dimension = ledger.dimensions().stream().filter(d -> d.name().equals(grouping)).findFirst().orElse(null);
        if (dimension == null) {
            return Collections.emptyList();
        }
        return dimension.slices().stream().filter(s -> groups.contains(s.name()) || groups.contains(this.translate(s.name()))).collect(Collectors.toList());
    }

    private List<Slice> slicesOf(Ledger ledger, Ledger.Query query, Dimension dimension, String value) {
        return this.slicesOf(ledger, dimension.name(), Set.of(value)).stream().collect(Collectors.toList());
    }

    public List<Slice> slicesOf(Ledger ledger, List<Filter> filters) {
        ArrayList<Slice> slices = new ArrayList<Slice>();
        CubeDatasource.groupByDimension(filters).forEach((dimension, values) -> {
            boolean hasPositives = values.stream().anyMatch(v -> !CubeDatasource.isNegative(v));
            if (hasPositives) {
                Set<String> positives = values.stream().filter(v -> !CubeDatasource.isNegative(v)).collect(Collectors.toSet());
                slices.addAll(this.slicesOf(ledger, (String)dimension, positives));
            } else {
                Set<String> negatives = values.stream().filter(CubeDatasource::isNegative).map(v -> v.substring(1)).collect(Collectors.toSet());
                slices.addAll(CubeDatasource.excludedSlices(ledger, dimension, negatives));
            }
        });
        return slices;
    }

    private static Map<String, Set<String>> groupByDimension(List<Filter> filters) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (Filter filter : filters) {
            Set groups = ((GroupFilter)filter).groups();
            map.putIfAbsent(filter.grouping(), new HashSet());
            ((Set)map.get(filter.grouping())).addAll(groups);
        }
        return map;
    }

    private static List<Slice> excludedSlices(Ledger ledger, String dimension, Set<String> excluded) {
        if (excluded.isEmpty()) {
            return new ArrayList<Slice>();
        }
        return ledger.dimension(dimension).slices().stream().filter(s -> excluded.stream().noneMatch(e -> e.equalsIgnoreCase(s.name()))).collect(Collectors.toList());
    }

    private static boolean isNegative(String value) {
        return value.startsWith("!");
    }

    private void addDrill(Cube cube, Ledger.Query query, Dimension drill) {
        query.dimensions(new Dimension[]{drill});
    }

    private ItemColumn itemColumnOf(Attribute attribute) {
        AttributeDefinition.Type type = attribute.type();
        if (type == AttributeDefinition.Type.int8 || type == AttributeDefinition.Type.int16 || type == AttributeDefinition.Type.int32 || type == AttributeDefinition.Type.int64 || type == AttributeDefinition.Type.real32 || type == AttributeDefinition.Type.real64) {
            return CubeDatasource.numberColumn(attribute.name());
        }
        if (type == AttributeDefinition.Type.url) {
            return CubeDatasource.linkColumn(attribute.name(), this.attributeDefinition(attribute.name()));
        }
        return CubeDatasource.textColumn(attribute.name());
    }

    private static Slice sliceAll() {
        return new Slice(){

            public Slice parent() {
                return super.parent();
            }

            public String name() {
                return "All";
            }

            public Dimension dimension() {
                return null;
            }

            public int level() {
                return super.level();
            }

            public boolean isNA() {
                return false;
            }

            public Index index() {
                return null;
            }
        };
    }

    private String defaultDrill() {
        List<Dimension> dimensions = this.dimensions();
        return dimensions.size() > 0 ? dimensions.get(0).name() : null;
    }

    private Ledger compositeLedger() {
        Timetag current = new Timetag(this.timetag.value());
        Timetag toTimetag = this.toTimetagOrDefault(this.timetag);
        CompositeLedger ledger = new CompositeLedger(this.translate("date"));
        LedgerDefinition definition = this.box().ledgerDefinition(this.name());
        while (!current.isAfter(toTimetag)) {
            Ledger currentLedger = this.box().ledger(this.name(), current, definition);
            if (!(currentLedger instanceof EmptyLedger)) {
                ledger.add(currentLedger, current.datetime().toLocalDate());
            }
            current = current.next();
        }
        return ledger;
    }

    private AttributeDefinition attributeDefinition(String attribute) {
        AttributeDefinition result = this.ledger().definition().attribute(attribute);
        if (result != null) {
            return result;
        }
        for (AttributeDefinition attr : this.ledger().definition().attributes) {
            AttributeDefinition resultMaster;
            if (attr.type() != AttributeDefinition.Type.key) continue;
            AttributeDefinition.Key key = (AttributeDefinition.Key)attr;
            LedgerDefinition masterDefinition = this.box().ledgerDefinition(key.ledgerJoin());
            if (masterDefinition == null || (resultMaster = masterDefinition.attribute(attribute)) == null) continue;
            return resultMaster;
        }
        return null;
    }
}

