import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import UserMessageTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import UserMessageTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class UserMessageTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new UserMessageTemplateNotifier(this);
		this.requester = new UserMessageTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="horizontal" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1357267807" mode="normal">
				</UiText>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(UserMessageTemplate));
DisplayFactory.register("UserMessageTemplate", withStyles(styles, { withTheme: true })(withSnackbar(UserMessageTemplate)));