import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import StoryboardsTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import StoryboardsTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class StoryboardsTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new StoryboardsTemplateNotifier(this);
		this.requester = new StoryboardsTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical centercenter" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_661498244" format="h4" mode="normal" translate={true} value="Select storyboard">
				</UiText>
				<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1362038322" multipleSelection={false}>
				</UiSelectorListBox>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(StoryboardsTemplate));
DisplayFactory.register("StoryboardsTemplate", withStyles(styles, { withTheme: true })(withSnackbar(StoryboardsTemplate)));