import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractHtmlRenderer from "../../gen/displays/AbstractHtmlRenderer";
import HtmlRendererNotifier from "../../gen/displays/notifiers/HtmlRendererNotifier";
import HtmlRendererRequester from "../../gen/displays/requesters/HtmlRendererRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';
import InnerHTML from 'dangerously-set-html-content'

const styles = theme => ({});

class HtmlRenderer extends AbstractHtmlRenderer {

	constructor(props) {
		super(props);
		this.notifier = new HtmlRendererNotifier(this);
		this.requester = new HtmlRendererRequester(this);
		this.state = {
		    ...this.state,
		    content: this.props.content != null ? this.props.content : '',
		}
	};

	render() {
	    this.refreshEvents();
	    if (this.state.content === "") return (<React.Fragment/>);
	    return (<InnerHTML id={this.props.id + "-html"} html={this.state.content} />);
	};

	openNode = (node) => {
	    this.requester.openNode(node);
	};

	openMicrosite = (cube, from, to, filtersMap, label, description) => {
	    this.showMessage(this.translate("Generating report. This operation may take time. Please wait..."), "loading");
	    this.requester.openMicrosite({ label: label, description: description, cube: cube, from: from, to: to, filters: this._filtersOf(filtersMap)});
	};

	gotoMicrosite = (link) => {
	    this.showMessage(this.translate("Report generated"), "success");
	    window.open(link);
	};

	refresh = (content) => {
	    this.setState({content});
	};

    printPage = () => {
        var w = window.open();
        var html = '<html><head><title>' + document.title + '</title>';
        html += '</head><body >';
        html += '<h1>' + document.title + '</h1>';
        html += document.getElementById(this.props.id + "-html").innerHTML;
        html += '</body></html>';
        w.document.write(html);
        w.document.close(); // necessary for IE >= 10
        w.focus(); // necessary for IE >= 10*/
        w.print();
        w.close();
        return true;
    };

	refreshEvents = () => {
        window.openNode = this.openNode.bind(this);
        window.openMicrosite = this.openMicrosite.bind(this);
    };

    _filtersOf = (filtersMap) => {
        let result = [];
        for (var idx in filtersMap) {
            const value = filtersMap[idx];
            const index = value.indexOf(":");
            result.push({ dimension: value.substring(0, index), values: [value.substring(index+1)]});
        }
        return result;
    }

}

export default withStyles(styles, { withTheme: true })(withSnackbar(HtmlRenderer));
DisplayFactory.register("HtmlRenderer", withStyles(styles, { withTheme: true })(withSnackbar(HtmlRenderer)));