/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.templates;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.Display;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.displays.HtmlRenderer;
import io.intino.sumus.box.ui.displays.templates.AbstractReportTemplate;
import io.intino.sumus.box.ui.displays.templates.CubeAnalyzeTemplate;
import io.intino.sumus.box.util.StringHelper;
import io.intino.sumus.reporting.model.DashboardDefinition;
import io.intino.sumus.reporting.model.Scale;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReportTemplate
extends AbstractReportTemplate<SumusBox> {
    private String dashboard;
    private String report;
    private Timetag period;
    private Scale scale;
    private String window;
    private String rootNode;
    private String node;
    private String nodeContent;
    private boolean admin;

    public ReportTemplate(Box box) {
        super((SumusBox)box);
    }

    public ReportTemplate dashboard(String dashboard) {
        this.dashboard = dashboard;
        return this;
    }

    public ReportTemplate report(String report) {
        this.report = report;
        return this;
    }

    public ReportTemplate period(String period) {
        return this.period(new Timetag(period));
    }

    public ReportTemplate period(Timetag period) {
        this.period = period;
        return this;
    }

    public ReportTemplate scale(Scale scale) {
        this.scale = scale;
        return this;
    }

    public ReportTemplate window(String window) {
        this.window = window;
        return this;
    }

    public ReportTemplate rootNode(String node) {
        this.rootNode = node;
        this.node = node;
        return this;
    }

    public ReportTemplate node(String node) {
        this.node = node;
        return this;
    }

    public ReportTemplate admin(String value) {
        return this.admin(Boolean.parseBoolean(value));
    }

    public ReportTemplate admin(boolean value) {
        this.admin = value;
        return this;
    }

    public void open(String report) {
        this.report = report;
        this.refresh();
    }

    public void didMount() {
        super.didMount();
        this.reportDisplay.display(this.initHtmlRenderer());
        this.refreshReport(true);
    }

    @Override
    public void init() {
        super.init();
        this.printPage.onExecute(e -> ((HtmlRenderer)this.reportDisplay.display()).printPage());
    }

    public void refresh() {
        super.refresh();
        this.refreshReport(true);
    }

    private Display<?, ?> initHtmlRenderer() {
        HtmlRenderer result = new HtmlRenderer((SumusBox)this.box());
        result.id(this.reportDisplay.display() != null ? this.reportDisplay.display().id() : UUID.randomUUID().toString());
        result.onOpenNode(this::openNode);
        return result;
    }

    private void openNode(String node) {
        this.node = node;
        this.refresh();
    }

    private void refreshReport(boolean force) {
        if (this.dashboard == null || this.report == null || this.period == null || this.node == null) {
            return;
        }
        this.refreshNode(force);
        this.refreshToolbar();
    }

    private void refreshNode(boolean force) {
        String nodeContent = this.nodeContent();
        if (!force && this.nodeContent != null && this.nodeContent.equals(nodeContent)) {
            return;
        }
        this.nodeContent = nodeContent;
        boolean existsReport = this.nodeContent != null;
        this.noReportBlock.visible(!existsReport);
        this.reportBlock.hide();
        if (!existsReport) {
            return;
        }
        this.loadingBlock.show();
        HtmlRenderer renderer = (HtmlRenderer)this.reportDisplay.display();
        if (renderer == null) {
            return;
        }
        renderer.dashboard(this.dashboard);
        renderer.content(StringHelper.translateContent(this.nodeContent, this.admin, this.translator()));
        renderer.refresh();
        this.loadingBlock.hide();
        this.reportBlock.show();
    }

    private void refreshToolbar() {
        DashboardDefinition definition = ((SumusBox)this.box()).dashboardDefinition(this.dashboard);
        this.analyzeList.clear();
        List<String> ledgers = definition.reportDefinitions().stream().filter(d -> d.name().equals(this.report)).map(DashboardDefinition.ReportDefinition::ledgers).flatMap(Collection::stream).collect(Collectors.toList());
        ledgers.forEach(l -> this.fill((String)l, (CubeAnalyzeTemplate)this.analyzeList.add()));
    }

    private void fill(String ledger, CubeAnalyzeTemplate display) {
        display.dashboard(this.dashboard);
        display.cube(ledger);
        display.period(this.period);
        display.node(this.node);
        display.refresh();
    }

    private Function<String, String> translator() {
        Map<String, String> translations = this.ledgerTranslations();
        translations.putAll(((SumusBox)this.box()).dashboardTranslations(this.dashboard, this.language()));
        return word -> translations.getOrDefault(word, (String)word);
    }

    private Map<String, String> ledgerTranslations() {
        DashboardDefinition.ReportDefinition reportDefinition = ((SumusBox)this.box()).dashboardDefinition(this.dashboard).reportDefinitions().stream().filter(rd -> rd.name().equals(this.report)).findFirst().orElse(null);
        if (reportDefinition == null) {
            return new HashMap<String, String>();
        }
        return reportDefinition.ledgers().stream().map(l -> ((SumusBox)this.box()).ledgerTranslations((String)l, this.language())).reduce((map1, map2) -> Stream.concat(map1.entrySet().stream(), map2.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (translation1, translation2) -> translation1))).get();
    }

    private String nodeContent() {
        return ((SumusBox)this.box()).reportNode(this.dashboard, this.report, this.period, this.scale, this.window, this.node);
    }
}

