/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays.templates;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.ui.displays.components.BlockConditional;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.displays.templates.AbstractAppTemplate;
import io.intino.sumus.reporting.model.DashboardDefinition;
import java.util.Arrays;
import java.util.List;

public class AppTemplate
extends AbstractAppTemplate<SumusBox> {
    private Page current = null;
    private boolean embedded = false;

    public AppTemplate(SumusBox box) {
        super(box);
    }

    public void embedded(boolean embedded) {
        if (!embedded) {
            return;
        }
        this.header.embedded(true);
        this.embedded = embedded;
    }

    public void openHome() {
        if (((SumusBox)this.box()).ledgers().size() > 0) {
            this.openCubes();
        } else if (((SumusBox)this.box()).dashboards().size() > 0) {
            this.openDashboards();
        } else {
            this.loading.hide();
        }
    }

    public void openDashboards() {
        this.openPage(Page.Dashboards);
        if (this.dashboardsPage.dashboardsStamp != null) {
            this.dashboardsPage.dashboardsStamp.refresh();
        }
    }

    public void openDashboard(String dashboard) {
        List reportDefinitionList = ((SumusBox)this.box()).dashboardDefinition(dashboard).reportDefinitions();
        this.openReport(dashboard, reportDefinitionList.size() > 0 ? ((DashboardDefinition.ReportDefinition)reportDefinitionList.get(0)).name() : null, null, null);
    }

    public void openReport(String dashboard, String report, Timetag period, String node) {
        this.openPage(Page.Dashboard);
        if (this.dashboardPage.dashboardStamp != null) {
            this.dashboardPage.dashboardStamp.open(dashboard, report, period, node);
        }
    }

    public void openCubes() {
        List<String> ledgers = ((SumusBox)this.box()).ledgers();
        this.openCube(ledgers.size() > 0 ? ledgers.get(0) : null);
    }

    public void openCube(String cube) {
        this.openPage(Page.Cube);
        if (this.cubePage.cubeStamp != null) {
            this.cubePage.cubeStamp.open(cube, this.embedded);
        }
    }

    public void openCube(String cube, String period, String drill, String filters) {
        this.openPage(Page.Cube);
        if (this.cubePage.cubeStamp != null) {
            this.cubePage.cubeStamp.open(cube, period, drill, filters, this.embedded);
        }
    }

    public void refresh() {
        super.refresh();
        this.refreshCurrentPage();
    }

    private boolean openPage(Page page) {
        if (page == this.current) {
            return false;
        }
        this.loading.visible(false);
        this.header.page(page);
        this.header.refresh();
        this.hideBlocks();
        this.blockOf(page).show();
        this.current = page;
        return true;
    }

    private void hideBlocks() {
        if (this.dashboardsPage.isVisible()) {
            this.dashboardsPage.hide();
        }
        if (this.dashboardPage.isVisible()) {
            this.dashboardPage.hide();
        }
        if (this.cubePage.isVisible()) {
            this.cubePage.hide();
        }
    }

    private BlockConditional blockOf(Page page) {
        if (page == Page.Dashboards) {
            return this.dashboardsPage;
        }
        if (page == Page.Dashboard || page == Page.Report) {
            return this.dashboardPage;
        }
        if (page == Page.Cubes || page == Page.Cube) {
            return this.cubePage;
        }
        return null;
    }

    private void refreshCurrentPage() {
        if (this.current == Page.Dashboards) {
            this.dashboardsPage.dashboardsStamp.refresh();
        } else if (this.current == Page.Dashboard || this.current == Page.Report) {
            this.dashboardPage.dashboardStamp.refresh();
        } else if (this.current == Page.Cubes || this.current == Page.Cube) {
            this.cubePage.cubeStamp.refresh();
        }
    }

    public static enum Page {
        Dashboards,
        Dashboard,
        Report,
        Cubes,
        Cube;


        public static Page from(String key) {
            return Arrays.stream(Page.values()).filter(v -> v.name().equalsIgnoreCase(key)).findFirst().orElse(null);
        }
    }
}

