/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.spark.PushService;
import io.intino.alexandria.ui.UI;
import io.intino.alexandria.ui.UISpark;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import io.intino.alexandria.ui.displays.notifiers.ItemNotifier;
import io.intino.alexandria.ui.displays.notifiers.RowNotifier;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.intino.alexandria.ui.displays.requesters.DisplayPushRequester;
import io.intino.alexandria.ui.displays.requesters.ItemPushRequester;
import io.intino.alexandria.ui.displays.requesters.ItemRequester;
import io.intino.alexandria.ui.displays.requesters.RowPushRequester;
import io.intino.alexandria.ui.displays.requesters.RowRequester;
import io.intino.alexandria.ui.displays.requesters.TemplatePushRequester;
import io.intino.alexandria.ui.displays.requesters.TemplateRequester;
import io.intino.alexandria.ui.resources.AssetResourceLoader;
import io.intino.alexandria.ui.spark.UIRouter;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.alexandria.ui.spark.resources.AfterDisplayRequest;
import io.intino.alexandria.ui.spark.resources.AssetResource;
import io.intino.alexandria.ui.spark.resources.AuthenticateCallbackResource;
import io.intino.alexandria.ui.spark.resources.BeforeDisplayRequest;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.SumusConfiguration;
import io.intino.sumus.box.ui.displays.CubeBarChart;
import io.intino.sumus.box.ui.displays.HtmlRenderer;
import io.intino.sumus.box.ui.displays.items.CubeIndicatorsItem;
import io.intino.sumus.box.ui.displays.notifiers.CubeBarChartNotifier;
import io.intino.sumus.box.ui.displays.notifiers.CubeTemplateNotifier;
import io.intino.sumus.box.ui.displays.notifiers.CubeTemplateProxyNotifier;
import io.intino.sumus.box.ui.displays.notifiers.DashboardTemplateNotifier;
import io.intino.sumus.box.ui.displays.notifiers.DashboardTemplateProxyNotifier;
import io.intino.sumus.box.ui.displays.notifiers.HtmlRendererNotifier;
import io.intino.sumus.box.ui.displays.notifiers.ReportTemplateNotifier;
import io.intino.sumus.box.ui.displays.notifiers.ReportTemplateProxyNotifier;
import io.intino.sumus.box.ui.displays.requesters.CubeBarChartPushRequester;
import io.intino.sumus.box.ui.displays.requesters.CubeBarChartRequester;
import io.intino.sumus.box.ui.displays.requesters.CubeTemplateProxyRequester;
import io.intino.sumus.box.ui.displays.requesters.DashboardTemplateProxyRequester;
import io.intino.sumus.box.ui.displays.requesters.HtmlRendererPushRequester;
import io.intino.sumus.box.ui.displays.requesters.HtmlRendererRequester;
import io.intino.sumus.box.ui.displays.requesters.ReportTemplateProxyRequester;
import io.intino.sumus.box.ui.displays.rows.CubeTableRow;
import io.intino.sumus.box.ui.displays.templates.AppTemplate;
import io.intino.sumus.box.ui.displays.templates.AttachedTemplateItem;
import io.intino.sumus.box.ui.displays.templates.CubeAnalyzeTemplate;
import io.intino.sumus.box.ui.displays.templates.CubeDialog;
import io.intino.sumus.box.ui.displays.templates.CubeTemplate;
import io.intino.sumus.box.ui.displays.templates.CubeTemplateProxy;
import io.intino.sumus.box.ui.displays.templates.CubeViewer;
import io.intino.sumus.box.ui.displays.templates.DashboardTemplate;
import io.intino.sumus.box.ui.displays.templates.DashboardTemplateProxy;
import io.intino.sumus.box.ui.displays.templates.DashboardsTemplate;
import io.intino.sumus.box.ui.displays.templates.Header;
import io.intino.sumus.box.ui.displays.templates.ReportTemplate;
import io.intino.sumus.box.ui.displays.templates.ReportTemplateProxy;
import io.intino.sumus.box.ui.displays.templates.SiteTemplate;
import io.intino.sumus.box.ui.resources.CubeQueryResource;
import io.intino.sumus.box.ui.resources.CubeResource;
import io.intino.sumus.box.ui.resources.CubeTemplateProxyResource;
import io.intino.sumus.box.ui.resources.CubesResource;
import io.intino.sumus.box.ui.resources.DashboardResource;
import io.intino.sumus.box.ui.resources.DashboardTemplateProxyResource;
import io.intino.sumus.box.ui.resources.DashboardsResource;
import io.intino.sumus.box.ui.resources.HomeResource;
import io.intino.sumus.box.ui.resources.ReportResource;
import io.intino.sumus.box.ui.resources.ReportTemplateProxyResource;
import io.intino.sumus.box.ui.resources.SitesIndexResource;
import io.intino.sumus.box.ui.resources.SitesResource;

public class SumusElementsService
extends UI {
    public static void init(UISpark spark, SumusBox box, io.intino.alexandria.ui.services.push.PushService pushService, DisplayRouteDispatcher routeDispatcher) {
        SumusConfiguration configuration = box.configuration();
        box.routeManager(SumusElementsService.routeManager((UISpark)spark, (DisplayRouteDispatcher)routeDispatcher));
        ((UIRouter)spark.route("/push")).push((PushService)pushService);
        ((UIRouter)spark.route("/authenticate-callback")).get(manager -> new AuthenticateCallbackResource(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/asset/:name")).get(manager -> new AssetResource(name -> new AssetResourceLoader((Box)box).load(name), manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/alexandria/user")).get(manager -> new HomeResource(box, (UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/")).get(manager -> new HomeResource(box, (UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/dashboards")).get(manager -> new DashboardsResource(box, (UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/dashboard/:dashboard")).get(manager -> new DashboardResource(box, (UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/dashboard/:dashboard/:report/:period/:node")).get(manager -> new ReportResource(box, (UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/olap")).get(manager -> new CubesResource(box, (UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/olap/:cube")).get(manager -> new CubeResource(box, (UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/olap/:cube/:period/:drill/:filters")).get(manager -> new CubeQueryResource(box, (UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/drills/:timetag/:id/")).get(manager -> new SitesIndexResource(box, (UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/drills/:timetag/:id/:page")).get(manager -> new SitesResource(box, (UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/dashboardtemplateproxy/:displayId/personify")).post(manager -> new DashboardTemplateProxyResource(box, (UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/reporttemplateproxy/:displayId/personify")).post(manager -> new ReportTemplateProxyResource(box, (UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/cubetemplateproxy/:displayId/personify")).post(manager -> new CubeTemplateProxyResource(box, (UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        SumusElementsService.initDisplays(spark, pushService);
    }

    public static void initDisplays(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        SumusElementsService.initDashboardTemplate(spark, pushService);
        SumusElementsService.initReportTemplate(spark, pushService);
        SumusElementsService.initCubeAnalyzeTemplate(spark, pushService);
        SumusElementsService.initHtmlRenderer(spark, pushService);
        SumusElementsService.initCubeTemplate(spark, pushService);
        SumusElementsService.initCubeDialog(spark, pushService);
        SumusElementsService.initCubeViewer(spark, pushService);
        SumusElementsService.initCubeBarChart(spark, pushService);
        SumusElementsService.initAttachedTemplateItem(spark, pushService);
        SumusElementsService.initAppTemplate(spark, pushService);
        SumusElementsService.initDashboardsTemplate(spark, pushService);
        SumusElementsService.initSiteTemplate(spark, pushService);
        SumusElementsService.initHeader(spark, pushService);
        SumusElementsService.initCubeIndicatorsItem(spark, pushService);
        SumusElementsService.initCubeTableRow(spark, pushService);
        SumusElementsService.registerNotifiers();
    }

    private static void registerNotifiers() {
        SumusElementsService.register(DashboardTemplateNotifier.class).forDisplay(DashboardTemplate.class);
        SumusElementsService.register(DashboardTemplateProxyNotifier.class).forDisplay(DashboardTemplateProxy.class);
        SumusElementsService.register(ReportTemplateNotifier.class).forDisplay(ReportTemplate.class);
        SumusElementsService.register(ReportTemplateProxyNotifier.class).forDisplay(ReportTemplateProxy.class);
        SumusElementsService.register(TemplateNotifier.class).forDisplay(CubeAnalyzeTemplate.class);
        SumusElementsService.register(HtmlRendererNotifier.class).forDisplay(HtmlRenderer.class);
        SumusElementsService.register(CubeTemplateNotifier.class).forDisplay(CubeTemplate.class);
        SumusElementsService.register(CubeTemplateProxyNotifier.class).forDisplay(CubeTemplateProxy.class);
        SumusElementsService.register(TemplateNotifier.class).forDisplay(CubeDialog.class);
        SumusElementsService.register(TemplateNotifier.class).forDisplay(CubeViewer.class);
        SumusElementsService.register(CubeBarChartNotifier.class).forDisplay(CubeBarChart.class);
        SumusElementsService.register(TemplateNotifier.class).forDisplay(AttachedTemplateItem.class);
        SumusElementsService.register(TemplateNotifier.class).forDisplay(AppTemplate.class);
        SumusElementsService.register(TemplateNotifier.class).forDisplay(DashboardsTemplate.class);
        SumusElementsService.register(TemplateNotifier.class).forDisplay(SiteTemplate.class);
        SumusElementsService.register(TemplateNotifier.class).forDisplay(Header.class);
        SumusElementsService.register(ItemNotifier.class).forDisplay(CubeIndicatorsItem.class);
        SumusElementsService.register(RowNotifier.class).forDisplay(CubeTableRow.class);
    }

    private static void initDashboardTemplate(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/dashboardtemplate/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/dashboardtemplate/:displayId")).post(manager -> new TemplateRequester(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/dashboardtemplate/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("dashboardtemplate", (DisplayPushRequester)new TemplatePushRequester());
        ((UIRouter)spark.route("/dashboardtemplateproxy/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/dashboardtemplateproxy/:displayId")).post(manager -> new DashboardTemplateProxyRequester((UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/dashboardtemplateproxy/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
    }

    private static void initReportTemplate(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/reporttemplate/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/reporttemplate/:displayId")).post(manager -> new TemplateRequester(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/reporttemplate/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("reporttemplate", (DisplayPushRequester)new TemplatePushRequester());
        ((UIRouter)spark.route("/reporttemplateproxy/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/reporttemplateproxy/:displayId")).post(manager -> new ReportTemplateProxyRequester((UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/reporttemplateproxy/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
    }

    private static void initCubeAnalyzeTemplate(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/cubeanalyzetemplate/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/cubeanalyzetemplate/:displayId")).post(manager -> new TemplateRequester(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/cubeanalyzetemplate/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("cubeanalyzetemplate", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initHtmlRenderer(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/htmlrenderer/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/htmlrenderer/:displayId")).post(manager -> new HtmlRendererRequester((UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/htmlrenderer/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("htmlrenderer", (DisplayPushRequester)new HtmlRendererPushRequester());
    }

    private static void initCubeTemplate(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/cubetemplate/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/cubetemplate/:displayId")).post(manager -> new TemplateRequester(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/cubetemplate/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("cubetemplate", (DisplayPushRequester)new TemplatePushRequester());
        ((UIRouter)spark.route("/cubetemplateproxy/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/cubetemplateproxy/:displayId")).post(manager -> new CubeTemplateProxyRequester((UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/cubetemplateproxy/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
    }

    private static void initCubeDialog(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/cubedialog/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/cubedialog/:displayId")).post(manager -> new TemplateRequester(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/cubedialog/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("cubedialog", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initCubeViewer(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/cubeviewer/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/cubeviewer/:displayId")).post(manager -> new TemplateRequester(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/cubeviewer/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("cubeviewer", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initCubeBarChart(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/cubebarchart/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/cubebarchart/:displayId")).post(manager -> new CubeBarChartRequester((UISparkManager)manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/cubebarchart/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("cubebarchart", (DisplayPushRequester)new CubeBarChartPushRequester());
    }

    private static void initAttachedTemplateItem(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/attachedtemplateitem/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/attachedtemplateitem/:displayId")).post(manager -> new TemplateRequester(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/attachedtemplateitem/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("attachedtemplateitem", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initAppTemplate(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/apptemplate/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/apptemplate/:displayId")).post(manager -> new TemplateRequester(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/apptemplate/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("apptemplate", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initDashboardsTemplate(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/dashboardstemplate/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/dashboardstemplate/:displayId")).post(manager -> new TemplateRequester(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/dashboardstemplate/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("dashboardstemplate", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initSiteTemplate(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/sitetemplate/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sitetemplate/:displayId")).post(manager -> new TemplateRequester(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sitetemplate/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("sitetemplate", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initHeader(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/header/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/header/:displayId")).post(manager -> new TemplateRequester(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/header/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("header", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initCubeIndicatorsItem(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/cubeindicatorsitem/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/cubeindicatorsitem/:displayId")).post(manager -> new ItemRequester(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/cubeindicatorsitem/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("cubeindicatorsitem", (DisplayPushRequester)new ItemPushRequester());
    }

    private static void initCubeTableRow(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/cubetablerow/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/cubetablerow/:displayId")).post(manager -> new RowRequester(manager, SumusElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/cubetablerow/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("cubetablerow", (DisplayPushRequester)new RowPushRequester());
    }
}

