/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.AlexandriaSparkBuilder;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.UISpark;
import io.intino.alexandria.ui.UiElementsService;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.TranslatorService;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.sumus.box.I18n;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.SumusConfiguration;
import io.intino.sumus.box.ui.SumusElementsService;
import io.intino.sumus.box.ui.displays.RouteDispatcher;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends AlexandriaUiBox {
    protected SumusConfiguration configuration;
    protected Map<String, Soul> uiSouls = new HashMap<String, Soul>();
    private List<AlexandriaUiBox.SoulsClosed> soulsClosedListeners = new ArrayList<AlexandriaUiBox.SoulsClosed>();
    private AuthService authService;
    private PushService pushService;

    public AbstractBox(String[] args) {
        this(new SumusConfiguration(args));
    }

    public AbstractBox(SumusConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
    }

    public SumusConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        return this;
    }

    public abstract void beforeStart();

    public Box start() {
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.startServices();
        }
        this.startServices();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    public abstract void afterStart();

    public abstract void beforeStop();

    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stopServices();
        }
        this.stopServices();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    public void stopServices() {
        AlexandriaSparkBuilder.instance().stop();
    }

    public abstract void afterStop();

    public void startServices() {
        this.initUI();
        this.initConnector();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initDatalake();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
        this.initAgenda();
    }

    public PushService pushService() {
        return this.pushService;
    }

    public List<Soul> souls() {
        return new ArrayList<Soul>(this.uiSouls.values());
    }

    public Optional<Soul> soul(String clientId) {
        return Optional.ofNullable(this.uiSouls.get(clientId));
    }

    public void registerSoul(String clientId, Soul soul) {
        this.uiSouls.put(clientId, soul);
    }

    public void unRegisterSoul(String clientId) {
        this.uiSouls.remove(clientId);
        if (this.uiSouls.size() <= 0) {
            this.notifySoulsClosed();
        }
    }

    public void onSoulsClosed(AlexandriaUiBox.SoulsClosed listener) {
        this.soulsClosedListeners.add(listener);
    }

    private void notifySoulsClosed() {
        this.soulsClosedListeners.forEach(l -> l.accept());
    }

    protected abstract AuthService authService(URL var1);

    public void setupUi() {
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        this.authService = this.authService(this.url(this.configuration().get("federation_url")));
        AlexandriaSparkBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/");
        AlexandriaSparkBuilder.setUI((boolean)true);
        AlexandriaSparkBuilder.addParameters((Object[])new Object[]{this.authService});
        this.pushService = new PushService();
        UISpark sparkInstance = (UISpark)AlexandriaSparkBuilder.instance();
        SumusElementsService.init(sparkInstance, (SumusBox)this, this.pushService, new RouteDispatcher());
        UiElementsService.initDisplays((UISpark)sparkInstance, (PushService)this.pushService);
    }

    private void initRestServices() {
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
        this.setupUi();
        this.initTranslatorService();
        UISpark sparkInstance = (UISpark)AlexandriaSparkBuilder.instance();
        sparkInstance.start();
        io.intino.alexandria.logger.Logger.info((String)("UI SumusElements: started at port " + this.configuration().get("port") + "!"));
    }

    private void initTranslatorService() {
        this.translatorService = new TranslatorService();
        this.translatorService.addAll(I18n.dictionaries());
        this.translatorService.addAll(io.intino.alexandria.I18n.dictionaries());
    }

    private void initDatalake() {
    }

    private void initConnector() {
    }

    private void initTerminal() {
    }

    private void initSentinels() {
    }

    private void initWorkflow() {
    }

    private void initAgenda() {
    }

    private void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new io.intino.alexandria.logger.Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
        io.intino.alexandria.logger4j.Logger.init();
    }

    protected URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

