import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiDisplayStamp from "alexandria-ui-elements/src/displays/components/DisplayStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysHtmlRenderer from "sumus-elements/src/displays/HtmlRenderer";
import DisplaysCubeAnalyzeTemplate from "sumus-elements/gen/displays/templates/CubeAnalyzeTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ReportTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ReportTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ReportTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ReportTemplateNotifier(this);
		this.requester = new ReportTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="vertical flexible" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_162182205" visible={false} layout="vertical centercenter flexible">
					<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_162182205.a1786721586" format="secondary" mode="Rise">
					</UiSpinner>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_85772698" visible={false} layout="vertical centercenter flexible">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_85772698.a1403437482" format="h5" mode="normal" translate={true} value="No report found">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600571289" visible={false} layout="vertical flexible">
					<UiDisplayStamp context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600571289.a1330834710">
					</UiDisplayStamp>
					<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600571289.a415290116" title="Print page" target="self" mode="Link" size="Medium">
					</UiAction>
					<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600571289.a1069349426" multiple={{instances:"analyzeList",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
					</UiMultiple>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(ReportTemplate));
DisplayFactory.register("ReportTemplate", withStyles(styles, { withTheme: true })(withSnackbar(ReportTemplate)));