import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiDisplayStamp from "alexandria-ui-elements/src/displays/components/DisplayStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import UiDynamicTable from "alexandria-ui-elements/src/displays/components/DynamicTable";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiGroupingToolbar from "alexandria-ui-elements/src/displays/components/GroupingToolbar";
import UiGrouping from "alexandria-ui-elements/src/displays/components/Grouping";
import DisplaysCubeTableRow from "sinergia-elements/gen/displays/rows/CubeTableRow";
import DisplaysCubeIndicatorsItem from "sinergia-elements/gen/displays/items/CubeIndicatorsItem";
import DisplaysCubeBarChart from "sinergia-elements/src/displays/CubeBarChart";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CubeNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CubeRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Cube extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CubeNotifier(this);
		this.requester = new CubeRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="relative" layout="horizontal flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1362887758" format="cubeStyle overflowAuto relative" layout="vertical flexible">
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1362887758.a268824453" layout="vertical flexible">
						<UiDynamicTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1362887758.a268824453.a_731715489" noItemsMessage="There is no facts" itemHeight={60} scrollingMark={true}>
							<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1362887758.a268824453.a_731715489.a679643630" style={{width:"30%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1362887758.a268824453.a_731715489.a679643630.a_1455709147" mode="normal" value="Indicators">
								</UiText>
							</UiHeading>
						</UiDynamicTable>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1362887758.a2114062737" format="airTop" layout="vertical flexible">
						<UiDisplayStamp context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1362887758.a2114062737.a_1248045362">
						</UiDisplayStamp>
					</UiBlockConditional>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_207666531" format="filtersBlockStyle" visible={false} layout="vertical" width="25.0%" height="100.0%">
					<UiGroupingToolbar context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_207666531.a1873292118" format="orangeBorder airBottom">
					</UiGroupingToolbar>
					<UiGrouping context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_207666531.a373820114" label="Test dimension" format="airBottom" visible={false} pageSize={5}>
					</UiGrouping>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(Cube));
DisplayFactory.register("Cube", withStyles(styles, { withTheme: true })(withSnackbar(Cube)));