import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import CubeScreenItemNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import CubeScreenItemRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CubeScreenItem extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new CubeScreenItemNotifier(this);
		this.requester = new CubeScreenItemRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1922809721" mode="normal">
				</UiText>
			</div>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(CubeScreenItem));
DisplayFactory.register("CubeScreenItem", withStyles(styles, { withTheme: true })(withSnackbar(CubeScreenItem)));