/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.displays;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.filters.GroupFilter;
import io.intino.alexandria.ui.model.dynamictable.Section;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.schemas.MicrositeFilter;
import io.intino.sumus.box.schemas.MicrositeParams;
import io.intino.sumus.box.schemas.ViewContent;
import io.intino.sumus.box.schemas.ViewParams;
import io.intino.sumus.box.ui.datasources.CubeDatasource;
import io.intino.sumus.box.ui.datasources.MicroSiteBuilderOfCube;
import io.intino.sumus.box.ui.displays.AbstractHtmlRenderer;
import io.intino.sumus.box.ui.displays.DisplayHelper;
import io.intino.sumus.box.ui.displays.notifiers.HtmlRendererNotifier;
import io.intino.sumus.box.util.TimetagHelper;
import io.intino.sumus.engine.Dimension;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.reporting.model.Scale;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HtmlRenderer
extends AbstractHtmlRenderer<SumusBox> {
    private String dashboard;
    private String content;
    private Consumer<String> openNodeListener;
    private Function<ViewParams, String> openViewListener;
    private Consumer<Scale> selectScaleListener;
    private Consumer<String> selectWindowListener;

    public HtmlRenderer(SumusBox box) {
        super(box);
    }

    public HtmlRenderer dashboard(String dashboard) {
        this.dashboard = dashboard;
        return this;
    }

    public HtmlRenderer content(String content) {
        this.content = content;
        return this;
    }

    public HtmlRenderer onOpenNode(Consumer<String> listener) {
        this.openNodeListener = listener;
        return this;
    }

    public HtmlRenderer onOpenView(Function<ViewParams, String> listener) {
        this.openViewListener = listener;
        return this;
    }

    public HtmlRenderer onSelectScale(Consumer<Scale> listener) {
        this.selectScaleListener = listener;
        return this;
    }

    public HtmlRenderer onSelectWindow(Consumer<String> listener) {
        this.selectWindowListener = listener;
        return this;
    }

    public void printPage() {
        ((HtmlRendererNotifier)this.notifier).printPage();
    }

    public void refresh() {
        super.refresh();
        ((HtmlRendererNotifier)this.notifier).refresh(this.content);
    }

    public void refreshEvents() {
        ((HtmlRendererNotifier)this.notifier).refreshEvents();
    }

    public void openNode(String area) {
        this.openNodeListener.accept(area);
    }

    public void openView(ViewParams params) {
        ((HtmlRendererNotifier)this.notifier).gotoView(this.contentOf(this.openViewListener.apply(params), params));
    }

    private ViewContent contentOf(String content, ViewParams params) {
        return new ViewContent().content(content).view(params.view()).period(params.period());
    }

    public void selectScale(String scale) {
        this.selectScaleListener.accept(Scale.valueOf((String)scale));
    }

    public void selectWindow(String window) {
        this.selectWindowListener.accept(window);
    }

    public void openMicrosite(MicrositeParams params) {
        ((HtmlRendererNotifier)this.notifier).generatingMicrosite();
        Timetag timetag = new Timetag(params.from());
        CubeDatasource source = new CubeDatasource((SumusBox)this.box(), this.session(), params.cube(), TimetagHelper.scaleFrom(timetag), timetag);
        Dimension dimension = this.dimensionFrom(source, params);
        List<Filter> filters = this.filtersOf(params.filters());
        Section section = new Section(source.translate(dimension.name()));
        source.drill(source.translate(dimension.name()));
        source.timetag(timetag);
        source.filters(filters);
        source.toTimetag(new Timetag(params.to()));
        String label = params.label() != null && !params.label().isEmpty() ? params.label() : source.title();
        String description = params.description() != null && !params.description().isEmpty() ? params.description() : source.description(null, null);
        MicroSiteBuilderOfCube builder = new MicroSiteBuilderOfCube((SumusBox)this.box(), DisplayHelper.cellProvider((SumusBox)this.box(), source), this.language());
        Iterator<Fact> details = source.details(source.timetag(), section, null, filters);
        String result = builder.build(timetag, label, description, source.itemColumns(), details);
        String url = ((SumusBox)this.box()).configuration().url();
        ((HtmlRendererNotifier)this.notifier).gotoMicrosite(url + (url.endsWith("/") ? "" : "/") + "drills/" + timetag + "/" + result + "/");
    }

    private Dimension dimensionFrom(CubeDatasource source, MicrositeParams params) {
        return params.filters().size() > 0 ? source.findDimension(params.filters().get(0).dimension()) : source.findDimension(((SumusBox)this.box()).dashboardDefinition(this.dashboard).navigation());
    }

    private List<String> dimensionValuesFrom(MicrositeParams params) {
        MicrositeFilter filter;
        MicrositeFilter micrositeFilter = filter = params.filters().size() > 0 ? params.filters().get(0) : null;
        if (filter == null || filter.values().size() <= 0) {
            return List.of(this.session().preference("territory"));
        }
        return filter.values();
    }

    private List<Filter> filtersOf(List<MicrositeFilter> filters) {
        return filters.stream().map(this::filterOf).collect(Collectors.toList());
    }

    private Filter filterOf(MicrositeFilter filter) {
        return new GroupFilter(filter.dimension(), filter.values());
    }

    private String language() {
        return this.session() != null ? this.session().discoverLanguage() : "en";
    }
}

