/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.ui.datasources;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zip.Zip;
import io.intino.sumus.box.I18n;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.ui.datasources.ItemColumn;
import io.intino.sumus.box.ui.datasources.SumusMicroSiteBuilder;
import io.intino.sumus.engine.Fact;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MicroSiteBuilderOfCube
extends SumusMicroSiteBuilder {
    private final SumusBox box;
    private final CellProvider provider;
    private final Map<String, String> pages = new HashMap<String, String>();
    private final String language;
    private static final int PageSize = 1000;
    private static final int MaxMicroSiteSize = 50000;

    public MicroSiteBuilderOfCube(SumusBox box, CellProvider provider, String language) {
        this.box = box;
        this.provider = provider;
        this.language = language;
    }

    public String build(Timetag timetag, String title, String description, List<ItemColumn> columns, Iterator<Fact> rows) {
        try {
            String id = UUID.randomUUID().toString();
            File cubeSite = this.box.archetype().microsites().getSite(id);
            cubeSite.getParentFile().mkdirs();
            Zip zip = new Zip(cubeSite);
            this.pages.clear();
            this.generatePages(id, title, description, columns, rows);
            zip.write(this.pages);
            return id;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private void generatePages(String id, String title, String description, List<ItemColumn> columns, Iterator<Fact> rows) throws IOException {
        int current;
        int currentPage = 0;
        StringBuilder pageData = new StringBuilder();
        StringBuilder tsvData = new StringBuilder();
        StringBuilder screensData = new StringBuilder();
        for (current = 0; rows.hasNext() && current <= 50000; ++current) {
            int page = this.pageOf(current);
            if (page != currentPage) {
                this.addPage(title, description, page - 1, columns, pageData);
                pageData = new StringBuilder();
                ++currentPage;
            }
            Fact next = rows.next();
            pageData.append(this.toRow(columns, this.provider.cells(next)));
            tsvData.append(this.toTsvRow(this.provider.cells(next)));
            screensData.append(this.toScreenRow(this.provider.id(next)));
        }
        this.addPage(title, description, this.pageOf(current), columns, pageData);
        this.addFilters(id, title);
        this.addTsv(id, columns, tsvData);
        this.addScreens(id, columns, screensData);
        this.modifyPages(current);
    }

    private void modifyPages(int count) throws IOException {
        int countPages = this.pageOf(count) + 1;
        for (int i = 0; i < countPages; ++i) {
            int finalI = i;
            String options = IntStream.range(0, countPages).mapToObj(j -> "<option value='" + (j + 1) + "'" + (finalI == j + 1 ? " selected" : "") + ">" + this.translate("Page") + " " + (j + 1) + "</option>").collect(Collectors.joining());
            if (i == 0) {
                this.modifyPage("index.html", i + 1, countPages, options);
            }
            this.modifyPage(i + 1 + ".html", i + 1, countPages, options);
        }
    }

    private void modifyPage(String pageName, int page, int countPages, String options) throws IOException {
        String content = this.pages.getOrDefault(pageName, "");
        content = content.replace("::currentPage::", this.translate("Page") + " " + page + " " + this.translate("of") + " " + countPages);
        content = content.replace("::previousPageDisabled::", page == 1 ? "disabled" : "");
        content = content.replace("::nextPageDisabled::", page == countPages ? "disabled" : "");
        content = content.replace("::toolbarDisplay::", countPages > 1 ? "block" : "none");
        content = content.replace("::options::", options);
        this.pages.put(pageName, content);
    }

    private void addPage(String title, String description, int page, List<ItemColumn> columns, StringBuilder collection) {
        String pageContent = this.pageContent(title, description, page + 1, columns, collection);
        if (page == 0) {
            this.pages.put("index.html", pageContent);
        }
        this.pages.put(page + 1 + ".html", pageContent);
    }

    private String pageContent(String title, String description, int page, List<ItemColumn> columns, StringBuilder collection) {
        String content = this.template();
        content = content.replace("::title::", title);
        content = content.replace("::logo::", MicroSiteBuilderOfCube.logo(this.box.logoContent()));
        content = content.replace("::description::", description != null ? description : "");
        content = content.replace("::transactionHeader::", this.toHeaderRow(columns));
        content = content.replace("::transactions::", collection);
        content = content.replace("::previousPage::", String.valueOf(page - 1));
        content = content.replace("::nextPage::", String.valueOf(page + 1));
        content = content.replace("::noTransactionsDisplay::", collection.length() > 0 ? "none" : "block");
        content = content.replace("::before::", this.translate("Previous"));
        content = content.replace("::next::", this.translate("Next"));
        return content;
    }

    public String template() {
        try {
            return new String(MicroSiteBuilderOfCube.class.getResourceAsStream("/MicroSiteTemplate.html").readAllBytes());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return "";
        }
    }

    private String translate(String word) {
        return I18n.translate(word, this.language);
    }

    private void addFilters(String id, String filter) {
        this.pages.put(id + ".filters", filter);
    }

    private void addTsv(String id, List<ItemColumn> columns, StringBuilder content) {
        this.pages.put(id + ".tsv", this.toTsvHeaderRow(columns) + content);
    }

    private void addScreens(String id, List<ItemColumn> columns, StringBuilder content) {
        this.pages.put(id + ".screens", content.toString());
    }

    private String toRow(List<ItemColumn> columns, Map<String, Object> rows) {
        ArrayList<Object> values = new ArrayList<Object>(rows.values());
        ArrayList<String> cells = new ArrayList<String>();
        for (int i = 0; i < values.size(); ++i) {
            cells.add(i == 0 ? this.toLinkCell(columns.get(i), values.get(i)) : this.toCell(columns.get(i), values.get(i)));
        }
        return "<tr>" + String.join((CharSequence)"", cells) + "</tr>";
    }

    private String toCell(ItemColumn column, Object cell) {
        return "<td " + this.style(column) + ">" + cell + "</td>";
    }

    private String toLinkCell(ItemColumn column, Object cell) {
        String link = this.provider.cellLinkOf(cell);
        if (link == null) {
            return this.toCell(column, cell);
        }
        return "<td " + this.style(column) + "><a href=" + this.provider.cellLinkOf(cell) + " target=\"_blank\">" + cell + "</a></td>";
    }

    private String toTsvRow(Map<String, Object> rows) {
        return rows.values().stream().map(c -> c + "\t").collect(Collectors.joining()) + "\n";
    }

    private String toScreenRow(String screen) {
        return screen + "\n";
    }

    private String toHeaderRow(List<ItemColumn> columns) {
        return "<tr>" + columns.stream().map(c -> "<th " + this.style((ItemColumn)c) + ">" + c.label(this.language).split(":")[0] + "</th>").collect(Collectors.joining()) + "</tr>";
    }

    private String style(ItemColumn column) {
        if (column.type() == ItemColumn.Type.Number) {
            return "style='text-align:right;'";
        }
        return "style='text-align:left;'";
    }

    private String toTsvHeaderRow(List<ItemColumn> columns) {
        return columns.stream().map(c -> c.label(this.language).split(":")[0] + this.tsvType((ItemColumn)c) + "\t").collect(Collectors.joining()) + "\n";
    }

    private String tsvType(ItemColumn column) {
        if (column.type == ItemColumn.Type.Number) {
            return "";
        }
        return "[type=Text]";
    }

    private int pageOf(long current) {
        if (current == 0L) {
            return 0;
        }
        return (int)(Math.floor(current / 1000L) + (double)(current % 1000L > 0L ? 1 : 0)) - 1;
    }

    public static interface CellProvider {
        public String id(Fact var1);

        public Map<String, Object> cells(Fact var1);

        public String cellLinkOf(Object var1);
    }
}

