import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import DisplaysCubeTemplate from "sumus-elements/gen/displays/templates/CubeTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CubeAnalyzeTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CubeAnalyzeTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CubeAnalyzeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CubeAnalyzeTemplateNotifier(this);
		this.requester = new CubeAnalyzeTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="horizontal" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a569154902" mode="normal">
				</UiText>
				<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1189220498" title="[view]" target="self" mode="Link" size="Medium" format="airLeft">
				</UiAction>
				<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1859134527" title="[analyze]" target="self" mode="Link" size="Medium" format="airLeft">
				</UiOpenDialog>
				<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a5300746" title="" fullscreen={true}>
					<DisplaysCubeTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a5300746.a_67977063">
					</DisplaysCubeTemplate>
				</UiDialog>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(CubeAnalyzeTemplate));
DisplayFactory.register("CubeAnalyzeTemplate", withStyles(styles, { withTheme: true })(withSnackbar(CubeAnalyzeTemplate)));