import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import DisplaysLedgerTemplate from "sumus-elements/gen/displays/templates/LedgerTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import LedgersTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import LedgersTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class LedgersTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new LedgersTemplateNotifier(this);
		this.requester = new LedgersTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="horizontal flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_487594668" format="blueRightBordered columnMinWidth doubleAirRight doubleRightSpaced" layout="vertical" width="calc(20% - 20px)" height="100.0%">
					<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_487594668.a_1070618979" format="doubleLeftSpaced" multipleSelection={false}>
					</UiSelectorListBox>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2030746945" format="doubleAirBottom middleAirTop" layout="horizontal flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2030746945.a2007683664" format="overflowAuto" layout="vertical flexible" width="100px" height="-1px">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2030746945.a2007683664.a548214945" layout="vertical flexible">
							<DisplaysLedgerTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2030746945.a2007683664.a548214945.a923512124">
							</DisplaysLedgerTemplate>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(LedgersTemplate));
DisplayFactory.register("LedgersTemplate", withStyles(styles, { withTheme: true })(withSnackbar(LedgersTemplate)));