import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiDateEditable from "alexandria-ui-elements/src/displays/components/DateEditable";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import DisplaysChatBotMessageTemplate from "sumus-elements/gen/displays/templates/ChatBotMessageTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ChatBotTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ChatBotTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ChatBotTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ChatBotTemplateNotifier(this);
		this.requester = new ChatBotTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835" format="horizontalAutoMargin" layout="vertical" width="50.0%" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835.a651655779" format="spaced" layout="vertical center" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835.a651655779.a879335679" format="airBottom h3" mode="normal" value="Chat bot">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835.a651655779.a1192661773" format="greyRoundedBorder lightgreyBackground messagePanelFormat overflowAuto" layout="vertical" width="100.0%" height="100.0%">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835.a651655779.a1192661773.a267815930" format="maxHeight100Percent" layout="verticalreverse">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835.a651655779.a1192661773.a267815930.a_1635847383" visible={false} layout="vertical flexible centercenter">
									<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835.a651655779.a1192661773.a267815930.a_1635847383.a_762633404" format="secondary" mode="Rise">
									</UiSpinner>
								</UiBlock>
								<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835.a651655779.a1192661773.a267815930.a360757821" multiple={{instances:"messagesList",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
								</UiMultiple>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835.a651655779.a_114793316" format="greyRoundedBorder heightAuto spaced" layout="horizontal end" width="100.0%" height="100.0%">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835.a651655779.a_114793316.a1507121621" layout="vertical" width="30.0%" height="100.0%">
								<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835.a651655779.a_114793316.a1507121621.a522898777" visible={false} pattern="DD/MM/YYYY" mode="tonow">
								</UiDateEditable>
								<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835.a651655779.a_114793316.a1507121621.a_1827480319" multipleSelection={false} placeholder="Select ledger" maxMenuHeight={300}>
								</UiSelectorComboBox>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835.a651655779.a_114793316.a_650941540" layout="horizontal" width="100.0%" height="100.0%">
								<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1094489835.a651655779.a_114793316.a_650941540.a_1383059318" format="airBottom airLeft middleAirTop" mode="normal" placeholder="Ask me anything...">
								</UiTextEditable>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ChatBotTemplate));
DisplayFactory.register("ChatBotTemplate", withStyles(styles, { withTheme: true })(withSnackbar(ChatBotTemplate)));