import React from "react";
import { withStyles } from '@material-ui/core/styles';
import DisplaysCubeIndicatorsItem from "sumus-elements/gen/displays/items/CubeIndicatorsItem";
import UiRow from "alexandria-ui-elements/src/displays/components/Row";
import CubeTableRowNotifier from "alexandria-ui-elements/gen/displays/notifiers/RowNotifier";
import CubeTableRowRequester from "alexandria-ui-elements/gen/displays/requesters/RowRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CubeTableRow extends UiRow {

	constructor(props) {
		super(props);
		this.notifier = new CubeTableRowNotifier(this);
		this.requester = new CubeTableRowRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return this.renderRow(
			<React.Fragment>
				<DisplaysCubeIndicatorsItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1230116157" style={{width:"30%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never"></DisplaysCubeIndicatorsItem>
			</React.Fragment>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(CubeTableRow));
DisplayFactory.register("CubeTableRow", withStyles(styles, { withTheme: true })(withSnackbar(CubeTableRow)));