import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiDisplayStamp from "alexandria-ui-elements/src/displays/components/DisplayStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysReportRenderer from "sumus-elements/src/displays/ReportRenderer";
import DisplaysStoryboardEntryTemplate from "sumus-elements/gen/displays/templates/StoryboardEntryTemplate";
import DisplaysCubeAnalyzeTemplate from "sumus-elements/gen/displays/templates/CubeAnalyzeTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ReportTemplateNotifier from "sumus-elements/gen/displays/notifiers/ReportTemplateNotifier";
import ReportTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ReportTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ReportTemplateNotifier(this);
		this.requester = new ReportTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="vertical flexible" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_162182205" visible={false} layout="vertical centercenter flexible">
					<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_162182205.a775604336" format="secondary" mode="Rise">
					</UiSpinner>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_85772698" visible={false} layout="vertical centercenter flexible">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_85772698.a123573804" format="h5" mode="normal" translate={true} value="No report found">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600571289" visible={false} layout="vertical flexible">
					<UiDisplayStamp context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600571289.a1330834710">
					</UiDisplayStamp>
					<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600571289.a415290116" title="Print page" target="self" mode="Link" size="Medium">
					</UiAction>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600571289.a18639014" format="airTop" visible={false} layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600571289.a18639014.a_1235020597" format="h6" mode="normal" translate={true} value="Storyboards">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600571289.a18639014.a1197301768" multiple={{instances:"storyboardList",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600571289.a712403323" format="airTop" visible={false} layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600571289.a712403323.a_1658948908" format="h6" mode="normal" translate={true} value="Analysis">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_600571289.a712403323.a_1797692602" multiple={{instances:"analyzeList",arrangement:"Vertical",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
		if (!this.props.onProxyMessage) return;
		this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ReportTemplate));
DisplayFactory.register("ReportTemplate", withStyles(styles, { withTheme: true })(withSnackbar(ReportTemplate)));