import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiUser from "alexandria-ui-elements/src/displays/components/User";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import HeaderNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import HeaderRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Header extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new HeaderNotifier(this);
		this.requester = new HeaderRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="whiteBackground middleAirBottom" layout="vertical" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190" format="centered airLeft airRight bottomBordered headerHeight" layout="horizontal" width="calc(100% - 20px)" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1623137411" layout="horizontal flexible">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1623137411.a1365819814" format="airRight smallAirTop" mobileReduceFactor={75}>
						</UiImage>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1623137411.a925568561" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1623137411.a925568561.a2009905114" format="h3 appTitleStyle" visible={false} mode="normal">
							</UiText>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a1623137411.a925568561.a500461566" format="appDescriptionStyle" visible={false} mode="normal">
							</UiText>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a688205457" layout="horizontal center endjustified">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a688205457.a973098092" format="doubleAirRight" layout="horizontal center">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a688205457.a973098092.a_1286523233" format="h4 airRight" visible={false} mode="normal" translate={true} value="OLAP">
							</UiText>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a688205457.a973098092.a_1532300487" title="OLAP" target="self" mode="Link" size="Medium" format="h4 airRight" visible={false}>
							</UiAction>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a688205457.a973098092.a_1187896002" format="h4 airRight" visible={false} mode="normal" translate={true} value="Dashboards">
							</UiText>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a688205457.a973098092.a_584746408" title="Dashboards" target="self" mode="Link" size="Medium" format="h4 airRight" visible={false}>
							</UiAction>
						</UiBlock>
						<UiUser context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1956073190.a688205457.a_565479828" mode="OnlyPhoto">
						</UiUser>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(Header));
DisplayFactory.register("Header", withStyles(styles, { withTheme: true })(withSnackbar(Header)));