import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractCubeStoryboardCategoriesDisplay from "../../gen/displays/AbstractCubeStoryboardCategoriesDisplay";
import CubeStoryboardCategoriesDisplayNotifier from "../../gen/displays/notifiers/CubeStoryboardCategoriesDisplayNotifier";
import CubeStoryboardCategoriesDisplayRequester from "../../gen/displays/requesters/CubeStoryboardCategoriesDisplayRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CubeStoryboardCategoriesDisplay extends AbstractCubeStoryboardCategoriesDisplay {

	constructor(props) {
		super(props);
		this.notifier = new CubeStoryboardCategoriesDisplayNotifier(this);
		this.requester = new CubeStoryboardCategoriesDisplayRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(CubeStoryboardCategoriesDisplay));
DisplayFactory.register("CubeStoryboardCategoriesDisplay", withStyles(styles, { withTheme: true })(withSnackbar(CubeStoryboardCategoriesDisplay)));