import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import DisplaysStoryboardTemplate from "sumus-elements/gen/displays/templates/StoryboardTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import StoryboardEntryTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import StoryboardEntryTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class StoryboardEntryTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new StoryboardEntryTemplateNotifier(this);
		this.requester = new StoryboardEntryTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="horizontal" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_61643836" mode="normal">
				</UiText>
				<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1977393079" title="[analyze]" target="self" mode="Link" size="Medium" format="airLeft">
				</UiOpenDialog>
				<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1925376348" title="" fullscreen={true}>
					<DisplaysStoryboardTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1925376348.a1377850959">
					</DisplaysStoryboardTemplate>
				</UiDialog>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(StoryboardEntryTemplate));
DisplayFactory.register("StoryboardEntryTemplate", withStyles(styles, { withTheme: true })(withSnackbar(StoryboardEntryTemplate)));