import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiDisplayStamp from "alexandria-ui-elements/src/displays/components/DisplayStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import UiDynamicTable from "alexandria-ui-elements/src/displays/components/DynamicTable";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import DisplaysCubeTableRow from "sumus-elements/gen/displays/rows/CubeTableRow";
import DisplaysCubeIndicatorsItem from "sumus-elements/gen/displays/items/CubeIndicatorsItem";
import DisplaysCubeBarChart from "sumus-elements/src/displays/CubeBarChart";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CubeViewerNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CubeViewerRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CubeViewer extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CubeViewerNotifier(this);
		this.requester = new CubeViewerRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="relative" layout="horizontal flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a571322752" format="cubeStyle relative" layout="vertical flexible">
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a571322752.a1620615626" layout="vertical flexible">
						<UiDynamicTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a571322752.a1620615626.a1013139556" noItemsMessage="No results" itemHeight={60} scrollingMark={true}>
							<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a571322752.a1620615626.a1013139556.a1244704850" style={{width:"30%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a571322752.a1620615626.a1013139556.a1244704850.a1286691206" mode="normal" value="Indicators">
								</UiText>
							</UiHeading>
						</UiDynamicTable>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a571322752.a_524568765" format="airTop" layout="vertical flexible">
						<UiDisplayStamp context={this._context.bind(this)} owner={this._owner.bind(this)} id="a571322752.a_524568765.a888797788">
						</UiDisplayStamp>
					</UiBlockConditional>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(CubeViewer));
DisplayFactory.register("CubeViewer", withStyles(styles, { withTheme: true })(withSnackbar(CubeViewer)));