import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ChatMessageTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ChatMessageTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ChatMessageTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ChatMessageTemplateNotifier(this);
		this.requester = new ChatMessageTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="horizontal" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a471756082" mode="normal">
				</UiText>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ChatMessageTemplate));
DisplayFactory.register("ChatMessageTemplate", withStyles(styles, { withTheme: true })(withSnackbar(ChatMessageTemplate)));