import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDateEditable from "alexandria-ui-elements/src/displays/components/DateEditable";
import UiTemporalSlider from "alexandria-ui-elements/src/displays/components/TemporalSlider";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import DisplaysCubeDialog from "sumus-elements/gen/displays/templates/CubeDialog";
import DisplaysCubeViewer from "sumus-elements/gen/displays/templates/CubeViewer";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CubeTemplateNotifier from "sumus-elements/gen/displays/notifiers/CubeTemplateNotifier";
import CubeTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CubeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CubeTemplateNotifier(this);
		this.requester = new CubeTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="horizontal flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1141412200" format="blueRightBordered doubleAirRight doubleLeftSpaced doubleRightSpaced columnMinWidth" visible={false} layout="vertical" width="calc(20% - 20px)" height="100.0%">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1141412200.a_1764087967" format="spaced" visible={false} mode="normal" translate={true} value="No data found">
					</UiText>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1141412200.a872932085" format="bottomSpaced" visible={false} layout="horizontal center">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1141412200.a872932085.a1220887783" layout="vertical flexible">
							<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1141412200.a872932085.a1220887783.a_1835135871" pattern="DD/MM/YYYY">
							</UiDateEditable>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1141412200.a872932085.a_852166127" layout="vertical">
							<UiTemporalSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1141412200.a872932085.a_852166127.a950648331" arrangement="Horizontal" style="NavigationOnly" position="SliderTop">
							</UiTemporalSlider>
						</UiBlock>
					</UiBlock>
					<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1141412200.a_1055229781" multipleSelection={false}>
					</UiSelectorListBox>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a736063204" layout="vertical flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a736063204.a_232467743" layout="vertical flexible centercenter">
						<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a736063204.a_232467743.a1030877037" format="secondary" mode="Rise">
						</UiSpinner>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a736063204.a719055851" format="middleAirBottom" layout="vertical">
						<DisplaysCubeDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a736063204.a719055851.a1281006322" visible={false}>
						</DisplaysCubeDialog>
					</UiBlock>
					<DisplaysCubeViewer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a736063204.a_363620638" visible={false}>
					</DisplaysCubeViewer>
				</UiBlock>
			</UiBlock>
		);
	}


	notifyProxyMessage = (name) => {
	    if (!this.props.onProxyMessage) return;
	    this.props.onProxyMessage(name);
	};
}

export default withStyles(styles, { withTheme: true })(withSnackbar(CubeTemplate));
DisplayFactory.register("CubeTemplate", withStyles(styles, { withTheme: true })(withSnackbar(CubeTemplate)));