import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractReportRenderer from "../../gen/displays/AbstractReportRenderer";
import ReportRendererNotifier from "../../gen/displays/notifiers/ReportRendererNotifier";
import ReportRendererRequester from "../../gen/displays/requesters/ReportRendererRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';
import InnerHTML from 'dangerously-set-html-content'

const styles = theme => ({});

class ReportRenderer extends AbstractReportRenderer {

	constructor(props) {
		super(props);
		this.notifier = new ReportRendererNotifier(this);
		this.requester = new ReportRendererRequester(this);
		this.callbacks = [];
		this.callback = null;
		this.state = {
		    ...this.state,
		    content: this.props.content != null ? this.props.content : '',
		}
	};

	render() {
	    this.refreshEvents();
	    if (this.state.content === "") return (<React.Fragment/>);
	    return (<InnerHTML id={this.props.id + "-html"} html={this.state.content} />);
	};

	openNode = (node) => {
	    this.requester.openNode(node);
	};

	openView = (view, period, callback) => {
	    this.callbacks[this.viewKey(view,period)] = callback;
	    this.requester.openView({view: view, period: period});
	};

	openReport = (report, callback) => {
	    this.callback = callback;
        this.requester.openReport(report);
	};

	viewKey = (view, period) => {
	    return view + period;
	};

	selectScale = (scale) => {
	    this.requester.selectScale(scale);
	};

	selectWindow = (window) => {
	    this.requester.selectWindow(window);
	};

	generatingMicrosite = () => {
	    this.showMessage(this.translate("Generating report. This operation may take time. Please wait..."), "loading");
	};

	openMicrosite = (cube, from, to, filtersMap, label, description) => {
	    this.requester.openMicrosite({ label: label, description: description, cube: cube, from: from, to: to, filters: this._filtersOf(filtersMap)});
	};

	gotoMicrosite = (link) => {
	    this.showMessage(this.translate("Report generated"), "success");
	    window.open(link);
	};

	gotoView = (data) => {
	    if (this.callbacks[this.viewKey(data.view, data.period)] == null) return;
	    this.callbacks[this.viewKey(data.view, data.period)](data.content);
	};

	gotoReport = (content) => {
	    if (!this.callback) return;
	    this.callback(content);
	};

	refresh = (content) => {
	    this.setState({content});
	};

    printPage = () => {
        var w = window.open();
        var html = '<html><head><title>' + document.title + '</title>';
        html += '</head><body>';
        html += '<h1>' + document.title + '</h1>';
        html += document.getElementById(this.props.id + "-html").innerHTML;
        html += '</body></html>';
        w.document.write(html);
        window.setTimeout(() => {
            w.document.close(); // necessary for IE >= 10
            w.focus(); // necessary for IE >= 10*/
            w.print();
            w.close();
        }, 200);
        return true;
    };

	refreshEvents = () => {
        window.openNode = this.openNode.bind(this);
        window.openView = this.openView.bind(this);
        window.openReport = this.openReport.bind(this);
        window.selectScale = this.selectScale.bind(this);
        window.selectWindow = this.selectWindow.bind(this);
        window.openMicrosite = this.openMicrosite.bind(this);
    };

    _filtersOf = (filtersMap) => {
        let result = [];
        for (var idx in filtersMap) {
            const value = filtersMap[idx];
            const index = value.indexOf(":");
            result.push({ dimension: value.substring(0, index), values: [value.substring(index+1)]});
        }
        return result;
    }

}

export default withStyles(styles, { withTheme: true })(withSnackbar(ReportRenderer));
DisplayFactory.register("ReportRenderer", withStyles(styles, { withTheme: true })(withSnackbar(ReportRenderer)));