import Requester from "./Requester";

export default class ReportRendererRequester extends Requester {
	constructor(element) {
		super(element);
	};
	openMicrosite = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "openMicrosite", s: "reportrenderer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	openNode = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "openNode", s: "reportrenderer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	openView = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "openView", s: "reportrenderer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(JSON.stringify(value))}, this.element.ownerUnit());
	};
	openReport = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "openReport", s: "reportrenderer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	selectScale = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "selectScale", s: "reportrenderer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
	selectWindow = (value) => {
	    if (this.addToHistory(value)) return;
	    this.pushService.send({ app: this.element.context, op: "selectWindow", s: "reportrenderer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context(), v: encodeURIComponent(value)}, this.element.ownerUnit());
	};
    didMount = () => {
	    this.pushService.send({ op: "didMount", s: "reportrenderer", d: this.element.shortId(), o: this.element.props.owner(), c: this.element.props.context()}, this.element.ownerUnit());
    };
}