import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDateEditable from "alexandria-ui-elements/src/displays/components/DateEditable";
import UiSlider from "alexandria-ui-elements/src/displays/components/Slider";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import DisplaysReportTemplate from "sumus-elements/gen/displays/templates/ReportTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DashboardTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DashboardTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DashboardTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DashboardTemplateNotifier(this);
		this.requester = new DashboardTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="overflowAuto" layout="horizontal flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1958674853" format="blueRightBordered doubleAirRight doubleRightSpaced columnMinWidth" layout="vertical" width="calc(20% - 20px)" height="100.0%">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1958674853.a516918281" format="topSpaced doubleLeftSpaced bottomSpaced" visible={false} mode="normal" translate={true} value="No reports found">
					</UiText>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1958674853.a1144681644" format="bottomSpaced doubleLeftSpaced" layout="horizontal center">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1958674853.a1144681644.a_1032470237" layout="vertical flexible">
							<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1958674853.a1144681644.a_1032470237.a1016484928" pattern="DD/MM/YYYY">
							</UiDateEditable>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1958674853.a1144681644.a_1066359819" layout="vertical">
							<UiSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1958674853.a1144681644.a_1066359819.a_181314719" arrangement="Horizontal" style="NavigationOnly" position="SliderBottom" range={{min:0,max:0}}>
							</UiSlider>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1958674853.a1210312777" layout="horizontal center">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1958674853.a1210312777.a_2038941405" format="bottomSpaced doubleLeftSpaced" visible={false} layout="vertical flexible">
							<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1958674853.a1210312777.a_2038941405.a729827629" multipleSelection={false} maxMenuHeight={300}>
							</UiSelectorComboBox>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1958674853.a1210312777.a1274594143" format="bottomSpaced doubleLeftSpaced" visible={false} layout="vertical flexible">
							<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1958674853.a1210312777.a1274594143.a_627055409" multipleSelection={false} maxMenuHeight={300}>
							</UiSelectorComboBox>
						</UiBlock>
					</UiBlock>
					<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1958674853.a_1878321197" format="doubleLeftSpaced" multipleSelection={false}>
					</UiSelectorListBox>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1616384791" format="middleAirTop doubleAirBottom" layout="horizontal flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1616384791.a_580003213" format="overflowAuto" layout="vertical flexible" width="100px" height="-1px">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1616384791.a_580003213.a1424311232" layout="vertical flexible">
							<DisplaysReportTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1616384791.a_580003213.a1424311232.a502178032">
							</DisplaysReportTemplate>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(DashboardTemplate));
DisplayFactory.register("DashboardTemplate", withStyles(styles, { withTheme: true })(withSnackbar(DashboardTemplate)));