import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTemporalSlider from "alexandria-ui-elements/src/displays/components/TemporalSlider";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiSelectorToggleBox from "alexandria-ui-elements/src/displays/components/SelectorToggleBox";
import UiMaterialIcon from "alexandria-ui-elements/src/displays/components/MaterialIcon";
import UiDownload from "alexandria-ui-elements/src/displays/components/Download";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiDecisionDialog from "alexandria-ui-elements/src/displays/components/DecisionDialog";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import DisplaysAttachedTemplateItem from "sumus-elements/gen/displays/templates/AttachedTemplateItem";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CubeDialogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CubeDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CubeDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CubeDialogNotifier(this);
		this.requester = new CubeDialogRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="cubeDialogStyle" layout="vertical" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659" format="containerAirMedium noAirTop" layout="horizontal center">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685" layout="vertical">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a827047055" format="airLeft" layout="horizontal">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a827047055.a_987701946" format="h6 airRight topSpaced" mode="normal">
							</UiText>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a827047055.a1220452333" format="topSpaced" layout="vertical">
								<UiTemporalSlider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a827047055.a1220452333.a_32612984" arrangement="Horizontal" style="NavigationOnly" position="SliderTop">
								</UiTemporalSlider>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949" layout="horizontal flexible center">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a_601921184" format="airLeft airRight middleTopSpaced" layout="vertical centercenter">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a_601921184.a_724625438" layout="horizontal center">
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a_601921184.a_724625438.a_643376676" format="airRight" layout="vertical" width="300px" height="-1px">
										<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a_601921184.a_724625438.a_643376676.a702991691" multipleSelection={false} placeholder="Select an option" maxMenuHeight={300}>
										</UiSelectorComboBox>
									</UiBlock>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a_601921184.a_724625438.a_1446564599" format="airRight" layout="vertical" width="300px" height="-1px">
										<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a_601921184.a_724625438.a_1446564599.a159972439" multipleSelection={false} placeholder="Select an option" maxMenuHeight={300}>
										</UiSelectorComboBox>
									</UiBlock>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a_601921184.a_663262823" format="middleAirTop" layout="horizontal center">
									<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a_601921184.a_663262823.a_970594924" format="middleAirRight" multiple={{instances:"attachedElements",arrangement:"Horizontal",noItemsMessage:"",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
									</UiMultiple>
									<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a_601921184.a_663262823.a_536550024" title="" target="self" mode="Link" size="Medium">
									</UiOpenDialog>
								</UiBlock>
							</UiBlock>
							<UiSelectorToggleBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a146832665" format="airRight viewSelectorStyle" multipleSelection={false} layout="Horizontal" size="Small">
								<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a146832665.a_599572279" name="listView" format="blackColor middleAirTop listViewStyle" icon="ViewHeadline">
								</UiMaterialIcon>
								<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a146832665.a118206006" name="barChartView" format="blackColor middleAirTop rotate90 barChartStyle" icon="BarChart">
								</UiMaterialIcon>
								<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a146832665.a2132344813" name="tableView" format="blackColor middleAirTop tableViewStyle" icon="Apps">
								</UiMaterialIcon>
							</UiSelectorToggleBox>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a965622936" format="airTop airBottom" layout="horizontal">
								<UiDownload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a965622936.a_1087293543" title="Download" target="self" mode="IconButton" size="Small" format="toolbarButton greyImage">
								</UiDownload>
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1532178659.a110444685.a_1896244949.a965622936.a393898568" title="Transpose" target="self" mode="IconButton" readonly={true} size="Small" format="airLeft toolbarButton rotate">
								</UiAction>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_314072779" format="filtersSummaryStyle" visible={false} layout="horizontal center">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_314072779.a_315070762" format="body2 airRight greyColor" mode="normal" translate={true} value="Applied filters">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_314072779.a_93442090" format="body2 bold" mode="normal" cropWithEllipsis={120}>
					</UiText>
					<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_314072779.a_1995080074" title="remove" target="self" mode="Link" size="Medium" format="body2 airLeft">
					</UiAction>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1243915374" format="addFiltersSummaryStyle" visible={false} layout="horizontal center">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1243915374.a_854090782" format="body2 bold" mode="normal" cropWithEllipsis={80}>
					</UiText>
					<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1243915374.a_723350470" title="add as filter" target="self" mode="Link" size="Medium" format="body2 airLeft">
					</UiAction>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a118526988" format="zoomLevelStyle" visible={false} layout="horizontal center">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a118526988.a1380589289" layout="vertical" width="100px" height="-1px">
						<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a118526988.a1380589289.a_1307480851" multipleSelection={false} placeholder="Level" maxMenuHeight={300} view="TextView">
						</UiSelectorComboBox>
					</UiBlock>
				</UiBlock>
				<UiDecisionDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1626965040" title="">
					<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1626965040.a_144176749" multipleSelection={false}>
					</UiSelectorListBox>
				</UiDecisionDialog>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(CubeDialog));
DisplayFactory.register("CubeDialog", withStyles(styles, { withTheme: true })(withSnackbar(CubeDialog)));