/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.engine;

import io.intino.alexandria.zet.ZetReader;
import io.intino.alexandria.zet.ZetStream;
import io.intino.sezzet.engine.Entity;
import io.intino.sezzet.engine.EntityStream;
import java.util.ArrayList;
import java.util.List;

public class EntityExtractor
implements EntityStream {
    private Entity current = null;
    private Entity next = null;
    private ZetStream stream;
    private List<ZetStreamStruct> featureStreams = new ArrayList<ZetStreamStruct>();

    private EntityExtractor(ZetStream stream) {
        this.stream = stream;
    }

    private EntityExtractor(long[] ids) {
        this.stream = new ZetReader(ids);
    }

    public static EntityExtractorBuilder create(ZetStream stream) {
        return new EntityExtractorBuilder(new EntityExtractor(stream));
    }

    public static EntityExtractorBuilder create(long[] ids) {
        return new EntityExtractorBuilder(new EntityExtractor(ids));
    }

    @Override
    public Entity current() {
        return this.current;
    }

    @Override
    public Entity next() {
        if (this.current == this.next) {
            this.hasNext();
        }
        this.current = this.next;
        return this.current;
    }

    @Override
    public boolean hasNext() {
        if (this.current != this.next) {
            return true;
        }
        if (!this.stream.hasNext()) {
            this.next = null;
            return false;
        }
        long id = this.stream.next();
        this.advanceStreamsUntil(id);
        this.next = new Entity(id);
        for (ZetStreamStruct featureStream : this.featureStreams) {
            if (featureStream.stream.current() != id) continue;
            this.next.add(featureStream.feature, featureStream.value);
        }
        return true;
    }

    private void advanceStreamsUntil(long value) {
        for (ZetStreamStruct featureStream : this.featureStreams) {
            while (featureStream.stream.current() < value && featureStream.stream.hasNext()) {
                featureStream.stream.next();
            }
        }
    }

    private static class ZetStreamStruct {
        private final ZetStream stream;
        private final String feature;
        private final String value;

        ZetStreamStruct(ZetStream stream, String feature, String value) {
            this.stream = stream;
            this.feature = feature;
            this.value = value;
        }
    }

    public static class EntityExtractorBuilder {
        private EntityExtractor entityExtractor;

        EntityExtractorBuilder(EntityExtractor entityExtractor) {
            this.entityExtractor = entityExtractor;
        }

        public EntityExtractorBuilder add(ZetStream stream, String feature, String value) {
            this.entityExtractor.featureStreams.add(new ZetStreamStruct(stream, feature, value));
            return this;
        }

        public EntityExtractor commit() {
            return this.entityExtractor;
        }
    }
}

