/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.engine;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zet.ZetReader;
import io.intino.alexandria.zet.ZetStream;
import io.intino.sezzet.engine.SetProvider;
import io.intino.sezzet.model.graph.SezzetGraph;
import io.intino.sezzet.setql.SetQL;
import io.intino.sezzet.setql.graph.AbstractExpression;
import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.sezzet.setql.graph.rules.Operator;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class SezzetEngine {
    private final SezzetGraph sezzetGraph;
    private SetProvider setProvider;
    private Instant reference;

    public SezzetEngine(SetProvider setProvider, SezzetGraph sezzetGraph) {
        this.setProvider = setProvider;
        this.sezzetGraph = sezzetGraph;
    }

    public ZetStream process(String expression, Locale locale) {
        SetqlGraph graph = SetQL.parseAndResolve((String)expression, (Locale)locale, (SezzetGraph)this.sezzetGraph);
        if (graph == null) {
            return null;
        }
        return this.process(graph.expression(), Instant.now());
    }

    ZetStream process(Expression expression, Instant reference) {
        this.reference = reference;
        return this.processExpression(expression);
    }

    private ZetStream processExpression(Expression expression) {
        return this.doProcessExpression(expression);
    }

    private ZetStream doProcessExpression(Expression expression) {
        List streams = expression.operandList().stream().map(this::process).collect(Collectors.toList());
        ZetStream result = (ZetStream)streams.get(0);
        for (int i = 1; i < streams.size(); ++i) {
            result = this.doOperation(Arrays.asList(result, (ZetStream)streams.get(i)), expression.operand(i).operator());
        }
        return result;
    }

    private ZetStream process(AbstractExpression.Operand operand) {
        return operand.i$(AbstractExpression.Predicate.class) ? this.process((AbstractExpression.Predicate)operand.a$(AbstractExpression.Predicate.class)) : this.doProcessExpression(((AbstractExpression.InnerExpression)operand.a$(AbstractExpression.InnerExpression.class)).expression());
    }

    private ZetStream process(AbstractExpression.Predicate predicate) {
        List<ZetStream> maps = !predicate.argumentList().isEmpty() ? predicate.argumentList().stream().map(a -> this.process((AbstractExpression.Predicate.Argument)a, predicate)).collect(Collectors.toList()) : Collections.singletonList(this.process(null, predicate));
        return this.doOperation(maps, predicate.argumentOperator());
    }

    private ZetStream doOperation(List<ZetStream> maps, Operator operator) {
        return maps.size() == 1 ? maps.get(0) : (operator == Operator.OR ? this.processOR(maps) : (operator == Operator.AND ? this.processAnd(maps) : (operator == Operator.DIFF ? this.processDiff(maps) : this.processSymmetricDiff(maps))));
    }

    private ZetStream processOR(List<ZetStream> list) {
        return new ZetStream.Union(list);
    }

    private ZetStream processAnd(List<ZetStream> list) {
        return new ZetStream.Intersection(list);
    }

    private ZetStream processDiff(List<ZetStream> list) {
        return new ZetStream.Difference(list);
    }

    private ZetStream processSymmetricDiff(List<ZetStream> list) {
        return new ZetStream.SymmetricDifference(list);
    }

    private Instant present() {
        return this.reference == null ? Instant.now() : this.reference;
    }

    private ZetStream process(AbstractExpression.Predicate.Argument argument, AbstractExpression.Predicate predicate) {
        Scale scale = this.scaleOf(predicate.property());
        if (scale == null) {
            return new ZetReader(new long[0]);
        }
        return new ZetStream.Union(this.zetStreams(argument, predicate), predicate.frequency() != null ? predicate.frequency().lowBound() : 0, predicate.frequency() != null ? predicate.frequency().highBound() : Integer.MAX_VALUE, predicate.frequency() != null && predicate.frequency().consecutives());
    }

    private List<ZetStream> zetStreams(AbstractExpression.Predicate.Argument argument, AbstractExpression.Predicate predicate) {
        return StreamSupport.stream(this.from(predicate).iterateTo(this.to(predicate)).spliterator(), false).flatMap(t -> this.zetStreams((Timetag)t, predicate, argument)).collect(Collectors.toList());
    }

    private Timetag timetag(Instant from, Scale scale) {
        return new Timetag(LocalDateTime.ofInstant(from, ZoneOffset.UTC), scale);
    }

    private Scale scaleOf(String feature) {
        return this.setProvider.scaleOf(feature);
    }

    private Timetag from(AbstractExpression.Predicate predicate) {
        AbstractExpression.Predicate.Period period = predicate.period();
        return period == null ? this.timetag(this.present(), this.scaleOf(predicate.property())).previous() : (period.i$(AbstractExpression.Predicate.FromNow.class) ? this.fromNowTimetag((AbstractExpression.Predicate.FromNow)period.a$(AbstractExpression.Predicate.FromNow.class)) : this.timeRangeFromTimetag(predicate, period));
    }

    private Timetag to(AbstractExpression.Predicate predicate) {
        AbstractExpression.Predicate.Period period = predicate.period();
        return period == null ? this.timetag(this.present(), this.scaleOf(predicate.property())).previous() : (period.i$(AbstractExpression.Predicate.FromNow.class) ? new Timetag(LocalDateTime.ofInstant(this.present(), ZoneOffset.UTC), this.scaleOf(predicate.property())) : this.timeRangeToTimetag(predicate, period));
    }

    private Timetag timeRangeFromTimetag(AbstractExpression.Predicate predicate, AbstractExpression.Predicate.Period period) {
        return this.timetag(((AbstractExpression.Predicate.TimeRange)period.a$(AbstractExpression.Predicate.TimeRange.class)).fromInstant(), this.scaleOf(predicate.property()));
    }

    private Timetag fromNowTimetag(AbstractExpression.Predicate.FromNow fromNow) {
        Timetag timetag = new Timetag(LocalDateTime.ofInstant(this.present(), ZoneOffset.UTC), Scale.valueOf((String)fromNow.scale().name()));
        for (int i = 0; i < fromNow.amount(); ++i) {
            timetag = timetag.previous();
        }
        return new Timetag(timetag.datetime(), this.scaleOf(((AbstractExpression.Predicate)fromNow.core$().ownerAs(AbstractExpression.Predicate.class)).property()));
    }

    private Timetag timeRangeToTimetag(AbstractExpression.Predicate predicate, AbstractExpression.Predicate.Period period) {
        return this.timetag(((AbstractExpression.Predicate.TimeRange)period.a$(AbstractExpression.Predicate.TimeRange.class)).toInstant(), this.scaleOf(predicate.property()));
    }

    private Stream<ZetStream> zetStreams(Timetag timetag, AbstractExpression.Predicate predicate, AbstractExpression.Predicate.Argument argument) {
        return argument == null ? this.zetStreams(predicate.property(), timetag) : (argument.i$(AbstractExpression.Predicate.SingleValue.class) ? this.zetStreams(predicate.property(), timetag, (AbstractExpression.Predicate.SingleValue)argument.a$(AbstractExpression.Predicate.SingleValue.class)) : this.zetStreams(timetag, predicate.property(), ((AbstractExpression.Predicate.Range)argument.a$(AbstractExpression.Predicate.Range.class)).lowBound(), ((AbstractExpression.Predicate.Range)argument.a$(AbstractExpression.Predicate.Range.class)).highBound()));
    }

    private Stream<ZetStream> zetStreams(String property, Timetag timetag) {
        return Stream.of(this.setProvider.setOf(property, timetag).content());
    }

    private Stream<ZetStream> zetStreams(String feature, Timetag timetag, AbstractExpression.Predicate.SingleValue value) {
        if (value instanceof AbstractExpression.Predicate.VariableOperation) {
            return this.zetStreams(feature, timetag, (AbstractExpression.Predicate.VariableOperation)value.a$(AbstractExpression.Predicate.VariableOperation.class));
        }
        String regex = value.value().replace("*", ".*");
        return this.setProvider.setsOf(feature, timetag, s -> s.name().matches(regex)).map(SetProvider.Set::content);
    }

    private Stream<ZetStream> zetStreams(String feature, Timetag timetag, AbstractExpression.Predicate.VariableOperation value) {
        return this.setProvider.setsOf(feature, timetag, s -> {
            boolean test = this.evaluate((SetProvider.Set)s, value.comparison(0));
            for (int i = 1; i < value.comparisonList().size(); ++i) {
                test = ((Operator)value.operators().get(i - 1)).equals((Object)Operator.AND) ? test & this.evaluate((SetProvider.Set)s, value.comparison(i)) : test || this.evaluate((SetProvider.Set)s, value.comparison(i));
            }
            return test;
        }).map(SetProvider.Set::content);
    }

    private boolean evaluate(SetProvider.Set set, AbstractExpression.Predicate.VariableOperation.Comparison comparison) {
        String expression = set.valueOf(comparison.variable()) + comparison.comparator() + comparison.value();
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName("JavaScript");
        try {
            return (Boolean)engine.eval(expression);
        }
        catch (ScriptException e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    private Stream<ZetStream> zetStreams(Timetag timetag, String feature, double lowBound, double highBound) {
        return this.setProvider.setsOf(feature, timetag, s -> {
            double value = Double.parseDouble(s.name());
            return this.isDouble(s.name()) && value >= lowBound && value <= highBound;
        }).map(SetProvider.Set::content);
    }

    private boolean isDouble(String name) {
        try {
            Double.parseDouble(name);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

