/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.engine;

import io.intino.ness.setstore.InstantIterator;
import io.intino.ness.setstore.SetStore;
import io.intino.sezzet.model.graph.SezzetGraph;
import io.intino.sezzet.operators.Difference;
import io.intino.sezzet.operators.Intersection;
import io.intino.sezzet.operators.SetStream;
import io.intino.sezzet.operators.Union;
import io.intino.sezzet.setql.SetQL;
import io.intino.sezzet.setql.graph.AbstractExpression;
import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.sezzet.setql.graph.rules.Operator;
import io.intino.sezzet.setql.graph.rules.Scale;
import java.io.File;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class SezzetEngine {
    private SetStore setStore;
    private final SezzetGraph sezzetGraph;
    private Instant reference;

    public SezzetEngine(SetStore setStore, SezzetGraph sezzetGraph) {
        this.setStore = setStore;
        this.sezzetGraph = sezzetGraph;
    }

    public File process(String expression) {
        SetqlGraph graph = SetQL.parseAndResolve((String)expression, (Locale)new Locale("es", "ES"), (SezzetGraph)this.sezzetGraph);
        if (graph == null) {
            return null;
        }
        return this.process(graph.expression(), Instant.now());
    }

    File process(Expression expression, Instant reference) {
        this.reference = reference;
        return this.processExpression(expression);
    }

    private File processExpression(Expression expression) {
        return this.setStore.storeSegment(expression.name$(), new SetStore.Timetag(Instant.now(), this.setStore.scale()), this.doProcessExpression(expression));
    }

    private SetStream doProcessExpression(Expression expression) {
        List streams = expression.operandList().stream().map(this::process).collect(Collectors.toList());
        SetStream result = (SetStream)streams.get(0);
        for (int i = 1; i < streams.size(); ++i) {
            result = this.doOperation(Arrays.asList(result, (SetStream)streams.get(i)), expression.operand(i).operator());
        }
        return result;
    }

    private SetStream process(AbstractExpression.Operand operand) {
        return operand.i$(AbstractExpression.Predicate.class) ? this.process((AbstractExpression.Predicate)operand.a$(AbstractExpression.Predicate.class)) : this.doProcessExpression(((AbstractExpression.InnerExpression)operand.a$(AbstractExpression.InnerExpression.class)).expression());
    }

    private SetStream process(AbstractExpression.Predicate predicate) {
        List<SetStream> maps = predicate.argumentList().stream().map(a -> this.process((AbstractExpression.Predicate.Argument)a, predicate)).collect(Collectors.toList());
        return this.doOperation(maps, predicate.argumentOperator());
    }

    private SetStream doOperation(List<SetStream> maps, Operator operator) {
        return maps.size() == 1 ? maps.get(0) : (operator == Operator.OR ? this.processOR(maps) : (operator == Operator.AND ? this.processAnd(maps) : this.processDiff(maps)));
    }

    private SetStream processOR(List<SetStream> list) {
        return new Union(list);
    }

    private SetStream processAnd(List<SetStream> list) {
        return new Intersection(list);
    }

    private SetStream processDiff(List<SetStream> list) {
        return new Difference(list);
    }

    private Instant present() {
        return this.reference == null ? Instant.now() : this.reference;
    }

    private SetStream process(AbstractExpression.Predicate.Argument argument, AbstractExpression.Predicate predicate) {
        ArrayList<SetStream> filesToRead = new ArrayList<SetStream>();
        for (Instant instant : new InstantIterator(this.from(predicate), this.to(predicate), this.setStore.scale())) {
            filesToRead.addAll(this.files(new SetStore.Timetag(instant, this.setStore.scale()), predicate, argument));
        }
        return new Union(filesToRead, predicate.frequency() != null ? predicate.frequency().lowBound() : 0, predicate.frequency() != null ? predicate.frequency().highBound() : Integer.MAX_VALUE, predicate.recency() != null ? this.recencyIndex(predicate) : -1);
    }

    private Instant from(AbstractExpression.Predicate predicate) {
        AbstractExpression.Predicate.Period period = predicate.period();
        return period.i$(AbstractExpression.Predicate.FromNow.class) ? this.present().minus(this.minutes((AbstractExpression.Predicate.FromNow)period.a$(AbstractExpression.Predicate.FromNow.class)), ChronoUnit.MINUTES) : ((AbstractExpression.Predicate.TimeRange)period.a$(AbstractExpression.Predicate.TimeRange.class)).fromInstant();
    }

    private Instant to(AbstractExpression.Predicate predicate) {
        AbstractExpression.Predicate.Period period = predicate.period();
        return period.i$(AbstractExpression.Predicate.FromNow.class) ? this.present() : ((AbstractExpression.Predicate.TimeRange)period.a$(AbstractExpression.Predicate.TimeRange.class)).toInstant();
    }

    private List<SetStream> files(SetStore.Timetag timetag, AbstractExpression.Predicate condition, AbstractExpression.Predicate.Argument argument) {
        return argument.i$(AbstractExpression.Predicate.SingleValue.class) ? this.setStreams(condition.tank().toLowerCase(), timetag, ((AbstractExpression.Predicate.SingleValue)argument.a$(AbstractExpression.Predicate.SingleValue.class)).value().replace("*", ".*")) : this.setStreams(timetag, condition.tank().toLowerCase(), ((AbstractExpression.Predicate.Range)argument.a$(AbstractExpression.Predicate.Range.class)).lowBound(), ((AbstractExpression.Predicate.Range)argument.a$(AbstractExpression.Predicate.Range.class)).highBound());
    }

    private List<SetStream> setStreams(String tank, SetStore.Timetag instant, String set) {
        SetStore.Tank.Tub tub = this.setStore.tank(tank).on(instant);
        return tub.sets(s -> s.name().equals(set) || s.name().matches(set)).stream().map(SetStore.Tank.Tub.Set::content).collect(Collectors.toList());
    }

    private List<SetStream> setStreams(SetStore.Timetag timetag, String tank, int lowBound, int highBound) {
        SetStore.Tank.Tub tub = this.setStore.tank(tank).on(timetag);
        return tub.sets(s -> Double.parseDouble(s.name()) >= (double)lowBound && Double.parseDouble(s.name()) <= (double)highBound).stream().map(SetStore.Tank.Tub.Set::content).collect(Collectors.toList());
    }

    private long minutes(AbstractExpression.Predicate.FromNow fromNow) {
        return this.amountOf(fromNow.amount(), fromNow.scale());
    }

    private long minutes(AbstractExpression.Predicate.Recency recency) {
        return this.amountOf(recency.amount(), recency.scale());
    }

    private int amountOf(int amount, Scale scale) {
        return scale == Scale.Hour ? amount * 60 : (scale == Scale.Day ? amount * 24 * 60 : (scale == Scale.Month ? amount * 30 * 24 * 60 : amount * 365 * 30 * 24 * 60));
    }

    private int recencyIndex(AbstractExpression.Predicate predicate) {
        Instant from = this.reference;
        Instant to = this.reference.minus(this.minutes(predicate.recency()), ChronoUnit.MINUTES);
        int count = 1;
        while (from.isAfter(to)) {
            ++count;
            from = this.setStore.scale().minus(this.reference);
        }
        return count;
    }
}

