/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.engine;

import io.intino.sezzet.SetStore;
import io.intino.sezzet.model.graph.InstantIterator;
import io.intino.sezzet.model.graph.SezzetGraph;
import io.intino.sezzet.operators.Difference;
import io.intino.sezzet.operators.FileReader;
import io.intino.sezzet.operators.Intersection;
import io.intino.sezzet.operators.SetStream;
import io.intino.sezzet.operators.Union;
import io.intino.sezzet.setql.SetQL;
import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.sezzet.setql.graph.rules.Operator;
import io.intino.sezzet.setql.graph.rules.Scale;
import java.io.File;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class SezzetEngine {
    private SetStore setStore;
    private final SezzetGraph sezzetGraph;
    private Instant reference;

    public SezzetEngine(SetStore setStore, SezzetGraph sezzetGraph) {
        this.setStore = setStore;
        this.sezzetGraph = sezzetGraph;
    }

    public File process(String expression) {
        SetqlGraph graph = SetQL.parseAndResolve((String)expression, (Locale)new Locale("es", "ES"), (SezzetGraph)this.sezzetGraph);
        if (graph == null) {
            return null;
        }
        return this.process(graph.expression(), Instant.now());
    }

    File process(Expression expression, Instant reference) {
        this.reference = reference;
        return this.processExpression(expression);
    }

    private File processExpression(Expression expression) {
        return this.setStore.storeSegment(Instant.now(), expression.name$(), this.doProcessExpression(expression));
    }

    private SetStream doProcessExpression(Expression expression) {
        List streams = expression.operandList().stream().map(this::process).collect(Collectors.toList());
        SetStream result = (SetStream)streams.get(0);
        for (int i = 1; i < streams.size(); ++i) {
            result = this.doOperation(Arrays.asList(result, (SetStream)streams.get(i)), expression.operand(i).operator());
        }
        return result;
    }

    private SetStream process(Expression.Operand operand) {
        return operand.i$(Expression.Predicate.class) ? this.process((Expression.Predicate)operand.a$(Expression.Predicate.class)) : this.doProcessExpression(((Expression.InnerExpression)operand.a$(Expression.InnerExpression.class)).expression());
    }

    private SetStream process(Expression.Predicate predicate) {
        List<SetStream> maps = predicate.argumentList().stream().map(a -> this.process((Expression.Predicate.Argument)a, predicate)).collect(Collectors.toList());
        Operator operator = predicate.operator();
        return this.doOperation(maps, operator);
    }

    private SetStream doOperation(List<SetStream> maps, Operator operator) {
        return maps.size() == 1 ? maps.get(0) : (operator == Operator.OR ? this.processOR(maps) : (operator == Operator.AND ? this.processAnd(maps) : this.processDiff(maps)));
    }

    private SetStream processOR(List<SetStream> list) {
        return new Union(list);
    }

    private SetStream processAnd(List<SetStream> list) {
        return new Intersection(list);
    }

    private SetStream processDiff(List<SetStream> list) {
        return new Difference(list);
    }

    private Instant present() {
        return this.reference == null ? Instant.now() : this.reference;
    }

    private SetStream process(Expression.Predicate.Argument argument, Expression.Predicate predicate) {
        ArrayList<File> filesToRead = new ArrayList<File>();
        for (Instant instant : new InstantIterator(this.from(predicate), this.to(predicate), this.setStore.scale())) {
            filesToRead.addAll(this.files(instant, predicate, argument));
        }
        return new Union(filesToRead.stream().map(FileReader::new).collect(Collectors.toList()), predicate.frequency() != null ? predicate.frequency().lowBound() : 0, predicate.frequency() != null ? predicate.frequency().highBound() : Integer.MAX_VALUE, predicate.recency() != null ? this.recencyIndex(predicate) : -1);
    }

    private Instant from(Expression.Predicate predicate) {
        Expression.Predicate.Period period = predicate.period();
        return period.i$(Expression.Predicate.FromNow.class) ? this.present().minus(this.minutes((Expression.Predicate.FromNow)period.a$(Expression.Predicate.FromNow.class)), ChronoUnit.MINUTES) : ((Expression.Predicate.TimeRange)period.a$(Expression.Predicate.TimeRange.class)).from();
    }

    private Instant to(Expression.Predicate predicate) {
        Expression.Predicate.Period period = predicate.period();
        return period.i$(Expression.Predicate.FromNow.class) ? this.present() : ((Expression.Predicate.TimeRange)period.a$(Expression.Predicate.TimeRange.class)).to();
    }

    private List<File> files(Instant instant, Expression.Predicate condition, Expression.Predicate.Argument argument) {
        return argument.i$(Expression.Predicate.SingleValue.class) ? this.files(instant, condition.property(), ((Expression.Predicate.SingleValue)argument.a$(Expression.Predicate.SingleValue.class)).value()) : this.files(instant, condition.property(), ((Expression.Predicate.Range)argument.a$(Expression.Predicate.Range.class)).lowBound(), ((Expression.Predicate.Range)argument.a$(Expression.Predicate.Range.class)).highBound());
    }

    private List<File> files(Instant instant, String tank, String argument) {
        return this.setStore.setsOf(tank, argument, instant).stream().map(v -> this.setStore.fileOf(tank, v, instant)).collect(Collectors.toList());
    }

    private List<File> files(Instant instant, String tank, int lowBound, int highBound) {
        return this.setStore.setsOf(tank, (double)lowBound, (double)highBound, instant).stream().map(v -> this.setStore.fileOf(tank, v, instant)).collect(Collectors.toList());
    }

    private long minutes(Expression.Predicate.FromNow fromNow) {
        return this.amountOf(fromNow.amount(), fromNow.scale());
    }

    private long minutes(Expression.Predicate.Recency recency) {
        return this.amountOf(recency.amount(), recency.scale());
    }

    private int amountOf(int amount, Scale scale) {
        return scale == Scale.Hour ? amount * 60 : (scale == Scale.Day ? amount * 24 * 60 : (scale == Scale.Month ? amount * 30 * 24 * 60 : amount * 365 * 30 * 24 * 60));
    }

    private int recencyIndex(Expression.Predicate predicate) {
        Instant from = this.reference;
        Instant to = this.reference.minus(this.minutes(predicate.recency()), ChronoUnit.MINUTES);
        int count = 1;
        while (from.isAfter(to)) {
            ++count;
            from = this.setStore.scale().minus(this.reference);
        }
        return count;
    }
}

