/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.engine;

import io.intino.sezzet.engine.FeatureRecord;
import io.intino.sezzet.engine.FeatureStream;
import io.intino.sezzet.operators.FileReader;
import io.intino.sezzet.operators.LongStream;
import io.intino.sezzet.operators.SetStream;
import java.util.ArrayList;
import java.util.List;

public class Featurizer
implements FeatureStream {
    private FeatureRecord current = null;
    private FeatureRecord next = null;
    private SetStream stream;
    private List<SetStreamStruct> featureStreams = new ArrayList<SetStreamStruct>();

    private Featurizer(SetStream stream) {
        this.stream = stream;
    }

    private Featurizer(long[] ids) {
        this.stream = new LongStream(ids);
    }

    public static FeaturizerBuilder create(SetStream stream) {
        return new FeaturizerBuilder(new Featurizer(stream));
    }

    public static FeaturizerBuilder create(long[] ids) {
        return new FeaturizerBuilder(new Featurizer(ids));
    }

    @Override
    public FeatureRecord current() {
        return this.current;
    }

    @Override
    public FeatureRecord next() {
        if (this.current == this.next) {
            this.hasNext();
        }
        this.current = this.next;
        return this.current;
    }

    @Override
    public boolean hasNext() {
        if (this.current != this.next) {
            return true;
        }
        if (!this.stream.hasNext()) {
            this.next = null;
            return false;
        }
        long id = this.stream.next();
        this.advanceStreamsUntil(id);
        this.next = new FeatureRecord(id);
        for (SetStreamStruct featureStream : this.featureStreams) {
            if (featureStream.stream.current() != id) continue;
            this.next.add(featureStream.feature, featureStream.value);
        }
        return true;
    }

    private void advanceStreamsUntil(long value) {
        for (SetStreamStruct featureStream : this.featureStreams) {
            while (featureStream.stream.current() < value && featureStream.stream.hasNext()) {
                featureStream.stream.next();
            }
        }
    }

    private static class SetStreamStruct {
        private final SetStream stream;
        private final String feature;
        private final String value;

        SetStreamStruct(SetStream stream, String feature, String value) {
            this.stream = stream;
            this.feature = feature;
            this.value = value;
        }
    }

    public static class FeaturizerBuilder {
        private Featurizer featurizer;

        FeaturizerBuilder(Featurizer featurizer) {
            this.featurizer = featurizer;
        }

        public FeaturizerBuilder add(SetStream stream, String feature, String value) {
            this.featurizer.featureStreams.add(new SetStreamStruct(stream, feature, value));
            return this;
        }

        public FeaturizerBuilder add(FileReader stream) {
            this.featurizer.featureStreams.add(new SetStreamStruct((SetStream)stream, stream.feature(), stream.value()));
            return this;
        }

        public Featurizer commit() {
            return this.featurizer;
        }
    }
}

