/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.editor.box.resources;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.AlexandriaDisplay;
import io.intino.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;
import io.intino.alexandria.ui.displays.DisplayRepository;
import io.intino.alexandria.ui.displays.Soul;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.alexandria.ui.spark.resources.Resource;
import io.intino.sezzet.editor.box.EditorBox;
import io.intino.sezzet.editor.box.actions.HomeAction;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class HomeResource
extends Resource {
    private final EditorBox box;

    public HomeResource(EditorBox box, UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
        this.box = box;
    }

    public void execute() throws AlexandriaException {
        super.execute();
        this.fillDeviceParameter();
        this.render();
    }

    private void render() {
        String clientId = UUID.randomUUID().toString();
        HomeAction action = new HomeAction();
        action.session = this.manager.currentSession();
        action.session.browser().requestUrl(this.manager.requestUrl());
        action.session.whenLogin((Function)new Function<String, String>(){

            @Override
            public String apply(String baseUrl) {
                return HomeResource.this.authenticate(baseUrl);
            }
        });
        action.session.whenLogout(b -> this.logout());
        action.box = this.box;
        action.clientId = clientId;
        action.device = this.parameterValue("device");
        action.token = this.parameterValue("token");
        ((PushService)this.manager.pushService()).onOpen(client -> {
            if (!client.id().equals(action.clientId)) {
                return false;
            }
            if (client.soul() != null) {
                return false;
            }
            Soul soul = action.prepareSoul((UIClient)client);
            soul.onRedirect(location -> this.manager.redirect(location));
            soul.addRegisterDisplayListener(display -> {
                display.inject(this.notifier(action.session, (UIClient)client, (AlexandriaDisplay)display));
                display.inject(action.session);
                display.inject((DisplayRepository)soul);
                display.inject(() -> soul);
            });
            client.soul(soul);
            this.box.registerSoul(clientId, soul);
            return true;
        });
        ((PushService)this.manager.pushService()).onClose(clientId).execute((Consumer)new Consumer<UIClient>(){

            @Override
            public void accept(UIClient client) {
                HomeResource.this.box.soul(client.id()).ifPresent(s -> s.destroy());
                HomeResource.this.box.unRegisterSoul(client.id());
                HomeResource.this.manager.unRegister(client);
            }
        });
        this.manager.write((Object)action.execute());
    }
}

