/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.editor.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.rest.spark.PushService;
import io.intino.alexandria.ui.AssetResourceLoader;
import io.intino.alexandria.ui.UI;
import io.intino.alexandria.ui.UIAlexandriaSpark;
import io.intino.alexandria.ui.spark.UIRouter;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.alexandria.ui.spark.resources.AfterDisplayRequest;
import io.intino.alexandria.ui.spark.resources.AssetResource;
import io.intino.alexandria.ui.spark.resources.AuthenticateCallbackResource;
import io.intino.alexandria.ui.spark.resources.BeforeDisplayRequest;
import io.intino.sezzet.editor.box.EditorBox;
import io.intino.sezzet.editor.box.EditorConfiguration;
import io.intino.sezzet.editor.box.displays.SezzetEditor;
import io.intino.sezzet.editor.box.displays.SezzetEditorHome;
import io.intino.sezzet.editor.box.displays.SezzetEditorMold;
import io.intino.sezzet.editor.box.displays.notifiers.SezzetEditorHomeNotifier;
import io.intino.sezzet.editor.box.displays.notifiers.SezzetEditorMoldNotifier;
import io.intino.sezzet.editor.box.displays.notifiers.SezzetEditorNotifier;
import io.intino.sezzet.editor.box.displays.requesters.SezzetEditorHomeRequester;
import io.intino.sezzet.editor.box.displays.requesters.SezzetEditorMoldRequester;
import io.intino.sezzet.editor.box.displays.requesters.SezzetEditorRequester;
import io.intino.sezzet.editor.box.resources.HomeResource;

public class EditorUiService
extends UI {
    public static void init(UIAlexandriaSpark spark, EditorBox box) {
        EditorConfiguration configuration = box.configuration();
        ((UIRouter)spark.route("/push")).push((PushService)new io.intino.alexandria.ui.services.push.PushService());
        ((UIRouter)spark.route("/authenticate-callback")).get(manager -> new AuthenticateCallbackResource(manager, EditorUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/asset/:name")).get(manager -> new AssetResource(name -> new AssetResourceLoader((Box)box).load(name), manager, EditorUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/")).get(manager -> new HomeResource(box, (UISparkManager)manager, EditorUiService.notifierProvider()).execute());
        EditorUiService.initDisplays(spark);
    }

    public static void initDisplays(UIAlexandriaSpark spark) {
        ((UIRouter)spark.route("/sezzeteditorhome/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sezzeteditorhome/:displayId")).post(manager -> new SezzetEditorHomeRequester((UISparkManager)manager, EditorUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sezzeteditorhome/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sezzeteditormold/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sezzeteditormold/:displayId")).post(manager -> new SezzetEditorMoldRequester((UISparkManager)manager, EditorUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sezzeteditormold/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sezzeteditor/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sezzeteditor/:displayId")).post(manager -> new SezzetEditorRequester((UISparkManager)manager, EditorUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sezzeteditor/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        EditorUiService.registerNotifiers();
    }

    private static void registerNotifiers() {
        EditorUiService.register(SezzetEditorHomeNotifier.class).forDisplay(SezzetEditorHome.class);
        EditorUiService.register(SezzetEditorMoldNotifier.class).forDisplay(SezzetEditorMold.class);
        EditorUiService.register(SezzetEditorNotifier.class).forDisplay(SezzetEditor.class);
    }
}

