/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.editor.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.rest.AlexandriaSparkBuilder;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.UIAlexandriaSpark;
import io.intino.alexandria.ui.UiElementsService;
import io.intino.alexandria.ui.displays.Soul;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.EditorService;
import io.intino.sezzet.editor.box.EditorBox;
import io.intino.sezzet.editor.box.EditorConfiguration;
import io.intino.sezzet.editor.box.EditorUiService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends AlexandriaUiBox {
    protected EditorConfiguration configuration;
    protected Map<String, Soul> uiSouls = new HashMap<String, Soul>();
    private List<AlexandriaUiBox.SoulsClosed> soulsClosedListeners = new ArrayList<AlexandriaUiBox.SoulsClosed>();
    private AuthService authService;
    private EditorService editorService;

    public AbstractBox(String[] args) {
        this(new EditorConfiguration(args));
    }

    public AbstractBox(EditorConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
        this.authService = null;
        this.editorService = null;
        if (this.configuration().get("port") != null && !this.configuration().get("port").isEmpty()) {
            AlexandriaSparkBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/");
        }
        AlexandriaSparkBuilder.setUI((boolean)true);
        AlexandriaSparkBuilder.addParameters((Object[])new Object[]{this.authService, this.editorService});
    }

    public EditorConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        return this;
    }

    public Box open() {
        if (this.owner != null) {
            this.owner.open();
        }
        this.initUI();
        this.initRESTServices();
        this.initJMXServices();
        this.initJMSServices();
        this.initDatalake();
        this.initTasks();
        this.initSlackBots();
        return this;
    }

    public void close() {
        if (this.owner != null) {
            this.owner.close();
        }
        AlexandriaSparkBuilder.instance().stop();
    }

    public List<Soul> souls() {
        return new ArrayList<Soul>(this.uiSouls.values());
    }

    public Optional<Soul> soul(String clientId) {
        return Optional.ofNullable(this.uiSouls.get(clientId));
    }

    public void registerSoul(String clientId, Soul soul) {
        this.uiSouls.put(clientId, soul);
    }

    public void unRegisterSoul(String clientId) {
        this.uiSouls.remove(clientId);
        if (this.uiSouls.size() <= 0) {
            this.notifySoulsClosed();
        }
    }

    public void onSoulsClosed(AlexandriaUiBox.SoulsClosed listener) {
        this.soulsClosedListeners.add(listener);
    }

    private void notifySoulsClosed() {
        this.soulsClosedListeners.forEach(l -> l.accept());
    }

    protected abstract AuthService authService(URL var1);

    protected abstract EditorService editorService(URL var1);

    public EditorService editorService() {
        return this.editorService;
    }

    private void initRESTServices() {
    }

    private void initJMSServices() {
    }

    private void initJMXServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
        if (this.configuration().get("port") == null || !AlexandriaSparkBuilder.isUI()) {
            return;
        }
        UIAlexandriaSpark sparkInstance = (UIAlexandriaSpark)AlexandriaSparkBuilder.instance();
        EditorUiService.init(sparkInstance, (EditorBox)this);
        UiElementsService.initDisplays((UIAlexandriaSpark)sparkInstance);
        sparkInstance.start();
        io.intino.alexandria.logger.Logger.info((String)"UI editor-ui: started!");
    }

    private void initDatalake() {
    }

    private void initTasks() {
    }

    private void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new io.intino.alexandria.logger.Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
    }

    private static URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

