package io.intino.sezzet.editor.box.displays;

import io.intino.alexandria.Base64;
import io.intino.alexandria.ui.displays.AlexandriaDesktop;
import io.intino.alexandria.ui.displays.AlexandriaElementDisplay;
import io.intino.alexandria.ui.model.Element;
import io.intino.alexandria.ui.model.panel.Desktop;
import io.intino.alexandria.ui.model.View;
import io.intino.alexandria.ui.utils.IOUtils;

import io.intino.sezzet.editor.box.EditorBox;
import io.intino.sezzet.editor.box.displays.notifiers.SezzetEditorHomeNotifier;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSezzetEditorHome extends AlexandriaDesktop<SezzetEditorHomeNotifier> {

	public AbstractSezzetEditorHome(EditorBox box) {
		super(box);
		element(buildDesktop(box));
	}

	private static Desktop buildDesktop(EditorBox box) {
		Desktop desktop = new Desktop();
		desktop.elementDisplayBuilder(new Desktop.ElementDisplayBuilder() {
			@Override
			public AlexandriaElementDisplay displayFor(Element element, Object o) {
				return get(element, o);
			}

			@Override
			public Class<? extends AlexandriaElementDisplay> displayTypeFor(Element element, Object o) {
				return get(element, o).getClass();
			}

			private AlexandriaElementDisplay get(Element element, Object o) {
				return Displays.displayFor(box, element);
			}
		});
		desktop.title("sezzet");
		desktop.subtitle("sezzet predicates editor");

		desktop.logo(toBase64(AbstractSezzetEditorHome.class.getResourceAsStream("/no-logo.png")));
		desktop.favicon(toBase64(AbstractSezzetEditorHome.class.getResourceAsStream("")));
		desktop.layout(Desktop.Layout.Tab);

		buildViews(box).forEach(v -> desktop.add(v));
		return desktop;
	}

	private static List<View> buildViews(EditorBox box) {
		List<View> result = new ArrayList<>();
		result.add(new io.intino.alexandria.ui.model.View().container(new io.intino.alexandria.ui.model.view.container.MoldContainer().mold((io.intino.alexandria.ui.model.Mold) io.intino.sezzet.editor.box.displays.Displays.displayFor(box, "SezzetEditorMold").element())).layout(View.Layout.Tab).width(100).name("1af8872e-fe93-44bb-9fac-6374c45ad9da").label("editor"));
		return result;
	}

	private static String toBase64(java.io.InputStream resource) {
		try {
			if (resource == null) return "";
			return "data:image/png;base64," + Base64.encode(toByteArray(resource));
		} catch (java.io.IOException e) {
			return "";
		}
	}

	private static java.net.URL url(String url) {
		try {
		return new java.net.URL(url);
		} catch (java.net.MalformedURLException e) {
			return null;
		}
	}

	private static byte[] toByteArray(java.io.InputStream input) throws java.io.IOException {
		java.io.ByteArrayOutputStream output = new java.io.ByteArrayOutputStream();
		IOUtils.copy(input, output);
		return output.toByteArray();
	}
}