package io.intino.sezzet.editor.box;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import io.intino.alexandria.logger.Logger;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;

import io.intino.alexandria.ui.displays.Soul;

public abstract class AbstractBox extends io.intino.alexandria.ui.AlexandriaUiBox {
	protected EditorConfiguration configuration;

    protected Map<String, Soul> uiSouls = new java.util.HashMap<>();
    private java.util.List<io.intino.alexandria.ui.AlexandriaUiBox.SoulsClosed> soulsClosedListeners = new java.util.ArrayList<>();
	private io.intino.alexandria.ui.services.AuthService authService;
	private io.intino.alexandria.ui.services.EditorService editorService;

	public AbstractBox(String[] args) {
		this(new EditorConfiguration(args));
	}

	public AbstractBox(EditorConfiguration configuration) {

		this.configuration = configuration;
		initJavaLogger();
		this.authService = null;
		this.editorService = null;
		if(configuration().get("port") != null && !configuration().get("port").isEmpty())io.intino.alexandria.rest.AlexandriaSparkBuilder.setup(Integer.parseInt(configuration().get("port")), "www/");
		io.intino.alexandria.rest.AlexandriaSparkBuilder.setUI(true);
		io.intino.alexandria.rest.AlexandriaSparkBuilder.addParameters(this.authService, this.editorService);

	}

	public EditorConfiguration configuration() {
		return configuration;
	}

	@Override
	public io.intino.alexandria.core.Box put(Object o) {

		return this;
	}

	public io.intino.alexandria.core.Box open() {
		if (owner != null) owner.open();
		initUI();
		initRESTServices();
		initJMXServices();
		initJMSServices();
		initDatalake();
		initTasks();
		initSlackBots();
		return this;
	}

	public void close() {
		if(owner != null) owner.close();
		io.intino.alexandria.rest.AlexandriaSparkBuilder.instance().stop();


	}

	public java.util.List<Soul> souls() {
	return new java.util.ArrayList<>(uiSouls.values());
}

	public java.util.Optional<Soul> soul(String clientId) {
		return java.util.Optional.ofNullable(uiSouls.get(clientId));
	}

	public void registerSoul(String clientId, Soul soul) {

		uiSouls.put(clientId, soul);
	}

	public void unRegisterSoul(String clientId) {

		uiSouls.remove(clientId);
		if (uiSouls.size() <= 0) notifySoulsClosed();
	}

	public void onSoulsClosed(io.intino.alexandria.ui.AlexandriaUiBox.SoulsClosed listener) {

		this.soulsClosedListeners.add(listener);
	}

	private void notifySoulsClosed() {
		soulsClosedListeners.forEach(l -> l.accept());
	}

	protected abstract io.intino.alexandria.ui.services.AuthService authService(java.net.URL authServiceUrl);
	protected abstract io.intino.alexandria.ui.services.EditorService editorService(java.net.URL editorServiceUrl);

public io.intino.alexandria.ui.services.EditorService editorService() {
	return this.editorService;
}



	private void initRESTServices() {

	}

	private void initJMSServices() {


	}

	private void initJMXServices() {

	}

	private void initSlackBots() {

	}

	private void initUI() {
		if (configuration().get("port") == null || !io.intino.alexandria.rest.AlexandriaSparkBuilder.isUI()) return;
		io.intino.alexandria.ui.UIAlexandriaSpark sparkInstance = (io.intino.alexandria.ui.UIAlexandriaSpark) io.intino.alexandria.rest.AlexandriaSparkBuilder.instance();
		EditorUiService.init(sparkInstance, (EditorBox) this);
		io.intino.alexandria.ui.UiElementsService.initDisplays(sparkInstance);

		sparkInstance.start();
		Logger.info("UI editor-ui: started!");
	}

	private void initDatalake() {

	}

	private void initTasks() {

	}

	private void initJavaLogger() {
		final java.util.logging.Logger Logger = java.util.logging.Logger.getGlobal();
		final ConsoleHandler handler = new ConsoleHandler();
		handler.setLevel(Level.INFO);
		handler.setFormatter(new io.intino.alexandria.logger.Formatter());
		Logger.setUseParentHandlers(false);
		Logger.addHandler(handler);
	}

	private static java.net.URL url(String url) {
		try {
		return new java.net.URL(url);
		} catch (java.net.MalformedURLException e) {
			return null;
		}
	}
}