package io.intino.sezzet.editor.box.displays.requesters;

import io.intino.sezzet.editor.box.displays.SezzetEditor;
import io.intino.alexandria.exceptions.*;
import io.intino.sezzet.editor.box.*;
import io.intino.sezzet.editor.box.schemas.*;

import io.intino.sezzet.editor.box.displays.notifiers.SezzetEditorNotifier;
import io.intino.alexandria.ui.displays.requesters.AlexandriaDisplayRequester;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class SezzetEditorRequester extends AlexandriaDisplayRequester {

	public SezzetEditorRequester(UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SezzetEditor display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("onSuggest")) {
			display.onSuggest(manager.fromQuery("value", io.intino.sezzet.editor.box.schemas.SuggestParameters.class));
			return;
		}
		else if (operation.equals("onChange")) {
			display.onChange(manager.fromQuery("value", io.intino.sezzet.editor.box.schemas.ChangeParameters.class));
			return;
		}
		super.execute();
	}
}