package io.intino.sezzet.editor.box.displays;

import io.intino.alexandria.ui.displays.AlexandriaDisplay;
import io.intino.alexandria.ui.displays.*;
import io.intino.sezzet.editor.box.EditorBox;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class Displays {
	private static Map<String, ElementDisplayBuilder> displayMap = new HashMap<>();

	static {
		{
			displayMap.put("SezzetEditorHome", (box) -> new SezzetEditorHome(box));
			displayMap.put("SezzetEditorMold", (box) -> new SezzetEditorMold(box));

		}
	}

	public static AlexandriaElementDisplay displayFor(EditorBox box, String name) {
		if (!displayMap.containsKey(name)) return null;
		return displayMap.get(name).build(box);
	}

	public static AlexandriaElementDisplay displayFor(EditorBox box, io.intino.alexandria.ui.model.Element element) {
		if (!displayMap.containsKey(element.name())) return defaultElement(box, element);
		return displayMap.get(element.name()).build(box);
	}

	public static <T extends io.intino.alexandria.ui.model.Element> T elementFor(EditorBox box, Class<T> tClass, String name) {
		if (!displayMap.containsKey(name)) return null;
		return (T) displayMap.get(name).build(box).element();
	}

	public static Class<? extends AlexandriaElementDisplay> displayTypeFor(EditorBox box, io.intino.alexandria.ui.model.Element element) {
		if (!displayMap.containsKey(element.name())) return defaultElementType(box, element);
		return displayMap.get(element.name()).build(box).getClass();
	}

	private static Class<? extends AlexandriaElementDisplay> defaultElementType(EditorBox box, io.intino.alexandria.ui.model.Element element) {
		if (element instanceof io.intino.alexandria.ui.model.Panel) return AlexandriaPanel.class;

		if (element instanceof io.intino.alexandria.ui.model.TemporalCatalog)
			return ((io.intino.alexandria.ui.model.TemporalCatalog) element).type() == io.intino.alexandria.ui.model.TemporalCatalog.Type.Range ? AlexandriaTemporalRangeCatalog.class : AlexandriaTemporalTimeCatalog.class;

		if (element instanceof io.intino.alexandria.ui.model.Catalog)
			return AlexandriaCatalog.class;

		if (element instanceof io.intino.alexandria.ui.model.panel.Desktop)
			return AlexandriaDesktop.class;

		return null;
	}

	private static AlexandriaElementDisplay defaultElement(EditorBox box, io.intino.alexandria.ui.model.Element element) {
		if (element instanceof io.intino.alexandria.ui.model.Panel) return new AlexandriaPanel(box);

		if (element instanceof io.intino.alexandria.ui.model.TemporalCatalog)
			return ((io.intino.alexandria.ui.model.TemporalCatalog) element).type() == io.intino.alexandria.ui.model.TemporalCatalog.Type.Range ? new AlexandriaTemporalRangeCatalog(box) : new AlexandriaTemporalTimeCatalog(box);

		if (element instanceof io.intino.alexandria.ui.model.Catalog)
			return new AlexandriaCatalog(box);

		if (element instanceof io.intino.alexandria.ui.model.panel.Desktop)
			return new AlexandriaDesktop(box);

		return null;
	}

/*		private void refreshCatalog(EditorBox box, String catalog, Item... items) {
		uiSouls.values().stream().map(Soul::getAll).flatMap(Collection::stream)
				.filter(d -> d instanceof AlexandriaAbstractCatalog && ((AlexandriaAbstractCatalog) d)
						.isFor(catalog)).forEach(d -> {
			AlexandriaAbstractCatalog display = (AlexandriaAbstractCatalog) d;
			display.dirty(true);
			if (categorizationsHaveChanges || items.length == 0)
				display.refresh();
			else
				display.refresh(items);
		});
	}
*/
	private interface ElementDisplayBuilder {
		AlexandriaElementDisplay build(EditorBox box);
	}
}