/**
 * vis.js
 * https://github.com/almende/vis
 *
 * A dynamic, browser-based visualization library.
 *
 * @version 4.18.1
 * @date    2017-01-29
 *
 * @license
 * Copyright (C) 2011-2016 Almende B.V, http://almende.com
 *
 * Vis.js is dual licensed under both
 *
 * * The Apache 2.0 License
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * and
 *
 * * The MIT License
 *   http://opensource.org/licenses/MIT
 *
 * Vis.js may be distributed under either license.
 */
"use strict";!function(t,e){"object"==typeof exports&&"object"==typeof module?module.exports=e():"function"==typeof define&&define.amd?define([],e):"object"==typeof exports?exports.vis=e():t.vis=e()}(this,function(){return function(t){function e(i){if(n[i])return n[i].exports;var r=n[i]={exports:{},id:i,loaded:!1};return t[i].call(r.exports,r,r.exports,e),r.loaded=!0,r.exports}var n={};return e.m=t,e.c=n,e.p="",e(0)}([function(t,e,n){e.util=n(1),e.DOMutil=n(89),e.DataSet=n(90),e.DataView=n(92),e.Queue=n(91),e.Graph3d=n(93),e.graph3d={Camera:n(97),Filter:n(102),Point2d:n(96),Point3d:n(95),Slider:n(103),StepNumber:n(104)},e.moment=n(84),e.Hammer=n(107),e.keycharm=n(110)},function(t,e,n){function i(t){return t&&t.__esModule?t:{default:t}}var r=n(2),o=i(r),s=n(55),a=i(s),h=n(58),u=i(h),l=n(62),c=i(l),f=n(82),d=i(f),p=n(84),m=n(88);e.isNumber=function(t){return t instanceof Number||"number"==typeof t},e.elementsCensor=function(t){if(t){var e=function(t,e){return e instanceof Element?"DOM Element":e};return JSON.parse((0,d.default)(t,e))}},e.recursiveDOMDelete=function(t){if(t)for(;t.hasChildNodes()===!0;)e.recursiveDOMDelete(t.firstChild),t.removeChild(t.firstChild)},e.giveRange=function(t,e,n,i){if(e==t)return.5;var r=1/(e-t);return Math.max(0,(i-t)*r)},e.isString=function(t){return t instanceof String||"string"==typeof t},e.isDate=function(t){if(t instanceof Date)return!0;if(e.isString(t)){var n=v.exec(t);if(n)return!0;if(!isNaN(Date.parse(t)))return!0}return!1},e.randomUUID=function(){return m.v4()},e.assignAllKeys=function(t,e){for(var n in t)t.hasOwnProperty(n)&&"object"!==(0,c.default)(t[n])&&(t[n]=e)},e.fillIfDefined=function(t,n){var i=arguments.length>2&&void 0!==arguments[2]&&arguments[2];for(var r in t)void 0!==n[r]&&("object"!==(0,c.default)(n[r])?void 0!==n[r]&&null!==n[r]||void 0===t[r]||i!==!0?t[r]=n[r]:delete t[r]:"object"===(0,c.default)(t[r])&&e.fillIfDefined(t[r],n[r],i))},e.protoExtend=function(t,e){for(var n=1;n<arguments.length;n++){var i=arguments[n];for(var r in i)t[r]=i[r]}return t},e.extend=function(t,e){for(var n=1;n<arguments.length;n++){var i=arguments[n];for(var r in i)i.hasOwnProperty(r)&&(t[r]=i[r])}return t},e.selectiveExtend=function(t,e,n){if(!Array.isArray(t))throw new Error("Array with property names expected as first argument");for(var i=2;i<arguments.length;i++)for(var r=arguments[i],o=0;o<t.length;o++){var s=t[o];r.hasOwnProperty(s)&&(e[s]=r[s])}return e},e.selectiveDeepExtend=function(t,n,i){var r=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(Array.isArray(i))throw new TypeError("Arrays are not supported by deepExtend");for(var o=2;o<arguments.length;o++)for(var s=arguments[o],a=0;a<t.length;a++){var h=t[a];if(s.hasOwnProperty(h))if(i[h]&&i[h].constructor===Object)void 0===n[h]&&(n[h]={}),n[h].constructor===Object?e.deepExtend(n[h],i[h],!1,r):null===i[h]&&void 0!==n[h]&&r===!0?delete n[h]:n[h]=i[h];else{if(Array.isArray(i[h]))throw new TypeError("Arrays are not supported by deepExtend");null===i[h]&&void 0!==n[h]&&r===!0?delete n[h]:n[h]=i[h]}}return n},e.selectiveNotDeepExtend=function(t,n,i){var r=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(Array.isArray(i))throw new TypeError("Arrays are not supported by deepExtend");for(var o in i)if(i.hasOwnProperty(o)&&t.indexOf(o)==-1)if(i[o]&&i[o].constructor===Object)void 0===n[o]&&(n[o]={}),n[o].constructor===Object?e.deepExtend(n[o],i[o]):null===i[o]&&void 0!==n[o]&&r===!0?delete n[o]:n[o]=i[o];else if(Array.isArray(i[o])){n[o]=[];for(var s=0;s<i[o].length;s++)n[o].push(i[o][s])}else null===i[o]&&void 0!==n[o]&&r===!0?delete n[o]:n[o]=i[o];return n},e.deepExtend=function(t,n,i,r){for(var o in n)if(n.hasOwnProperty(o)||i===!0)if(n[o]&&n[o].constructor===Object)void 0===t[o]&&(t[o]={}),t[o].constructor===Object?e.deepExtend(t[o],n[o],i):null===n[o]&&void 0!==t[o]&&r===!0?delete t[o]:t[o]=n[o];else if(Array.isArray(n[o])){t[o]=[];for(var s=0;s<n[o].length;s++)t[o].push(n[o][s])}else null===n[o]&&void 0!==t[o]&&r===!0?delete t[o]:t[o]=n[o];return t},e.equalArray=function(t,e){if(t.length!=e.length)return!1;for(var n=0,i=t.length;n<i;n++)if(t[n]!=e[n])return!1;return!0},e.convert=function(t,n){var i;if(void 0!==t){if(null===t)return null;if(!n)return t;if("string"!=typeof n&&!(n instanceof String))throw new Error("Type must be a string");switch(n){case"boolean":case"Boolean":return Boolean(t);case"number":case"Number":return e.isString(t)&&!isNaN(Date.parse(t))?p(t).valueOf():Number(t.valueOf());case"string":case"String":return String(t);case"Date":if(e.isNumber(t))return new Date(t);if(t instanceof Date)return new Date(t.valueOf());if(p.isMoment(t))return new Date(t.valueOf());if(e.isString(t))return i=v.exec(t),i?new Date(Number(i[1])):p(new Date(t)).toDate();throw new Error("Cannot convert object of type "+e.getType(t)+" to type Date");case"Moment":if(e.isNumber(t))return p(t);if(t instanceof Date)return p(t.valueOf());if(p.isMoment(t))return p(t);if(e.isString(t))return i=v.exec(t),p(i?Number(i[1]):t);throw new Error("Cannot convert object of type "+e.getType(t)+" to type Date");case"ISODate":if(e.isNumber(t))return new Date(t);if(t instanceof Date)return t.toISOString();if(p.isMoment(t))return t.toDate().toISOString();if(e.isString(t))return i=v.exec(t),i?new Date(Number(i[1])).toISOString():p(t).format();throw new Error("Cannot convert object of type "+e.getType(t)+" to type ISODate");case"ASPDate":if(e.isNumber(t))return"/Date("+t+")/";if(t instanceof Date)return"/Date("+t.valueOf()+")/";if(e.isString(t)){i=v.exec(t);var r;return r=i?new Date(Number(i[1])).valueOf():new Date(t).valueOf(),"/Date("+r+")/"}throw new Error("Cannot convert object of type "+e.getType(t)+" to type ASPDate");default:throw new Error('Unknown type "'+n+'"')}}};var v=/^\/?Date\((\-?\d+)/i;e.getType=function(t){var e="undefined"==typeof t?"undefined":(0,c.default)(t);return"object"==e?null===t?"null":t instanceof Boolean?"Boolean":t instanceof Number?"Number":t instanceof String?"String":Array.isArray(t)?"Array":t instanceof Date?"Date":"Object":"number"==e?"Number":"boolean"==e?"Boolean":"string"==e?"String":void 0===e?"undefined":e},e.copyAndExtendArray=function(t,e){for(var n=[],i=0;i<t.length;i++)n.push(t[i]);return n.push(e),n},e.copyArray=function(t){for(var e=[],n=0;n<t.length;n++)e.push(t[n]);return e},e.getAbsoluteLeft=function(t){return t.getBoundingClientRect().left},e.getAbsoluteRight=function(t){return t.getBoundingClientRect().right},e.getAbsoluteTop=function(t){return t.getBoundingClientRect().top},e.addClassName=function(t,e){var n=t.className.split(" ");n.indexOf(e)==-1&&(n.push(e),t.className=n.join(" "))},e.removeClassName=function(t,e){var n=t.className.split(" "),i=n.indexOf(e);i!=-1&&(n.splice(i,1),t.className=n.join(" "))},e.forEach=function(t,e){var n,i;if(Array.isArray(t))for(n=0,i=t.length;n<i;n++)e(t[n],n,t);else for(n in t)t.hasOwnProperty(n)&&e(t[n],n,t)},e.toArray=function(t){var e=[];for(var n in t)t.hasOwnProperty(n)&&e.push(t[n]);return e},e.updateProperty=function(t,e,n){return t[e]!==n&&(t[e]=n,!0)},e.throttle=function(t){var e=!1;return function(){e||(e=!0,requestAnimationFrame(function(){e=!1,t()}))}},e.addEventListener=function(t,e,n,i){t.addEventListener?(void 0===i&&(i=!1),"mousewheel"===e&&navigator.userAgent.indexOf("Firefox")>=0&&(e="DOMMouseScroll"),t.addEventListener(e,n,i)):t.attachEvent("on"+e,n)},e.removeEventListener=function(t,e,n,i){t.removeEventListener?(void 0===i&&(i=!1),"mousewheel"===e&&navigator.userAgent.indexOf("Firefox")>=0&&(e="DOMMouseScroll"),t.removeEventListener(e,n,i)):t.detachEvent("on"+e,n)},e.preventDefault=function(t){t||(t=window.event),t.preventDefault?t.preventDefault():t.returnValue=!1},e.getTarget=function(t){t||(t=window.event);var e;return t.target?e=t.target:t.srcElement&&(e=t.srcElement),void 0!=e.nodeType&&3==e.nodeType&&(e=e.parentNode),e},e.hasParent=function(t,e){for(var n=t;n;){if(n===e)return!0;n=n.parentNode}return!1},e.option={},e.option.asBoolean=function(t,e){return"function"==typeof t&&(t=t()),null!=t?0!=t:e||null},e.option.asNumber=function(t,e){return"function"==typeof t&&(t=t()),null!=t?Number(t)||e||null:e||null},e.option.asString=function(t,e){return"function"==typeof t&&(t=t()),null!=t?String(t):e||null},e.option.asSize=function(t,n){return"function"==typeof t&&(t=t()),e.isString(t)?t:e.isNumber(t)?t+"px":n||null},e.option.asElement=function(t,e){return"function"==typeof t&&(t=t()),t||e||null},e.hexToRGB=function(t){var e=/^#?([a-f\d])([a-f\d])([a-f\d])$/i;t=t.replace(e,function(t,e,n,i){return e+e+n+n+i+i});var n=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(t);return n?{r:parseInt(n[1],16),g:parseInt(n[2],16),b:parseInt(n[3],16)}:null},e.overrideOpacity=function(t,n){if(t.indexOf("rgba")!=-1)return t;if(t.indexOf("rgb")!=-1){var i=t.substr(t.indexOf("(")+1).replace(")","").split(",");return"rgba("+i[0]+","+i[1]+","+i[2]+","+n+")"}var i=e.hexToRGB(t);return null==i?t:"rgba("+i.r+","+i.g+","+i.b+","+n+")"},e.RGBToHex=function(t,e,n){return"#"+((1<<24)+(t<<16)+(e<<8)+n).toString(16).slice(1)},e.parseColor=function(t){var n;if(e.isString(t)===!0){if(e.isValidRGB(t)===!0){var i=t.substr(4).substr(0,t.length-5).split(",").map(function(t){return parseInt(t)});t=e.RGBToHex(i[0],i[1],i[2])}if(e.isValidHex(t)===!0){var r=e.hexToHSV(t),o={h:r.h,s:.8*r.s,v:Math.min(1,1.02*r.v)},s={h:r.h,s:Math.min(1,1.25*r.s),v:.8*r.v},a=e.HSVToHex(s.h,s.s,s.v),h=e.HSVToHex(o.h,o.s,o.v);n={background:t,border:a,highlight:{background:h,border:a},hover:{background:h,border:a}}}else n={background:t,border:t,highlight:{background:t,border:t},hover:{background:t,border:t}}}else n={},n.background=t.background||void 0,n.border=t.border||void 0,e.isString(t.highlight)?n.highlight={border:t.highlight,background:t.highlight}:(n.highlight={},n.highlight.background=t.highlight&&t.highlight.background||void 0,n.highlight.border=t.highlight&&t.highlight.border||void 0),e.isString(t.hover)?n.hover={border:t.hover,background:t.hover}:(n.hover={},n.hover.background=t.hover&&t.hover.background||void 0,n.hover.border=t.hover&&t.hover.border||void 0);return n},e.RGBToHSV=function(t,e,n){t/=255,e/=255,n/=255;var i=Math.min(t,Math.min(e,n)),r=Math.max(t,Math.max(e,n));if(i==r)return{h:0,s:0,v:i};var o=t==i?e-n:n==i?t-e:n-t,s=t==i?3:n==i?1:5,a=60*(s-o/(r-i))/360,h=(r-i)/r,u=r;return{h:a,s:h,v:u}};var y={split:function(t){var e={};return t.split(";").forEach(function(t){if(""!=t.trim()){var n=t.split(":"),i=n[0].trim(),r=n[1].trim();e[i]=r}}),e},join:function(t){return(0,u.default)(t).map(function(e){return e+": "+t[e]}).join("; ")}};e.addCssText=function(t,n){var i=y.split(t.style.cssText),r=y.split(n),o=e.extend(i,r);t.style.cssText=y.join(o)},e.removeCssText=function(t,e){var n=y.split(t.style.cssText),i=y.split(e);for(var r in i)i.hasOwnProperty(r)&&delete n[r];t.style.cssText=y.join(n)},e.HSVToRGB=function(t,e,n){var i,r,o,s=Math.floor(6*t),a=6*t-s,h=n*(1-e),u=n*(1-a*e),l=n*(1-(1-a)*e);switch(s%6){case 0:i=n,r=l,o=h;break;case 1:i=u,r=n,o=h;break;case 2:i=h,r=n,o=l;break;case 3:i=h,r=u,o=n;break;case 4:i=l,r=h,o=n;break;case 5:i=n,r=h,o=u}return{r:Math.floor(255*i),g:Math.floor(255*r),b:Math.floor(255*o)}},e.HSVToHex=function(t,n,i){var r=e.HSVToRGB(t,n,i);return e.RGBToHex(r.r,r.g,r.b)},e.hexToHSV=function(t){var n=e.hexToRGB(t);return e.RGBToHSV(n.r,n.g,n.b)},e.isValidHex=function(t){var e=/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(t);return e},e.isValidRGB=function(t){t=t.replace(" ","");var e=/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/i.test(t);return e},e.isValidRGBA=function(t){t=t.replace(" ","");var e=/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),(.{1,3})\)/i.test(t);return e},e.selectiveBridgeObject=function(t,n){if("object"==("undefined"==typeof n?"undefined":(0,c.default)(n))){for(var i=(0,a.default)(n),r=0;r<t.length;r++)n.hasOwnProperty(t[r])&&"object"==(0,c.default)(n[t[r]])&&(i[t[r]]=e.bridgeObject(n[t[r]]));return i}return null},e.bridgeObject=function(t){if("object"==("undefined"==typeof t?"undefined":(0,c.default)(t))){var n=(0,a.default)(t);for(var i in t)t.hasOwnProperty(i)&&"object"==(0,c.default)(t[i])&&(n[i]=e.bridgeObject(t[i]));return n}return null},e.insertSort=function(t,e){for(var n=0;n<t.length;n++){for(var i=t[n],r=n;r>0&&e(i,t[r-1])<0;r--)t[r]=t[r-1];t[r]=i}return t},e.mergeOptions=function(t,e,n){var i=(arguments.length>3&&void 0!==arguments[3]&&arguments[3],arguments.length>4&&void 0!==arguments[4]?arguments[4]:{});if(null===e[n])t[n]=(0,a.default)(i[n]);else if(void 0!==e[n])if("boolean"==typeof e[n])t[n].enabled=e[n];else{void 0===e[n].enabled&&(t[n].enabled=!0);for(var r in e[n])e[n].hasOwnProperty(r)&&(t[n][r]=e[n][r])}},e.binarySearchCustom=function(t,e,n,i){for(var r=1e4,o=0,s=0,a=t.length-1;s<=a&&o<r;){var h=Math.floor((s+a)/2),u=t[h],l=void 0===i?u[n]:u[n][i],c=e(l);if(0==c)return h;c==-1?s=h+1:a=h-1,o++}return-1},e.binarySearchValue=function(t,e,n,i,r){for(var o,s,a,h,u=1e4,l=0,c=0,f=t.length-1,r=void 0!=r?r:function(t,e){return t==e?0:t<e?-1:1};c<=f&&l<u;){if(h=Math.floor(.5*(f+c)),o=t[Math.max(0,h-1)][n],s=t[h][n],a=t[Math.min(t.length-1,h+1)][n],0==r(s,e))return h;if(r(o,e)<0&&r(s,e)>0)return"before"==i?Math.max(0,h-1):h;if(r(s,e)<0&&r(a,e)>0)return"before"==i?h:Math.min(t.length-1,h+1);r(s,e)<0?c=h+1:f=h-1,l++}return-1},e.easingFunctions={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return t*(2-t)},easeInOutQuad:function(t){return t<.5?2*t*t:-1+(4-2*t)*t},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return--t*t*t+1},easeInOutCubic:function(t){return t<.5?4*t*t*t:(t-1)*(2*t-2)*(2*t-2)+1},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return 1- --t*t*t*t},easeInOutQuart:function(t){return t<.5?8*t*t*t*t:1-8*--t*t*t*t},easeInQuint:function(t){return t*t*t*t*t},easeOutQuint:function(t){return 1+--t*t*t*t*t},easeInOutQuint:function(t){return t<.5?16*t*t*t*t*t:1+16*--t*t*t*t*t}},e.getScrollBarWidth=function(){var t=document.createElement("p");t.style.width="100%",t.style.height="200px";var e=document.createElement("div");e.style.position="absolute",e.style.top="0px",e.style.left="0px",e.style.visibility="hidden",e.style.width="200px",e.style.height="150px",e.style.overflow="hidden",e.appendChild(t),document.body.appendChild(e);var n=t.offsetWidth;e.style.overflow="scroll";var i=t.offsetWidth;return n==i&&(i=e.clientWidth),document.body.removeChild(e),n-i},e.topMost=function(t,e){var n=void 0;Array.isArray(e)||(e=[e]);var i=!0,r=!1,s=void 0;try{for(var a,h=(0,o.default)(t);!(i=(a=h.next()).done);i=!0){var u=a.value;if(u){n=u[e[0]];for(var l=1;l<e.length;l++)n&&(n=n[e[l]]);if("undefined"!=typeof n)break}}}catch(t){r=!0,s=t}finally{try{!i&&h.return&&h.return()}finally{if(r)throw s}}return n}},function(t,e,n){t.exports={default:n(3),__esModule:!0}},function(t,e,n){n(4),n(50),t.exports=n(52)},function(t,e,n){n(5);for(var i=n(16),r=n(20),o=n(8),s=n(47)("toStringTag"),a=["NodeList","DOMTokenList","MediaList","StyleSheetList","CSSRuleList"],h=0;h<5;h++){var u=a[h],l=i[u],c=l&&l.prototype;c&&!c[s]&&r(c,s,u),o[u]=o.Array}},function(t,e,n){var i=n(6),r=n(7),o=n(8),s=n(9);t.exports=n(13)(Array,"Array",function(t,e){this._t=s(t),this._i=0,this._k=e},function(){var t=this._t,e=this._k,n=this._i++;return!t||n>=t.length?(this._t=void 0,r(1)):"keys"==e?r(0,n):"values"==e?r(0,t[n]):r(0,[n,t[n]])},"values"),o.Arguments=o.Array,i("keys"),i("values"),i("entries")},function(t,e){t.exports=function(){}},function(t,e){t.exports=function(t,e){return{value:e,done:!!t}}},function(t,e){t.exports={}},function(t,e,n){var i=n(10),r=n(12);t.exports=function(t){return i(r(t))}},function(t,e,n){var i=n(11);t.exports=Object("z").propertyIsEnumerable(0)?Object:function(t){return"String"==i(t)?t.split(""):Object(t)}},function(t,e){var n={}.toString;t.exports=function(t){return n.call(t).slice(8,-1)}},function(t,e){t.exports=function(t){if(void 0==t)throw TypeError("Can't call method on  "+t);return t}},function(t,e,n){var i=n(14),r=n(15),o=n(30),s=n(20),a=n(31),h=n(8),u=n(32),l=n(46),c=n(48),f=n(47)("iterator"),d=!([].keys&&"next"in[].keys()),p="@@iterator",m="keys",v="values",y=function(){return this};t.exports=function(t,e,n,g,_,w,x){u(n,e,g);var b,S,T,D=function(t){if(!d&&t in E)return E[t];switch(t){case m:return function(){return new n(this,t)};case v:return function(){return new n(this,t)}}return function(){return new n(this,t)}},M=e+" Iterator",k=_==v,O=!1,E=t.prototype,C=E[f]||E[p]||_&&E[_],P=C||D(_),L=_?k?D("entries"):P:void 0,Y="Array"==e?E.entries||C:C;if(Y&&(T=c(Y.call(new t)),T!==Object.prototype&&(l(T,M,!0),i||a(T,f)||s(T,f,y))),k&&C&&C.name!==v&&(O=!0,P=function(){return C.call(this)}),i&&!x||!d&&!O&&E[f]||s(E,f,P),h[e]=P,h[M]=y,_)if(b={values:k?P:D(v),keys:w?P:D(m),entries:L},x)for(S in b)S in E||o(E,S,b[S]);else r(r.P+r.F*(d||O),e,b);return b}},function(t,e){t.exports=!0},function(t,e,n){var i=n(16),r=n(17),o=n(18),s=n(20),a="prototype",h=function(t,e,n){var u,l,c,f=t&h.F,d=t&h.G,p=t&h.S,m=t&h.P,v=t&h.B,y=t&h.W,g=d?r:r[e]||(r[e]={}),_=g[a],w=d?i:p?i[e]:(i[e]||{})[a];d&&(n=e);for(u in n)l=!f&&w&&void 0!==w[u],l&&u in g||(c=l?w[u]:n[u],g[u]=d&&"function"!=typeof w[u]?n[u]:v&&l?o(c,i):y&&w[u]==c?function(t){var e=function(e,n,i){if(this instanceof t){switch(arguments.length){case 0:return new t;case 1:return new t(e);case 2:return new t(e,n)}return new t(e,n,i)}return t.apply(this,arguments)};return e[a]=t[a],e}(c):m&&"function"==typeof c?o(Function.call,c):c,m&&((g.virtual||(g.virtual={}))[u]=c,t&h.R&&_&&!_[u]&&s(_,u,c)))};h.F=1,h.G=2,h.S=4,h.P=8,h.B=16,h.W=32,h.U=64,h.R=128,t.exports=h},function(t,e){var n=t.exports="undefined"!=typeof window&&window.Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=n)},function(t,e){var n=t.exports={version:"2.4.0"};"number"==typeof __e&&(__e=n)},function(t,e,n){var i=n(19);t.exports=function(t,e,n){if(i(t),void 0===e)return t;switch(n){case 1:return function(n){return t.call(e,n)};case 2:return function(n,i){return t.call(e,n,i)};case 3:return function(n,i,r){return t.call(e,n,i,r)}}return function(){return t.apply(e,arguments)}}},function(t,e){t.exports=function(t){if("function"!=typeof t)throw TypeError(t+" is not a function!");return t}},function(t,e,n){var i=n(21),r=n(29);t.exports=n(25)?function(t,e,n){return i.f(t,e,r(1,n))}:function(t,e,n){return t[e]=n,t}},function(t,e,n){var i=n(22),r=n(24),o=n(28),s=Object.defineProperty;e.f=n(25)?Object.defineProperty:function(t,e,n){if(i(t),e=o(e,!0),i(n),r)try{return s(t,e,n)}catch(t){}if("get"in n||"set"in n)throw TypeError("Accessors not supported!");return"value"in n&&(t[e]=n.value),t}},function(t,e,n){var i=n(23);t.exports=function(t){if(!i(t))throw TypeError(t+" is not an object!");return t}},function(t,e){t.exports=function(t){return"object"==typeof t?null!==t:"function"==typeof t}},function(t,e,n){t.exports=!n(25)&&!n(26)(function(){return 7!=Object.defineProperty(n(27)("div"),"a",{get:function(){return 7}}).a})},function(t,e,n){t.exports=!n(26)(function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a})},function(t,e){t.exports=function(t){try{return!!t()}catch(t){return!0}}},function(t,e,n){var i=n(23),r=n(16).document,o=i(r)&&i(r.createElement);t.exports=function(t){return o?r.createElement(t):{}}},function(t,e,n){var i=n(23);t.exports=function(t,e){if(!i(t))return t;var n,r;if(e&&"function"==typeof(n=t.toString)&&!i(r=n.call(t)))return r;if("function"==typeof(n=t.valueOf)&&!i(r=n.call(t)))return r;if(!e&&"function"==typeof(n=t.toString)&&!i(r=n.call(t)))return r;throw TypeError("Can't convert object to primitive value")}},function(t,e){t.exports=function(t,e){return{enumerable:!(1&t),configurable:!(2&t),writable:!(4&t),value:e}}},function(t,e,n){t.exports=n(20)},function(t,e){var n={}.hasOwnProperty;t.exports=function(t,e){return n.call(t,e)}},function(t,e,n){var i=n(33),r=n(29),o=n(46),s={};n(20)(s,n(47)("iterator"),function(){return this}),t.exports=function(t,e,n){t.prototype=i(s,{next:r(1,n)}),o(t,e+" Iterator")}},function(t,e,n){var i=n(22),r=n(34),o=n(44),s=n(41)("IE_PROTO"),a=function(){},h="prototype",u=function(){var t,e=n(27)("iframe"),i=o.length,r="<",s=">";for(e.style.display="none",n(45).appendChild(e),e.src="javascript:",t=e.contentWindow.document,t.open(),t.write(r+"script"+s+"document.F=Object"+r+"/script"+s),t.close(),u=t.F;i--;)delete u[h][o[i]];return u()};t.exports=Object.create||function(t,e){var n;return null!==t?(a[h]=i(t),n=new a,a[h]=null,n[s]=t):n=u(),void 0===e?n:r(n,e)}},function(t,e,n){var i=n(21),r=n(22),o=n(35);t.exports=n(25)?Object.defineProperties:function(t,e){r(t);for(var n,s=o(e),a=s.length,h=0;a>h;)i.f(t,n=s[h++],e[n]);return t}},function(t,e,n){var i=n(36),r=n(44);t.exports=Object.keys||function(t){return i(t,r)}},function(t,e,n){var i=n(31),r=n(9),o=n(37)(!1),s=n(41)("IE_PROTO");t.exports=function(t,e){var n,a=r(t),h=0,u=[];for(n in a)n!=s&&i(a,n)&&u.push(n);for(;e.length>h;)i(a,n=e[h++])&&(~o(u,n)||u.push(n));return u}},function(t,e,n){var i=n(9),r=n(38),o=n(40);t.exports=function(t){return function(e,n,s){var a,h=i(e),u=r(h.length),l=o(s,u);if(t&&n!=n){for(;u>l;)if(a=h[l++],a!=a)return!0}else for(;u>l;l++)if((t||l in h)&&h[l]===n)return t||l||0;return!t&&-1}}},function(t,e,n){var i=n(39),r=Math.min;t.exports=function(t){return t>0?r(i(t),9007199254740991):0}},function(t,e){var n=Math.ceil,i=Math.floor;t.exports=function(t){return isNaN(t=+t)?0:(t>0?i:n)(t)}},function(t,e,n){var i=n(39),r=Math.max,o=Math.min;t.exports=function(t,e){return t=i(t),t<0?r(t+e,0):o(t,e)}},function(t,e,n){var i=n(42)("keys"),r=n(43);t.exports=function(t){return i[t]||(i[t]=r(t))}},function(t,e,n){var i=n(16),r="__core-js_shared__",o=i[r]||(i[r]={});t.exports=function(t){return o[t]||(o[t]={})}},function(t,e){var n=0,i=Math.random();t.exports=function(t){return"Symbol(".concat(void 0===t?"":t,")_",(++n+i).toString(36))}},function(t,e){t.exports="constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf".split(",")},function(t,e,n){t.exports=n(16).document&&document.documentElement},function(t,e,n){var i=n(21).f,r=n(31),o=n(47)("toStringTag");t.exports=function(t,e,n){t&&!r(t=n?t:t.prototype,o)&&i(t,o,{configurable:!0,value:e})}},function(t,e,n){var i=n(42)("wks"),r=n(43),o=n(16).Symbol,s="function"==typeof o,a=t.exports=function(t){return i[t]||(i[t]=s&&o[t]||(s?o:r)("Symbol."+t))};a.store=i},function(t,e,n){var i=n(31),r=n(49),o=n(41)("IE_PROTO"),s=Object.prototype;t.exports=Object.getPrototypeOf||function(t){return t=r(t),i(t,o)?t[o]:"function"==typeof t.constructor&&t instanceof t.constructor?t.constructor.prototype:t instanceof Object?s:null}},function(t,e,n){var i=n(12);t.exports=function(t){return Object(i(t))}},function(t,e,n){var i=n(51)(!0);n(13)(String,"String",function(t){this._t=String(t),this._i=0},function(){var t,e=this._t,n=this._i;return n>=e.length?{value:void 0,done:!0}:(t=i(e,n),this._i+=t.length,{value:t,done:!1})})},function(t,e,n){var i=n(39),r=n(12);t.exports=function(t){return function(e,n){var o,s,a=String(r(e)),h=i(n),u=a.length;return h<0||h>=u?t?"":void 0:(o=a.charCodeAt(h),o<55296||o>56319||h+1===u||(s=a.charCodeAt(h+1))<56320||s>57343?t?a.charAt(h):o:t?a.slice(h,h+2):(o-55296<<10)+(s-56320)+65536)}}},function(t,e,n){var i=n(22),r=n(53);t.exports=n(17).getIterator=function(t){var e=r(t);if("function"!=typeof e)throw TypeError(t+" is not iterable!");return i(e.call(t))}},function(t,e,n){var i=n(54),r=n(47)("iterator"),o=n(8);t.exports=n(17).getIteratorMethod=function(t){if(void 0!=t)return t[r]||t["@@iterator"]||o[i(t)]}},function(t,e,n){var i=n(11),r=n(47)("toStringTag"),o="Arguments"==i(function(){return arguments}()),s=function(t,e){try{return t[e]}catch(t){}};t.exports=function(t){var e,n,a;return void 0===t?"Undefined":null===t?"Null":"string"==typeof(n=s(e=Object(t),r))?n:o?i(e):"Object"==(a=i(e))&&"function"==typeof e.callee?"Arguments":a}},function(t,e,n){t.exports={default:n(56),__esModule:!0}},function(t,e,n){n(57);var i=n(17).Object;t.exports=function(t,e){return i.create(t,e)}},function(t,e,n){var i=n(15);i(i.S,"Object",{create:n(33)})},function(t,e,n){t.exports={default:n(59),__esModule:!0}},function(t,e,n){n(60),t.exports=n(17).Object.keys},function(t,e,n){var i=n(49),r=n(35);n(61)("keys",function(){return function(t){return r(i(t))}})},function(t,e,n){var i=n(15),r=n(17),o=n(26);t.exports=function(t,e){var n=(r.Object||{})[t]||Object[t],s={};s[t]=e(n),i(i.S+i.F*o(function(){n(1)}),"Object",s)}},function(t,e,n){function i(t){return t&&t.__esModule?t:{default:t}}e.__esModule=!0;var r=n(63),o=i(r),s=n(66),a=i(s),h="function"==typeof a.default&&"symbol"==typeof o.default?function(t){return typeof t}:function(t){return t&&"function"==typeof a.default&&t.constructor===a.default&&t!==a.default.prototype?"symbol":typeof t};e.default="function"==typeof a.default&&"symbol"===h(o.default)?function(t){return"undefined"==typeof t?"undefined":h(t)}:function(t){return t&&"function"==typeof a.default&&t.constructor===a.default&&t!==a.default.prototype?"symbol":"undefined"==typeof t?"undefined":h(t)}},function(t,e,n){t.exports={default:n(64),__esModule:!0}},function(t,e,n){n(50),n(4),t.exports=n(65).f("iterator")},function(t,e,n){e.f=n(47)},function(t,e,n){t.exports={default:n(67),__esModule:!0}},function(t,e,n){n(68),n(79),n(80),n(81),t.exports=n(17).Symbol},function(t,e,n){var i=n(16),r=n(31),o=n(25),s=n(15),a=n(30),h=n(69).KEY,u=n(26),l=n(42),c=n(46),f=n(43),d=n(47),p=n(65),m=n(70),v=n(71),y=n(72),g=n(75),_=n(22),w=n(9),x=n(28),b=n(29),S=n(33),T=n(76),D=n(78),M=n(21),k=n(35),O=D.f,E=M.f,C=T.f,P=i.Symbol,L=i.JSON,Y=L&&L.stringify,R="prototype",A=d("_hidden"),I=d("toPrimitive"),N={}.propertyIsEnumerable,W=l("symbol-registry"),z=l("symbols"),F=l("op-symbols"),j=Object[R],G="function"==typeof P,B=i.QObject,V=!B||!B[R]||!B[R].findChild,U=o&&u(function(){return 7!=S(E({},"a",{get:function(){return E(this,"a",{value:7}).a}})).a})?function(t,e,n){var i=O(j,e);i&&delete j[e],E(t,e,n),i&&t!==j&&E(j,e,i)}:E,H=function(t){var e=z[t]=S(P[R]);return e._k=t,e},X=G&&"symbol"==typeof P.iterator?function(t){return"symbol"==typeof t}:function(t){return t instanceof P},Z=function(t,e,n){return t===j&&Z(F,e,n),_(t),e=x(e,!0),_(n),r(z,e)?(n.enumerable?(r(t,A)&&t[A][e]&&(t[A][e]=!1),n=S(n,{enumerable:b(0,!1)})):(r(t,A)||E(t,A,b(1,{})),t[A][e]=!0),U(t,e,n)):E(t,e,n)},q=function(t,e){_(t);for(var n,i=y(e=w(e)),r=0,o=i.length;o>r;)Z(t,n=i[r++],e[n]);return t},$=function(t,e){return void 0===e?S(t):q(S(t),e)},J=function(t){var e=N.call(this,t=x(t,!0));return!(this===j&&r(z,t)&&!r(F,t))&&(!(e||!r(this,t)||!r(z,t)||r(this,A)&&this[A][t])||e)},Q=function(t,e){if(t=w(t),e=x(e,!0),t!==j||!r(z,e)||r(F,e)){var n=O(t,e);return!n||!r(z,e)||r(t,A)&&t[A][e]||(n.enumerable=!0),n}},K=function(t){for(var e,n=C(w(t)),i=[],o=0;n.length>o;)r(z,e=n[o++])||e==A||e==h||i.push(e);return i},tt=function(t){for(var e,n=t===j,i=C(n?F:w(t)),o=[],s=0;i.length>s;)!r(z,e=i[s++])||n&&!r(j,e)||o.push(z[e]);return o};G||(P=function(){if(this instanceof P)throw TypeError("Symbol is not a constructor!");var t=f(arguments.length>0?arguments[0]:void 0),e=function(n){this===j&&e.call(F,n),r(this,A)&&r(this[A],t)&&(this[A][t]=!1),U(this,t,b(1,n))};return o&&V&&U(j,t,{configurable:!0,set:e}),H(t)},a(P[R],"toString",function(){return this._k}),D.f=Q,M.f=Z,n(77).f=T.f=K,n(74).f=J,n(73).f=tt,o&&!n(14)&&a(j,"propertyIsEnumerable",J,!0),p.f=function(t){return H(d(t))}),s(s.G+s.W+s.F*!G,{Symbol:P});for(var et="hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables".split(","),nt=0;et.length>nt;)d(et[nt++]);for(var et=k(d.store),nt=0;et.length>nt;)m(et[nt++]);s(s.S+s.F*!G,"Symbol",{for:function(t){return r(W,t+="")?W[t]:W[t]=P(t)},keyFor:function(t){if(X(t))return v(W,t);throw TypeError(t+" is not a symbol!")},useSetter:function(){V=!0},useSimple:function(){V=!1}}),s(s.S+s.F*!G,"Object",{create:$,defineProperty:Z,defineProperties:q,getOwnPropertyDescriptor:Q,getOwnPropertyNames:K,getOwnPropertySymbols:tt}),L&&s(s.S+s.F*(!G||u(function(){var t=P();return"[null]"!=Y([t])||"{}"!=Y({a:t})||"{}"!=Y(Object(t))})),"JSON",{stringify:function(t){if(void 0!==t&&!X(t)){for(var e,n,i=[t],r=1;arguments.length>r;)i.push(arguments[r++]);return e=i[1],"function"==typeof e&&(n=e),!n&&g(e)||(e=function(t,e){if(n&&(e=n.call(this,t,e)),!X(e))return e}),i[1]=e,Y.apply(L,i)}}}),P[R][I]||n(20)(P[R],I,P[R].valueOf),c(P,"Symbol"),c(Math,"Math",!0),c(i.JSON,"JSON",!0)},function(t,e,n){var i=n(43)("meta"),r=n(23),o=n(31),s=n(21).f,a=0,h=Object.isExtensible||function(){return!0},u=!n(26)(function(){return h(Object.preventExtensions({}))}),l=function(t){s(t,i,{value:{i:"O"+ ++a,w:{}}})},c=function(t,e){if(!r(t))return"symbol"==typeof t?t:("string"==typeof t?"S":"P")+t;if(!o(t,i)){if(!h(t))return"F";if(!e)return"E";l(t)}return t[i].i},f=function(t,e){if(!o(t,i)){if(!h(t))return!0;if(!e)return!1;l(t)}return t[i].w},d=function(t){return u&&p.NEED&&h(t)&&!o(t,i)&&l(t),t},p=t.exports={KEY:i,NEED:!1,fastKey:c,getWeak:f,onFreeze:d}},function(t,e,n){var i=n(16),r=n(17),o=n(14),s=n(65),a=n(21).f;t.exports=function(t){var e=r.Symbol||(r.Symbol=o?{}:i.Symbol||{});"_"==t.charAt(0)||t in e||a(e,t,{value:s.f(t)})}},function(t,e,n){var i=n(35),r=n(9);t.exports=function(t,e){for(var n,o=r(t),s=i(o),a=s.length,h=0;a>h;)if(o[n=s[h++]]===e)return n}},function(t,e,n){var i=n(35),r=n(73),o=n(74);t.exports=function(t){var e=i(t),n=r.f;if(n)for(var s,a=n(t),h=o.f,u=0;a.length>u;)h.call(t,s=a[u++])&&e.push(s);return e}},function(t,e){e.f=Object.getOwnPropertySymbols},function(t,e){e.f={}.propertyIsEnumerable},function(t,e,n){var i=n(11);t.exports=Array.isArray||function(t){return"Array"==i(t)}},function(t,e,n){var i=n(9),r=n(77).f,o={}.toString,s="object"==typeof window&&window&&Object.getOwnPropertyNames?Object.getOwnPropertyNames(window):[],a=function(t){try{return r(t)}catch(t){return s.slice()}};t.exports.f=function(t){return s&&"[object Window]"==o.call(t)?a(t):r(i(t))}},function(t,e,n){var i=n(36),r=n(44).concat("length","prototype");e.f=Object.getOwnPropertyNames||function(t){return i(t,r)}},function(t,e,n){var i=n(74),r=n(29),o=n(9),s=n(28),a=n(31),h=n(24),u=Object.getOwnPropertyDescriptor;e.f=n(25)?u:function(t,e){if(t=o(t),e=s(e,!0),h)try{return u(t,e)}catch(t){}if(a(t,e))return r(!i.f.call(t,e),t[e])}},function(t,e){},function(t,e,n){n(70)("asyncIterator")},function(t,e,n){n(70)("observable")},function(t,e,n){t.exports={default:n(83),__esModule:!0}},function(t,e,n){var i=n(17),r=i.JSON||(i.JSON={stringify:JSON.stringify});t.exports=function(t){return r.stringify.apply(r,arguments)}},function(t,e,n){t.exports="undefined"!=typeof window&&window.moment||n(85)},function(t,e,n){(function(t){!function(e,n){t.exports=n()}(this,function(){function e(){return vi.apply(null,arguments)}function n(t){vi=t}function i(t){return t instanceof Array||"[object Array]"===Object.prototype.toString.call(t)}function r(t){return null!=t&&"[object Object]"===Object.prototype.toString.call(t)}function o(t){var e;for(e in t)return!1;return!0}function s(t){return"number"==typeof t||"[object Number]"===Object.prototype.toString.call(t)}function a(t){return t instanceof Date||"[object Date]"===Object.prototype.toString.call(t)}function h(t,e){var n,i=[];for(n=0;n<t.length;++n)i.push(e(t[n],n));return i}function u(t,e){return Object.prototype.hasOwnProperty.call(t,e)}function l(t,e){for(var n in e)u(e,n)&&(t[n]=e[n]);return u(e,"toString")&&(t.toString=e.toString),u(e,"valueOf")&&(t.valueOf=e.valueOf),t}function c(t,e,n,i){return ge(t,e,n,i,!0).utc()}function f(){return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],meridiem:null}}function d(t){return null==t._pf&&(t._pf=f()),t._pf}function p(t){if(null==t._isValid){var e=d(t),n=gi.call(e.parsedDateParts,function(t){return null!=t}),i=!isNaN(t._d.getTime())&&e.overflow<0&&!e.empty&&!e.invalidMonth&&!e.invalidWeekday&&!e.nullInput&&!e.invalidFormat&&!e.userInvalidated&&(!e.meridiem||e.meridiem&&n);
if(t._strict&&(i=i&&0===e.charsLeftOver&&0===e.unusedTokens.length&&void 0===e.bigHour),null!=Object.isFrozen&&Object.isFrozen(t))return i;t._isValid=i}return t._isValid}function m(t){var e=c(NaN);return null!=t?l(d(e),t):d(e).userInvalidated=!0,e}function v(t){return void 0===t}function y(t,e){var n,i,r;if(v(e._isAMomentObject)||(t._isAMomentObject=e._isAMomentObject),v(e._i)||(t._i=e._i),v(e._f)||(t._f=e._f),v(e._l)||(t._l=e._l),v(e._strict)||(t._strict=e._strict),v(e._tzm)||(t._tzm=e._tzm),v(e._isUTC)||(t._isUTC=e._isUTC),v(e._offset)||(t._offset=e._offset),v(e._pf)||(t._pf=d(e)),v(e._locale)||(t._locale=e._locale),_i.length>0)for(n in _i)i=_i[n],r=e[i],v(r)||(t[i]=r);return t}function g(t){y(this,t),this._d=new Date(null!=t._d?t._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),wi===!1&&(wi=!0,e.updateOffset(this),wi=!1)}function _(t){return t instanceof g||null!=t&&null!=t._isAMomentObject}function w(t){return t<0?Math.ceil(t)||0:Math.floor(t)}function x(t){var e=+t,n=0;return 0!==e&&isFinite(e)&&(n=w(e)),n}function b(t,e,n){var i,r=Math.min(t.length,e.length),o=Math.abs(t.length-e.length),s=0;for(i=0;i<r;i++)(n&&t[i]!==e[i]||!n&&x(t[i])!==x(e[i]))&&s++;return s+o}function S(t){e.suppressDeprecationWarnings===!1&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+t)}function T(t,n){var i=!0;return l(function(){if(null!=e.deprecationHandler&&e.deprecationHandler(null,t),i){for(var r,o=[],s=0;s<arguments.length;s++){if(r="","object"==typeof arguments[s]){r+="\n["+s+"] ";for(var a in arguments[0])r+=a+": "+arguments[0][a]+", ";r=r.slice(0,-2)}else r=arguments[s];o.push(r)}S(t+"\nArguments: "+Array.prototype.slice.call(o).join("")+"\n"+(new Error).stack),i=!1}return n.apply(this,arguments)},n)}function D(t,n){null!=e.deprecationHandler&&e.deprecationHandler(t,n),xi[t]||(S(n),xi[t]=!0)}function M(t){return t instanceof Function||"[object Function]"===Object.prototype.toString.call(t)}function k(t){var e,n;for(n in t)e=t[n],M(e)?this[n]=e:this["_"+n]=e;this._config=t,this._ordinalParseLenient=new RegExp(this._ordinalParse.source+"|"+/\d{1,2}/.source)}function O(t,e){var n,i=l({},t);for(n in e)u(e,n)&&(r(t[n])&&r(e[n])?(i[n]={},l(i[n],t[n]),l(i[n],e[n])):null!=e[n]?i[n]=e[n]:delete i[n]);for(n in t)u(t,n)&&!u(e,n)&&r(t[n])&&(i[n]=l({},i[n]));return i}function E(t){null!=t&&this.set(t)}function C(t,e,n){var i=this._calendar[t]||this._calendar.sameElse;return M(i)?i.call(e,n):i}function P(t){var e=this._longDateFormat[t],n=this._longDateFormat[t.toUpperCase()];return e||!n?e:(this._longDateFormat[t]=n.replace(/MMMM|MM|DD|dddd/g,function(t){return t.slice(1)}),this._longDateFormat[t])}function L(){return this._invalidDate}function Y(t){return this._ordinal.replace("%d",t)}function R(t,e,n,i){var r=this._relativeTime[n];return M(r)?r(t,e,n,i):r.replace(/%d/i,t)}function A(t,e){var n=this._relativeTime[t>0?"future":"past"];return M(n)?n(e):n.replace(/%s/i,e)}function I(t,e){var n=t.toLowerCase();Pi[n]=Pi[n+"s"]=Pi[e]=t}function N(t){return"string"==typeof t?Pi[t]||Pi[t.toLowerCase()]:void 0}function W(t){var e,n,i={};for(n in t)u(t,n)&&(e=N(n),e&&(i[e]=t[n]));return i}function z(t,e){Li[t]=e}function F(t){var e=[];for(var n in t)e.push({unit:n,priority:Li[n]});return e.sort(function(t,e){return t.priority-e.priority}),e}function j(t,n){return function(i){return null!=i?(B(this,t,i),e.updateOffset(this,n),this):G(this,t)}}function G(t,e){return t.isValid()?t._d["get"+(t._isUTC?"UTC":"")+e]():NaN}function B(t,e,n){t.isValid()&&t._d["set"+(t._isUTC?"UTC":"")+e](n)}function V(t){return t=N(t),M(this[t])?this[t]():this}function U(t,e){if("object"==typeof t){t=W(t);for(var n=F(t),i=0;i<n.length;i++)this[n[i].unit](t[n[i].unit])}else if(t=N(t),M(this[t]))return this[t](e);return this}function H(t,e,n){var i=""+Math.abs(t),r=e-i.length,o=t>=0;return(o?n?"+":"":"-")+Math.pow(10,Math.max(0,r)).toString().substr(1)+i}function X(t,e,n,i){var r=i;"string"==typeof i&&(r=function(){return this[i]()}),t&&(Ii[t]=r),e&&(Ii[e[0]]=function(){return H(r.apply(this,arguments),e[1],e[2])}),n&&(Ii[n]=function(){return this.localeData().ordinal(r.apply(this,arguments),t)})}function Z(t){return t.match(/\[[\s\S]/)?t.replace(/^\[|\]$/g,""):t.replace(/\\/g,"")}function q(t){var e,n,i=t.match(Yi);for(e=0,n=i.length;e<n;e++)Ii[i[e]]?i[e]=Ii[i[e]]:i[e]=Z(i[e]);return function(e){var r,o="";for(r=0;r<n;r++)o+=i[r]instanceof Function?i[r].call(e,t):i[r];return o}}function $(t,e){return t.isValid()?(e=J(e,t.localeData()),Ai[e]=Ai[e]||q(e),Ai[e](t)):t.localeData().invalidDate()}function J(t,e){function n(t){return e.longDateFormat(t)||t}var i=5;for(Ri.lastIndex=0;i>=0&&Ri.test(t);)t=t.replace(Ri,n),Ri.lastIndex=0,i-=1;return t}function Q(t,e,n){tr[t]=M(e)?e:function(t,i){return t&&n?n:e}}function K(t,e){return u(tr,t)?tr[t](e._strict,e._locale):new RegExp(tt(t))}function tt(t){return et(t.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(t,e,n,i,r){return e||n||i||r}))}function et(t){return t.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function nt(t,e){var n,i=e;for("string"==typeof t&&(t=[t]),s(e)&&(i=function(t,n){n[e]=x(t)}),n=0;n<t.length;n++)er[t[n]]=i}function it(t,e){nt(t,function(t,n,i,r){i._w=i._w||{},e(t,i._w,i,r)})}function rt(t,e,n){null!=e&&u(er,t)&&er[t](e,n._a,n,t)}function ot(t,e){return new Date(Date.UTC(t,e+1,0)).getUTCDate()}function st(t,e){return t?i(this._months)?this._months[t.month()]:this._months[(this._months.isFormat||fr).test(e)?"format":"standalone"][t.month()]:this._months}function at(t,e){return t?i(this._monthsShort)?this._monthsShort[t.month()]:this._monthsShort[fr.test(e)?"format":"standalone"][t.month()]:this._monthsShort}function ht(t,e,n){var i,r,o,s=t.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],i=0;i<12;++i)o=c([2e3,i]),this._shortMonthsParse[i]=this.monthsShort(o,"").toLocaleLowerCase(),this._longMonthsParse[i]=this.months(o,"").toLocaleLowerCase();return n?"MMM"===e?(r=cr.call(this._shortMonthsParse,s),r!==-1?r:null):(r=cr.call(this._longMonthsParse,s),r!==-1?r:null):"MMM"===e?(r=cr.call(this._shortMonthsParse,s),r!==-1?r:(r=cr.call(this._longMonthsParse,s),r!==-1?r:null)):(r=cr.call(this._longMonthsParse,s),r!==-1?r:(r=cr.call(this._shortMonthsParse,s),r!==-1?r:null))}function ut(t,e,n){var i,r,o;if(this._monthsParseExact)return ht.call(this,t,e,n);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),i=0;i<12;i++){if(r=c([2e3,i]),n&&!this._longMonthsParse[i]&&(this._longMonthsParse[i]=new RegExp("^"+this.months(r,"").replace(".","")+"$","i"),this._shortMonthsParse[i]=new RegExp("^"+this.monthsShort(r,"").replace(".","")+"$","i")),n||this._monthsParse[i]||(o="^"+this.months(r,"")+"|^"+this.monthsShort(r,""),this._monthsParse[i]=new RegExp(o.replace(".",""),"i")),n&&"MMMM"===e&&this._longMonthsParse[i].test(t))return i;if(n&&"MMM"===e&&this._shortMonthsParse[i].test(t))return i;if(!n&&this._monthsParse[i].test(t))return i}}function lt(t,e){var n;if(!t.isValid())return t;if("string"==typeof e)if(/^\d+$/.test(e))e=x(e);else if(e=t.localeData().monthsParse(e),!s(e))return t;return n=Math.min(t.date(),ot(t.year(),e)),t._d["set"+(t._isUTC?"UTC":"")+"Month"](e,n),t}function ct(t){return null!=t?(lt(this,t),e.updateOffset(this,!0),this):G(this,"Month")}function ft(){return ot(this.year(),this.month())}function dt(t){return this._monthsParseExact?(u(this,"_monthsRegex")||mt.call(this),t?this._monthsShortStrictRegex:this._monthsShortRegex):(u(this,"_monthsShortRegex")||(this._monthsShortRegex=mr),this._monthsShortStrictRegex&&t?this._monthsShortStrictRegex:this._monthsShortRegex)}function pt(t){return this._monthsParseExact?(u(this,"_monthsRegex")||mt.call(this),t?this._monthsStrictRegex:this._monthsRegex):(u(this,"_monthsRegex")||(this._monthsRegex=vr),this._monthsStrictRegex&&t?this._monthsStrictRegex:this._monthsRegex)}function mt(){function t(t,e){return e.length-t.length}var e,n,i=[],r=[],o=[];for(e=0;e<12;e++)n=c([2e3,e]),i.push(this.monthsShort(n,"")),r.push(this.months(n,"")),o.push(this.months(n,"")),o.push(this.monthsShort(n,""));for(i.sort(t),r.sort(t),o.sort(t),e=0;e<12;e++)i[e]=et(i[e]),r[e]=et(r[e]);for(e=0;e<24;e++)o[e]=et(o[e]);this._monthsRegex=new RegExp("^("+o.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+r.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+i.join("|")+")","i")}function vt(t){return yt(t)?366:365}function yt(t){return t%4===0&&t%100!==0||t%400===0}function gt(){return yt(this.year())}function _t(t,e,n,i,r,o,s){var a=new Date(t,e,n,i,r,o,s);return t<100&&t>=0&&isFinite(a.getFullYear())&&a.setFullYear(t),a}function wt(t){var e=new Date(Date.UTC.apply(null,arguments));return t<100&&t>=0&&isFinite(e.getUTCFullYear())&&e.setUTCFullYear(t),e}function xt(t,e,n){var i=7+e-n,r=(7+wt(t,0,i).getUTCDay()-e)%7;return-r+i-1}function bt(t,e,n,i,r){var o,s,a=(7+n-i)%7,h=xt(t,i,r),u=1+7*(e-1)+a+h;return u<=0?(o=t-1,s=vt(o)+u):u>vt(t)?(o=t+1,s=u-vt(t)):(o=t,s=u),{year:o,dayOfYear:s}}function St(t,e,n){var i,r,o=xt(t.year(),e,n),s=Math.floor((t.dayOfYear()-o-1)/7)+1;return s<1?(r=t.year()-1,i=s+Tt(r,e,n)):s>Tt(t.year(),e,n)?(i=s-Tt(t.year(),e,n),r=t.year()+1):(r=t.year(),i=s),{week:i,year:r}}function Tt(t,e,n){var i=xt(t,e,n),r=xt(t+1,e,n);return(vt(t)-i+r)/7}function Dt(t){return St(t,this._week.dow,this._week.doy).week}function Mt(){return this._week.dow}function kt(){return this._week.doy}function Ot(t){var e=this.localeData().week(this);return null==t?e:this.add(7*(t-e),"d")}function Et(t){var e=St(this,1,4).week;return null==t?e:this.add(7*(t-e),"d")}function Ct(t,e){return"string"!=typeof t?t:isNaN(t)?(t=e.weekdaysParse(t),"number"==typeof t?t:null):parseInt(t,10)}function Pt(t,e){return"string"==typeof t?e.weekdaysParse(t)%7||7:isNaN(t)?null:t}function Lt(t,e){return t?i(this._weekdays)?this._weekdays[t.day()]:this._weekdays[this._weekdays.isFormat.test(e)?"format":"standalone"][t.day()]:this._weekdays}function Yt(t){return t?this._weekdaysShort[t.day()]:this._weekdaysShort}function Rt(t){return t?this._weekdaysMin[t.day()]:this._weekdaysMin}function At(t,e,n){var i,r,o,s=t.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],i=0;i<7;++i)o=c([2e3,1]).day(i),this._minWeekdaysParse[i]=this.weekdaysMin(o,"").toLocaleLowerCase(),this._shortWeekdaysParse[i]=this.weekdaysShort(o,"").toLocaleLowerCase(),this._weekdaysParse[i]=this.weekdays(o,"").toLocaleLowerCase();return n?"dddd"===e?(r=cr.call(this._weekdaysParse,s),r!==-1?r:null):"ddd"===e?(r=cr.call(this._shortWeekdaysParse,s),r!==-1?r:null):(r=cr.call(this._minWeekdaysParse,s),r!==-1?r:null):"dddd"===e?(r=cr.call(this._weekdaysParse,s),r!==-1?r:(r=cr.call(this._shortWeekdaysParse,s),r!==-1?r:(r=cr.call(this._minWeekdaysParse,s),r!==-1?r:null))):"ddd"===e?(r=cr.call(this._shortWeekdaysParse,s),r!==-1?r:(r=cr.call(this._weekdaysParse,s),r!==-1?r:(r=cr.call(this._minWeekdaysParse,s),r!==-1?r:null))):(r=cr.call(this._minWeekdaysParse,s),r!==-1?r:(r=cr.call(this._weekdaysParse,s),r!==-1?r:(r=cr.call(this._shortWeekdaysParse,s),r!==-1?r:null)))}function It(t,e,n){var i,r,o;if(this._weekdaysParseExact)return At.call(this,t,e,n);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),i=0;i<7;i++){if(r=c([2e3,1]).day(i),n&&!this._fullWeekdaysParse[i]&&(this._fullWeekdaysParse[i]=new RegExp("^"+this.weekdays(r,"").replace(".",".?")+"$","i"),this._shortWeekdaysParse[i]=new RegExp("^"+this.weekdaysShort(r,"").replace(".",".?")+"$","i"),this._minWeekdaysParse[i]=new RegExp("^"+this.weekdaysMin(r,"").replace(".",".?")+"$","i")),this._weekdaysParse[i]||(o="^"+this.weekdays(r,"")+"|^"+this.weekdaysShort(r,"")+"|^"+this.weekdaysMin(r,""),this._weekdaysParse[i]=new RegExp(o.replace(".",""),"i")),n&&"dddd"===e&&this._fullWeekdaysParse[i].test(t))return i;if(n&&"ddd"===e&&this._shortWeekdaysParse[i].test(t))return i;if(n&&"dd"===e&&this._minWeekdaysParse[i].test(t))return i;if(!n&&this._weekdaysParse[i].test(t))return i}}function Nt(t){if(!this.isValid())return null!=t?this:NaN;var e=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=t?(t=Ct(t,this.localeData()),this.add(t-e,"d")):e}function Wt(t){if(!this.isValid())return null!=t?this:NaN;var e=(this.day()+7-this.localeData()._week.dow)%7;return null==t?e:this.add(t-e,"d")}function zt(t){if(!this.isValid())return null!=t?this:NaN;if(null!=t){var e=Pt(t,this.localeData());return this.day(this.day()%7?e:e-7)}return this.day()||7}function Ft(t){return this._weekdaysParseExact?(u(this,"_weekdaysRegex")||Bt.call(this),t?this._weekdaysStrictRegex:this._weekdaysRegex):(u(this,"_weekdaysRegex")||(this._weekdaysRegex=br),this._weekdaysStrictRegex&&t?this._weekdaysStrictRegex:this._weekdaysRegex)}function jt(t){return this._weekdaysParseExact?(u(this,"_weekdaysRegex")||Bt.call(this),t?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(u(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=Sr),this._weekdaysShortStrictRegex&&t?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)}function Gt(t){return this._weekdaysParseExact?(u(this,"_weekdaysRegex")||Bt.call(this),t?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(u(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=Tr),this._weekdaysMinStrictRegex&&t?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)}function Bt(){function t(t,e){return e.length-t.length}var e,n,i,r,o,s=[],a=[],h=[],u=[];for(e=0;e<7;e++)n=c([2e3,1]).day(e),i=this.weekdaysMin(n,""),r=this.weekdaysShort(n,""),o=this.weekdays(n,""),s.push(i),a.push(r),h.push(o),u.push(i),u.push(r),u.push(o);for(s.sort(t),a.sort(t),h.sort(t),u.sort(t),e=0;e<7;e++)a[e]=et(a[e]),h[e]=et(h[e]),u[e]=et(u[e]);this._weekdaysRegex=new RegExp("^("+u.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+h.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+a.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+s.join("|")+")","i")}function Vt(){return this.hours()%12||12}function Ut(){return this.hours()||24}function Ht(t,e){X(t,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),e)})}function Xt(t,e){return e._meridiemParse}function Zt(t){return"p"===(t+"").toLowerCase().charAt(0)}function qt(t,e,n){return t>11?n?"pm":"PM":n?"am":"AM"}function $t(t){return t?t.toLowerCase().replace("_","-"):t}function Jt(t){for(var e,n,i,r,o=0;o<t.length;){for(r=$t(t[o]).split("-"),e=r.length,n=$t(t[o+1]),n=n?n.split("-"):null;e>0;){if(i=Qt(r.slice(0,e).join("-")))return i;if(n&&n.length>=e&&b(r,n,!0)>=e-1)break;e--}o++}return null}function Qt(e){var n=null;if(!Er[e]&&"undefined"!=typeof t&&t&&t.exports)try{n=Dr._abbr,!function(){var t=new Error('Cannot find module "./locale"');throw t.code="MODULE_NOT_FOUND",t}(),Kt(n)}catch(t){}return Er[e]}function Kt(t,e){var n;return t&&(n=v(e)?ne(t):te(t,e),n&&(Dr=n)),Dr._abbr}function te(t,e){if(null!==e){var n=Or;if(e.abbr=t,null!=Er[t])D("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),n=Er[t]._config;else if(null!=e.parentLocale){if(null==Er[e.parentLocale])return Cr[e.parentLocale]||(Cr[e.parentLocale]=[]),Cr[e.parentLocale].push({name:t,config:e}),null;n=Er[e.parentLocale]._config}return Er[t]=new E(O(n,e)),Cr[t]&&Cr[t].forEach(function(t){te(t.name,t.config)}),Kt(t),Er[t]}return delete Er[t],null}function ee(t,e){if(null!=e){var n,i=Or;null!=Er[t]&&(i=Er[t]._config),e=O(i,e),n=new E(e),n.parentLocale=Er[t],Er[t]=n,Kt(t)}else null!=Er[t]&&(null!=Er[t].parentLocale?Er[t]=Er[t].parentLocale:null!=Er[t]&&delete Er[t]);return Er[t]}function ne(t){var e;if(t&&t._locale&&t._locale._abbr&&(t=t._locale._abbr),!t)return Dr;if(!i(t)){if(e=Qt(t))return e;t=[t]}return Jt(t)}function ie(){return Ti(Er)}function re(t){var e,n=t._a;return n&&d(t).overflow===-2&&(e=n[ir]<0||n[ir]>11?ir:n[rr]<1||n[rr]>ot(n[nr],n[ir])?rr:n[or]<0||n[or]>24||24===n[or]&&(0!==n[sr]||0!==n[ar]||0!==n[hr])?or:n[sr]<0||n[sr]>59?sr:n[ar]<0||n[ar]>59?ar:n[hr]<0||n[hr]>999?hr:-1,d(t)._overflowDayOfYear&&(e<nr||e>rr)&&(e=rr),d(t)._overflowWeeks&&e===-1&&(e=ur),d(t)._overflowWeekday&&e===-1&&(e=lr),d(t).overflow=e),t}function oe(t){var e,n,i,r,o,s,a=t._i,h=Pr.exec(a)||Lr.exec(a);if(h){for(d(t).iso=!0,e=0,n=Rr.length;e<n;e++)if(Rr[e][1].exec(h[1])){r=Rr[e][0],i=Rr[e][2]!==!1;break}if(null==r)return void(t._isValid=!1);if(h[3]){for(e=0,n=Ar.length;e<n;e++)if(Ar[e][1].exec(h[3])){o=(h[2]||" ")+Ar[e][0];break}if(null==o)return void(t._isValid=!1)}if(!i&&null!=o)return void(t._isValid=!1);if(h[4]){if(!Yr.exec(h[4]))return void(t._isValid=!1);s="Z"}t._f=r+(o||"")+(s||""),ce(t)}else t._isValid=!1}function se(t){var n=Ir.exec(t._i);return null!==n?void(t._d=new Date(+n[1])):(oe(t),void(t._isValid===!1&&(delete t._isValid,e.createFromInputFallback(t))))}function ae(t,e,n){return null!=t?t:null!=e?e:n}function he(t){var n=new Date(e.now());return t._useUTC?[n.getUTCFullYear(),n.getUTCMonth(),n.getUTCDate()]:[n.getFullYear(),n.getMonth(),n.getDate()]}function ue(t){var e,n,i,r,o=[];if(!t._d){for(i=he(t),t._w&&null==t._a[rr]&&null==t._a[ir]&&le(t),t._dayOfYear&&(r=ae(t._a[nr],i[nr]),t._dayOfYear>vt(r)&&(d(t)._overflowDayOfYear=!0),n=wt(r,0,t._dayOfYear),t._a[ir]=n.getUTCMonth(),t._a[rr]=n.getUTCDate()),e=0;e<3&&null==t._a[e];++e)t._a[e]=o[e]=i[e];for(;e<7;e++)t._a[e]=o[e]=null==t._a[e]?2===e?1:0:t._a[e];24===t._a[or]&&0===t._a[sr]&&0===t._a[ar]&&0===t._a[hr]&&(t._nextDay=!0,t._a[or]=0),t._d=(t._useUTC?wt:_t).apply(null,o),null!=t._tzm&&t._d.setUTCMinutes(t._d.getUTCMinutes()-t._tzm),t._nextDay&&(t._a[or]=24)}}function le(t){var e,n,i,r,o,s,a,h;if(e=t._w,null!=e.GG||null!=e.W||null!=e.E)o=1,s=4,n=ae(e.GG,t._a[nr],St(_e(),1,4).year),i=ae(e.W,1),r=ae(e.E,1),(r<1||r>7)&&(h=!0);else{o=t._locale._week.dow,s=t._locale._week.doy;var u=St(_e(),o,s);n=ae(e.gg,t._a[nr],u.year),i=ae(e.w,u.week),null!=e.d?(r=e.d,(r<0||r>6)&&(h=!0)):null!=e.e?(r=e.e+o,(e.e<0||e.e>6)&&(h=!0)):r=o}i<1||i>Tt(n,o,s)?d(t)._overflowWeeks=!0:null!=h?d(t)._overflowWeekday=!0:(a=bt(n,i,r,o,s),t._a[nr]=a.year,t._dayOfYear=a.dayOfYear)}function ce(t){if(t._f===e.ISO_8601)return void oe(t);t._a=[],d(t).empty=!0;var n,i,r,o,s,a=""+t._i,h=a.length,u=0;for(r=J(t._f,t._locale).match(Yi)||[],n=0;n<r.length;n++)o=r[n],i=(a.match(K(o,t))||[])[0],i&&(s=a.substr(0,a.indexOf(i)),s.length>0&&d(t).unusedInput.push(s),a=a.slice(a.indexOf(i)+i.length),u+=i.length),Ii[o]?(i?d(t).empty=!1:d(t).unusedTokens.push(o),rt(o,i,t)):t._strict&&!i&&d(t).unusedTokens.push(o);d(t).charsLeftOver=h-u,a.length>0&&d(t).unusedInput.push(a),t._a[or]<=12&&d(t).bigHour===!0&&t._a[or]>0&&(d(t).bigHour=void 0),d(t).parsedDateParts=t._a.slice(0),d(t).meridiem=t._meridiem,t._a[or]=fe(t._locale,t._a[or],t._meridiem),ue(t),re(t)}function fe(t,e,n){var i;return null==n?e:null!=t.meridiemHour?t.meridiemHour(e,n):null!=t.isPM?(i=t.isPM(n),i&&e<12&&(e+=12),i||12!==e||(e=0),e):e}function de(t){var e,n,i,r,o;if(0===t._f.length)return d(t).invalidFormat=!0,void(t._d=new Date(NaN));for(r=0;r<t._f.length;r++)o=0,e=y({},t),null!=t._useUTC&&(e._useUTC=t._useUTC),e._f=t._f[r],ce(e),p(e)&&(o+=d(e).charsLeftOver,o+=10*d(e).unusedTokens.length,d(e).score=o,(null==i||o<i)&&(i=o,n=e));l(t,n||e)}function pe(t){if(!t._d){var e=W(t._i);t._a=h([e.year,e.month,e.day||e.date,e.hour,e.minute,e.second,e.millisecond],function(t){return t&&parseInt(t,10)}),ue(t)}}function me(t){var e=new g(re(ve(t)));return e._nextDay&&(e.add(1,"d"),e._nextDay=void 0),e}function ve(t){var e=t._i,n=t._f;return t._locale=t._locale||ne(t._l),null===e||void 0===n&&""===e?m({nullInput:!0}):("string"==typeof e&&(t._i=e=t._locale.preparse(e)),_(e)?new g(re(e)):(a(e)?t._d=e:i(n)?de(t):n?ce(t):ye(t),p(t)||(t._d=null),t))}function ye(t){var n=t._i;void 0===n?t._d=new Date(e.now()):a(n)?t._d=new Date(n.valueOf()):"string"==typeof n?se(t):i(n)?(t._a=h(n.slice(0),function(t){return parseInt(t,10)}),ue(t)):"object"==typeof n?pe(t):s(n)?t._d=new Date(n):e.createFromInputFallback(t)}function ge(t,e,n,s,a){var h={};return n!==!0&&n!==!1||(s=n,n=void 0),(r(t)&&o(t)||i(t)&&0===t.length)&&(t=void 0),h._isAMomentObject=!0,h._useUTC=h._isUTC=a,h._l=n,h._i=t,h._f=e,h._strict=s,me(h)}function _e(t,e,n,i){return ge(t,e,n,i,!1)}function we(t,e){var n,r;if(1===e.length&&i(e[0])&&(e=e[0]),!e.length)return _e();for(n=e[0],r=1;r<e.length;++r)e[r].isValid()&&!e[r][t](n)||(n=e[r]);return n}function xe(){var t=[].slice.call(arguments,0);return we("isBefore",t)}function be(){var t=[].slice.call(arguments,0);return we("isAfter",t)}function Se(t){var e=W(t),n=e.year||0,i=e.quarter||0,r=e.month||0,o=e.week||0,s=e.day||0,a=e.hour||0,h=e.minute||0,u=e.second||0,l=e.millisecond||0;this._milliseconds=+l+1e3*u+6e4*h+1e3*a*60*60,this._days=+s+7*o,this._months=+r+3*i+12*n,this._data={},this._locale=ne(),this._bubble()}function Te(t){return t instanceof Se}function De(t){return t<0?Math.round(-1*t)*-1:Math.round(t)}function Me(t,e){X(t,0,0,function(){var t=this.utcOffset(),n="+";return t<0&&(t=-t,n="-"),n+H(~~(t/60),2)+e+H(~~t%60,2)})}function ke(t,e){var n=(e||"").match(t);if(null===n)return null;var i=n[n.length-1]||[],r=(i+"").match(Fr)||["-",0,0],o=+(60*r[1])+x(r[2]);return 0===o?0:"+"===r[0]?o:-o}function Oe(t,n){var i,r;return n._isUTC?(i=n.clone(),r=(_(t)||a(t)?t.valueOf():_e(t).valueOf())-i.valueOf(),i._d.setTime(i._d.valueOf()+r),e.updateOffset(i,!1),i):_e(t).local()}function Ee(t){return 15*-Math.round(t._d.getTimezoneOffset()/15)}function Ce(t,n){var i,r=this._offset||0;if(!this.isValid())return null!=t?this:NaN;if(null!=t){if("string"==typeof t){if(t=ke(Ji,t),null===t)return this}else Math.abs(t)<16&&(t*=60);return!this._isUTC&&n&&(i=Ee(this)),this._offset=t,this._isUTC=!0,null!=i&&this.add(i,"m"),r!==t&&(!n||this._changeInProgress?He(this,je(t-r,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,e.updateOffset(this,!0),this._changeInProgress=null)),this}return this._isUTC?r:Ee(this)}function Pe(t,e){return null!=t?("string"!=typeof t&&(t=-t),this.utcOffset(t,e),this):-this.utcOffset()}function Le(t){return this.utcOffset(0,t)}function Ye(t){return this._isUTC&&(this.utcOffset(0,t),this._isUTC=!1,t&&this.subtract(Ee(this),"m")),this}function Re(){if(null!=this._tzm)this.utcOffset(this._tzm);else if("string"==typeof this._i){var t=ke($i,this._i);null!=t?this.utcOffset(t):this.utcOffset(0,!0)}return this}function Ae(t){return!!this.isValid()&&(t=t?_e(t).utcOffset():0,(this.utcOffset()-t)%60===0)}function Ie(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function Ne(){if(!v(this._isDSTShifted))return this._isDSTShifted;var t={};if(y(t,this),t=ve(t),t._a){var e=t._isUTC?c(t._a):_e(t._a);this._isDSTShifted=this.isValid()&&b(t._a,e.toArray())>0}else this._isDSTShifted=!1;return this._isDSTShifted}function We(){return!!this.isValid()&&!this._isUTC}function ze(){return!!this.isValid()&&this._isUTC}function Fe(){return!!this.isValid()&&(this._isUTC&&0===this._offset)}function je(t,e){var n,i,r,o=t,a=null;return Te(t)?o={ms:t._milliseconds,d:t._days,M:t._months}:s(t)?(o={},e?o[e]=t:o.milliseconds=t):(a=jr.exec(t))?(n="-"===a[1]?-1:1,o={y:0,d:x(a[rr])*n,h:x(a[or])*n,m:x(a[sr])*n,s:x(a[ar])*n,ms:x(De(1e3*a[hr]))*n}):(a=Gr.exec(t))?(n="-"===a[1]?-1:1,o={y:Ge(a[2],n),M:Ge(a[3],n),w:Ge(a[4],n),d:Ge(a[5],n),h:Ge(a[6],n),m:Ge(a[7],n),s:Ge(a[8],n)}):null==o?o={}:"object"==typeof o&&("from"in o||"to"in o)&&(r=Ve(_e(o.from),_e(o.to)),o={},o.ms=r.milliseconds,o.M=r.months),i=new Se(o),Te(t)&&u(t,"_locale")&&(i._locale=t._locale),i}function Ge(t,e){var n=t&&parseFloat(t.replace(",","."));return(isNaN(n)?0:n)*e}function Be(t,e){var n={milliseconds:0,months:0};return n.months=e.month()-t.month()+12*(e.year()-t.year()),t.clone().add(n.months,"M").isAfter(e)&&--n.months,n.milliseconds=+e-+t.clone().add(n.months,"M"),n}function Ve(t,e){var n;return t.isValid()&&e.isValid()?(e=Oe(e,t),t.isBefore(e)?n=Be(t,e):(n=Be(e,t),n.milliseconds=-n.milliseconds,n.months=-n.months),n):{milliseconds:0,months:0}}function Ue(t,e){return function(n,i){var r,o;return null===i||isNaN(+i)||(D(e,"moment()."+e+"(period, number) is deprecated. Please use moment()."+e+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),o=n,n=i,i=o),n="string"==typeof n?+n:n,r=je(n,i),He(this,r,t),this}}function He(t,n,i,r){var o=n._milliseconds,s=De(n._days),a=De(n._months);t.isValid()&&(r=null==r||r,o&&t._d.setTime(t._d.valueOf()+o*i),s&&B(t,"Date",G(t,"Date")+s*i),a&&lt(t,G(t,"Month")+a*i),r&&e.updateOffset(t,s||a))}function Xe(t,e){var n=t.diff(e,"days",!0);return n<-6?"sameElse":n<-1?"lastWeek":n<0?"lastDay":n<1?"sameDay":n<2?"nextDay":n<7?"nextWeek":"sameElse"}function Ze(t,n){var i=t||_e(),r=Oe(i,this).startOf("day"),o=e.calendarFormat(this,r)||"sameElse",s=n&&(M(n[o])?n[o].call(this,i):n[o]);return this.format(s||this.localeData().calendar(o,this,_e(i)))}function qe(){return new g(this)}function $e(t,e){var n=_(t)?t:_e(t);return!(!this.isValid()||!n.isValid())&&(e=N(v(e)?"millisecond":e),"millisecond"===e?this.valueOf()>n.valueOf():n.valueOf()<this.clone().startOf(e).valueOf())}function Je(t,e){var n=_(t)?t:_e(t);return!(!this.isValid()||!n.isValid())&&(e=N(v(e)?"millisecond":e),"millisecond"===e?this.valueOf()<n.valueOf():this.clone().endOf(e).valueOf()<n.valueOf())}function Qe(t,e,n,i){return i=i||"()",("("===i[0]?this.isAfter(t,n):!this.isBefore(t,n))&&(")"===i[1]?this.isBefore(e,n):!this.isAfter(e,n))}function Ke(t,e){var n,i=_(t)?t:_e(t);return!(!this.isValid()||!i.isValid())&&(e=N(e||"millisecond"),"millisecond"===e?this.valueOf()===i.valueOf():(n=i.valueOf(),this.clone().startOf(e).valueOf()<=n&&n<=this.clone().endOf(e).valueOf()))}function tn(t,e){return this.isSame(t,e)||this.isAfter(t,e)}function en(t,e){return this.isSame(t,e)||this.isBefore(t,e)}function nn(t,e,n){var i,r,o,s;return this.isValid()?(i=Oe(t,this),i.isValid()?(r=6e4*(i.utcOffset()-this.utcOffset()),e=N(e),"year"===e||"month"===e||"quarter"===e?(s=rn(this,i),"quarter"===e?s/=3:"year"===e&&(s/=12)):(o=this-i,s="second"===e?o/1e3:"minute"===e?o/6e4:"hour"===e?o/36e5:"day"===e?(o-r)/864e5:"week"===e?(o-r)/6048e5:o),n?s:w(s)):NaN):NaN}function rn(t,e){var n,i,r=12*(e.year()-t.year())+(e.month()-t.month()),o=t.clone().add(r,"months");return e-o<0?(n=t.clone().add(r-1,"months"),i=(e-o)/(o-n)):(n=t.clone().add(r+1,"months"),i=(e-o)/(n-o)),-(r+i)||0}function on(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function sn(){var t=this.clone().utc();return 0<t.year()&&t.year()<=9999?M(Date.prototype.toISOString)?this.toDate().toISOString():$(t,"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]"):$(t,"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]")}function an(){if(!this.isValid())return"moment.invalid(/* "+this._i+" */)";var t="moment",e="";this.isLocal()||(t=0===this.utcOffset()?"moment.utc":"moment.parseZone",e="Z");var n="["+t+'("]',i=0<this.year()&&this.year()<=9999?"YYYY":"YYYYYY",r="-MM-DD[T]HH:mm:ss.SSS",o=e+'[")]';return this.format(n+i+r+o)}function hn(t){t||(t=this.isUtc()?e.defaultFormatUtc:e.defaultFormat);var n=$(this,t);return this.localeData().postformat(n)}function un(t,e){return this.isValid()&&(_(t)&&t.isValid()||_e(t).isValid())?je({to:this,from:t}).locale(this.locale()).humanize(!e):this.localeData().invalidDate()}function ln(t){return this.from(_e(),t)}function cn(t,e){return this.isValid()&&(_(t)&&t.isValid()||_e(t).isValid())?je({from:this,to:t}).locale(this.locale()).humanize(!e):this.localeData().invalidDate()}function fn(t){return this.to(_e(),t)}function dn(t){var e;return void 0===t?this._locale._abbr:(e=ne(t),null!=e&&(this._locale=e),this)}function pn(){return this._locale}function mn(t){switch(t=N(t)){case"year":this.month(0);case"quarter":case"month":this.date(1);case"week":case"isoWeek":case"day":case"date":this.hours(0);case"hour":this.minutes(0);case"minute":this.seconds(0);case"second":this.milliseconds(0)}return"week"===t&&this.weekday(0),"isoWeek"===t&&this.isoWeekday(1),"quarter"===t&&this.month(3*Math.floor(this.month()/3)),this}function vn(t){return t=N(t),void 0===t||"millisecond"===t?this:("date"===t&&(t="day"),this.startOf(t).add(1,"isoWeek"===t?"week":t).subtract(1,"ms"))}function yn(){return this._d.valueOf()-6e4*(this._offset||0)}function gn(){return Math.floor(this.valueOf()/1e3)}function _n(){return new Date(this.valueOf())}function wn(){var t=this;return[t.year(),t.month(),t.date(),t.hour(),t.minute(),t.second(),t.millisecond()]}function xn(){var t=this;return{years:t.year(),months:t.month(),date:t.date(),hours:t.hours(),minutes:t.minutes(),seconds:t.seconds(),milliseconds:t.milliseconds()}}function bn(){return this.isValid()?this.toISOString():null}function Sn(){return p(this)}function Tn(){return l({},d(this))}function Dn(){return d(this).overflow}function Mn(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function kn(t,e){X(0,[t,t.length],0,e)}function On(t){return Ln.call(this,t,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)}function En(t){return Ln.call(this,t,this.isoWeek(),this.isoWeekday(),1,4)}function Cn(){return Tt(this.year(),1,4)}function Pn(){var t=this.localeData()._week;return Tt(this.year(),t.dow,t.doy)}function Ln(t,e,n,i,r){var o;return null==t?St(this,i,r).year:(o=Tt(t,i,r),e>o&&(e=o),Yn.call(this,t,e,n,i,r))}function Yn(t,e,n,i,r){var o=bt(t,e,n,i,r),s=wt(o.year,0,o.dayOfYear);return this.year(s.getUTCFullYear()),this.month(s.getUTCMonth()),this.date(s.getUTCDate()),this}function Rn(t){return null==t?Math.ceil((this.month()+1)/3):this.month(3*(t-1)+this.month()%3)}function An(t){var e=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==t?e:this.add(t-e,"d")}function In(t,e){e[hr]=x(1e3*("0."+t))}function Nn(){return this._isUTC?"UTC":""}function Wn(){return this._isUTC?"Coordinated Universal Time":""}function zn(t){return _e(1e3*t)}function Fn(){return _e.apply(null,arguments).parseZone()}function jn(t){return t}function Gn(t,e,n,i){var r=ne(),o=c().set(i,e);return r[n](o,t)}function Bn(t,e,n){if(s(t)&&(e=t,t=void 0),t=t||"",null!=e)return Gn(t,e,n,"month");var i,r=[];for(i=0;i<12;i++)r[i]=Gn(t,i,n,"month");return r}function Vn(t,e,n,i){"boolean"==typeof t?(s(e)&&(n=e,e=void 0),e=e||""):(e=t,n=e,t=!1,s(e)&&(n=e,e=void 0),e=e||"");var r=ne(),o=t?r._week.dow:0;if(null!=n)return Gn(e,(n+o)%7,i,"day");var a,h=[];for(a=0;a<7;a++)h[a]=Gn(e,(a+o)%7,i,"day");return h}function Un(t,e){return Bn(t,e,"months")}function Hn(t,e){return Bn(t,e,"monthsShort")}function Xn(t,e,n){return Vn(t,e,n,"weekdays")}function Zn(t,e,n){return Vn(t,e,n,"weekdaysShort")}function qn(t,e,n){return Vn(t,e,n,"weekdaysMin")}function $n(){var t=this._data;return this._milliseconds=Kr(this._milliseconds),this._days=Kr(this._days),this._months=Kr(this._months),t.milliseconds=Kr(t.milliseconds),t.seconds=Kr(t.seconds),t.minutes=Kr(t.minutes),t.hours=Kr(t.hours),t.months=Kr(t.months),t.years=Kr(t.years),this}function Jn(t,e,n,i){var r=je(e,n);return t._milliseconds+=i*r._milliseconds,t._days+=i*r._days,t._months+=i*r._months,t._bubble()}function Qn(t,e){return Jn(this,t,e,1)}function Kn(t,e){return Jn(this,t,e,-1)}function ti(t){return t<0?Math.floor(t):Math.ceil(t)}function ei(){var t,e,n,i,r,o=this._milliseconds,s=this._days,a=this._months,h=this._data;return o>=0&&s>=0&&a>=0||o<=0&&s<=0&&a<=0||(o+=864e5*ti(ii(a)+s),s=0,a=0),h.milliseconds=o%1e3,t=w(o/1e3),h.seconds=t%60,e=w(t/60),h.minutes=e%60,n=w(e/60),h.hours=n%24,s+=w(n/24),r=w(ni(s)),a+=r,s-=ti(ii(r)),i=w(a/12),a%=12,h.days=s,h.months=a,h.years=i,this}function ni(t){return 4800*t/146097}function ii(t){return 146097*t/4800;
}function ri(t){var e,n,i=this._milliseconds;if(t=N(t),"month"===t||"year"===t)return e=this._days+i/864e5,n=this._months+ni(e),"month"===t?n:n/12;switch(e=this._days+Math.round(ii(this._months)),t){case"week":return e/7+i/6048e5;case"day":return e+i/864e5;case"hour":return 24*e+i/36e5;case"minute":return 1440*e+i/6e4;case"second":return 86400*e+i/1e3;case"millisecond":return Math.floor(864e5*e)+i;default:throw new Error("Unknown unit "+t)}}function oi(){return this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*x(this._months/12)}function si(t){return function(){return this.as(t)}}function ai(t){return t=N(t),this[t+"s"]()}function hi(t){return function(){return this._data[t]}}function ui(){return w(this.days()/7)}function li(t,e,n,i,r){return r.relativeTime(e||1,!!n,t,i)}function ci(t,e,n){var i=je(t).abs(),r=vo(i.as("s")),o=vo(i.as("m")),s=vo(i.as("h")),a=vo(i.as("d")),h=vo(i.as("M")),u=vo(i.as("y")),l=r<yo.s&&["s",r]||o<=1&&["m"]||o<yo.m&&["mm",o]||s<=1&&["h"]||s<yo.h&&["hh",s]||a<=1&&["d"]||a<yo.d&&["dd",a]||h<=1&&["M"]||h<yo.M&&["MM",h]||u<=1&&["y"]||["yy",u];return l[2]=e,l[3]=+t>0,l[4]=n,li.apply(null,l)}function fi(t){return void 0===t?vo:"function"==typeof t&&(vo=t,!0)}function di(t,e){return void 0!==yo[t]&&(void 0===e?yo[t]:(yo[t]=e,!0))}function pi(t){var e=this.localeData(),n=ci(this,!t,e);return t&&(n=e.pastFuture(+this,n)),e.postformat(n)}function mi(){var t,e,n,i=go(this._milliseconds)/1e3,r=go(this._days),o=go(this._months);t=w(i/60),e=w(t/60),i%=60,t%=60,n=w(o/12),o%=12;var s=n,a=o,h=r,u=e,l=t,c=i,f=this.asSeconds();return f?(f<0?"-":"")+"P"+(s?s+"Y":"")+(a?a+"M":"")+(h?h+"D":"")+(u||l||c?"T":"")+(u?u+"H":"")+(l?l+"M":"")+(c?c+"S":""):"P0D"}var vi,yi;yi=Array.prototype.some?Array.prototype.some:function(t){for(var e=Object(this),n=e.length>>>0,i=0;i<n;i++)if(i in e&&t.call(this,e[i],i,e))return!0;return!1};var gi=yi,_i=e.momentProperties=[],wi=!1,xi={};e.suppressDeprecationWarnings=!1,e.deprecationHandler=null;var bi;bi=Object.keys?Object.keys:function(t){var e,n=[];for(e in t)u(t,e)&&n.push(e);return n};var Si,Ti=bi,Di={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},Mi={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},ki="Invalid date",Oi="%d",Ei=/\d{1,2}/,Ci={future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},Pi={},Li={},Yi=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,Ri=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,Ai={},Ii={},Ni=/\d/,Wi=/\d\d/,zi=/\d{3}/,Fi=/\d{4}/,ji=/[+-]?\d{6}/,Gi=/\d\d?/,Bi=/\d\d\d\d?/,Vi=/\d\d\d\d\d\d?/,Ui=/\d{1,3}/,Hi=/\d{1,4}/,Xi=/[+-]?\d{1,6}/,Zi=/\d+/,qi=/[+-]?\d+/,$i=/Z|[+-]\d\d:?\d\d/gi,Ji=/Z|[+-]\d\d(?::?\d\d)?/gi,Qi=/[+-]?\d+(\.\d{1,3})?/,Ki=/[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i,tr={},er={},nr=0,ir=1,rr=2,or=3,sr=4,ar=5,hr=6,ur=7,lr=8;Si=Array.prototype.indexOf?Array.prototype.indexOf:function(t){var e;for(e=0;e<this.length;++e)if(this[e]===t)return e;return-1};var cr=Si;X("M",["MM",2],"Mo",function(){return this.month()+1}),X("MMM",0,0,function(t){return this.localeData().monthsShort(this,t)}),X("MMMM",0,0,function(t){return this.localeData().months(this,t)}),I("month","M"),z("month",8),Q("M",Gi),Q("MM",Gi,Wi),Q("MMM",function(t,e){return e.monthsShortRegex(t)}),Q("MMMM",function(t,e){return e.monthsRegex(t)}),nt(["M","MM"],function(t,e){e[ir]=x(t)-1}),nt(["MMM","MMMM"],function(t,e,n,i){var r=n._locale.monthsParse(t,i,n._strict);null!=r?e[ir]=r:d(n).invalidMonth=t});var fr=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,dr="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),pr="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),mr=Ki,vr=Ki;X("Y",0,0,function(){var t=this.year();return t<=9999?""+t:"+"+t}),X(0,["YY",2],0,function(){return this.year()%100}),X(0,["YYYY",4],0,"year"),X(0,["YYYYY",5],0,"year"),X(0,["YYYYYY",6,!0],0,"year"),I("year","y"),z("year",1),Q("Y",qi),Q("YY",Gi,Wi),Q("YYYY",Hi,Fi),Q("YYYYY",Xi,ji),Q("YYYYYY",Xi,ji),nt(["YYYYY","YYYYYY"],nr),nt("YYYY",function(t,n){n[nr]=2===t.length?e.parseTwoDigitYear(t):x(t)}),nt("YY",function(t,n){n[nr]=e.parseTwoDigitYear(t)}),nt("Y",function(t,e){e[nr]=parseInt(t,10)}),e.parseTwoDigitYear=function(t){return x(t)+(x(t)>68?1900:2e3)};var yr=j("FullYear",!0);X("w",["ww",2],"wo","week"),X("W",["WW",2],"Wo","isoWeek"),I("week","w"),I("isoWeek","W"),z("week",5),z("isoWeek",5),Q("w",Gi),Q("ww",Gi,Wi),Q("W",Gi),Q("WW",Gi,Wi),it(["w","ww","W","WW"],function(t,e,n,i){e[i.substr(0,1)]=x(t)});var gr={dow:0,doy:6};X("d",0,"do","day"),X("dd",0,0,function(t){return this.localeData().weekdaysMin(this,t)}),X("ddd",0,0,function(t){return this.localeData().weekdaysShort(this,t)}),X("dddd",0,0,function(t){return this.localeData().weekdays(this,t)}),X("e",0,0,"weekday"),X("E",0,0,"isoWeekday"),I("day","d"),I("weekday","e"),I("isoWeekday","E"),z("day",11),z("weekday",11),z("isoWeekday",11),Q("d",Gi),Q("e",Gi),Q("E",Gi),Q("dd",function(t,e){return e.weekdaysMinRegex(t)}),Q("ddd",function(t,e){return e.weekdaysShortRegex(t)}),Q("dddd",function(t,e){return e.weekdaysRegex(t)}),it(["dd","ddd","dddd"],function(t,e,n,i){var r=n._locale.weekdaysParse(t,i,n._strict);null!=r?e.d=r:d(n).invalidWeekday=t}),it(["d","e","E"],function(t,e,n,i){e[i]=x(t)});var _r="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),wr="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),xr="Su_Mo_Tu_We_Th_Fr_Sa".split("_"),br=Ki,Sr=Ki,Tr=Ki;X("H",["HH",2],0,"hour"),X("h",["hh",2],0,Vt),X("k",["kk",2],0,Ut),X("hmm",0,0,function(){return""+Vt.apply(this)+H(this.minutes(),2)}),X("hmmss",0,0,function(){return""+Vt.apply(this)+H(this.minutes(),2)+H(this.seconds(),2)}),X("Hmm",0,0,function(){return""+this.hours()+H(this.minutes(),2)}),X("Hmmss",0,0,function(){return""+this.hours()+H(this.minutes(),2)+H(this.seconds(),2)}),Ht("a",!0),Ht("A",!1),I("hour","h"),z("hour",13),Q("a",Xt),Q("A",Xt),Q("H",Gi),Q("h",Gi),Q("HH",Gi,Wi),Q("hh",Gi,Wi),Q("hmm",Bi),Q("hmmss",Vi),Q("Hmm",Bi),Q("Hmmss",Vi),nt(["H","HH"],or),nt(["a","A"],function(t,e,n){n._isPm=n._locale.isPM(t),n._meridiem=t}),nt(["h","hh"],function(t,e,n){e[or]=x(t),d(n).bigHour=!0}),nt("hmm",function(t,e,n){var i=t.length-2;e[or]=x(t.substr(0,i)),e[sr]=x(t.substr(i)),d(n).bigHour=!0}),nt("hmmss",function(t,e,n){var i=t.length-4,r=t.length-2;e[or]=x(t.substr(0,i)),e[sr]=x(t.substr(i,2)),e[ar]=x(t.substr(r)),d(n).bigHour=!0}),nt("Hmm",function(t,e,n){var i=t.length-2;e[or]=x(t.substr(0,i)),e[sr]=x(t.substr(i))}),nt("Hmmss",function(t,e,n){var i=t.length-4,r=t.length-2;e[or]=x(t.substr(0,i)),e[sr]=x(t.substr(i,2)),e[ar]=x(t.substr(r))});var Dr,Mr=/[ap]\.?m?\.?/i,kr=j("Hours",!0),Or={calendar:Di,longDateFormat:Mi,invalidDate:ki,ordinal:Oi,ordinalParse:Ei,relativeTime:Ci,months:dr,monthsShort:pr,week:gr,weekdays:_r,weekdaysMin:xr,weekdaysShort:wr,meridiemParse:Mr},Er={},Cr={},Pr=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,Lr=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,Yr=/Z|[+-]\d\d(?::?\d\d)?/,Rr=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/]],Ar=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],Ir=/^\/?Date\((\-?\d+)/i;e.createFromInputFallback=T("value provided is not in a recognized ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non ISO date formats are discouraged and will be removed in an upcoming major release. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",function(t){t._d=new Date(t._i+(t._useUTC?" UTC":""))}),e.ISO_8601=function(){};var Nr=T("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var t=_e.apply(null,arguments);return this.isValid()&&t.isValid()?t<this?this:t:m()}),Wr=T("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var t=_e.apply(null,arguments);return this.isValid()&&t.isValid()?t>this?this:t:m()}),zr=function(){return Date.now?Date.now():+new Date};Me("Z",":"),Me("ZZ",""),Q("Z",Ji),Q("ZZ",Ji),nt(["Z","ZZ"],function(t,e,n){n._useUTC=!0,n._tzm=ke(Ji,t)});var Fr=/([\+\-]|\d\d)/gi;e.updateOffset=function(){};var jr=/^(\-)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/,Gr=/^(-)?P(?:(-?[0-9,.]*)Y)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)W)?(?:(-?[0-9,.]*)D)?(?:T(?:(-?[0-9,.]*)H)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)S)?)?$/;je.fn=Se.prototype;var Br=Ue(1,"add"),Vr=Ue(-1,"subtract");e.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",e.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var Ur=T("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(t){return void 0===t?this.localeData():this.locale(t)});X(0,["gg",2],0,function(){return this.weekYear()%100}),X(0,["GG",2],0,function(){return this.isoWeekYear()%100}),kn("gggg","weekYear"),kn("ggggg","weekYear"),kn("GGGG","isoWeekYear"),kn("GGGGG","isoWeekYear"),I("weekYear","gg"),I("isoWeekYear","GG"),z("weekYear",1),z("isoWeekYear",1),Q("G",qi),Q("g",qi),Q("GG",Gi,Wi),Q("gg",Gi,Wi),Q("GGGG",Hi,Fi),Q("gggg",Hi,Fi),Q("GGGGG",Xi,ji),Q("ggggg",Xi,ji),it(["gggg","ggggg","GGGG","GGGGG"],function(t,e,n,i){e[i.substr(0,2)]=x(t)}),it(["gg","GG"],function(t,n,i,r){n[r]=e.parseTwoDigitYear(t)}),X("Q",0,"Qo","quarter"),I("quarter","Q"),z("quarter",7),Q("Q",Ni),nt("Q",function(t,e){e[ir]=3*(x(t)-1)}),X("D",["DD",2],"Do","date"),I("date","D"),z("date",9),Q("D",Gi),Q("DD",Gi,Wi),Q("Do",function(t,e){return t?e._ordinalParse:e._ordinalParseLenient}),nt(["D","DD"],rr),nt("Do",function(t,e){e[rr]=x(t.match(Gi)[0],10)});var Hr=j("Date",!0);X("DDD",["DDDD",3],"DDDo","dayOfYear"),I("dayOfYear","DDD"),z("dayOfYear",4),Q("DDD",Ui),Q("DDDD",zi),nt(["DDD","DDDD"],function(t,e,n){n._dayOfYear=x(t)}),X("m",["mm",2],0,"minute"),I("minute","m"),z("minute",14),Q("m",Gi),Q("mm",Gi,Wi),nt(["m","mm"],sr);var Xr=j("Minutes",!1);X("s",["ss",2],0,"second"),I("second","s"),z("second",15),Q("s",Gi),Q("ss",Gi,Wi),nt(["s","ss"],ar);var Zr=j("Seconds",!1);X("S",0,0,function(){return~~(this.millisecond()/100)}),X(0,["SS",2],0,function(){return~~(this.millisecond()/10)}),X(0,["SSS",3],0,"millisecond"),X(0,["SSSS",4],0,function(){return 10*this.millisecond()}),X(0,["SSSSS",5],0,function(){return 100*this.millisecond()}),X(0,["SSSSSS",6],0,function(){return 1e3*this.millisecond()}),X(0,["SSSSSSS",7],0,function(){return 1e4*this.millisecond()}),X(0,["SSSSSSSS",8],0,function(){return 1e5*this.millisecond()}),X(0,["SSSSSSSSS",9],0,function(){return 1e6*this.millisecond()}),I("millisecond","ms"),z("millisecond",16),Q("S",Ui,Ni),Q("SS",Ui,Wi),Q("SSS",Ui,zi);var qr;for(qr="SSSS";qr.length<=9;qr+="S")Q(qr,Zi);for(qr="S";qr.length<=9;qr+="S")nt(qr,In);var $r=j("Milliseconds",!1);X("z",0,0,"zoneAbbr"),X("zz",0,0,"zoneName");var Jr=g.prototype;Jr.add=Br,Jr.calendar=Ze,Jr.clone=qe,Jr.diff=nn,Jr.endOf=vn,Jr.format=hn,Jr.from=un,Jr.fromNow=ln,Jr.to=cn,Jr.toNow=fn,Jr.get=V,Jr.invalidAt=Dn,Jr.isAfter=$e,Jr.isBefore=Je,Jr.isBetween=Qe,Jr.isSame=Ke,Jr.isSameOrAfter=tn,Jr.isSameOrBefore=en,Jr.isValid=Sn,Jr.lang=Ur,Jr.locale=dn,Jr.localeData=pn,Jr.max=Wr,Jr.min=Nr,Jr.parsingFlags=Tn,Jr.set=U,Jr.startOf=mn,Jr.subtract=Vr,Jr.toArray=wn,Jr.toObject=xn,Jr.toDate=_n,Jr.toISOString=sn,Jr.inspect=an,Jr.toJSON=bn,Jr.toString=on,Jr.unix=gn,Jr.valueOf=yn,Jr.creationData=Mn,Jr.year=yr,Jr.isLeapYear=gt,Jr.weekYear=On,Jr.isoWeekYear=En,Jr.quarter=Jr.quarters=Rn,Jr.month=ct,Jr.daysInMonth=ft,Jr.week=Jr.weeks=Ot,Jr.isoWeek=Jr.isoWeeks=Et,Jr.weeksInYear=Pn,Jr.isoWeeksInYear=Cn,Jr.date=Hr,Jr.day=Jr.days=Nt,Jr.weekday=Wt,Jr.isoWeekday=zt,Jr.dayOfYear=An,Jr.hour=Jr.hours=kr,Jr.minute=Jr.minutes=Xr,Jr.second=Jr.seconds=Zr,Jr.millisecond=Jr.milliseconds=$r,Jr.utcOffset=Ce,Jr.utc=Le,Jr.local=Ye,Jr.parseZone=Re,Jr.hasAlignedHourOffset=Ae,Jr.isDST=Ie,Jr.isLocal=We,Jr.isUtcOffset=ze,Jr.isUtc=Fe,Jr.isUTC=Fe,Jr.zoneAbbr=Nn,Jr.zoneName=Wn,Jr.dates=T("dates accessor is deprecated. Use date instead.",Hr),Jr.months=T("months accessor is deprecated. Use month instead",ct),Jr.years=T("years accessor is deprecated. Use year instead",yr),Jr.zone=T("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",Pe),Jr.isDSTShifted=T("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",Ne);var Qr=E.prototype;Qr.calendar=C,Qr.longDateFormat=P,Qr.invalidDate=L,Qr.ordinal=Y,Qr.preparse=jn,Qr.postformat=jn,Qr.relativeTime=R,Qr.pastFuture=A,Qr.set=k,Qr.months=st,Qr.monthsShort=at,Qr.monthsParse=ut,Qr.monthsRegex=pt,Qr.monthsShortRegex=dt,Qr.week=Dt,Qr.firstDayOfYear=kt,Qr.firstDayOfWeek=Mt,Qr.weekdays=Lt,Qr.weekdaysMin=Rt,Qr.weekdaysShort=Yt,Qr.weekdaysParse=It,Qr.weekdaysRegex=Ft,Qr.weekdaysShortRegex=jt,Qr.weekdaysMinRegex=Gt,Qr.isPM=Zt,Qr.meridiem=qt,Kt("en",{ordinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(t){var e=t%10,n=1===x(t%100/10)?"th":1===e?"st":2===e?"nd":3===e?"rd":"th";return t+n}}),e.lang=T("moment.lang is deprecated. Use moment.locale instead.",Kt),e.langData=T("moment.langData is deprecated. Use moment.localeData instead.",ne);var Kr=Math.abs,to=si("ms"),eo=si("s"),no=si("m"),io=si("h"),ro=si("d"),oo=si("w"),so=si("M"),ao=si("y"),ho=hi("milliseconds"),uo=hi("seconds"),lo=hi("minutes"),co=hi("hours"),fo=hi("days"),po=hi("months"),mo=hi("years"),vo=Math.round,yo={s:45,m:45,h:22,d:26,M:11},go=Math.abs,_o=Se.prototype;return _o.abs=$n,_o.add=Qn,_o.subtract=Kn,_o.as=ri,_o.asMilliseconds=to,_o.asSeconds=eo,_o.asMinutes=no,_o.asHours=io,_o.asDays=ro,_o.asWeeks=oo,_o.asMonths=so,_o.asYears=ao,_o.valueOf=oi,_o._bubble=ei,_o.get=ai,_o.milliseconds=ho,_o.seconds=uo,_o.minutes=lo,_o.hours=co,_o.days=fo,_o.weeks=ui,_o.months=po,_o.years=mo,_o.humanize=pi,_o.toISOString=mi,_o.toString=mi,_o.toJSON=mi,_o.locale=dn,_o.localeData=pn,_o.toIsoString=T("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",mi),_o.lang=Ur,X("X",0,0,"unix"),X("x",0,0,"valueOf"),Q("x",qi),Q("X",Qi),nt("X",function(t,e,n){n._d=new Date(1e3*parseFloat(t,10))}),nt("x",function(t,e,n){n._d=new Date(x(t))}),e.version="2.17.1",n(_e),e.fn=Jr,e.min=xe,e.max=be,e.now=zr,e.utc=c,e.unix=zn,e.months=Un,e.isDate=a,e.locale=Kt,e.invalid=m,e.duration=je,e.isMoment=_,e.weekdays=Xn,e.parseZone=Fn,e.localeData=ne,e.isDuration=Te,e.monthsShort=Hn,e.weekdaysMin=qn,e.defineLocale=te,e.updateLocale=ee,e.locales=ie,e.weekdaysShort=Zn,e.normalizeUnits=N,e.relativeTimeRounding=fi,e.relativeTimeThreshold=di,e.calendarFormat=Xe,e.prototype=Jr,e})}).call(e,n(86)(t))},function(t,e){t.exports=function(t){return t.webpackPolyfill||(t.deprecate=function(){},t.paths=[],t.children=[],t.webpackPolyfill=1),t}},function(t,e){function n(t){throw new Error("Cannot find module '"+t+"'.")}n.keys=function(){return[]},n.resolve=n,t.exports=n,n.id=87},function(t,e){(function(e){function n(t,e,n){var i=e&&n||0,r=0;for(e=e||[],t.toLowerCase().replace(/[0-9a-f]{2}/g,function(t){r<16&&(e[i+r++]=c[t])});r<16;)e[i+r++]=0;return e}function i(t,e){var n=e||0,i=l;return i[t[n++]]+i[t[n++]]+i[t[n++]]+i[t[n++]]+"-"+i[t[n++]]+i[t[n++]]+"-"+i[t[n++]]+i[t[n++]]+"-"+i[t[n++]]+i[t[n++]]+"-"+i[t[n++]]+i[t[n++]]+i[t[n++]]+i[t[n++]]+i[t[n++]]+i[t[n++]]}function r(t,e,n){var r=e&&n||0,o=e||[];t=t||{};var s=void 0!==t.clockseq?t.clockseq:m,a=void 0!==t.msecs?t.msecs:(new Date).getTime(),h=void 0!==t.nsecs?t.nsecs:y+1,u=a-v+(h-y)/1e4;if(u<0&&void 0===t.clockseq&&(s=s+1&16383),(u<0||a>v)&&void 0===t.nsecs&&(h=0),h>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");v=a,y=h,m=s,a+=122192928e5;var l=(1e4*(268435455&a)+h)%4294967296;o[r++]=l>>>24&255,o[r++]=l>>>16&255,o[r++]=l>>>8&255,o[r++]=255&l;var c=a/4294967296*1e4&268435455;o[r++]=c>>>8&255,o[r++]=255&c,o[r++]=c>>>24&15|16,o[r++]=c>>>16&255,o[r++]=s>>>8|128,o[r++]=255&s;for(var f=t.node||p,d=0;d<6;d++)o[r+d]=f[d];return e?e:i(o)}function o(t,e,n){var r=e&&n||0;"string"==typeof t&&(e="binary"==t?new Array(16):null,t=null),t=t||{};var o=t.random||(t.rng||s)();if(o[6]=15&o[6]|64,o[8]=63&o[8]|128,e)for(var a=0;a<16;a++)e[r+a]=o[a];return e||i(o)}var s,a="undefined"!=typeof window?window:"undefined"!=typeof e?e:null;if(a&&a.crypto&&crypto.getRandomValues){var h=new Uint8Array(16);s=function(){return crypto.getRandomValues(h),h}}if(!s){var u=new Array(16);s=function(){for(var t,e=0;e<16;e++)0===(3&e)&&(t=4294967296*Math.random()),u[e]=t>>>((3&e)<<3)&255;return u}}for(var l=[],c={},f=0;f<256;f++)l[f]=(f+256).toString(16).substr(1),c[l[f]]=f;var d=s(),p=[1|d[0],d[1],d[2],d[3],d[4],d[5]],m=16383&(d[6]<<8|d[7]),v=0,y=0,g=o;g.v1=r,g.v4=o,g.parse=n,g.unparse=i,t.exports=g}).call(e,function(){return this}())},function(t,e){e.prepareElements=function(t){for(var e in t)t.hasOwnProperty(e)&&(t[e].redundant=t[e].used,t[e].used=[])},e.cleanupElements=function(t){for(var e in t)if(t.hasOwnProperty(e)&&t[e].redundant){for(var n=0;n<t[e].redundant.length;n++)t[e].redundant[n].parentNode.removeChild(t[e].redundant[n]);t[e].redundant=[]}},e.resetElements=function(t){e.prepareElements(t),e.cleanupElements(t),e.prepareElements(t)},e.getSVGElement=function(t,e,n){var i;return e.hasOwnProperty(t)?e[t].redundant.length>0?(i=e[t].redundant[0],e[t].redundant.shift()):(i=document.createElementNS("http://www.w3.org/2000/svg",t),n.appendChild(i)):(i=document.createElementNS("http://www.w3.org/2000/svg",t),e[t]={used:[],redundant:[]},n.appendChild(i)),e[t].used.push(i),i},e.getDOMElement=function(t,e,n,i){var r;return e.hasOwnProperty(t)?e[t].redundant.length>0?(r=e[t].redundant[0],e[t].redundant.shift()):(r=document.createElement(t),void 0!==i?n.insertBefore(r,i):n.appendChild(r)):(r=document.createElement(t),e[t]={used:[],redundant:[]},void 0!==i?n.insertBefore(r,i):n.appendChild(r)),e[t].used.push(r),r},e.drawPoint=function(t,n,i,r,o,s){var a;if("circle"==i.style?(a=e.getSVGElement("circle",r,o),a.setAttributeNS(null,"cx",t),a.setAttributeNS(null,"cy",n),a.setAttributeNS(null,"r",.5*i.size)):(a=e.getSVGElement("rect",r,o),a.setAttributeNS(null,"x",t-.5*i.size),a.setAttributeNS(null,"y",n-.5*i.size),a.setAttributeNS(null,"width",i.size),a.setAttributeNS(null,"height",i.size)),void 0!==i.styles&&a.setAttributeNS(null,"style",i.styles),a.setAttributeNS(null,"class",i.className+" vis-point"),s){var h=e.getSVGElement("text",r,o);s.xOffset&&(t+=s.xOffset),s.yOffset&&(n+=s.yOffset),s.content&&(h.textContent=s.content),s.className&&h.setAttributeNS(null,"class",s.className+" vis-label"),h.setAttributeNS(null,"x",t),h.setAttributeNS(null,"y",n)}return a},e.drawBar=function(t,n,i,r,o,s,a,h){if(0!=r){r<0&&(r*=-1,n-=r);var u=e.getSVGElement("rect",s,a);u.setAttributeNS(null,"x",t-.5*i),u.setAttributeNS(null,"y",n),u.setAttributeNS(null,"width",i),u.setAttributeNS(null,"height",r),u.setAttributeNS(null,"class",o),h&&u.setAttributeNS(null,"style",h)}}},function(t,e,n){function i(t){return t&&t.__esModule?t:{default:t}}function r(t,e){if(t&&!Array.isArray(t)&&(e=t,t=null),this._options=e||{},this._data={},this.length=0,this._fieldId=this._options.fieldId||"id",this._type={},this._options.type)for(var n=(0,l.default)(this._options.type),i=0,r=n.length;i<r;i++){var o=n[i],s=this._options.type[o];"Date"==s||"ISODate"==s||"ASPDate"==s?this._type[o]="Date":this._type[o]=s}if(this._options.convert)throw new Error('Option "convert" is deprecated. Use "type" instead.');this._subscribers={},t&&this.add(t),this.setOptions(e)}var o=n(82),s=i(o),a=n(62),h=i(a),u=n(58),l=i(u),c=n(1),f=n(91);r.prototype.setOptions=function(t){t&&void 0!==t.queue&&(t.queue===!1?this._queue&&(this._queue.destroy(),delete this._queue):(this._queue||(this._queue=f.extend(this,{replace:["add","update","remove"]})),"object"===(0,h.default)(t.queue)&&this._queue.setOptions(t.queue)))},r.prototype.on=function(t,e){var n=this._subscribers[t];n||(n=[],this._subscribers[t]=n),n.push({callback:e})},r.prototype.subscribe=function(){throw new Error("DataSet.subscribe is deprecated. Use DataSet.on instead.")},r.prototype.off=function(t,e){var n=this._subscribers[t];n&&(this._subscribers[t]=n.filter(function(t){return t.callback!=e}))},r.prototype.unsubscribe=function(){throw new Error("DataSet.unsubscribe is deprecated. Use DataSet.off instead.")},r.prototype._trigger=function(t,e,n){if("*"==t)throw new Error("Cannot trigger event *");var i=[];t in this._subscribers&&(i=i.concat(this._subscribers[t])),"*"in this._subscribers&&(i=i.concat(this._subscribers["*"]));for(var r=0,o=i.length;r<o;r++){var s=i[r];s.callback&&s.callback(t,e,n||null)}},r.prototype.add=function(t,e){var n,i=[],r=this;if(Array.isArray(t))for(var o=0,s=t.length;o<s;o++)n=r._addItem(t[o]),i.push(n);else{if(!(t instanceof Object))throw new Error("Unknown dataType");n=r._addItem(t),i.push(n)}return i.length&&this._trigger("add",{items:i},e),i},r.prototype.update=function(t,e){var n=[],i=[],r=[],o=[],s=this,a=s._fieldId,h=function(t){var e=t[a];if(s._data[e]){var h=c.extend({},s._data[e]);e=s._updateItem(t),i.push(e),o.push(t),r.push(h)}else e=s._addItem(t),n.push(e)};if(Array.isArray(t))for(var u=0,l=t.length;u<l;u++)t[u]instanceof Object?h(t[u]):console.warn("Ignoring input item, which is not an object at index "+u);else{if(!(t instanceof Object))throw new Error("Unknown dataType");h(t)}if(n.length&&this._trigger("add",{items:n},e),i.length){var f={items:i,oldData:r,data:o};this._trigger("update",f,e)}return n.concat(i)},r.prototype.get=function(t){var e,n,i,r=this,o=c.getType(arguments[0]);"String"==o||"Number"==o?(e=arguments[0],i=arguments[1]):"Array"==o?(n=arguments[0],i=arguments[1]):i=arguments[0];var s;if(i&&i.returnType){var a=["Array","Object"];s=a.indexOf(i.returnType)==-1?"Array":i.returnType}else s="Array";var h,u,f,d,p,m=i&&i.type||this._options.type,v=i&&i.filter,y=[];if(void 0!=e)h=r._getItem(e,m),h&&v&&!v(h)&&(h=null);else if(void 0!=n)for(d=0,p=n.length;d<p;d++)h=r._getItem(n[d],m),v&&!v(h)||y.push(h);else for(u=(0,l.default)(this._data),d=0,p=u.length;d<p;d++)f=u[d],h=r._getItem(f,m),v&&!v(h)||y.push(h);if(i&&i.order&&void 0==e&&this._sort(y,i.order),i&&i.fields){var g=i.fields;if(void 0!=e)h=this._filterFields(h,g);else for(d=0,p=y.length;d<p;d++)y[d]=this._filterFields(y[d],g)}if("Object"==s){var _,w={};for(d=0,p=y.length;d<p;d++)_=y[d],w[_.id]=_;return w}return void 0!=e?h:y},r.prototype.getIds=function(t){var e,n,i,r,o,s=this._data,a=t&&t.filter,h=t&&t.order,u=t&&t.type||this._options.type,c=(0,l.default)(s),f=[];if(a)if(h){for(o=[],e=0,n=c.length;e<n;e++)i=c[e],r=this._getItem(i,u),a(r)&&o.push(r);for(this._sort(o,h),e=0,n=o.length;e<n;e++)f.push(o[e][this._fieldId])}else for(e=0,n=c.length;e<n;e++)i=c[e],r=this._getItem(i,u),a(r)&&f.push(r[this._fieldId]);else if(h){for(o=[],e=0,n=c.length;e<n;e++)i=c[e],o.push(s[i]);for(this._sort(o,h),e=0,n=o.length;e<n;e++)f.push(o[e][this._fieldId])}else for(e=0,n=c.length;e<n;e++)i=c[e],r=s[i],f.push(r[this._fieldId]);return f},r.prototype.getDataSet=function(){return this},r.prototype.forEach=function(t,e){var n,i,r,o,s=e&&e.filter,a=e&&e.type||this._options.type,h=this._data,u=(0,l.default)(h);if(e&&e.order){var c=this.get(e);for(n=0,i=c.length;n<i;n++)r=c[n],o=r[this._fieldId],t(r,o)}else for(n=0,i=u.length;n<i;n++)o=u[n],r=this._getItem(o,a),s&&!s(r)||t(r,o)},r.prototype.map=function(t,e){var n,i,r,o,s=e&&e.filter,a=e&&e.type||this._options.type,h=[],u=this._data,c=(0,l.default)(u);for(n=0,i=c.length;n<i;n++)r=c[n],o=this._getItem(r,a),s&&!s(o)||h.push(t(o,r));return e&&e.order&&this._sort(h,e.order),h},r.prototype._filterFields=function(t,e){if(!t)return t;var n,i,r={},o=(0,l.default)(t),s=o.length;if(Array.isArray(e))for(n=0;n<s;n++)i=o[n],e.indexOf(i)!=-1&&(r[i]=t[i]);else for(n=0;n<s;n++)i=o[n],e.hasOwnProperty(i)&&(r[e[i]]=t[i]);return r},r.prototype._sort=function(t,e){if(c.isString(e)){var n=e;t.sort(function(t,e){var i=t[n],r=e[n];return i>r?1:i<r?-1:0})}else{if("function"!=typeof e)throw new TypeError("Order must be a function or a string");t.sort(e)}},r.prototype.remove=function(t,e){var n,i,r,o,s=[],a=[],h=[];for(h=Array.isArray(t)?t:[t],n=0,i=h.length;n<i;n++)o=this._remove(h[n]),o&&(r=o[this._fieldId],void 0!=r&&(s.push(r),a.push(o)));return s.length&&this._trigger("remove",{items:s,oldData:a},e),s},r.prototype._remove=function(t){var e,n;return c.isNumber(t)||c.isString(t)?n=t:t instanceof Object&&(n=t[this._fieldId]),void 0!==n&&this._data[n]?(e=this._data[n],delete this._data[n],this.length--,e):null},r.prototype.clear=function(t){var e,n,i=(0,l.default)(this._data),r=[];for(e=0,n=i.length;e<n;e++)r.push(this._data[i[e]]);return this._data={},this.length=0,this._trigger("remove",{items:i,oldData:r},t),i},r.prototype.max=function(t){var e,n,i=this._data,r=(0,l.default)(i),o=null,s=null;for(e=0,n=r.length;e<n;e++){var a=r[e],h=i[a],u=h[t];null!=u&&(!o||u>s)&&(o=h,s=u)}return o},r.prototype.min=function(t){var e,n,i=this._data,r=(0,l.default)(i),o=null,s=null;for(e=0,n=r.length;e<n;e++){var a=r[e],h=i[a],u=h[t];null!=u&&(!o||u<s)&&(o=h,s=u)}return o},r.prototype.distinct=function(t){var e,n,i,r=this._data,o=(0,l.default)(r),s=[],a=this._options.type&&this._options.type[t]||null,h=0;for(e=0,i=o.length;e<i;e++){var u=o[e],f=r[u],d=f[t],p=!1;for(n=0;n<h;n++)if(s[n]==d){p=!0;break}p||void 0===d||(s[h]=d,h++)}if(a)for(e=0,i=s.length;e<i;e++)s[e]=c.convert(s[e],a);return s},r.prototype._addItem=function(t){var e=t[this._fieldId];if(void 0!=e){if(this._data[e])throw new Error("Cannot add item: item with id "+e+" already exists")}else e=c.randomUUID(),t[this._fieldId]=e;var n,i,r={},o=(0,l.default)(t);for(n=0,i=o.length;n<i;n++){var s=o[n],a=this._type[s];r[s]=c.convert(t[s],a)}return this._data[e]=r,this.length++,e},r.prototype._getItem=function(t,e){var n,i,r,o,s=this._data[t];if(!s)return null;var a={},h=(0,l.default)(s);if(e)for(r=0,o=h.length;r<o;r++)n=h[r],i=s[n],a[n]=c.convert(i,e[n]);else for(r=0,o=h.length;r<o;r++)n=h[r],i=s[n],a[n]=i;return a[this._fieldId]||(a[this._fieldId]=s.id),a},r.prototype._updateItem=function(t){var e=t[this._fieldId];if(void 0==e)throw new Error("Cannot update item: item has no id (item: "+(0,s.default)(t)+")");var n=this._data[e];if(!n)throw new Error("Cannot update item: no item with id "+e+" found");for(var i=(0,l.default)(t),r=0,o=i.length;r<o;r++){var a=i[r],h=this._type[a];n[a]=c.convert(t[a],h)}return e},t.exports=r},function(t,e){function n(t){this.delay=null,this.max=1/0,this._queue=[],this._timeout=null,this._extended=null,this.setOptions(t)}n.prototype.setOptions=function(t){t&&"undefined"!=typeof t.delay&&(this.delay=t.delay),t&&"undefined"!=typeof t.max&&(this.max=t.max),this._flushIfNeeded()},n.extend=function(t,e){var i=new n(e);if(void 0!==t.flush)throw new Error("Target object already has a property flush");t.flush=function(){i.flush()};var r=[{name:"flush",original:void 0}];if(e&&e.replace)for(var o=0;o<e.replace.length;o++){var s=e.replace[o];r.push({name:s,original:t[s]}),i.replace(t,s)}return i._extended={object:t,methods:r},i},n.prototype.destroy=function(){if(this.flush(),this._extended){for(var t=this._extended.object,e=this._extended.methods,n=0;n<e.length;n++){var i=e[n];i.original?t[i.name]=i.original:delete t[i.name]}this._extended=null}},n.prototype.replace=function(t,e){var n=this,i=t[e];if(!i)throw new Error("Method "+e+" undefined");t[e]=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];n.queue({args:t,fn:i,context:this})}},n.prototype.queue=function(t){"function"==typeof t?this._queue.push({fn:t}):this._queue.push(t),this._flushIfNeeded()},n.prototype._flushIfNeeded=function(){if(this._queue.length>this.max&&this.flush(),clearTimeout(this._timeout),this.queue.length>0&&"number"==typeof this.delay){var t=this;this._timeout=setTimeout(function(){t.flush()},this.delay)}},n.prototype.flush=function(){for(;this._queue.length>0;){var t=this._queue.shift();t.fn.apply(t.context||t.fn,t.args||[])}},t.exports=n},function(t,e,n){function i(t){return t&&t.__esModule?t:{default:t}}function r(t,e){this._data=null,this._ids={},this.length=0,this._options=e||{},this._fieldId="id",this._subscribers={};var n=this;this.listener=function(){n._onEvent.apply(n,arguments)},this.setData(t)}var o=n(58),s=i(o),a=n(1),h=n(90);r.prototype.setData=function(t){var e,n,i,r,o;if(this._data){for(this._data.off&&this._data.off("*",this.listener),e=this._data.getIds({filter:this._options&&this._options.filter}),o=[],i=0,r=e.length;i<r;i++)o.push(this._data._data[e[i]]);this._ids={},this.length=0,this._trigger("remove",{items:e,oldData:o})}if(this._data=t,this._data){for(this._fieldId=this._options.fieldId||this._data&&this._data.options&&this._data.options.fieldId||"id",e=this._data.getIds({filter:this._options&&this._options.filter}),i=0,r=e.length;i<r;i++)n=e[i],this._ids[n]=!0;this.length=e.length,this._trigger("add",{items:e}),this._data.on&&this._data.on("*",this.listener)}},r.prototype.refresh=function(){var t,e,n,i=this._data.getIds({filter:this._options&&this._options.filter}),r=(0,s.default)(this._ids),o={},a=[],h=[],u=[];for(e=0,n=i.length;e<n;e++)t=i[e],o[t]=!0,this._ids[t]||(a.push(t),this._ids[t]=!0);for(e=0,n=r.length;e<n;e++)t=r[e],o[t]||(h.push(t),u.push(this._data._data[t]),delete this._ids[t]);this.length+=a.length-h.length,a.length&&this._trigger("add",{items:a}),h.length&&this._trigger("remove",{items:h,oldData:u})},r.prototype.get=function(t){var e,n,i,r=this,o=a.getType(arguments[0]);"String"==o||"Number"==o||"Array"==o?(e=arguments[0],n=arguments[1],i=arguments[2]):(n=arguments[0],i=arguments[1]);var s=a.extend({},this._options,n);this._options.filter&&n&&n.filter&&(s.filter=function(t){return r._options.filter(t)&&n.filter(t)});var h=[];return void 0!=e&&h.push(e),h.push(s),h.push(i),this._data&&this._data.get.apply(this._data,h)},r.prototype.getIds=function(t){var e;if(this._data){var n,i=this._options.filter;n=t&&t.filter?i?function(e){return i(e)&&t.filter(e)}:t.filter:i,e=this._data.getIds({filter:n,order:t&&t.order})}else e=[];return e},r.prototype.map=function(t,e){var n=[];if(this._data){var i,r=this._options.filter;i=e&&e.filter?r?function(t){return r(t)&&e.filter(t)}:e.filter:r,n=this._data.map(t,{filter:i,order:e&&e.order})}else n=[];return n},r.prototype.getDataSet=function(){for(var t=this;t instanceof r;)t=t._data;return t||null},r.prototype._onEvent=function(t,e,n){var i,r,o,s,a=e&&e.items,h=[],u=[],l=[],c=[],f=[],d=[];if(a&&this._data){switch(t){case"add":for(i=0,r=a.length;i<r;i++)o=a[i],s=this.get(o),s&&(this._ids[o]=!0,h.push(o));break;case"update":for(i=0,r=a.length;i<r;i++)o=a[i],s=this.get(o),s?this._ids[o]?(u.push(o),f.push(e.data[i]),c.push(e.oldData[i])):(this._ids[o]=!0,h.push(o)):this._ids[o]&&(delete this._ids[o],l.push(o),d.push(e.oldData[i]));break;case"remove":for(i=0,r=a.length;i<r;i++)o=a[i],this._ids[o]&&(delete this._ids[o],l.push(o),d.push(e.oldData[i]))}this.length+=h.length-l.length,h.length&&this._trigger("add",{items:h},n),u.length&&this._trigger("update",{items:u,oldData:c,data:f},n),l.length&&this._trigger("remove",{
items:l,oldData:d},n)}},r.prototype.on=h.prototype.on,r.prototype.off=h.prototype.off,r.prototype._trigger=h.prototype._trigger,r.prototype.subscribe=r.prototype.on,r.prototype.unsubscribe=r.prototype.off,t.exports=r},function(t,e,n){function i(t,e,n){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");this.containerElement=t,this.dataTable=null,this.dataPoints=null,this.create(),v.setDefaults(g,this),this.colX=void 0,this.colY=void 0,this.colZ=void 0,this.colValue=void 0,this.colFilter=void 0,this.setOptions(n),e&&this.setData(e)}function r(t){return"clientX"in t?t.clientX:t.targetTouches[0]&&t.targetTouches[0].clientX||0}function o(t){return"clientY"in t?t.clientY:t.targetTouches[0]&&t.targetTouches[0].clientY||0}var s=n(94),a=n(90),h=n(92),u=n(1),l=n(95),c=n(96),f=(n(97),n(102)),d=n(103),p=n(104),m=n(105),v=n(106);i.STYLE=v.STYLE;var y=void 0,g={width:"400px",height:"400px",filterLabel:"time",legendLabel:"value",xLabel:"x",yLabel:"y",zLabel:"z",xValueLabel:function(t){return t},yValueLabel:function(t){return t},zValueLabel:function(t){return t},showGrid:!0,showPerspective:!0,showShadow:!1,keepAspectRatio:!0,verticalRatio:.5,dotSizeRatio:.02,showAnimationControls:y,animationInterval:1e3,animationPreload:!1,animationAutoStart:y,axisColor:"#4D4D4D",gridColor:"#D3D3D3",xCenter:"55%",yCenter:"50%",style:i.STYLE.DOT,tooltip:!1,showLegend:y,backgroundColor:y,dataColor:{fill:"#7DC1FF",stroke:"#3267D2",strokeWidth:1},cameraPosition:{horizontal:1,vertical:.5,distance:1.7},xBarWidth:y,yBarWidth:y,valueMin:y,valueMax:y,xMin:y,xMax:y,xStep:y,yMin:y,yMax:y,yStep:y,zMin:y,zMax:y,zStep:y};s(i.prototype),i.prototype._setScale=function(){this.scale=new l(1/this.xRange.range(),1/this.yRange.range(),1/this.zRange.range()),this.keepAspectRatio&&(this.scale.x<this.scale.y?this.scale.y=this.scale.x:this.scale.x=this.scale.y),this.scale.z*=this.verticalRatio,void 0!==this.valueRange&&(this.scale.value=1/this.valueRange.range());var t=this.xRange.center()*this.scale.x,e=this.yRange.center()*this.scale.y,n=this.zRange.center()*this.scale.z;this.camera.setArmLocation(t,e,n)},i.prototype._convert3Dto2D=function(t){var e=this._convertPointToTranslation(t);return this._convertTranslationToScreen(e)},i.prototype._convertPointToTranslation=function(t){var e=this.camera.getCameraLocation(),n=this.camera.getCameraRotation(),i=t.x*this.scale.x,r=t.y*this.scale.y,o=t.z*this.scale.z,s=e.x,a=e.y,h=e.z,u=Math.sin(n.x),c=Math.cos(n.x),f=Math.sin(n.y),d=Math.cos(n.y),p=Math.sin(n.z),m=Math.cos(n.z),v=d*(p*(r-a)+m*(i-s))-f*(o-h),y=u*(d*(o-h)+f*(p*(r-a)+m*(i-s)))+c*(m*(r-a)-p*(i-s)),g=c*(d*(o-h)+f*(p*(r-a)+m*(i-s)))-u*(m*(r-a)-p*(i-s));return new l(v,y,g)},i.prototype._convertTranslationToScreen=function(t){var e,n,i=this.eye.x,r=this.eye.y,o=this.eye.z,s=t.x,a=t.y,h=t.z;return this.showPerspective?(e=(s-i)*(o/h),n=(a-r)*(o/h)):(e=s*-(o/this.camera.getArmLength()),n=a*-(o/this.camera.getArmLength())),new c(this.currentXCenter+e*this.frame.canvas.clientWidth,this.currentYCenter-n*this.frame.canvas.clientWidth)},i.prototype._calcTranslations=function(t,e){void 0===e&&(e=!0);for(var n=0;n<t.length;n++){var i=t[n];i.trans=this._convertPointToTranslation(i.point),i.screen=this._convertTranslationToScreen(i.trans);var r=this._convertPointToTranslation(i.bottom);i.dist=this.showPerspective?r.length():-r.z}if(e){var o=function(t,e){return e.dist-t.dist};t.sort(o)}},i.prototype.getNumberOfRows=function(t){return t.length},i.prototype.getNumberOfColumns=function(t){var e=0;for(var n in t[0])t[0].hasOwnProperty(n)&&e++;return e},i.prototype.getDistinctValues=function(t,e){for(var n=[],i=0;i<t.length;i++)n.indexOf(t[i][e])==-1&&n.push(t[i][e]);return n},i.prototype.getColumnRange=function(t,e){for(var n=new m,i=0;i<t.length;i++){var r=t[i][e];n.adjust(r)}return n},i.prototype._checkValueField=function(t){var e=this.style===i.STYLE.BARCOLOR||this.style===i.STYLE.BARSIZE||this.style===i.STYLE.DOTCOLOR||this.style===i.STYLE.DOTSIZE;if(e){if(void 0===this.colValue)throw new Error("Expected data to have  field 'style'  for graph style '"+this.style+"'");if(void 0===t[0][this.colValue])throw new Error("Expected data to have  field '"+this.colValue+"'  for graph style '"+this.style+"'")}},i.prototype._setRangeDefaults=function(t,e,n){void 0!==e&&(t.min=e),void 0!==n&&(t.max=n),t.max<=t.min&&(t.max=t.min+1)},i.prototype._dataInitialize=function(t,e){var n=this;if(this.dataSet&&this.dataSet.off("*",this._onChange),void 0!==t){Array.isArray(t)&&(t=new a(t));var r;if(!(t instanceof a||t instanceof h))throw new Error("Array, DataSet, or DataView expected");if(r=t.get(),0!=r.length){this.dataSet=t,this.dataTable=r,this._onChange=function(){n.setData(n.dataSet)},this.dataSet.on("*",this._onChange),this.colX="x",this.colY="y",this.colZ="z";var o=this.style==i.STYLE.BAR||this.style==i.STYLE.BARCOLOR||this.style==i.STYLE.BARSIZE;if(o){if(void 0!==this.defaultXBarWidth)this.xBarWidth=this.defaultXBarWidth;else{var s=this.getDistinctValues(r,this.colX);this.xBarWidth=s[1]-s[0]||1}if(void 0!==this.defaultYBarWidth)this.yBarWidth=this.defaultYBarWidth;else{var u=this.getDistinctValues(r,this.colY);this.yBarWidth=u[1]-u[0]||1}}var l=5,c=this.getColumnRange(r,this.colX);o&&c.expand(this.xBarWidth/2),this._setRangeDefaults(c,this.defaultXMin,this.defaultXMax),this.xRange=c,this.xStep=void 0!==this.defaultXStep?this.defaultXStep:c.range()/l;var d=this.getColumnRange(r,this.colY);o&&d.expand(this.yBarWidth/2),this._setRangeDefaults(d,this.defaultYMin,this.defaultYMax),this.yRange=d,this.yStep=void 0!==this.defaultYStep?this.defaultYStep:d.range()/l;var p=this.getColumnRange(r,this.colZ);if(this._setRangeDefaults(p,this.defaultZMin,this.defaultZMax),this.zRange=p,this.zStep=void 0!==this.defaultZStep?this.defaultZStep:p.range()/l,r[0].hasOwnProperty("style")){this.colValue="style";var m=this.getColumnRange(r,this.colValue);this._setRangeDefaults(m,this.defaultValueMin,this.defaultValueMax),this.valueRange=m}r[0].hasOwnProperty("filter")&&(this.colFilter="filter",void 0===this.dataFilter&&(this.dataFilter=new f(t,this.colFilter,this),this.dataFilter.setOnLoadCallback(function(){n.redraw()}))),this._setScale()}}},i.prototype._getDataPoints=function(t){var e,n,r,o,s,a,h=[];if(this.style===i.STYLE.GRID||this.style===i.STYLE.SURFACE){var u=[],c=[];for(r=0;r<this.getNumberOfRows(t);r++)e=t[r][this.colX]||0,n=t[r][this.colY]||0,u.indexOf(e)===-1&&u.push(e),c.indexOf(n)===-1&&c.push(n);var f=function(t,e){return t-e};u.sort(f),c.sort(f);var d=[];for(r=0;r<t.length;r++){e=t[r][this.colX]||0,n=t[r][this.colY]||0,o=t[r][this.colZ]||0;var p=u.indexOf(e),m=c.indexOf(n);void 0===d[p]&&(d[p]=[]);var v=new l;v.x=e,v.y=n,v.z=o,v.data=t[r],s={},s.point=v,s.trans=void 0,s.screen=void 0,s.bottom=new l(e,n,this.zRange.min),d[p][m]=s,h.push(s)}for(e=0;e<d.length;e++)for(n=0;n<d[e].length;n++)d[e][n]&&(d[e][n].pointRight=e<d.length-1?d[e+1][n]:void 0,d[e][n].pointTop=n<d[e].length-1?d[e][n+1]:void 0,d[e][n].pointCross=e<d.length-1&&n<d[e].length-1?d[e+1][n+1]:void 0)}else for(this._checkValueField(t),r=0;r<t.length;r++)a=new l,a.x=t[r][this.colX]||0,a.y=t[r][this.colY]||0,a.z=t[r][this.colZ]||0,a.data=t[r],void 0!==this.colValue&&(a.value=t[r][this.colValue]||0),s={},s.point=a,s.bottom=new l(a.x,a.y,this.zRange.min),s.trans=void 0,s.screen=void 0,this.style===i.STYLE.LINE&&r>0&&(h[r-1].pointNext=s),h.push(s);return h},i.prototype.create=function(){for(;this.containerElement.hasChildNodes();)this.containerElement.removeChild(this.containerElement.firstChild);this.frame=document.createElement("div"),this.frame.style.position="relative",this.frame.style.overflow="hidden",this.frame.canvas=document.createElement("canvas"),this.frame.canvas.style.position="relative",this.frame.appendChild(this.frame.canvas);var t=document.createElement("DIV");t.style.color="red",t.style.fontWeight="bold",t.style.padding="10px",t.innerHTML="Error: your browser does not support HTML canvas",this.frame.canvas.appendChild(t),this.frame.filter=document.createElement("div"),this.frame.filter.style.position="absolute",this.frame.filter.style.bottom="0px",this.frame.filter.style.left="0px",this.frame.filter.style.width="100%",this.frame.appendChild(this.frame.filter);var e=this,n=function(t){e._onMouseDown(t)},i=function(t){e._onTouchStart(t)},r=function(t){e._onWheel(t)},o=function(t){e._onTooltip(t)},s=function(t){e._onClick(t)};u.addEventListener(this.frame.canvas,"keydown",onkeydown),u.addEventListener(this.frame.canvas,"mousedown",n),u.addEventListener(this.frame.canvas,"touchstart",i),u.addEventListener(this.frame.canvas,"mousewheel",r),u.addEventListener(this.frame.canvas,"mousemove",o),u.addEventListener(this.frame.canvas,"click",s),this.containerElement.appendChild(this.frame)},i.prototype._setSize=function(t,e){this.frame.style.width=t,this.frame.style.height=e,this._resizeCanvas()},i.prototype._resizeCanvas=function(){this.frame.canvas.style.width="100%",this.frame.canvas.style.height="100%",this.frame.canvas.width=this.frame.canvas.clientWidth,this.frame.canvas.height=this.frame.canvas.clientHeight,this.frame.filter.style.width=this.frame.canvas.clientWidth-20+"px"},i.prototype.animationStart=function(){if(!this.frame.filter||!this.frame.filter.slider)throw new Error("No animation available");this.frame.filter.slider.play()},i.prototype.animationStop=function(){this.frame.filter&&this.frame.filter.slider&&this.frame.filter.slider.stop()},i.prototype._resizeCenter=function(){"%"===this.xCenter.charAt(this.xCenter.length-1)?this.currentXCenter=parseFloat(this.xCenter)/100*this.frame.canvas.clientWidth:this.currentXCenter=parseFloat(this.xCenter),"%"===this.yCenter.charAt(this.yCenter.length-1)?this.currentYCenter=parseFloat(this.yCenter)/100*(this.frame.canvas.clientHeight-this.frame.filter.clientHeight):this.currentYCenter=parseFloat(this.yCenter)},i.prototype.getCameraPosition=function(){var t=this.camera.getArmRotation();return t.distance=this.camera.getArmLength(),t},i.prototype._readData=function(t){this._dataInitialize(t,this.style),this.dataFilter?this.dataPoints=this.dataFilter._getDataPoints():this.dataPoints=this._getDataPoints(this.dataTable),this._redrawFilter()},i.prototype.setData=function(t){this._readData(t),this.redraw(),this.animationAutoStart&&this.dataFilter&&this.animationStart()},i.prototype.setOptions=function(t){this.animationStop(),v.setOptions(t,this),this.setPointDrawingMethod(),this._setSize(this.width,this.height),this.dataTable&&this.setData(this.dataTable),this.animationAutoStart&&this.dataFilter&&this.animationStart()},i.prototype.setPointDrawingMethod=function(){var t=void 0;switch(this.style){case i.STYLE.BAR:t=i.prototype._redrawBarGraphPoint;break;case i.STYLE.BARCOLOR:t=i.prototype._redrawBarColorGraphPoint;break;case i.STYLE.BARSIZE:t=i.prototype._redrawBarSizeGraphPoint;break;case i.STYLE.DOT:t=i.prototype._redrawDotGraphPoint;break;case i.STYLE.DOTLINE:t=i.prototype._redrawDotLineGraphPoint;break;case i.STYLE.DOTCOLOR:t=i.prototype._redrawDotColorGraphPoint;break;case i.STYLE.DOTSIZE:t=i.prototype._redrawDotSizeGraphPoint;break;case i.STYLE.SURFACE:t=i.prototype._redrawSurfaceGraphPoint;break;case i.STYLE.GRID:t=i.prototype._redrawGridGraphPoint;break;case i.STYLE.LINE:t=i.prototype._redrawLineGraphPoint;break;default:throw new Error("Can not determine point drawing method for graph style '"+this.style+"'")}this._pointDrawingMethod=t},i.prototype.redraw=function(){if(void 0===this.dataPoints)throw new Error("Graph data not initialized");this._resizeCanvas(),this._resizeCenter(),this._redrawSlider(),this._redrawClear(),this._redrawAxis(),this._redrawDataGraph(),this._redrawInfo(),this._redrawLegend()},i.prototype._getContext=function(){var t=this.frame.canvas,e=t.getContext("2d");return e.lineJoin="round",e.lineCap="round",e},i.prototype._redrawClear=function(){var t=this.frame.canvas,e=t.getContext("2d");e.clearRect(0,0,t.width,t.height)},i.prototype._dotSize=function(){return this.frame.clientWidth*this.dotSizeRatio},i.prototype._getLegendWidth=function(){var t;if(this.style===i.STYLE.DOTSIZE){var e=this._dotSize();t=e/2+2*e}else t=this.style===i.STYLE.BARSIZE?this.xBarWidth:20;return t},i.prototype._redrawLegend=function(){if(this.showLegend===!0&&this.style!==i.STYLE.LINE&&this.style!==i.STYLE.BARSIZE){var t=this.style===i.STYLE.BARSIZE||this.style===i.STYLE.DOTSIZE,e=this.style===i.STYLE.DOTSIZE||this.style===i.STYLE.DOTCOLOR||this.style===i.STYLE.BARCOLOR,n=Math.max(.25*this.frame.clientHeight,100),r=this.margin,o=this._getLegendWidth(),s=this.frame.clientWidth-this.margin,a=s-o,h=r+n,u=this._getContext();if(u.lineWidth=1,u.font="14px arial",t===!1){var l,f=0,d=n;for(l=f;l<d;l++){var m=(l-f)/(d-f),v=240*m,y=this._hsv2rgb(v,1,1);u.strokeStyle=y,u.beginPath(),u.moveTo(a,r+l),u.lineTo(s,r+l),u.stroke()}u.strokeStyle=this.axisColor,u.strokeRect(a,r,o,n)}else{var g;if(this.style===i.STYLE.DOTSIZE){var _=this._dotSize();g=_/2}else this.style===i.STYLE.BARSIZE;u.strokeStyle=this.axisColor,u.fillStyle=this.dataColor.fill,u.beginPath(),u.moveTo(a,r),u.lineTo(s,r),u.lineTo(s-o+g,h),u.lineTo(a,h),u.closePath(),u.fill(),u.stroke()}var w=5,x=e?this.valueRange.min:this.zRange.min,b=e?this.valueRange.max:this.zRange.max,S=new p(x,b,(b-x)/5,!0);S.start(!0);for(var l,T,D;!S.end();)l=h-(S.getCurrent()-x)/(b-x)*n,T=new c(a-w,l),D=new c(a,l),this._line(u,T,D),u.textAlign="right",u.textBaseline="middle",u.fillStyle=this.axisColor,u.fillText(S.getCurrent(),a-2*w,l),S.next();u.textAlign="right",u.textBaseline="top";var M=this.legendLabel;u.fillText(M,s,h+this.margin)}},i.prototype._redrawFilter=function(){if(this.frame.filter.innerHTML="",this.dataFilter){var t={visible:this.showAnimationControls},e=new d(this.frame.filter,t);this.frame.filter.slider=e,this.frame.filter.style.padding="10px",e.setValues(this.dataFilter.values),e.setPlayInterval(this.animationInterval);var n=this,i=function(){var t=e.getIndex();n.dataFilter.selectValue(t),n.dataPoints=n.dataFilter._getDataPoints(),n.redraw()};e.setOnChangeCallback(i)}else this.frame.filter.slider=void 0},i.prototype._redrawSlider=function(){void 0!==this.frame.filter.slider&&this.frame.filter.slider.redraw()},i.prototype._redrawInfo=function(){if(this.dataFilter){var t=this._getContext();t.font="14px arial",t.lineStyle="gray",t.fillStyle="gray",t.textAlign="left",t.textBaseline="top";var e=this.margin,n=this.margin;t.fillText(this.dataFilter.getLabel()+": "+this.dataFilter.getSelectedValue(),e,n)}},i.prototype._line=function(t,e,n,i){void 0!==i&&(t.strokeStyle=i),t.beginPath(),t.moveTo(e.x,e.y),t.lineTo(n.x,n.y),t.stroke()},i.prototype.drawAxisLabelX=function(t,e,n,i,r){void 0===r&&(r=0);var o=this._convert3Dto2D(e);Math.cos(2*i)>0?(t.textAlign="center",t.textBaseline="top",o.y+=r):Math.sin(2*i)<0?(t.textAlign="right",t.textBaseline="middle"):(t.textAlign="left",t.textBaseline="middle"),t.fillStyle=this.axisColor,t.fillText(n,o.x,o.y)},i.prototype.drawAxisLabelY=function(t,e,n,i,r){void 0===r&&(r=0);var o=this._convert3Dto2D(e);Math.cos(2*i)<0?(t.textAlign="center",t.textBaseline="top",o.y+=r):Math.sin(2*i)>0?(t.textAlign="right",t.textBaseline="middle"):(t.textAlign="left",t.textBaseline="middle"),t.fillStyle=this.axisColor,t.fillText(n,o.x,o.y)},i.prototype.drawAxisLabelZ=function(t,e,n,i){void 0===i&&(i=0);var r=this._convert3Dto2D(e);t.textAlign="right",t.textBaseline="middle",t.fillStyle=this.axisColor,t.fillText(n,r.x-i,r.y)},i.prototype._line3d=function(t,e,n,i){var r=this._convert3Dto2D(e),o=this._convert3Dto2D(n);this._line(t,r,o,i)},i.prototype._redrawAxis=function(){var t,e,n,i,r,o,s,a,h,u,f,d=this._getContext();d.font=24/this.camera.getArmLength()+"px arial";var m=.025/this.scale.x,v=.025/this.scale.y,y=5/this.camera.getArmLength(),g=this.camera.getArmRotation().horizontal,_=new c(Math.cos(g),Math.sin(g)),w=this.xRange,x=this.yRange,b=this.zRange;for(d.lineWidth=1,i=void 0===this.defaultXStep,n=new p(w.min,w.max,this.xStep,i),n.start(!0);!n.end();){var S=n.getCurrent();this.showGrid?(t=new l(S,x.min,b.min),e=new l(S,x.max,b.min),this._line3d(d,t,e,this.gridColor)):(t=new l(S,x.min,b.min),e=new l(S,x.min+m,b.min),this._line3d(d,t,e,this.axisColor),t=new l(S,x.max,b.min),e=new l(S,x.max-m,b.min),this._line3d(d,t,e,this.axisColor)),s=_.x>0?x.min:x.max;var T=new l(S,s,b.min),D="  "+this.xValueLabel(S)+"  ";this.drawAxisLabelX(d,T,D,g,y),n.next()}for(d.lineWidth=1,i=void 0===this.defaultYStep,n=new p(x.min,x.max,this.yStep,i),n.start(!0);!n.end();){var M=n.getCurrent();this.showGrid?(t=new l(w.min,M,b.min),e=new l(w.max,M,b.min),this._line3d(d,t,e,this.gridColor)):(t=new l(w.min,M,b.min),e=new l(w.min+v,M,b.min),this._line3d(d,t,e,this.axisColor),t=new l(w.max,M,b.min),e=new l(w.max-v,M,b.min),this._line3d(d,t,e,this.axisColor)),o=_.y>0?w.min:w.max,T=new l(o,M,b.min);var D="  "+this.yValueLabel(M)+"  ";this.drawAxisLabelY(d,T,D,g,y),n.next()}for(d.lineWidth=1,i=void 0===this.defaultZStep,n=new p(b.min,b.max,this.zStep,i),n.start(!0),o=_.x>0?w.min:w.max,s=_.y<0?x.min:x.max;!n.end();){var k=n.getCurrent(),O=new l(o,s,k),E=this._convert3Dto2D(O);e=new c(E.x-y,E.y),this._line(d,E,e,this.axisColor);var D=this.zValueLabel(k)+" ";this.drawAxisLabelZ(d,O,D,5),n.next()}d.lineWidth=1,t=new l(o,s,b.min),e=new l(o,s,b.max),this._line3d(d,t,e,this.axisColor);var C,P;d.lineWidth=1,C=new l(w.min,x.min,b.min),P=new l(w.max,x.min,b.min),this._line3d(d,C,P,this.axisColor),C=new l(w.min,x.max,b.min),P=new l(w.max,x.max,b.min),this._line3d(d,C,P,this.axisColor),d.lineWidth=1,t=new l(w.min,x.min,b.min),e=new l(w.min,x.max,b.min),this._line3d(d,t,e,this.axisColor),t=new l(w.max,x.min,b.min),e=new l(w.max,x.max,b.min),this._line3d(d,t,e,this.axisColor);var L=this.xLabel;L.length>0&&(f=.1/this.scale.y,o=(w.max+3*w.min)/4,s=_.x>0?x.min-f:x.max+f,r=new l(o,s,b.min),this.drawAxisLabelX(d,r,L,g));var Y=this.yLabel;Y.length>0&&(u=.1/this.scale.x,o=_.y>0?w.min-u:w.max+u,s=(x.max+3*x.min)/4,r=new l(o,s,b.min),this.drawAxisLabelY(d,r,Y,g));var R=this.zLabel;R.length>0&&(h=30,o=_.x>0?w.min:w.max,s=_.y<0?x.min:x.max,a=(b.max+3*b.min)/4,r=new l(o,s,a),this.drawAxisLabelZ(d,r,R,h))},i.prototype._hsv2rgb=function(t,e,n){var i,r,o,s,a,h;switch(s=n*e,a=Math.floor(t/60),h=s*(1-Math.abs(t/60%2-1)),a){case 0:i=s,r=h,o=0;break;case 1:i=h,r=s,o=0;break;case 2:i=0,r=s,o=h;break;case 3:i=0,r=h,o=s;break;case 4:i=h,r=0,o=s;break;case 5:i=s,r=0,o=h;break;default:i=0,r=0,o=0}return"RGB("+parseInt(255*i)+","+parseInt(255*r)+","+parseInt(255*o)+")"},i.prototype._getStrokeWidth=function(t){return void 0!==t?this.showPerspective?1/-t.trans.z*this.dataColor.strokeWidth:-(this.eye.z/this.camera.getArmLength())*this.dataColor.strokeWidth:this.dataColor.strokeWidth},i.prototype._redrawBar=function(t,e,n,i,r,o){var s,a,h=this,u=e.point,c=this.zRange.min,f=[{point:new l(u.x-n,u.y-i,u.z)},{point:new l(u.x+n,u.y-i,u.z)},{point:new l(u.x+n,u.y+i,u.z)},{point:new l(u.x-n,u.y+i,u.z)}],d=[{point:new l(u.x-n,u.y-i,c)},{point:new l(u.x+n,u.y-i,c)},{point:new l(u.x+n,u.y+i,c)},{point:new l(u.x-n,u.y+i,c)}];f.forEach(function(t){t.screen=h._convert3Dto2D(t.point)}),d.forEach(function(t){t.screen=h._convert3Dto2D(t.point)});var p=[{corners:f,center:l.avg(d[0].point,d[2].point)},{corners:[f[0],f[1],d[1],d[0]],center:l.avg(d[1].point,d[0].point)},{corners:[f[1],f[2],d[2],d[1]],center:l.avg(d[2].point,d[1].point)},{corners:[f[2],f[3],d[3],d[2]],center:l.avg(d[3].point,d[2].point)},{corners:[f[3],f[0],d[0],d[3]],center:l.avg(d[0].point,d[3].point)}];for(e.surfaces=p,s=0;s<p.length;s++){a=p[s];var m=this._convertPointToTranslation(a.center);a.dist=this.showPerspective?m.length():-m.z}for(p.sort(function(t,e){var n=e.dist-t.dist;return n?n:t.corners===f?1:e.corners===f?-1:0}),t.lineWidth=this._getStrokeWidth(e),t.strokeStyle=o,t.fillStyle=r,s=2;s<p.length;s++)a=p[s],this._polygon(t,a.corners)},i.prototype._polygon=function(t,e,n,i){if(!(e.length<2)){void 0!==n&&(t.fillStyle=n),void 0!==i&&(t.strokeStyle=i),t.beginPath(),t.moveTo(e[0].screen.x,e[0].screen.y);for(var r=1;r<e.length;++r){var o=e[r];t.lineTo(o.screen.x,o.screen.y)}t.closePath(),t.fill(),t.stroke()}},i.prototype._drawCircle=function(t,e,n,i,r){var o=this._calcRadius(e,r);t.lineWidth=this._getStrokeWidth(e),t.strokeStyle=i,t.fillStyle=n,t.beginPath(),t.arc(e.screen.x,e.screen.y,o,0,2*Math.PI,!0),t.fill(),t.stroke()},i.prototype._getColorsRegular=function(t){var e=240*(1-(t.point.z-this.zRange.min)*this.scale.z/this.verticalRatio),n=this._hsv2rgb(e,1,1),i=this._hsv2rgb(e,1,.8);return{fill:n,border:i}},i.prototype._getColorsColor=function(t){var e,n;if("string"==typeof t.point.value)e=t.point.value,n=t.point.value;else{var i=240*(1-(t.point.value-this.valueRange.min)*this.scale.value);e=this._hsv2rgb(i,1,1),n=this._hsv2rgb(i,1,.8)}return{fill:e,border:n}},i.prototype._getColorsSize=function(){return{fill:this.dataColor.fill,border:this.dataColor.stroke}},i.prototype._calcRadius=function(t,e){void 0===e&&(e=this._dotSize());var n;return n=this.showPerspective?e/-t.trans.z:e*-(this.eye.z/this.camera.getArmLength()),n<0&&(n=0),n},i.prototype._redrawBarGraphPoint=function(t,e){var n=this.xBarWidth/2,i=this.yBarWidth/2,r=this._getColorsRegular(e);this._redrawBar(t,e,n,i,r.fill,r.border)},i.prototype._redrawBarColorGraphPoint=function(t,e){var n=this.xBarWidth/2,i=this.yBarWidth/2,r=this._getColorsColor(e);this._redrawBar(t,e,n,i,r.fill,r.border)},i.prototype._redrawBarSizeGraphPoint=function(t,e){var n=(e.point.value-this.valueRange.min)/this.valueRange.range(),i=this.xBarWidth/2*(.8*n+.2),r=this.yBarWidth/2*(.8*n+.2),o=this._getColorsSize();this._redrawBar(t,e,i,r,o.fill,o.border)},i.prototype._redrawDotGraphPoint=function(t,e){var n=this._getColorsRegular(e);this._drawCircle(t,e,n.fill,n.border)},i.prototype._redrawDotLineGraphPoint=function(t,e){var n=this._convert3Dto2D(e.bottom);t.lineWidth=1,this._line(t,n,e.screen,this.gridColor),this._redrawDotGraphPoint(t,e)},i.prototype._redrawDotColorGraphPoint=function(t,e){var n=this._getColorsColor(e);this._drawCircle(t,e,n.fill,n.border)},i.prototype._redrawDotSizeGraphPoint=function(t,e){var n=this._dotSize(),i=(e.point.value-this.valueRange.min)/this.valueRange.range(),r=n/2+2*n*i,o=this._getColorsSize();this._drawCircle(t,e,o.fill,o.border,r)},i.prototype._redrawSurfaceGraphPoint=function(t,e){var n=e.pointRight,i=e.pointTop,r=e.pointCross;if(void 0!==e&&void 0!==n&&void 0!==i&&void 0!==r){var o,s,a=!0;if(this.showGrayBottom||this.showShadow){var h=l.subtract(r.trans,e.trans),u=l.subtract(i.trans,n.trans),c=l.crossProduct(h,u),f=c.length();a=c.z>0}if(a){var d,p=(e.point.z+n.point.z+i.point.z+r.point.z)/4,m=240*(1-(p-this.zRange.min)*this.scale.z/this.verticalRatio),v=1;this.showShadow?(d=Math.min(1+c.x/f/2,1),o=this._hsv2rgb(m,v,d),s=o):(d=1,o=this._hsv2rgb(m,v,d),s=this.axisColor)}else o="gray",s=this.axisColor;t.lineWidth=this._getStrokeWidth(e);var y=[e,n,r,i];this._polygon(t,y,o,s)}},i.prototype._drawGridLine=function(t,e,n){if(void 0!==e&&void 0!==n){var i=(e.point.z+n.point.z)/2,r=240*(1-(i-this.zRange.min)*this.scale.z/this.verticalRatio);t.lineWidth=2*this._getStrokeWidth(e),t.strokeStyle=this._hsv2rgb(r,1,1),this._line(t,e.screen,n.screen)}},i.prototype._redrawGridGraphPoint=function(t,e){this._drawGridLine(t,e,e.pointRight),this._drawGridLine(t,e,e.pointTop)},i.prototype._redrawLineGraphPoint=function(t,e){void 0!==e.pointNext&&(t.lineWidth=this._getStrokeWidth(e),t.strokeStyle=this.dataColor.stroke,this._line(t,e.screen,e.pointNext.screen))},i.prototype._redrawDataGraph=function(){var t,e=this._getContext();if(!(void 0===this.dataPoints||this.dataPoints.length<=0))for(this._calcTranslations(this.dataPoints),t=0;t<this.dataPoints.length;t++){var n=this.dataPoints[t];this._pointDrawingMethod.call(this,e,n)}},i.prototype._storeMousePosition=function(t){this.startMouseX=r(t),this.startMouseY=o(t),this._startCameraOffset=this.camera.getOffset()},i.prototype._onMouseDown=function(t){if(t=t||window.event,this.leftButtonDown&&this._onMouseUp(t),this.leftButtonDown=t.which?1===t.which:1===t.button,this.leftButtonDown||this.touchDown){this._storeMousePosition(t),this.startStart=new Date(this.start),this.startEnd=new Date(this.end),this.startArmRotation=this.camera.getArmRotation(),this.frame.style.cursor="move";var e=this;this.onmousemove=function(t){e._onMouseMove(t)},this.onmouseup=function(t){e._onMouseUp(t)},u.addEventListener(document,"mousemove",e.onmousemove),u.addEventListener(document,"mouseup",e.onmouseup),u.preventDefault(t)}},i.prototype._onMouseMove=function(t){this.moving=!0,t=t||window.event;var e=parseFloat(r(t))-this.startMouseX,n=parseFloat(o(t))-this.startMouseY;if(t&&t.ctrlKey===!0){var i=.5*this.frame.clientWidth,s=.5*this.frame.clientHeight,a=(this._startCameraOffset.x||0)-e/i*this.camera.armLength*.8,h=(this._startCameraOffset.y||0)+n/s*this.camera.armLength*.8;this.camera.setOffset(a,h),this._storeMousePosition(t)}else{var l=this.startArmRotation.horizontal+e/200,c=this.startArmRotation.vertical+n/200,f=4,d=Math.sin(f/360*2*Math.PI);Math.abs(Math.sin(l))<d&&(l=Math.round(l/Math.PI)*Math.PI-.001),Math.abs(Math.cos(l))<d&&(l=(Math.round(l/Math.PI-.5)+.5)*Math.PI-.001),Math.abs(Math.sin(c))<d&&(c=Math.round(c/Math.PI)*Math.PI),Math.abs(Math.cos(c))<d&&(c=(Math.round(c/Math.PI-.5)+.5)*Math.PI),this.camera.setArmRotation(l,c)}this.redraw();var p=this.getCameraPosition();this.emit("cameraPositionChange",p),u.preventDefault(t)},i.prototype._onMouseUp=function(t){this.frame.style.cursor="auto",this.leftButtonDown=!1,u.removeEventListener(document,"mousemove",this.onmousemove),u.removeEventListener(document,"mouseup",this.onmouseup),u.preventDefault(t)},i.prototype._onClick=function(t){if(this.onclick_callback){if(this.moving)this.moving=!1;else{var e=this.frame.getBoundingClientRect(),n=r(t)-e.left,i=o(t)-e.top,s=this._dataPointFromXY(n,i);s&&this.onclick_callback(s.point.data)}u.preventDefault(t)}},i.prototype._onTooltip=function(t){var e=300,n=this.frame.getBoundingClientRect(),i=r(t)-n.left,s=o(t)-n.top;if(this.showTooltip){if(this.tooltipTimeout&&clearTimeout(this.tooltipTimeout),this.leftButtonDown)return void this._hideTooltip();if(this.tooltip&&this.tooltip.dataPoint){var a=this._dataPointFromXY(i,s);a!==this.tooltip.dataPoint&&(a?this._showTooltip(a):this._hideTooltip())}else{var h=this;this.tooltipTimeout=setTimeout(function(){h.tooltipTimeout=null;var t=h._dataPointFromXY(i,s);t&&h._showTooltip(t)},e)}}},i.prototype._onTouchStart=function(t){this.touchDown=!0;var e=this;this.ontouchmove=function(t){e._onTouchMove(t)},this.ontouchend=function(t){e._onTouchEnd(t)},u.addEventListener(document,"touchmove",e.ontouchmove),u.addEventListener(document,"touchend",e.ontouchend),this._onMouseDown(t)},i.prototype._onTouchMove=function(t){this._onMouseMove(t)},i.prototype._onTouchEnd=function(t){this.touchDown=!1,u.removeEventListener(document,"touchmove",this.ontouchmove),u.removeEventListener(document,"touchend",this.ontouchend),this._onMouseUp(t)},i.prototype._onWheel=function(t){t||(t=window.event);var e=0;if(t.wheelDelta?e=t.wheelDelta/120:t.detail&&(e=-t.detail/3),e){var n=this.camera.getArmLength(),i=n*(1-e/10);this.camera.setArmLength(i),this.redraw(),this._hideTooltip()}var r=this.getCameraPosition();this.emit("cameraPositionChange",r),u.preventDefault(t)},i.prototype._insideTriangle=function(t,e){function n(t){return t>0?1:t<0?-1:0}var i=e[0],r=e[1],o=e[2],s=n((r.x-i.x)*(t.y-i.y)-(r.y-i.y)*(t.x-i.x)),a=n((o.x-r.x)*(t.y-r.y)-(o.y-r.y)*(t.x-r.x)),h=n((i.x-o.x)*(t.y-o.y)-(i.y-o.y)*(t.x-o.x));return!(0!=s&&0!=a&&s!=a||0!=a&&0!=h&&a!=h||0!=s&&0!=h&&s!=h)},i.prototype._dataPointFromXY=function(t,e){var n,r=100,o=null,s=null,a=null,h=new c(t,e);if(this.style===i.STYLE.BAR||this.style===i.STYLE.BARCOLOR||this.style===i.STYLE.BARSIZE)for(n=this.dataPoints.length-1;n>=0;n--){o=this.dataPoints[n];var u=o.surfaces;if(u)for(var l=u.length-1;l>=0;l--){var f=u[l],d=f.corners,p=[d[0].screen,d[1].screen,d[2].screen],m=[d[2].screen,d[3].screen,d[0].screen];if(this._insideTriangle(h,p)||this._insideTriangle(h,m))return o}}else for(n=0;n<this.dataPoints.length;n++){o=this.dataPoints[n];var v=o.screen;if(v){var y=Math.abs(t-v.x),g=Math.abs(e-v.y),_=Math.sqrt(y*y+g*g);(null===a||_<a)&&_<r&&(a=_,s=o)}}return s},i.prototype._showTooltip=function(t){var e,n,i;this.tooltip?(e=this.tooltip.dom.content,n=this.tooltip.dom.line,i=this.tooltip.dom.dot):(e=document.createElement("div"),e.style.position="absolute",e.style.padding="10px",e.style.border="1px solid #4d4d4d",e.style.color="#1a1a1a",e.style.background="rgba(255,255,255,0.7)",e.style.borderRadius="2px",e.style.boxShadow="5px 5px 10px rgba(128,128,128,0.5)",n=document.createElement("div"),n.style.position="absolute",n.style.height="40px",n.style.width="0",n.style.borderLeft="1px solid #4d4d4d",i=document.createElement("div"),i.style.position="absolute",i.style.height="0",i.style.width="0",i.style.border="5px solid #4d4d4d",i.style.borderRadius="5px",this.tooltip={dataPoint:null,dom:{content:e,line:n,dot:i}}),this._hideTooltip(),this.tooltip.dataPoint=t,"function"==typeof this.showTooltip?e.innerHTML=this.showTooltip(t.point):e.innerHTML="<table><tr><td>"+this.xLabel+":</td><td>"+t.point.x+"</td></tr><tr><td>"+this.yLabel+":</td><td>"+t.point.y+"</td></tr><tr><td>"+this.zLabel+":</td><td>"+t.point.z+"</td></tr></table>",e.style.left="0",e.style.top="0",this.frame.appendChild(e),this.frame.appendChild(n),this.frame.appendChild(i);var r=e.offsetWidth,o=e.offsetHeight,s=n.offsetHeight,a=i.offsetWidth,h=i.offsetHeight,u=t.screen.x-r/2;u=Math.min(Math.max(u,10),this.frame.clientWidth-10-r),n.style.left=t.screen.x+"px",n.style.top=t.screen.y-s+"px",e.style.left=u+"px",e.style.top=t.screen.y-s-o+"px",i.style.left=t.screen.x-a/2+"px",i.style.top=t.screen.y-h/2+"px"},i.prototype._hideTooltip=function(){if(this.tooltip){this.tooltip.dataPoint=null;for(var t in this.tooltip.dom)if(this.tooltip.dom.hasOwnProperty(t)){var e=this.tooltip.dom[t];e&&e.parentNode&&e.parentNode.removeChild(e)}}},i.prototype.setCameraPosition=function(t){v.setCameraPosition(t,this),this.redraw()},i.prototype.setSize=function(t,e){this._setSize(t,e),this.redraw()},t.exports=i},function(t,e){function n(t){if(t)return i(t)}function i(t){for(var e in n.prototype)t[e]=n.prototype[e];return t}t.exports=n,n.prototype.on=n.prototype.addEventListener=function(t,e){return this._callbacks=this._callbacks||{},(this._callbacks[t]=this._callbacks[t]||[]).push(e),this},n.prototype.once=function(t,e){function n(){i.off(t,n),e.apply(this,arguments)}var i=this;return this._callbacks=this._callbacks||{},n.fn=e,this.on(t,n),this},n.prototype.off=n.prototype.removeListener=n.prototype.removeAllListeners=n.prototype.removeEventListener=function(t,e){if(this._callbacks=this._callbacks||{},0==arguments.length)return this._callbacks={},this;var n=this._callbacks[t];if(!n)return this;if(1==arguments.length)return delete this._callbacks[t],this;for(var i,r=0;r<n.length;r++)if(i=n[r],i===e||i.fn===e){n.splice(r,1);break}return this},n.prototype.emit=function(t){this._callbacks=this._callbacks||{};var e=[].slice.call(arguments,1),n=this._callbacks[t];if(n){n=n.slice(0);for(var i=0,r=n.length;i<r;++i)n[i].apply(this,e)}return this},n.prototype.listeners=function(t){return this._callbacks=this._callbacks||{},this._callbacks[t]||[]},n.prototype.hasListeners=function(t){return!!this.listeners(t).length}},function(t,e){function n(t,e,n){this.x=void 0!==t?t:0,this.y=void 0!==e?e:0,this.z=void 0!==n?n:0}n.subtract=function(t,e){var i=new n;return i.x=t.x-e.x,i.y=t.y-e.y,i.z=t.z-e.z,i},n.add=function(t,e){var i=new n;return i.x=t.x+e.x,i.y=t.y+e.y,i.z=t.z+e.z,i},n.avg=function(t,e){return new n((t.x+e.x)/2,(t.y+e.y)/2,(t.z+e.z)/2)},n.crossProduct=function(t,e){var i=new n;return i.x=t.y*e.z-t.z*e.y,i.y=t.z*e.x-t.x*e.z,i.z=t.x*e.y-t.y*e.x,i},n.prototype.length=function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},t.exports=n},function(t,e){function n(t,e){this.x=void 0!==t?t:0,this.y=void 0!==e?e:0}t.exports=n},function(t,e,n){function i(t){return t&&t.__esModule?t:{
default:t}}function r(){this.armLocation=new a,this.armRotation={},this.armRotation.horizontal=0,this.armRotation.vertical=0,this.armLength=1.7,this.cameraOffset=new a,this.offsetMultiplier=.6,this.cameraLocation=new a,this.cameraRotation=new a(.5*Math.PI,0,0),this.calculateCameraOrientation()}var o=n(98),s=i(o),a=n(95);r.prototype.setOffset=function(t,e){var n=Math.abs,i=s.default,r=this.offsetMultiplier,o=this.armLength*r;n(t)>o&&(t=i(t)*o),n(e)>o&&(e=i(e)*o),this.cameraOffset.x=t,this.cameraOffset.y=e,this.calculateCameraOrientation()},r.prototype.getOffset=function(t,e){return this.cameraOffset},r.prototype.setArmLocation=function(t,e,n){this.armLocation.x=t,this.armLocation.y=e,this.armLocation.z=n,this.calculateCameraOrientation()},r.prototype.setArmRotation=function(t,e){void 0!==t&&(this.armRotation.horizontal=t),void 0!==e&&(this.armRotation.vertical=e,this.armRotation.vertical<0&&(this.armRotation.vertical=0),this.armRotation.vertical>.5*Math.PI&&(this.armRotation.vertical=.5*Math.PI)),void 0===t&&void 0===e||this.calculateCameraOrientation()},r.prototype.getArmRotation=function(){var t={};return t.horizontal=this.armRotation.horizontal,t.vertical=this.armRotation.vertical,t},r.prototype.setArmLength=function(t){void 0!==t&&(this.armLength=t,this.armLength<.71&&(this.armLength=.71),this.armLength>5&&(this.armLength=5),this.setOffset(this.cameraOffset.x,this.cameraOffset.y),this.calculateCameraOrientation())},r.prototype.getArmLength=function(){return this.armLength},r.prototype.getCameraLocation=function(){return this.cameraLocation},r.prototype.getCameraRotation=function(){return this.cameraRotation},r.prototype.calculateCameraOrientation=function(){this.cameraLocation.x=this.armLocation.x-this.armLength*Math.sin(this.armRotation.horizontal)*Math.cos(this.armRotation.vertical),this.cameraLocation.y=this.armLocation.y-this.armLength*Math.cos(this.armRotation.horizontal)*Math.cos(this.armRotation.vertical),this.cameraLocation.z=this.armLocation.z+this.armLength*Math.sin(this.armRotation.vertical),this.cameraRotation.x=Math.PI/2-this.armRotation.vertical,this.cameraRotation.y=0,this.cameraRotation.z=-this.armRotation.horizontal;var t=this.cameraRotation.x,e=(this.cameraRotation.y,this.cameraRotation.z),n=this.cameraOffset.x,i=this.cameraOffset.y,r=Math.sin,o=Math.cos;this.cameraLocation.x=this.cameraLocation.x+n*o(e)+i*-r(e)*o(t),this.cameraLocation.y=this.cameraLocation.y+n*r(e)+i*o(e)*o(t),this.cameraLocation.z=this.cameraLocation.z+i*r(t)},t.exports=r},function(t,e,n){t.exports={default:n(99),__esModule:!0}},function(t,e,n){n(100),t.exports=n(17).Math.sign},function(t,e,n){var i=n(15);i(i.S,"Math",{sign:n(101)})},function(t,e){t.exports=Math.sign||function(t){return 0==(t=+t)||t!=t?t:t<0?-1:1}},function(t,e,n){function i(t,e,n){this.data=t,this.column=e,this.graph=n,this.index=void 0,this.value=void 0,this.values=n.getDistinctValues(t.get(),this.column),this.values.sort(function(t,e){return t>e?1:t<e?-1:0}),this.values.length>0&&this.selectValue(0),this.dataPoints=[],this.loaded=!1,this.onLoadCallback=void 0,n.animationPreload?(this.loaded=!1,this.loadInBackground()):this.loaded=!0}var r=n(92);i.prototype.isLoaded=function(){return this.loaded},i.prototype.getLoadedProgress=function(){for(var t=this.values.length,e=0;this.dataPoints[e];)e++;return Math.round(e/t*100)},i.prototype.getLabel=function(){return this.graph.filterLabel},i.prototype.getColumn=function(){return this.column},i.prototype.getSelectedValue=function(){if(void 0!==this.index)return this.values[this.index]},i.prototype.getValues=function(){return this.values},i.prototype.getValue=function(t){if(t>=this.values.length)throw new Error("Index out of range");return this.values[t]},i.prototype._getDataPoints=function(t){if(void 0===t&&(t=this.index),void 0===t)return[];var e;if(this.dataPoints[t])e=this.dataPoints[t];else{var n={};n.column=this.column,n.value=this.values[t];var i=new r(this.data,{filter:function(t){return t[n.column]==n.value}}).get();e=this.graph._getDataPoints(i),this.dataPoints[t]=e}return e},i.prototype.setOnLoadCallback=function(t){this.onLoadCallback=t},i.prototype.selectValue=function(t){if(t>=this.values.length)throw new Error("Index out of range");this.index=t,this.value=this.values[t]},i.prototype.loadInBackground=function(t){void 0===t&&(t=0);var e=this.graph.frame;if(t<this.values.length){this._getDataPoints(t);void 0===e.progress&&(e.progress=document.createElement("DIV"),e.progress.style.position="absolute",e.progress.style.color="gray",e.appendChild(e.progress));var n=this.getLoadedProgress();e.progress.innerHTML="Loading animation... "+n+"%",e.progress.style.bottom="60px",e.progress.style.left="10px";var i=this;setTimeout(function(){i.loadInBackground(t+1)},10),this.loaded=!1}else this.loaded=!0,void 0!==e.progress&&(e.removeChild(e.progress),e.progress=void 0),this.onLoadCallback&&this.onLoadCallback()},t.exports=i},function(t,e,n){function i(t,e){if(void 0===t)throw new Error("No container element defined");if(this.container=t,this.visible=!e||void 0==e.visible||e.visible,this.visible){this.frame=document.createElement("DIV"),this.frame.style.width="100%",this.frame.style.position="relative",this.container.appendChild(this.frame),this.frame.prev=document.createElement("INPUT"),this.frame.prev.type="BUTTON",this.frame.prev.value="Prev",this.frame.appendChild(this.frame.prev),this.frame.play=document.createElement("INPUT"),this.frame.play.type="BUTTON",this.frame.play.value="Play",this.frame.appendChild(this.frame.play),this.frame.next=document.createElement("INPUT"),this.frame.next.type="BUTTON",this.frame.next.value="Next",this.frame.appendChild(this.frame.next),this.frame.bar=document.createElement("INPUT"),this.frame.bar.type="BUTTON",this.frame.bar.style.position="absolute",this.frame.bar.style.border="1px solid red",this.frame.bar.style.width="100px",this.frame.bar.style.height="6px",this.frame.bar.style.borderRadius="2px",this.frame.bar.style.MozBorderRadius="2px",this.frame.bar.style.border="1px solid #7F7F7F",this.frame.bar.style.backgroundColor="#E5E5E5",this.frame.appendChild(this.frame.bar),this.frame.slide=document.createElement("INPUT"),this.frame.slide.type="BUTTON",this.frame.slide.style.margin="0px",this.frame.slide.value=" ",this.frame.slide.style.position="relative",this.frame.slide.style.left="-100px",this.frame.appendChild(this.frame.slide);var n=this;this.frame.slide.onmousedown=function(t){n._onMouseDown(t)},this.frame.prev.onclick=function(t){n.prev(t)},this.frame.play.onclick=function(t){n.togglePlay(t)},this.frame.next.onclick=function(t){n.next(t)}}this.onChangeCallback=void 0,this.values=[],this.index=void 0,this.playTimeout=void 0,this.playInterval=1e3,this.playLoop=!0}var r=n(1);i.prototype.prev=function(){var t=this.getIndex();t>0&&(t--,this.setIndex(t))},i.prototype.next=function(){var t=this.getIndex();t<this.values.length-1&&(t++,this.setIndex(t))},i.prototype.playNext=function(){var t=new Date,e=this.getIndex();e<this.values.length-1?(e++,this.setIndex(e)):this.playLoop&&(e=0,this.setIndex(e));var n=new Date,i=n-t,r=Math.max(this.playInterval-i,0),o=this;this.playTimeout=setTimeout(function(){o.playNext()},r)},i.prototype.togglePlay=function(){void 0===this.playTimeout?this.play():this.stop()},i.prototype.play=function(){this.playTimeout||(this.playNext(),this.frame&&(this.frame.play.value="Stop"))},i.prototype.stop=function(){clearInterval(this.playTimeout),this.playTimeout=void 0,this.frame&&(this.frame.play.value="Play")},i.prototype.setOnChangeCallback=function(t){this.onChangeCallback=t},i.prototype.setPlayInterval=function(t){this.playInterval=t},i.prototype.getPlayInterval=function(t){return this.playInterval},i.prototype.setPlayLoop=function(t){this.playLoop=t},i.prototype.onChange=function(){void 0!==this.onChangeCallback&&this.onChangeCallback()},i.prototype.redraw=function(){if(this.frame){this.frame.bar.style.top=this.frame.clientHeight/2-this.frame.bar.offsetHeight/2+"px",this.frame.bar.style.width=this.frame.clientWidth-this.frame.prev.clientWidth-this.frame.play.clientWidth-this.frame.next.clientWidth-30+"px";var t=this.indexToLeft(this.index);this.frame.slide.style.left=t+"px"}},i.prototype.setValues=function(t){this.values=t,this.values.length>0?this.setIndex(0):this.index=void 0},i.prototype.setIndex=function(t){if(!(t<this.values.length))throw new Error("Index out of range");this.index=t,this.redraw(),this.onChange()},i.prototype.getIndex=function(){return this.index},i.prototype.get=function(){return this.values[this.index]},i.prototype._onMouseDown=function(t){var e=t.which?1===t.which:1===t.button;if(e){this.startClientX=t.clientX,this.startSlideX=parseFloat(this.frame.slide.style.left),this.frame.style.cursor="move";var n=this;this.onmousemove=function(t){n._onMouseMove(t)},this.onmouseup=function(t){n._onMouseUp(t)},r.addEventListener(document,"mousemove",this.onmousemove),r.addEventListener(document,"mouseup",this.onmouseup),r.preventDefault(t)}},i.prototype.leftToIndex=function(t){var e=parseFloat(this.frame.bar.style.width)-this.frame.slide.clientWidth-10,n=t-3,i=Math.round(n/e*(this.values.length-1));return i<0&&(i=0),i>this.values.length-1&&(i=this.values.length-1),i},i.prototype.indexToLeft=function(t){var e=parseFloat(this.frame.bar.style.width)-this.frame.slide.clientWidth-10,n=t/(this.values.length-1)*e,i=n+3;return i},i.prototype._onMouseMove=function(t){var e=t.clientX-this.startClientX,n=this.startSlideX+e,i=this.leftToIndex(n);this.setIndex(i),r.preventDefault()},i.prototype._onMouseUp=function(t){this.frame.style.cursor="auto",r.removeEventListener(document,"mousemove",this.onmousemove),r.removeEventListener(document,"mouseup",this.onmouseup),r.preventDefault()},t.exports=i},function(t,e){function n(t,e,n,i){this._start=0,this._end=0,this._step=1,this.prettyStep=!0,this.precision=5,this._current=0,this.setRange(t,e,n,i)}n.prototype.isNumeric=function(t){return!isNaN(parseFloat(t))&&isFinite(t)},n.prototype.setRange=function(t,e,n,i){if(!this.isNumeric(t))throw new Error("Parameter 'start' is not numeric; value: "+t);if(!this.isNumeric(e))throw new Error("Parameter 'end' is not numeric; value: "+t);if(!this.isNumeric(n))throw new Error("Parameter 'step' is not numeric; value: "+t);this._start=t?t:0,this._end=e?e:0,this.setStep(n,i)},n.prototype.setStep=function(t,e){void 0===t||t<=0||(void 0!==e&&(this.prettyStep=e),this.prettyStep===!0?this._step=n.calculatePrettyStep(t):this._step=t)},n.calculatePrettyStep=function(t){var e=function(t){return Math.log(t)/Math.LN10},n=Math.pow(10,Math.round(e(t))),i=2*Math.pow(10,Math.round(e(t/2))),r=5*Math.pow(10,Math.round(e(t/5))),o=n;return Math.abs(i-t)<=Math.abs(o-t)&&(o=i),Math.abs(r-t)<=Math.abs(o-t)&&(o=r),o<=0&&(o=1),o},n.prototype.getCurrent=function(){return parseFloat(this._current.toPrecision(this.precision))},n.prototype.getStep=function(){return this._step},n.prototype.start=function(t){void 0===t&&(t=!1),this._current=this._start-this._start%this._step,t&&this.getCurrent()<this._start&&this.next()},n.prototype.next=function(){this._current+=this._step},n.prototype.end=function(){return this._current>this._end},t.exports=n},function(t,e){function n(){this.min=void 0,this.max=void 0}n.prototype.adjust=function(t){void 0!==t&&((void 0===this.min||this.min>t)&&(this.min=t),(void 0===this.max||this.max<t)&&(this.max=t))},n.prototype.combine=function(t){this.add(t.min),this.add(t.max)},n.prototype.expand=function(t){if(void 0!==t){var e=this.min-t,n=this.max+t;if(e>n)throw new Error("Passed expansion value makes range invalid");this.min=e,this.max=n}},n.prototype.range=function(){return this.max-this.min},n.prototype.center=function(){return(this.min+this.max)/2},t.exports=n},function(t,e,n){function i(t){return t&&t.__esModule?t:{default:t}}function r(t){for(var e in t)if(t.hasOwnProperty(e))return!1;return!0}function o(t){return void 0===t||""===t||"string"!=typeof t?t:t.charAt(0).toUpperCase()+t.slice(1)}function s(t,e){return void 0===t||""===t?e:t+o(e)}function a(t,e,n,i){var r,o;for(var a in n)r=n[a],o=s(i,r),e[o]=t[r]}function h(t,e,n,i){var r,o;for(var a in n)r=n[a],void 0!==t[r]&&(o=s(i,r),e[o]=t[r])}function u(t,e){if(void 0===t||r(t))throw new Error("No DEFAULTS passed");if(void 0===e)throw new Error("No dst passed");k=t,a(t,e,D),a(t,e,M,"default"),c(t,e),e.margin=10,e.showGrayBottom=!1,e.showTooltip=!1,e.onclick_callback=null,e.eye=new b(0,0,-1)}function l(t,e){if(void 0!==t){if(void 0===e)throw new Error("No dst passed");if(void 0===k||r(k))throw new Error("DEFAULTS not set for module Settings");h(t,e,D),h(t,e,M,"default"),c(t,e)}}function c(t,e){void 0!==t.backgroundColor&&v(t.backgroundColor,e),y(t.dataColor,e),m(t.style,e),f(t.showLegend,e),g(t.cameraPosition,e),void 0!==t.tooltip&&(e.showTooltip=t.tooltip),void 0!=t.onclick&&(e.onclick_callback=t.onclick)}function f(t,e){if(void 0===t){var n=void 0===k.showLegend;if(n){var i=e.style===S.DOTCOLOR||e.style===S.DOTSIZE;e.showLegend=i}}else e.showLegend=t}function d(t){var e=T[t];return void 0===e?-1:e}function p(t){var e=!1;for(var n in S)if(S[n]===t){e=!0;break}return e}function m(t,e){if(void 0!==t){var n;if("string"==typeof t){if(n=d(t),n===-1)throw new Error("Style '"+t+"' is invalid")}else{if(!p(t))throw new Error("Style '"+t+"' is invalid");n=t}e.style=n}}function v(t,e){var n="white",i="gray",r=1;if("string"==typeof t)n=t,i="none",r=0;else{if("object"!==("undefined"==typeof t?"undefined":(0,w.default)(t)))throw new Error("Unsupported type of backgroundColor");void 0!==t.fill&&(n=t.fill),void 0!==t.stroke&&(i=t.stroke),void 0!==t.strokeWidth&&(r=t.strokeWidth)}e.frame.style.backgroundColor=n,e.frame.style.borderColor=i,e.frame.style.borderWidth=r+"px",e.frame.style.borderStyle="solid"}function y(t,e){void 0!==t&&(void 0===e.dataColor&&(e.dataColor={}),"string"==typeof t?(e.dataColor.fill=t,e.dataColor.stroke=t):(t.fill&&(e.dataColor.fill=t.fill),t.stroke&&(e.dataColor.stroke=t.stroke),void 0!==t.strokeWidth&&(e.dataColor.strokeWidth=t.strokeWidth)))}function g(t,e){var n=t;void 0!==n&&(void 0===e.camera&&(e.camera=new x),e.camera.setArmRotation(n.horizontal,n.vertical),e.camera.setArmLength(n.distance))}var _=n(62),w=i(_),x=n(97),b=n(95),S={BAR:0,BARCOLOR:1,BARSIZE:2,DOT:3,DOTLINE:4,DOTCOLOR:5,DOTSIZE:6,GRID:7,LINE:8,SURFACE:9},T={dot:S.DOT,"dot-line":S.DOTLINE,"dot-color":S.DOTCOLOR,"dot-size":S.DOTSIZE,line:S.LINE,grid:S.GRID,surface:S.SURFACE,bar:S.BAR,"bar-color":S.BARCOLOR,"bar-size":S.BARSIZE},D=["width","height","filterLabel","legendLabel","xLabel","yLabel","zLabel","xValueLabel","yValueLabel","zValueLabel","showGrid","showPerspective","showShadow","keepAspectRatio","verticalRatio","dotSizeRatio","showAnimationControls","animationInterval","animationPreload","animationAutoStart","axisColor","gridColor","xCenter","yCenter"],M=["xBarWidth","yBarWidth","valueMin","valueMax","xMin","xMax","xStep","yMin","yMax","yStep","zMin","zMax","zStep"],k=void 0;t.exports.STYLE=S,t.exports.setDefaults=u,t.exports.setOptions=l,t.exports.setCameraPosition=g},function(t,e,n){if("undefined"!=typeof window){var i=n(108),r=window.Hammer||n(109);t.exports=i(r,{preventDefault:"mouse"})}else t.exports=function(){throw Error("hammer.js is only available in a browser, not in node.js.")}},function(t,e,n){var i,r,o;!function(n){r=[],i=n,o="function"==typeof i?i.apply(e,r):i,!(void 0!==o&&(t.exports=o))}(function(){var t=null;return function e(n,i){function r(t){return t.match(/[^ ]+/g)}function o(e){if("hammer.input"!==e.type){if(e.srcEvent._handled||(e.srcEvent._handled={}),e.srcEvent._handled[e.type])return;e.srcEvent._handled[e.type]=!0}var n=!1;e.stopPropagation=function(){n=!0};var i=e.srcEvent.stopPropagation.bind(e.srcEvent);"function"==typeof i&&(e.srcEvent.stopPropagation=function(){i(),e.stopPropagation()}),e.firstTarget=t;for(var r=t;r&&!n;){var o=r.hammer;if(o)for(var s,a=0;a<o.length;a++)if(s=o[a]._handlers[e.type])for(var h=0;h<s.length&&!n;h++)s[h](e);r=r.parentNode}}var s=i||{preventDefault:!1};if(n.Manager){var a=n,h=function(t,n){var i=Object.create(s);return n&&a.assign(i,n),e(new a(t,i),i)};return a.assign(h,a),h.Manager=function(t,n){var i=Object.create(s);return n&&a.assign(i,n),e(new a.Manager(t,i),i)},h}var u=Object.create(n),l=n.element;return l.hammer||(l.hammer=[]),l.hammer.push(u),n.on("hammer.input",function(e){s.preventDefault!==!0&&s.preventDefault!==e.pointerType||e.preventDefault(),e.isFirst&&(t=e.target)}),u._handlers={},u.on=function(t,e){return r(t).forEach(function(t){var i=u._handlers[t];i||(u._handlers[t]=i=[],n.on(t,o)),i.push(e)}),u},u.off=function(t,e){return r(t).forEach(function(t){var i=u._handlers[t];i&&(i=e?i.filter(function(t){return t!==e}):[],i.length>0?u._handlers[t]=i:(n.off(t,o),delete u._handlers[t]))}),u},u.emit=function(e,i){t=i.target,n.emit(e,i)},u.destroy=function(){var t=n.element.hammer,e=t.indexOf(u);e!==-1&&t.splice(e,1),t.length||delete n.element.hammer,u._handlers={},n.destroy()},u}})},function(t,e,n){var i;/*! Hammer.JS - v2.0.7 - 2016-04-22
   * http://hammerjs.github.io/
   *
   * Copyright (c) 2016 Jorik Tangelder;
   * Licensed under the MIT license */
!function(r,o,s,a){function h(t,e,n){return setTimeout(d(t,n),e)}function u(t,e,n){return!!Array.isArray(t)&&(l(t,n[e],n),!0)}function l(t,e,n){var i;if(t)if(t.forEach)t.forEach(e,n);else if(t.length!==a)for(i=0;i<t.length;)e.call(n,t[i],i,t),i++;else for(i in t)t.hasOwnProperty(i)&&e.call(n,t[i],i,t)}function c(t,e,n){var i="DEPRECATED METHOD: "+e+"\n"+n+" AT \n";return function(){var e=new Error("get-stack-trace"),n=e&&e.stack?e.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",o=r.console&&(r.console.warn||r.console.log);return o&&o.call(r.console,i,n),t.apply(this,arguments)}}function f(t,e,n){var i,r=e.prototype;i=t.prototype=Object.create(r),i.constructor=t,i._super=r,n&&mt(i,n)}function d(t,e){return function(){return t.apply(e,arguments)}}function p(t,e){return typeof t==gt?t.apply(e?e[0]||a:a,e):t}function m(t,e){return t===a?e:t}function v(t,e,n){l(w(e),function(e){t.addEventListener(e,n,!1)})}function y(t,e,n){l(w(e),function(e){t.removeEventListener(e,n,!1)})}function g(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function _(t,e){return t.indexOf(e)>-1}function w(t){return t.trim().split(/\s+/g)}function x(t,e,n){if(t.indexOf&&!n)return t.indexOf(e);for(var i=0;i<t.length;){if(n&&t[i][n]==e||!n&&t[i]===e)return i;i++}return-1}function b(t){return Array.prototype.slice.call(t,0)}function S(t,e,n){for(var i=[],r=[],o=0;o<t.length;){var s=e?t[o][e]:t[o];x(r,s)<0&&i.push(t[o]),r[o]=s,o++}return n&&(i=e?i.sort(function(t,n){return t[e]>n[e]}):i.sort()),i}function T(t,e){for(var n,i,r=e[0].toUpperCase()+e.slice(1),o=0;o<vt.length;){if(n=vt[o],i=n?n+r:e,i in t)return i;o++}return a}function D(){return Tt++}function M(t){var e=t.ownerDocument||t;return e.defaultView||e.parentWindow||r}function k(t,e){var n=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){p(t.options.enable,[t])&&n.handler(e)},this.init()}function O(t){var e,n=t.options.inputClass;return new(e=n?n:kt?G:Ot?U:Mt?X:j)(t,E)}function E(t,e,n){var i=n.pointers.length,r=n.changedPointers.length,o=e&Rt&&i-r===0,s=e&(It|Nt)&&i-r===0;n.isFirst=!!o,n.isFinal=!!s,o&&(t.session={}),n.eventType=e,C(t,n),t.emit("hammer.input",n),t.recognize(n),t.session.prevInput=n}function C(t,e){var n=t.session,i=e.pointers,r=i.length;n.firstInput||(n.firstInput=Y(e)),r>1&&!n.firstMultiple?n.firstMultiple=Y(e):1===r&&(n.firstMultiple=!1);var o=n.firstInput,s=n.firstMultiple,a=s?s.center:o.center,h=e.center=R(i);e.timeStamp=xt(),e.deltaTime=e.timeStamp-o.timeStamp,e.angle=W(a,h),e.distance=N(a,h),P(n,e),e.offsetDirection=I(e.deltaX,e.deltaY);var u=A(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=u.x,e.overallVelocityY=u.y,e.overallVelocity=wt(u.x)>wt(u.y)?u.x:u.y,e.scale=s?F(s.pointers,i):1,e.rotation=s?z(s.pointers,i):0,e.maxPointers=n.prevInput?e.pointers.length>n.prevInput.maxPointers?e.pointers.length:n.prevInput.maxPointers:e.pointers.length,L(n,e);var l=t.element;g(e.srcEvent.target,l)&&(l=e.srcEvent.target),e.target=l}function P(t,e){var n=e.center,i=t.offsetDelta||{},r=t.prevDelta||{},o=t.prevInput||{};e.eventType!==Rt&&o.eventType!==It||(r=t.prevDelta={x:o.deltaX||0,y:o.deltaY||0},i=t.offsetDelta={x:n.x,y:n.y}),e.deltaX=r.x+(n.x-i.x),e.deltaY=r.y+(n.y-i.y)}function L(t,e){var n,i,r,o,s=t.lastInterval||e,h=e.timeStamp-s.timeStamp;if(e.eventType!=Nt&&(h>Yt||s.velocity===a)){var u=e.deltaX-s.deltaX,l=e.deltaY-s.deltaY,c=A(h,u,l);i=c.x,r=c.y,n=wt(c.x)>wt(c.y)?c.x:c.y,o=I(u,l),t.lastInterval=e}else n=s.velocity,i=s.velocityX,r=s.velocityY,o=s.direction;e.velocity=n,e.velocityX=i,e.velocityY=r,e.direction=o}function Y(t){for(var e=[],n=0;n<t.pointers.length;)e[n]={clientX:_t(t.pointers[n].clientX),clientY:_t(t.pointers[n].clientY)},n++;return{timeStamp:xt(),pointers:e,center:R(e),deltaX:t.deltaX,deltaY:t.deltaY}}function R(t){var e=t.length;if(1===e)return{x:_t(t[0].clientX),y:_t(t[0].clientY)};for(var n=0,i=0,r=0;r<e;)n+=t[r].clientX,i+=t[r].clientY,r++;return{x:_t(n/e),y:_t(i/e)}}function A(t,e,n){return{x:e/t||0,y:n/t||0}}function I(t,e){return t===e?Wt:wt(t)>=wt(e)?t<0?zt:Ft:e<0?jt:Gt}function N(t,e,n){n||(n=Ht);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return Math.sqrt(i*i+r*r)}function W(t,e,n){n||(n=Ht);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return 180*Math.atan2(r,i)/Math.PI}function z(t,e){return W(e[1],e[0],Xt)+W(t[1],t[0],Xt)}function F(t,e){return N(e[0],e[1],Xt)/N(t[0],t[1],Xt)}function j(){this.evEl=qt,this.evWin=$t,this.pressed=!1,k.apply(this,arguments)}function G(){this.evEl=Kt,this.evWin=te,k.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}function B(){this.evTarget=ne,this.evWin=ie,this.started=!1,k.apply(this,arguments)}function V(t,e){var n=b(t.touches),i=b(t.changedTouches);return e&(It|Nt)&&(n=S(n.concat(i),"identifier",!0)),[n,i]}function U(){this.evTarget=oe,this.targetIds={},k.apply(this,arguments)}function H(t,e){var n=b(t.touches),i=this.targetIds;if(e&(Rt|At)&&1===n.length)return i[n[0].identifier]=!0,[n,n];var r,o,s=b(t.changedTouches),a=[],h=this.target;if(o=n.filter(function(t){return g(t.target,h)}),e===Rt)for(r=0;r<o.length;)i[o[r].identifier]=!0,r++;for(r=0;r<s.length;)i[s[r].identifier]&&a.push(s[r]),e&(It|Nt)&&delete i[s[r].identifier],r++;return a.length?[S(o.concat(a),"identifier",!0),a]:void 0}function X(){k.apply(this,arguments);var t=d(this.handler,this);this.touch=new U(this.manager,t),this.mouse=new j(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function Z(t,e){t&Rt?(this.primaryTouch=e.changedPointers[0].identifier,q.call(this,e)):t&(It|Nt)&&q.call(this,e)}function q(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var n={x:e.clientX,y:e.clientY};this.lastTouches.push(n);var i=this.lastTouches,r=function(){var t=i.indexOf(n);t>-1&&i.splice(t,1)};setTimeout(r,se)}}function $(t){for(var e=t.srcEvent.clientX,n=t.srcEvent.clientY,i=0;i<this.lastTouches.length;i++){var r=this.lastTouches[i],o=Math.abs(e-r.x),s=Math.abs(n-r.y);if(o<=ae&&s<=ae)return!0}return!1}function J(t,e){this.manager=t,this.set(e)}function Q(t){if(_(t,de))return de;var e=_(t,pe),n=_(t,me);return e&&n?de:e||n?e?pe:me:_(t,fe)?fe:ce}function K(){if(!ue)return!1;var t={},e=r.CSS&&r.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach(function(n){t[n]=!e||r.CSS.supports("touch-action",n)}),t}function tt(t){this.options=mt({},this.defaults,t||{}),this.id=D(),this.manager=null,this.options.enable=m(this.options.enable,!0),this.state=ye,this.simultaneous={},this.requireFail=[]}function et(t){return t&be?"cancel":t&we?"end":t&_e?"move":t&ge?"start":""}function nt(t){return t==Gt?"down":t==jt?"up":t==zt?"left":t==Ft?"right":""}function it(t,e){var n=e.manager;return n?n.get(t):t}function rt(){tt.apply(this,arguments)}function ot(){rt.apply(this,arguments),this.pX=null,this.pY=null}function st(){rt.apply(this,arguments)}function at(){tt.apply(this,arguments),this._timer=null,this._input=null}function ht(){rt.apply(this,arguments)}function ut(){rt.apply(this,arguments)}function lt(){tt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function ct(t,e){return e=e||{},e.recognizers=m(e.recognizers,ct.defaults.preset),new ft(t,e)}function ft(t,e){this.options=mt({},ct.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=O(this),this.touchAction=new J(this,this.options.touchAction),dt(this,!0),l(this.options.recognizers,function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])},this)}function dt(t,e){var n=t.element;if(n.style){var i;l(t.options.cssProps,function(r,o){i=T(n.style,o),e?(t.oldCssProps[i]=n.style[i],n.style[i]=r):n.style[i]=t.oldCssProps[i]||""}),e||(t.oldCssProps={})}}function pt(t,e){var n=o.createEvent("Event");n.initEvent(t,!0,!0),n.gesture=e,e.target.dispatchEvent(n)}var mt,vt=["","webkit","Moz","MS","ms","o"],yt=o.createElement("div"),gt="function",_t=Math.round,wt=Math.abs,xt=Date.now;mt="function"!=typeof Object.assign?function(t){if(t===a||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),n=1;n<arguments.length;n++){var i=arguments[n];if(i!==a&&null!==i)for(var r in i)i.hasOwnProperty(r)&&(e[r]=i[r])}return e}:Object.assign;var bt=c(function(t,e,n){for(var i=Object.keys(e),r=0;r<i.length;)(!n||n&&t[i[r]]===a)&&(t[i[r]]=e[i[r]]),r++;return t},"extend","Use `assign`."),St=c(function(t,e){return bt(t,e,!0)},"merge","Use `assign`."),Tt=1,Dt=/mobile|tablet|ip(ad|hone|od)|android/i,Mt="ontouchstart"in r,kt=T(r,"PointerEvent")!==a,Ot=Mt&&Dt.test(navigator.userAgent),Et="touch",Ct="pen",Pt="mouse",Lt="kinect",Yt=25,Rt=1,At=2,It=4,Nt=8,Wt=1,zt=2,Ft=4,jt=8,Gt=16,Bt=zt|Ft,Vt=jt|Gt,Ut=Bt|Vt,Ht=["x","y"],Xt=["clientX","clientY"];k.prototype={handler:function(){},init:function(){this.evEl&&v(this.element,this.evEl,this.domHandler),this.evTarget&&v(this.target,this.evTarget,this.domHandler),this.evWin&&v(M(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&y(this.element,this.evEl,this.domHandler),this.evTarget&&y(this.target,this.evTarget,this.domHandler),this.evWin&&y(M(this.element),this.evWin,this.domHandler)}};var Zt={mousedown:Rt,mousemove:At,mouseup:It},qt="mousedown",$t="mousemove mouseup";f(j,k,{handler:function(t){var e=Zt[t.type];e&Rt&&0===t.button&&(this.pressed=!0),e&At&&1!==t.which&&(e=It),this.pressed&&(e&It&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:Pt,srcEvent:t}))}});var Jt={pointerdown:Rt,pointermove:At,pointerup:It,pointercancel:Nt,pointerout:Nt},Qt={2:Et,3:Ct,4:Pt,5:Lt},Kt="pointerdown",te="pointermove pointerup pointercancel";r.MSPointerEvent&&!r.PointerEvent&&(Kt="MSPointerDown",te="MSPointerMove MSPointerUp MSPointerCancel"),f(G,k,{handler:function(t){var e=this.store,n=!1,i=t.type.toLowerCase().replace("ms",""),r=Jt[i],o=Qt[t.pointerType]||t.pointerType,s=o==Et,a=x(e,t.pointerId,"pointerId");r&Rt&&(0===t.button||s)?a<0&&(e.push(t),a=e.length-1):r&(It|Nt)&&(n=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:o,srcEvent:t}),n&&e.splice(a,1))}});var ee={touchstart:Rt,touchmove:At,touchend:It,touchcancel:Nt},ne="touchstart",ie="touchstart touchmove touchend touchcancel";f(B,k,{handler:function(t){var e=ee[t.type];if(e===Rt&&(this.started=!0),this.started){var n=V.call(this,t,e);e&(It|Nt)&&n[0].length-n[1].length===0&&(this.started=!1),this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:Et,srcEvent:t})}}});var re={touchstart:Rt,touchmove:At,touchend:It,touchcancel:Nt},oe="touchstart touchmove touchend touchcancel";f(U,k,{handler:function(t){var e=re[t.type],n=H.call(this,t,e);n&&this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:Et,srcEvent:t})}});var se=2500,ae=25;f(X,k,{handler:function(t,e,n){var i=n.pointerType==Et,r=n.pointerType==Pt;if(!(r&&n.sourceCapabilities&&n.sourceCapabilities.firesTouchEvents)){if(i)Z.call(this,e,n);else if(r&&$.call(this,n))return;this.callback(t,e,n)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var he=T(yt.style,"touchAction"),ue=he!==a,le="compute",ce="auto",fe="manipulation",de="none",pe="pan-x",me="pan-y",ve=K();J.prototype={set:function(t){t==le&&(t=this.compute()),ue&&this.manager.element.style&&ve[t]&&(this.manager.element.style[he]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return l(this.manager.recognizers,function(e){p(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))}),Q(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,n=t.offsetDirection;if(this.manager.session.prevented)return void e.preventDefault();var i=this.actions,r=_(i,de)&&!ve[de],o=_(i,me)&&!ve[me],s=_(i,pe)&&!ve[pe];if(r){var a=1===t.pointers.length,h=t.distance<2,u=t.deltaTime<250;if(a&&h&&u)return}return s&&o?void 0:r||o&&n&Bt||s&&n&Vt?this.preventSrc(e):void 0},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var ye=1,ge=2,_e=4,we=8,xe=we,be=16,Se=32;tt.prototype={defaults:{},set:function(t){return mt(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(u(t,"recognizeWith",this))return this;var e=this.simultaneous;return t=it(t,this),e[t.id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return u(t,"dropRecognizeWith",this)?this:(t=it(t,this),delete this.simultaneous[t.id],this)},requireFailure:function(t){if(u(t,"requireFailure",this))return this;var e=this.requireFail;return t=it(t,this),x(e,t)===-1&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(u(t,"dropRequireFailure",this))return this;t=it(t,this);var e=x(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){function e(e){n.manager.emit(e,t)}var n=this,i=this.state;i<we&&e(n.options.event+et(i)),e(n.options.event),t.additionalEvent&&e(t.additionalEvent),i>=we&&e(n.options.event+et(i))},tryEmit:function(t){return this.canEmit()?this.emit(t):void(this.state=Se)},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(this.requireFail[t].state&(Se|ye)))return!1;t++}return!0},recognize:function(t){var e=mt({},t);return p(this.options.enable,[this,e])?(this.state&(xe|be|Se)&&(this.state=ye),this.state=this.process(e),void(this.state&(ge|_e|we|be)&&this.tryEmit(e))):(this.reset(),void(this.state=Se))},process:function(t){},getTouchAction:function(){},reset:function(){}},f(rt,tt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,n=t.eventType,i=e&(ge|_e),r=this.attrTest(t);return i&&(n&Nt||!r)?e|be:i||r?n&It?e|we:e&ge?e|_e:ge:Se}}),f(ot,rt,{defaults:{event:"pan",threshold:10,pointers:1,direction:Ut},getTouchAction:function(){var t=this.options.direction,e=[];return t&Bt&&e.push(me),t&Vt&&e.push(pe),e},directionTest:function(t){var e=this.options,n=!0,i=t.distance,r=t.direction,o=t.deltaX,s=t.deltaY;return r&e.direction||(e.direction&Bt?(r=0===o?Wt:o<0?zt:Ft,n=o!=this.pX,i=Math.abs(t.deltaX)):(r=0===s?Wt:s<0?jt:Gt,n=s!=this.pY,i=Math.abs(t.deltaY))),t.direction=r,n&&i>e.threshold&&r&e.direction},attrTest:function(t){return rt.prototype.attrTest.call(this,t)&&(this.state&ge||!(this.state&ge)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=nt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),f(st,rt,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[de]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||this.state&ge)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),f(at,tt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[ce]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!i||!n||t.eventType&(It|Nt)&&!r)this.reset();else if(t.eventType&Rt)this.reset(),this._timer=h(function(){this.state=xe,this.tryEmit()},e.time,this);else if(t.eventType&It)return xe;return Se},reset:function(){clearTimeout(this._timer)},emit:function(t){this.state===xe&&(t&&t.eventType&It?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=xt(),this.manager.emit(this.options.event,this._input)))}}),f(ht,rt,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[de]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||this.state&ge)}}),f(ut,rt,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:Bt|Vt,pointers:1},getTouchAction:function(){return ot.prototype.getTouchAction.call(this)},attrTest:function(t){var e,n=this.options.direction;return n&(Bt|Vt)?e=t.overallVelocity:n&Bt?e=t.overallVelocityX:n&Vt&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&n&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&wt(e)>this.options.velocity&&t.eventType&It},emit:function(t){var e=nt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),f(lt,tt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[fe]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),t.eventType&Rt&&0===this.count)return this.failTimeout();if(i&&r&&n){if(t.eventType!=It)return this.failTimeout();var o=!this.pTime||t.timeStamp-this.pTime<e.interval,s=!this.pCenter||N(this.pCenter,t.center)<e.posThreshold;this.pTime=t.timeStamp,this.pCenter=t.center,s&&o?this.count+=1:this.count=1,this._input=t;var a=this.count%e.taps;if(0===a)return this.hasRequireFailures()?(this._timer=h(function(){this.state=xe,this.tryEmit()},e.interval,this),ge):xe}return Se},failTimeout:function(){return this._timer=h(function(){this.state=Se},this.options.interval,this),Se},reset:function(){clearTimeout(this._timer)},emit:function(){this.state==xe&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),ct.VERSION="2.0.7",ct.defaults={domEvents:!1,touchAction:le,enable:!0,inputTarget:null,inputClass:null,preset:[[ht,{enable:!1}],[st,{enable:!1},["rotate"]],[ut,{direction:Bt}],[ot,{direction:Bt},["swipe"]],[lt],[lt,{event:"doubletap",taps:2},["tap"]],[at]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};var Te=1,De=2;ft.prototype={set:function(t){return mt(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?De:Te},recognize:function(t){var e=this.session;if(!e.stopped){this.touchAction.preventDefaults(t);var n,i=this.recognizers,r=e.curRecognizer;(!r||r&&r.state&xe)&&(r=e.curRecognizer=null);for(var o=0;o<i.length;)n=i[o],e.stopped===De||r&&n!=r&&!n.canRecognizeWith(r)?n.reset():n.recognize(t),!r&&n.state&(ge|_e|we)&&(r=e.curRecognizer=n),o++}},get:function(t){if(t instanceof tt)return t;for(var e=this.recognizers,n=0;n<e.length;n++)if(e[n].options.event==t)return e[n];return null},add:function(t){if(u(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(u(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,n=x(e,t);n!==-1&&(e.splice(n,1),this.touchAction.update())}return this},on:function(t,e){if(t!==a&&e!==a){var n=this.handlers;return l(w(t),function(t){n[t]=n[t]||[],n[t].push(e)}),this}},off:function(t,e){if(t!==a){var n=this.handlers;return l(w(t),function(t){e?n[t]&&n[t].splice(x(n[t],e),1):delete n[t]}),this}},emit:function(t,e){this.options.domEvents&&pt(t,e);var n=this.handlers[t]&&this.handlers[t].slice();if(n&&n.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var i=0;i<n.length;)n[i](e),i++}},destroy:function(){this.element&&dt(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},mt(ct,{INPUT_START:Rt,INPUT_MOVE:At,INPUT_END:It,INPUT_CANCEL:Nt,STATE_POSSIBLE:ye,STATE_BEGAN:ge,STATE_CHANGED:_e,STATE_ENDED:we,STATE_RECOGNIZED:xe,STATE_CANCELLED:be,STATE_FAILED:Se,DIRECTION_NONE:Wt,DIRECTION_LEFT:zt,DIRECTION_RIGHT:Ft,DIRECTION_UP:jt,DIRECTION_DOWN:Gt,DIRECTION_HORIZONTAL:Bt,DIRECTION_VERTICAL:Vt,DIRECTION_ALL:Ut,Manager:ft,Input:k,TouchAction:J,TouchInput:U,MouseInput:j,PointerEventInput:G,TouchMouseInput:X,SingleTouchInput:B,Recognizer:tt,AttrRecognizer:rt,Tap:lt,Pan:ot,Swipe:ut,Pinch:st,Rotate:ht,Press:at,on:v,off:y,each:l,merge:St,extend:bt,assign:mt,inherit:f,bindFn:d,prefixed:T});var Me="undefined"!=typeof r?r:"undefined"!=typeof self?self:{};Me.Hammer=ct,i=function(){return ct}.call(e,n,e,t),!(i!==a&&(t.exports=i))}(window,document,"Hammer")},function(t,e,n){var i,r,o;!function(n,s){r=[],i=s,o="function"==typeof i?i.apply(e,r):i,!(void 0!==o&&(t.exports=o))}(this,function(){function t(t){var e,n=t&&t.preventDefault||!1,i=t&&t.container||window,r={},o={keydown:{},keyup:{}},s={};for(e=97;e<=122;e++)s[String.fromCharCode(e)]={code:65+(e-97),shift:!1};for(e=65;e<=90;e++)s[String.fromCharCode(e)]={code:e,shift:!0};for(e=0;e<=9;e++)s[""+e]={code:48+e,shift:!1};for(e=1;e<=12;e++)s["F"+e]={code:111+e,shift:!1};for(e=0;e<=9;e++)s["num"+e]={code:96+e,shift:!1};s["num*"]={code:106,shift:!1},s["num+"]={code:107,shift:!1},s["num-"]={code:109,shift:!1},s["num/"]={code:111,shift:!1},s["num."]={code:110,shift:!1},s.left={code:37,shift:!1},s.up={code:38,shift:!1},s.right={code:39,shift:!1},s.down={code:40,shift:!1},s.space={code:32,shift:!1},s.enter={code:13,shift:!1},s.shift={code:16,shift:void 0},s.esc={code:27,shift:!1},s.backspace={code:8,shift:!1},s.tab={code:9,shift:!1},s.ctrl={code:17,shift:!1},s.alt={code:18,shift:!1},s.delete={code:46,shift:!1},s.pageup={code:33,shift:!1},s.pagedown={code:34,shift:!1},s["="]={code:187,shift:!1},s["-"]={code:189,shift:!1},s["]"]={code:221,shift:!1},s["["]={code:219,shift:!1};var a=function(t){u(t,"keydown")},h=function(t){u(t,"keyup")},u=function(t,e){if(void 0!==o[e][t.keyCode]){for(var i=o[e][t.keyCode],r=0;r<i.length;r++)void 0===i[r].shift?i[r].fn(t):1==i[r].shift&&1==t.shiftKey?i[r].fn(t):0==i[r].shift&&0==t.shiftKey&&i[r].fn(t);1==n&&t.preventDefault()}};return r.bind=function(t,e,n){if(void 0===n&&(n="keydown"),void 0===s[t])throw new Error("unsupported key: "+t);void 0===o[n][s[t].code]&&(o[n][s[t].code]=[]),o[n][s[t].code].push({fn:e,shift:s[t].shift})},r.bindAll=function(t,e){void 0===e&&(e="keydown");for(var n in s)s.hasOwnProperty(n)&&r.bind(n,t,e)},r.getKey=function(t){for(var e in s)if(s.hasOwnProperty(e)){if(1==t.shiftKey&&1==s[e].shift&&t.keyCode==s[e].code)return e;if(0==t.shiftKey&&0==s[e].shift&&t.keyCode==s[e].code)return e;if(t.keyCode==s[e].code&&"shift"==e)return e}return"unknown key, currently not supported"},r.unbind=function(t,e,n){if(void 0===n&&(n="keydown"),void 0===s[t])throw new Error("unsupported key: "+t);if(void 0!==e){var i=[],r=o[n][s[t].code];if(void 0!==r)for(var a=0;a<r.length;a++)r[a].fn==e&&r[a].shift==s[t].shift||i.push(o[n][s[t].code][a]);o[n][s[t].code]=i}else o[n][s[t].code]=[]},r.reset=function(){o={keydown:{},keyup:{}}},r.destroy=function(){o={keydown:{},keyup:{}},i.removeEventListener("keydown",a,!0),i.removeEventListener("keyup",h,!0)},i.addEventListener("keydown",a,!0),i.addEventListener("keyup",h,!0),r}return t})}])});