/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.editor.box.displays;

import io.intino.konos.alexandria.ui.displays.AlexandriaStamp;
import io.intino.sezzet.editor.box.displays.notifiers.SezzetEditorNotifier;
import io.intino.sezzet.editor.box.schemas.ChangeParameters;
import io.intino.sezzet.editor.box.schemas.Setup;
import io.intino.sezzet.editor.box.schemas.SuggestParameters;
import io.intino.sezzet.editor.box.schemas.ValidationItem;
import io.intino.sezzet.model.graph.Category;
import io.intino.sezzet.model.graph.Feature;
import io.intino.sezzet.model.graph.Group;
import io.intino.sezzet.model.graph.SezzetGraph;
import io.intino.sezzet.setql.SetqlChecker;
import io.intino.sezzet.setql.SetqlParser;
import io.intino.sezzet.setql.exceptions.SemanticException;
import io.intino.sezzet.setql.exceptions.SetqlError;
import io.intino.sezzet.setql.exceptions.SyntaxException;
import io.intino.sezzet.setql.graph.Expression;
import io.intino.sezzet.setql.graph.SetqlGraph;
import io.intino.sezzet.setql.graph.rules.Operator;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SezzetEditor
extends AlexandriaStamp<SezzetEditorNotifier> {
    private List<Consumer<ChangeContext>> listeners = new ArrayList<Consumer<ChangeContext>>();
    private SetqlGraph setql = (SetqlGraph)new Graph().loadStashes(new String[]{"Setql"}).as(SetqlGraph.class);
    private SezzetGraph sezzetGraph;
    private final List<Feature> features;
    private String expression;
    private boolean readonly = false;

    public SezzetEditor(String dsl) {
        this.sezzetGraph = (SezzetGraph)new Graph().loadStashes(new String[]{"Sezzet", dsl}).as(SezzetGraph.class);
        this.features = this.sezzetGraph.allFeatures();
    }

    public String expression() {
        return this.expression;
    }

    public SezzetEditor expression(String expression) {
        this.expression = expression;
        return this;
    }

    public SezzetEditor readonly(boolean value) {
        this.readonly = value;
        return this;
    }

    public SezzetEditor addListener(Consumer<ChangeContext> listener) {
        this.listeners.add(listener);
        return this;
    }

    protected void init() {
        super.init();
        ((SezzetEditorNotifier)this.notifier).render(new Setup().readonly(this.readonly).features(this.features()).invalidLabel(this.sezzetGraph.invalidLabel().value()).undefinedLabel(this.sezzetGraph.undefinedLabel().value()));
    }

    public void refresh() {
        ((SezzetEditorNotifier)this.notifier).setExpression(this.expression);
        this.validate();
    }

    public void onChange(ChangeParameters params) {
        this.expression = params.expression();
        SetqlGraph graph = this.validate();
        this.listeners.forEach(l -> l.accept(this.changeContext(params, graph)));
    }

    private ChangeContext changeContext(final ChangeParameters params, final SetqlGraph graph) {
        final String line = this.lineOf(params);
        return new ChangeContext(){

            @Override
            public boolean existsOperator() {
                return !line.startsWith("*");
            }

            @Override
            public String operand() {
                return line;
            }

            @Override
            public Expression expression() {
                return graph == null ? null : graph.expression();
            }

            @Override
            public String rawExpression() {
                return params.expression();
            }

            @Override
            public int lineNumber() {
                return params.cursor().row();
            }
        };
    }

    private String lineOf(ChangeParameters parameters) {
        String[] split = parameters.expression().split("\n");
        return split[parameters.cursor().row()].trim();
    }

    private SetqlGraph validate() {
        SetqlGraph graph = this.graph();
        ArrayList<ValidationItem> items = new ArrayList<ValidationItem>();
        if (this.expression != null && !this.expression.isEmpty()) {
            this.validate(items, graph);
        }
        ((SezzetEditorNotifier)this.notifier).validationResult(items);
        return graph;
    }

    private void validate(List<ValidationItem> items, SetqlGraph graph) {
        try {
            String language = this.session().browser().languageFromMetadata();
            Locale locale = language.equals("es") || language.equals("mx") ? new Locale("es", "ES") : Locale.ENGLISH;
            new SetqlParser(this.expression, locale).check(graph);
            new SetqlChecker(this.sezzetGraph, locale).check(graph);
        }
        catch (SyntaxException e) {
            for (SetqlError error : e.errors()) {
                items.add(new ValidationItem().line(error.line()).message(((SyntaxException.SyntaxError)error).lineMessage()));
            }
        }
        catch (SemanticException e) {
            for (SetqlError error : e.errors()) {
                items.add(new ValidationItem().line(error.line()).message(error.message()));
            }
        }
    }

    public void onSuggest(SuggestParameters params) {
        String line = params.line();
        if (this.isInArgumentContext(line, params.cursor())) {
            ((SezzetEditorNotifier)this.notifier).suggestion(this.arguments(this.featureIn(line, params.cursor()).toLowerCase()));
        } else if (this.startsWithOperator(line) && !line.contains("::") || line.indexOf("::") > params.cursor()) {
            ((SezzetEditorNotifier)this.notifier).suggestion(this.features(params.line(), params.cursor()));
        } else if (line.contains("::")) {
            String temporal = line.substring(line.indexOf("::"));
            ArrayList<String> options = new ArrayList<String>();
            if (!temporal.contains("period")) {
                options.add("period");
            }
            if (!temporal.contains("recency")) {
                options.add("recency");
            }
            if (!temporal.contains("frequency")) {
                options.add("frequency");
            }
            ((SezzetEditorNotifier)this.notifier).suggestion(options);
        }
    }

    private List<String> features() {
        return this.features.stream().map(Feature::label).collect(Collectors.toList());
    }

    private List<String> features(String line, int cursor) {
        String feature = this.featureIn(line, cursor);
        String prefix = feature.contains(".") ? feature.substring(0, feature.lastIndexOf(".")) : feature;
        String suffix = feature.contains(".") ? feature.substring(feature.lastIndexOf(".") + 1) : feature;
        String[] names = prefix.split("\\.");
        if (names.length == 1) {
            return names[0].equals(this.sezzetGraph.subject().value()) ? this.map(this.sezzetGraph.groupList(), ".", suffix) : Collections.singletonList(this.sezzetGraph.subject().value() + ".");
        }
        Group group = this.findGroup(Arrays.copyOfRange(names, 1, names.length));
        if (group == null) {
            return Collections.emptyList();
        }
        List<String> values = this.map(group.groupList(), ".", suffix);
        values.addAll(this.map(group.featureList(), "", suffix));
        return values;
    }

    private Group findGroup(String[] names) {
        Group currentGroup = null;
        for (String name : names) {
            if (currentGroup == null) {
                currentGroup = this.findGroup(this.sezzetGraph.groupList(), name);
                if (currentGroup != null) continue;
                return null;
            }
            currentGroup = this.findGroup(currentGroup.groupList(), name);
        }
        return currentGroup;
    }

    private List<String> map(List<? extends Layer> layers, String prefix, String suffix) {
        return layers.stream().map(g -> g.name$() + prefix).filter(g2 -> g2.startsWith(suffix)).collect(Collectors.toList());
    }

    private Group findGroup(List<Group> groupList, String name) {
        for (Group g : groupList) {
            if (!g.name$().equals(name)) continue;
            return g;
        }
        return null;
    }

    private boolean startsWithOperator(String line) {
        char start = line.trim().isEmpty() ? (char)'\u0000' : line.trim().charAt(0);
        return start != '\u0000' && (start == '*' || Operator.fromText((String)(start + "")) != null) && this.hasIndent(line);
    }

    private boolean hasIndent(String line) {
        return line.trim().length() > 1 && line.trim().charAt(1) == '\t' || line.length() == 2 && line.charAt(1) == '\t';
    }

    private List<String> arguments(String featureName) {
        Feature feature = this.features.stream().filter(f -> f.label().equalsIgnoreCase(featureName)).findFirst().orElse(null);
        if (feature == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arguments = new ArrayList<String>();
        if (feature.isEnumerate()) {
            arguments.addAll(this.sezzetGraph.valuesOf(feature).stream().map(Category::label).collect(Collectors.toList()));
        } else if (feature.isText()) {
            arguments.addAll(feature.asText().suggestions());
        } else if (feature.isNumeric()) {
            arguments.addAll(feature.asNumeric().suggestions());
        }
        if (feature.isAllowEmpty()) {
            arguments.add(this.sezzetGraph.undefinedLabel().value());
        }
        if (feature.isAllowNaS()) {
            arguments.add(this.sezzetGraph.invalidLabel().value());
        }
        return arguments;
    }

    private String featureIn(String line, int cursor) {
        String text = line.indexOf(")", cursor) > 0 ? line.substring(0, line.indexOf(")", cursor)) : line;
        String string = text = !text.contains("(") ? text : text.substring(0, text.lastIndexOf("("));
        if (text.contains(" ")) {
            text = text.substring(text.lastIndexOf(" ") + 1);
        }
        return text.substring(text.lastIndexOf("\t") + 1);
    }

    private boolean isInArgumentContext(String line, int cursor) {
        int rightParenthesis = line.indexOf(")", cursor);
        int leftParenthesis = line.indexOf("(");
        return leftParenthesis > 0 && cursor > leftParenthesis && (cursor <= rightParenthesis || !line.contains(")"));
    }

    private SetqlGraph graph() {
        return (SetqlGraph)this.setql.core$().clone().as(SetqlGraph.class);
    }

    public static interface ChangeContext {
        public boolean existsOperator();

        public String operand();

        public Expression expression();

        public String rawExpression();

        public int lineNumber();
    }
}

