/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sezzet.editor.box;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.rest.spark.PushService;
import io.intino.konos.alexandria.ui.AssetResourceLoader;
import io.intino.konos.alexandria.ui.UI;
import io.intino.konos.alexandria.ui.UIAlexandriaSpark;
import io.intino.konos.alexandria.ui.spark.UIRouter;
import io.intino.konos.alexandria.ui.spark.UISparkManager;
import io.intino.konos.alexandria.ui.spark.resources.AfterDisplayRequest;
import io.intino.konos.alexandria.ui.spark.resources.AssetResource;
import io.intino.konos.alexandria.ui.spark.resources.AuthenticateCallbackResource;
import io.intino.konos.alexandria.ui.spark.resources.BeforeDisplayRequest;
import io.intino.sezzet.editor.box.EditorBox;
import io.intino.sezzet.editor.box.EditorConfiguration;
import io.intino.sezzet.editor.box.displays.SezzetEditor;
import io.intino.sezzet.editor.box.displays.SezzetEditorHome;
import io.intino.sezzet.editor.box.displays.SezzetEditorMold;
import io.intino.sezzet.editor.box.displays.notifiers.SezzetEditorHomeNotifier;
import io.intino.sezzet.editor.box.displays.notifiers.SezzetEditorMoldNotifier;
import io.intino.sezzet.editor.box.displays.notifiers.SezzetEditorNotifier;
import io.intino.sezzet.editor.box.displays.requesters.SezzetEditorHomeRequester;
import io.intino.sezzet.editor.box.displays.requesters.SezzetEditorMoldRequester;
import io.intino.sezzet.editor.box.displays.requesters.SezzetEditorRequester;
import io.intino.sezzet.editor.box.resources.HomeResource;

public class EditorUi
extends UI {
    public static void init(UIAlexandriaSpark spark, EditorBox box) {
        EditorConfiguration configuration = box.configuration();
        ((UIRouter)spark.route("/push")).push((PushService)new io.intino.konos.alexandria.ui.services.push.PushService());
        ((UIRouter)spark.route("/authenticate-callback")).get(manager -> new AuthenticateCallbackResource(manager, EditorUi.notifierProvider()).execute());
        ((UIRouter)spark.route("/asset/:name")).get(manager -> new AssetResource(name -> new AssetResourceLoader((Box)box).load(name), manager, EditorUi.notifierProvider()).execute());
        ((UIRouter)spark.route("/")).get(manager -> new HomeResource(box, (UISparkManager)manager, EditorUi.notifierProvider()).execute());
        EditorUi.initDisplays(spark);
    }

    public static void initDisplays(UIAlexandriaSpark spark) {
        ((UIRouter)spark.route("/sezzeteditorhome/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sezzeteditorhome/:displayId")).post(manager -> new SezzetEditorHomeRequester((UISparkManager)manager, EditorUi.notifierProvider()).execute());
        ((UIRouter)spark.route("/sezzeteditorhome/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sezzeteditormold/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sezzeteditormold/:displayId")).post(manager -> new SezzetEditorMoldRequester((UISparkManager)manager, EditorUi.notifierProvider()).execute());
        ((UIRouter)spark.route("/sezzeteditormold/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sezzeteditor/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sezzeteditor/:displayId")).post(manager -> new SezzetEditorRequester((UISparkManager)manager, EditorUi.notifierProvider()).execute());
        ((UIRouter)spark.route("/sezzeteditor/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        EditorUi.registerNotifiers();
    }

    private static void registerNotifiers() {
        EditorUi.register(SezzetEditorHomeNotifier.class).forDisplay(SezzetEditorHome.class);
        EditorUi.register(SezzetEditorMoldNotifier.class).forDisplay(SezzetEditorMold.class);
        EditorUi.register(SezzetEditorNotifier.class).forDisplay(SezzetEditor.class);
    }
}

