package io.intino.sezzet.editor.box.displays;

import io.intino.konos.alexandria.ui.displays.AlexandriaMold;
import io.intino.konos.alexandria.ui.model.Mold;
import io.intino.konos.alexandria.ui.model.mold.Block;
import io.intino.konos.alexandria.ui.model.mold.Stamp;
import io.intino.konos.alexandria.ui.model.mold.stamps.*;

import io.intino.sezzet.editor.box.EditorBox;
import io.intino.sezzet.editor.box.displays.notifiers.SezzetEditorMoldNotifier;

public abstract class AbstractSezzetEditorMold extends AlexandriaMold<SezzetEditorMoldNotifier> {

	public AbstractSezzetEditorMold(EditorBox box) {
		super(box);
		element(buildMold(box));
	}

	public Mold buildMold(EditorBox box) {
		Mold mold = new Mold().add(new Block().name("a").expanded(false).add(Block.Layout.Vertical).add(Block.Layout.CenterJustified).add(Block.Layout.Flexible).hiddenIfMobile(false).style("height:100%")
			.add(new Block().name("a1").expanded(false).add(Block.Layout.Horizontal).add(Block.Layout.Flexible).hiddenIfMobile(false).style("height:100%")
				.add(new io.intino.konos.alexandria.ui.model.mold.stamps.EmbeddedDisplay().displayType("SezzetEditor").displayBuilder((name, session) -> SezzetEditorMold.Stamps.Editor.buildDisplay(box, name, session)).name("editor")
				.defaultStyle("height:calc(100% - 30px);display:block"))));
		mold.name("SezzetEditorMold");
		mold.type("sezzet-editor-mold");
		return mold;
	}
}